"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import blickfeld.stream.connection_pb2
import builtins
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import typing
import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor = ...

class Advanced(google.protobuf.message.Message):
    """*
    > Introduced in BSL v2.11 and firmware v1.11

    Expert parameters: It is not recommended to adapt this calibrated configuration without understanding the influences on the resulting point cloud quality.

    The current set of parameters is preliminary, additional parameters may be added or may get obsolete in the future.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    class Detector(google.protobuf.message.Message):
        """*
        The behavior of the detector can be adjusted to improve the performance under extreme environmental conditions, e.g. static setup with strong daylight or basement rooms without daylight.
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        SENSITIVITY_FIELD_NUMBER: builtins.int
        sensitivity: builtins.float = ...
        """Relatively influences the sensitivity of the detector. Higher values might also result into range loss. It is recommended to validate the noise filter parameters after changes to this setting."""

        def __init__(self,
            *,
            sensitivity : typing.Optional[builtins.float] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal[u"sensitivity",b"sensitivity"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal[u"sensitivity",b"sensitivity"]) -> None: ...

    class Processing(google.protobuf.message.Message):
        """*
        > Introduced in BSL v2.12 and firmware v1.12

        Processing parameters are set at the factory after calibration. Changing these values invalidates the factory calibration.
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        RANGE_OFFSET_FIELD_NUMBER: builtins.int
        IMU_STATIC_ROTATION_OFFSET_FIELD_NUMBER: builtins.int
        HORIZONTAL_PHASE_OFFSET_FIELD_NUMBER: builtins.int
        range_offset: builtins.float = ...
        """in [m]"""

        @property
        def imu_static_rotation_offset(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]:
            """<blockquote>Introduced in BSL v2.19 and firmware v1.20</blockquote> in [rad] - Offset rotation matrix for acceleration of IMU. Can be used to calibrate the accelerometer e.g. on a flat surface."""
            pass
        horizontal_phase_offset: builtins.float = ...
        """<blockquote>Introduced in BSL v2.19.5 and firmware v1.21.1</blockquote> in [s] - Correction for phase offset in the horizontal field of view. This parameter might be adjusted in the field if the upper and lower half of the frame drifted horizontally."""

        def __init__(self,
            *,
            range_offset : typing.Optional[builtins.float] = ...,
            imu_static_rotation_offset : typing.Optional[typing.Iterable[builtins.float]] = ...,
            horizontal_phase_offset : typing.Optional[builtins.float] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal[u"horizontal_phase_offset",b"horizontal_phase_offset",u"range_offset",b"range_offset"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal[u"horizontal_phase_offset",b"horizontal_phase_offset",u"imu_static_rotation_offset",b"imu_static_rotation_offset",u"range_offset",b"range_offset"]) -> None: ...

    class Server(google.protobuf.message.Message):
        """*
        > Introduced in BSL v2.13 and firmware v1.13

        Parameters, which control the server behavior.
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        DEFAULT_POINT_CLOUD_SUBSCRIPTION_FIELD_NUMBER: builtins.int
        @property
        def default_point_cloud_subscription(self) -> blickfeld.stream.connection_pb2.Subscribe.PointCloud:
            """Overwrite default point cloud subscription. Can still be overridden with client requests."""
            pass
        def __init__(self,
            *,
            default_point_cloud_subscription : typing.Optional[blickfeld.stream.connection_pb2.Subscribe.PointCloud] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal[u"default_point_cloud_subscription",b"default_point_cloud_subscription"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal[u"default_point_cloud_subscription",b"default_point_cloud_subscription"]) -> None: ...

    class TimeSynchronization(google.protobuf.message.Message):
        """*
        > Introduced in BSL v2.18 and firmware v1.19

        Activate or deactivate synchronization and change parameters
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        class NTP(google.protobuf.message.Message):
            """*
            The Blickfeld devices can use an NTPv4 client to synchronize the local device time to a time server.
            NTP can achieve synchronization accuracy below one millisecond for measurement results in local networks.
            """
            DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
            SERVERS_FIELD_NUMBER: builtins.int
            @property
            def servers(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]:
                """Specify list of NTP server. By default, debian pool NTP servers are used."""
                pass
            def __init__(self,
                *,
                servers : typing.Optional[typing.Iterable[typing.Text]] = ...,
                ) -> None: ...
            def ClearField(self, field_name: typing_extensions.Literal[u"servers",b"servers"]) -> None: ...

        class PTP(google.protobuf.message.Message):
            """*
            The Blickfeld devices can use a PTP client to synchronize the local device time to a time server.
            PTP can achieve an higher accuracy than NTP in local networks.
            """
            DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
            class DelayMechanism(_DelayMechanism, metaclass=_DelayMechanismEnumTypeWrapper):
                pass
            class _DelayMechanism:
                V = typing.NewType('V', builtins.int)
            class _DelayMechanismEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_DelayMechanism.V], builtins.type):
                DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor = ...
                E2E = Advanced.TimeSynchronization.PTP.DelayMechanism.V(1)
                """End to end delay detection"""

                P2P = Advanced.TimeSynchronization.PTP.DelayMechanism.V(2)
                """Peer to peer delay detection"""


            E2E = Advanced.TimeSynchronization.PTP.DelayMechanism.V(1)
            """End to end delay detection"""

            P2P = Advanced.TimeSynchronization.PTP.DelayMechanism.V(2)
            """Peer to peer delay detection"""


            DOMAIN_FIELD_NUMBER: builtins.int
            DELAY_MECHANISM_FIELD_NUMBER: builtins.int
            UNICAST_DESTINATIONS_FIELD_NUMBER: builtins.int
            domain: builtins.int = ...
            """PTP domain number."""

            delay_mechanism: global___Advanced.TimeSynchronization.PTP.DelayMechanism.V = ...
            """Delay detection mode used"""

            @property
            def unicast_destinations(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]:
                """Specify unicast slave addresses for unicast master operation, or unicast master addresses for slave operation. If this is set unicast mode will be activated."""
                pass
            def __init__(self,
                *,
                domain : typing.Optional[builtins.int] = ...,
                delay_mechanism : typing.Optional[global___Advanced.TimeSynchronization.PTP.DelayMechanism.V] = ...,
                unicast_destinations : typing.Optional[typing.Iterable[typing.Text]] = ...,
                ) -> None: ...
            def HasField(self, field_name: typing_extensions.Literal[u"delay_mechanism",b"delay_mechanism",u"domain",b"domain"]) -> builtins.bool: ...
            def ClearField(self, field_name: typing_extensions.Literal[u"delay_mechanism",b"delay_mechanism",u"domain",b"domain",u"unicast_destinations",b"unicast_destinations"]) -> None: ...

        NTP_FIELD_NUMBER: builtins.int
        PTP_FIELD_NUMBER: builtins.int
        @property
        def ntp(self) -> global___Advanced.TimeSynchronization.NTP:
            """If this field is set, NTP synchronization is activated, which is the default configuration. Refer to [NTP](#blickfeld.protocol.config.Advanced.Synchronization.NTP)"""
            pass
        @property
        def ptp(self) -> global___Advanced.TimeSynchronization.PTP:
            """If this field is set, PTP synchronization is activated and NTP synchronization is deactivated. Refer to [PTP](#blickfeld.protocol.config.Advanced.Synchronization.PTP)"""
            pass
        def __init__(self,
            *,
            ntp : typing.Optional[global___Advanced.TimeSynchronization.NTP] = ...,
            ptp : typing.Optional[global___Advanced.TimeSynchronization.PTP] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal[u"kind",b"kind",u"ntp",b"ntp",u"ptp",b"ptp"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal[u"kind",b"kind",u"ntp",b"ntp",u"ptp",b"ptp"]) -> None: ...
        def WhichOneof(self, oneof_group: typing_extensions.Literal[u"kind",b"kind"]) -> typing.Optional[typing_extensions.Literal["ntp","ptp"]]: ...

    DETECTOR_FIELD_NUMBER: builtins.int
    PROCESSING_FIELD_NUMBER: builtins.int
    SERVER_FIELD_NUMBER: builtins.int
    TIME_SYNCHRONIZATION_FIELD_NUMBER: builtins.int
    @property
    def detector(self) -> global___Advanced.Detector:
        """Refer to [Detector](#blickfeld.protocol.config.Advanced.Detector)"""
        pass
    @property
    def processing(self) -> global___Advanced.Processing:
        """<blockquote>Introduced in BSL v2.12 and firmware v1.12</blockquote> Refer to [Processing](#blickfeld.protocol.config.Advanced.Processing)"""
        pass
    @property
    def server(self) -> global___Advanced.Server:
        """<blockquote>Introduced in BSL v2.13 and firmware v1.13</blockquote> Refer to [Server](#blickfeld.protocol.config.Advanced.Server)"""
        pass
    @property
    def time_synchronization(self) -> global___Advanced.TimeSynchronization:
        """<blockquote>Introduced in BSL v2.18 and firmware v1.19</blockquote> Refer to [TimeSynchronization](#blickfeld.protocol.config.Advanced.TimeSynchronization)"""
        pass
    def __init__(self,
        *,
        detector : typing.Optional[global___Advanced.Detector] = ...,
        processing : typing.Optional[global___Advanced.Processing] = ...,
        server : typing.Optional[global___Advanced.Server] = ...,
        time_synchronization : typing.Optional[global___Advanced.TimeSynchronization] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal[u"detector",b"detector",u"processing",b"processing",u"server",b"server",u"time_synchronization",b"time_synchronization"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"detector",b"detector",u"processing",b"processing",u"server",b"server",u"time_synchronization",b"time_synchronization"]) -> None: ...
global___Advanced = Advanced
