"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor = ...

class Algorithm(google.protobuf.message.Message):
    """*
    > Introduced in BSL v2.17 and firmware v1.18

    This section describes configuration of on-device algorithms.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    class BackgroundSubtraction(google.protobuf.message.Message):
        """*
        > Introduced in firmware v1.16

        This message configures the background subtraction.

        The algorithm uses a configurable number of reference frames to estimate static points (background) in the scene.
        Once the number of reference frames are processed, it removes all static points from the point cloud output.
        The resulting point cloud then only contains the non-static points (foreground).
        Points that are a initially part of the foreground and but then stop moving, will be added to the background and
        thus disappear after a certain amount of time, which is given by the exponential decay rate parameter.
        Conversely, if an object that is already part of the background suddenly starts moving, it will be added to the foreground.
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        INITIALIZATION_FRAMES_FIELD_NUMBER: builtins.int
        EXPONENTIAL_DECAY_RATE_FIELD_NUMBER: builtins.int
        initialization_frames: builtins.int = ...
        """Number of frames to initialize the background with"""

        exponential_decay_rate: builtins.float = ...
        """Controls how fast objects switch between foreground and background. Exponential decay factor."""

        def __init__(self,
            *,
            initialization_frames : typing.Optional[builtins.int] = ...,
            exponential_decay_rate : typing.Optional[builtins.float] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal[u"exponential_decay_rate",b"exponential_decay_rate",u"initialization_frames",b"initialization_frames"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal[u"exponential_decay_rate",b"exponential_decay_rate",u"initialization_frames",b"initialization_frames"]) -> None: ...

    class NeighborFilter(google.protobuf.message.Message):
        """*
        > Introduced in firmware v1.18

        The neighbor filter is a simple noise filter, which uses neighboring returns in the scan pattern to decide if returns should be filtered.

        The algorithm iterates through all returns and removes all, which have zero neighbors.
        A neighbor return must be:
        - directly to the left / to the right / above / below the current return in the scan pattern
        - close to the current return. The maximum range, used for this condition, is defined by the angle spacing of the scan pattern and the range of the current return. As with higher distance, neighboring returns are expected to be further away.

        No parameters can be configured at the moment.
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        def __init__(self,
            ) -> None: ...

    class StaticTransformation(google.protobuf.message.Message):
        """*

        > Introduced in firmware v1.18

        This message configures a static geometric transformation.

        The algorithm applies a static rotation and translation to the point cloud output.

        The rotation matrix **R** is expected to be a 3 x 3 matrix serialized in row major order.

        Rotation in matrix representation:

        |     |  R  |     |
        | --- | --- | --- |
        | r<sub>1,1</sub> | r<sub>1,2</sub> | r<sub>1,3</sub> |
        | r<sub>2,1</sub> | r<sub>2,2</sub> | r<sub>2,3</sub> |
        | r<sub>3,1</sub> | r<sub>3,2</sub> | r<sub>3,3</sub> |

        Rotation in serialized representation:

        **R** = [r<sub>1,1</sub>, r<sub>1,2</sub>, ... r<sub>3,2</sub>, r<sub>3,3</sub>]

        The translation vector **T** is expected to be a 3 x 1 vector.

        Translation in vector representation:

        |  T  |
        | --- |
        |  t<sub>1</sub>  |
        |  t<sub>2</sub>  |
        |  t<sub>3</sub>  |

        Translation in serialized representation:

        **T** = [t<sub>1</sub>, t<sub>2</sub>, t<sub>3</sub>] =  [x, y, z]
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        ROTATION_MATRIX_FIELD_NUMBER: builtins.int
        TRANSLATION_VECTOR_FIELD_NUMBER: builtins.int
        @property
        def rotation_matrix(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]:
            """rotation matrix **R** in serialized representation."""
            pass
        @property
        def translation_vector(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]:
            """translation vector **T** in serialized representation."""
            pass
        def __init__(self,
            *,
            rotation_matrix : typing.Optional[typing.Iterable[builtins.float]] = ...,
            translation_vector : typing.Optional[typing.Iterable[builtins.float]] = ...,
            ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal[u"rotation_matrix",b"rotation_matrix",u"translation_vector",b"translation_vector"]) -> None: ...

    BACKGROUND_SUBTRACTION_FIELD_NUMBER: builtins.int
    NEIGHBOR_FILTER_FIELD_NUMBER: builtins.int
    STATIC_TRANSFORMATION_FIELD_NUMBER: builtins.int
    @property
    def background_subtraction(self) -> global___Algorithm.BackgroundSubtraction:
        """Refer to [BackgroundSubtraction](#blickfeld.protocol.config.Algorithm.BackgroundSubtraction)"""
        pass
    @property
    def neighbor_filter(self) -> global___Algorithm.NeighborFilter:
        """Refer to [NeighborFilter](#blickfeld.protocol.config.Algorithm.NeighborFilter)"""
        pass
    @property
    def static_transformation(self) -> global___Algorithm.StaticTransformation:
        """Refer to [StaticTransformation](#blickfeld.protocol.config.Algorithm.StaticTransformation)"""
        pass
    def __init__(self,
        *,
        background_subtraction : typing.Optional[global___Algorithm.BackgroundSubtraction] = ...,
        neighbor_filter : typing.Optional[global___Algorithm.NeighborFilter] = ...,
        static_transformation : typing.Optional[global___Algorithm.StaticTransformation] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal[u"algo",b"algo",u"background_subtraction",b"background_subtraction",u"neighbor_filter",b"neighbor_filter",u"static_transformation",b"static_transformation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"algo",b"algo",u"background_subtraction",b"background_subtraction",u"neighbor_filter",b"neighbor_filter",u"static_transformation",b"static_transformation"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal[u"algo",b"algo"]) -> typing.Optional[typing_extensions.Literal["background_subtraction","neighbor_filter","static_transformation"]]: ...
global___Algorithm = Algorithm
