"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import blickfeld.common_pb2
import builtins
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import typing
import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor = ...

class ScanPattern(google.protobuf.message.Message):
    """*
    The scan pattern defines the movement of the mirrors.
    The key parameters of the pattern are the horizontal and vertical fields of view (FoV) as well as the number of scan lines per frame.
    The frame rate is defined by the total number of scan lines and the oscillation frequency of the mirrors which is fixed and device-spcific.

    For a more detailed explanation, see: [Scan Pattern documentation](Scan_Pattern)
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    class Horizontal(google.protobuf.message.Message):
        """*
        This section defines the movement of the horizontal mirror.
        The mirror moves continuously with its own frequency. Each half-oscillation period of the mirror results in one scan line.
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        FOV_FIELD_NUMBER: builtins.int
        fov: builtins.float = ...
        """*
        Unit: [rad]
        –
        optical field of view of the horizontal mirror.
        Note: In v2.2* and below, this was defined as a mechanical FoV.
        """

        def __init__(self,
            *,
            fov : typing.Optional[builtins.float] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal[u"fov",b"fov"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal[u"fov",b"fov"]) -> None: ...

    class Vertical(google.protobuf.message.Message):
        """*
        This section defines the movement of the vertical mirror within one frame.
        The mirror moves for from 0 degrees to the configured target FoV (up-ramping phase) and back to 0 degrees (down-ramping phase) with its eigenfrequency.
        The number of scanlines for each phase can be configured.
        Due to the dynamics of the mirror, a certain number of scan lines are required to reach the target FoV and then to reach 0 degrees again.
        Consequently, if the limit is reached, a lower number of scan lines requires a reduced FoV.
        Thus, a higher number of scan lines allows a larger vertical FoV. The vertical FoV is limited by the optical components.

        Note: Due to the time required for one scan line, the rounded even number of scan lines directly scales inverse proportionally with65t the frame rate.

        For a more detailed explanation, see: [Scan Pattern documentation](Scan_Pattern)
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        FOV_FIELD_NUMBER: builtins.int
        SCANLINES_UP_FIELD_NUMBER: builtins.int
        SCANLINES_DOWN_FIELD_NUMBER: builtins.int
        fov: builtins.float = ...
        """*
        Unit: [rad]
        –
        FoV in the center of the frame.
        Due to the eye shape of the scan pattern, the vertical FoV decreases the outer boundaries of the horizontal mirror.
        """

        scanlines_up: builtins.int = ...
        """*
        Configures the number of scan lines required for the up-ramping phase.
        During the up-ramping phase, the vertical mirror increases its amplitude from 0 degrees to the target FoV. Default: 200
        """

        scanlines_down: builtins.int = ...
        """*
        Configures the amount of scan lines required for the down-ramping phase.
        During the down-ramping phase, the vertical mirror decreases its amplitude from the target FoV to 0 degrees. Default: 30
        """

        def __init__(self,
            *,
            fov : typing.Optional[builtins.float] = ...,
            scanlines_up : typing.Optional[builtins.int] = ...,
            scanlines_down : typing.Optional[builtins.int] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal[u"fov",b"fov",u"scanlines_down",b"scanlines_down",u"scanlines_up",b"scanlines_up"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal[u"fov",b"fov",u"scanlines_down",b"scanlines_down",u"scanlines_up",b"scanlines_up"]) -> None: ...

    class Pulse(google.protobuf.message.Message):
        """*
        This section defines the pattern in which the laser pulses and captures sample points
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        class Type(_Type, metaclass=_TypeEnumTypeWrapper):
            """*
            The device pulses depending on the mirror positioning.
            Currently, only pulse triggering on the horizontal angle is supported.
            The laser pulses are emittet with the configured angular spacing.
            """
            pass
        class _Type:
            V = typing.NewType('V', builtins.int)
        class _TypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_Type.V], builtins.type):
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor = ...
            EQUI_HORIZONTAL_ANGLE = ScanPattern.Pulse.Type.V(0)
            """The laser is triggered depending on the horizontal angle of the laser beam with the configured angle spacing."""

            EQUI_DENSITY = ScanPattern.Pulse.Type.V(1)
            """Reserved for future use. Not yet supported."""

            CUSTOM = ScanPattern.Pulse.Type.V(2)
            """Internal feature for custom scan patterns"""

            INTERLEAVE = ScanPattern.Pulse.Type.V(3)
            """
            The laser is triggered depending on the horizontal angle of the laser beam with the configured angle spacing.
            Scanlines are shifted by angle_spacing/4 with alternate directions.
            This doubles the horizontal density with the COMBINE_UP_DOWN FrameMode and efficiently uses the down-ramp phase in the inner horizontal FoV.
            """


        EQUI_HORIZONTAL_ANGLE = ScanPattern.Pulse.Type.V(0)
        """The laser is triggered depending on the horizontal angle of the laser beam with the configured angle spacing."""

        EQUI_DENSITY = ScanPattern.Pulse.Type.V(1)
        """Reserved for future use. Not yet supported."""

        CUSTOM = ScanPattern.Pulse.Type.V(2)
        """Internal feature for custom scan patterns"""

        INTERLEAVE = ScanPattern.Pulse.Type.V(3)
        """
        The laser is triggered depending on the horizontal angle of the laser beam with the configured angle spacing.
        Scanlines are shifted by angle_spacing/4 with alternate directions.
        This doubles the horizontal density with the COMBINE_UP_DOWN FrameMode and efficiently uses the down-ramp phase in the inner horizontal FoV.
        """


        class FrameMode(_FrameMode, metaclass=_FrameModeEnumTypeWrapper):
            """*
            Because of the mirrors oscillating and the resulting Lissajous curve, it is not possible to pulse in a completely arbitrary pattern.
            A frame always starts with a phase in which the vertical mirror increases its amplitude (up-ramping).
            It is followed by a second phase, in which it decreases its amplitude until it no longer moves (down-ramping).
            It is possible to pulse in both phases. There are four different options to pulse:
            """
            pass
        class _FrameMode:
            V = typing.NewType('V', builtins.int)
        class _FrameModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_FrameMode.V], builtins.type):
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor = ...
            NONE = ScanPattern.Pulse.FrameMode.V(0)
            COMBINE_UP_DOWN = ScanPattern.Pulse.FrameMode.V(1)
            """*
            The device pulses in the up-ramping and down-ramping phases and one frame is created by combining the resulting sample points.
            """

            ONLY_UP = ScanPattern.Pulse.FrameMode.V(2)
            """*
            The device pulses in the **up-ramping** phase and **does not** pulse in the **down-ramping** phase.
            """

            ONLY_DOWN = ScanPattern.Pulse.FrameMode.V(3)
            """*
            The device is **does not** pulse in the **up-ramping** phase and pulses in the **down-ramping** phase.
            """

            SEPARATE = ScanPattern.Pulse.FrameMode.V(4)
            """*
            The device pulses in the up-ramping and down-ramping phases and one frame for each phase is created.
            """


        NONE = ScanPattern.Pulse.FrameMode.V(0)
        COMBINE_UP_DOWN = ScanPattern.Pulse.FrameMode.V(1)
        """*
        The device pulses in the up-ramping and down-ramping phases and one frame is created by combining the resulting sample points.
        """

        ONLY_UP = ScanPattern.Pulse.FrameMode.V(2)
        """*
        The device pulses in the **up-ramping** phase and **does not** pulse in the **down-ramping** phase.
        """

        ONLY_DOWN = ScanPattern.Pulse.FrameMode.V(3)
        """*
        The device is **does not** pulse in the **up-ramping** phase and pulses in the **down-ramping** phase.
        """

        SEPARATE = ScanPattern.Pulse.FrameMode.V(4)
        """*
        The device pulses in the up-ramping and down-ramping phases and one frame for each phase is created.
        """


        class Custom(google.protobuf.message.Message):
            """
            > Introduced in BSL v2.15 and firmware v1.16

            Custom scan pattern configuration. Required for different use cases, as e.g. angle triggers, point triggers, or detector recordings.
            """
            DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
            class Trigger(_Trigger, metaclass=_TriggerEnumTypeWrapper):
                """
                List of available device triggers.
                """
                pass
            class _Trigger:
                V = typing.NewType('V', builtins.int)
            class _TriggerEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_Trigger.V], builtins.type):
                DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor = ...
                TRG_EXTERNAL_0 = ScanPattern.Pulse.Custom.Trigger.V(1)
                """External output pin, routed to TEST0 on the debug board."""

                TRG_EXTERNAL_1 = ScanPattern.Pulse.Custom.Trigger.V(2)
                """External output pin, routed to TEST1 on the debug board."""

                TRG_DETECTOR = ScanPattern.Pulse.Custom.Trigger.V(3)
                """Internal detector recording, which can retrieved with the detector stream."""

                TRG_LASER = ScanPattern.Pulse.Custom.Trigger.V(4)
                """Trigger laser."""


            TRG_EXTERNAL_0 = ScanPattern.Pulse.Custom.Trigger.V(1)
            """External output pin, routed to TEST0 on the debug board."""

            TRG_EXTERNAL_1 = ScanPattern.Pulse.Custom.Trigger.V(2)
            """External output pin, routed to TEST1 on the debug board."""

            TRG_DETECTOR = ScanPattern.Pulse.Custom.Trigger.V(3)
            """Internal detector recording, which can retrieved with the detector stream."""

            TRG_LASER = ScanPattern.Pulse.Custom.Trigger.V(4)
            """Trigger laser."""


            class Duration(google.protobuf.message.Message):
                """
                Specify duration for trigger type in seconds.
                """
                DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
                EXTERNAL_0_FIELD_NUMBER: builtins.int
                EXTERNAL_1_FIELD_NUMBER: builtins.int
                external_0: builtins.float = ...
                """in [s]"""

                external_1: builtins.float = ...
                """in [s]"""

                def __init__(self,
                    *,
                    external_0 : typing.Optional[builtins.float] = ...,
                    external_1 : typing.Optional[builtins.float] = ...,
                    ) -> None: ...
                def HasField(self, field_name: typing_extensions.Literal[u"external_0",b"external_0",u"external_1",b"external_1"]) -> builtins.bool: ...
                def ClearField(self, field_name: typing_extensions.Literal[u"external_0",b"external_0",u"external_1",b"external_1"]) -> None: ...

            class AngleTrigger(google.protobuf.message.Message):
                """
                Allows to trigger based on horizontal angles.
                """
                DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
                class Angle(google.protobuf.message.Message):
                    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
                    HORIZONTAL_ANGLE_FIELD_NUMBER: builtins.int
                    SCANLINE_ID_FIELD_NUMBER: builtins.int
                    ENABLED_TRIGGERS_FIELD_NUMBER: builtins.int
                    horizontal_angle: builtins.float = ...
                    """in [rad]"""

                    scanline_id: builtins.int = ...
                    """Define in which scanline the trigger should occur, if none is given, it will trigger in all scanlines"""

                    @property
                    def enabled_triggers(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___ScanPattern.Pulse.Custom.Trigger.V]: ...
                    def __init__(self,
                        *,
                        horizontal_angle : typing.Optional[builtins.float] = ...,
                        scanline_id : typing.Optional[builtins.int] = ...,
                        enabled_triggers : typing.Optional[typing.Iterable[global___ScanPattern.Pulse.Custom.Trigger.V]] = ...,
                        ) -> None: ...
                    def HasField(self, field_name: typing_extensions.Literal[u"horizontal_angle",b"horizontal_angle",u"scanline_id",b"scanline_id"]) -> builtins.bool: ...
                    def ClearField(self, field_name: typing_extensions.Literal[u"enabled_triggers",b"enabled_triggers",u"horizontal_angle",b"horizontal_angle",u"scanline_id",b"scanline_id"]) -> None: ...

                ANGLES_FIELD_NUMBER: builtins.int
                @property
                def angles(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ScanPattern.Pulse.Custom.AngleTrigger.Angle]:
                    """List of angles"""
                    pass
                def __init__(self,
                    *,
                    angles : typing.Optional[typing.Iterable[global___ScanPattern.Pulse.Custom.AngleTrigger.Angle]] = ...,
                    ) -> None: ...
                def ClearField(self, field_name: typing_extensions.Literal[u"angles",b"angles"]) -> None: ...

            class PointTrigger(google.protobuf.message.Message):
                """
                Set point triggers for the normal equi-distant horizontal scan pattern.
                """
                DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
                class Point(google.protobuf.message.Message):
                    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
                    ID_FIELD_NUMBER: builtins.int
                    ENABLED_TRIGGERS_FIELD_NUMBER: builtins.int
                    id: builtins.int = ...
                    """Define which point ID should be triggered"""

                    @property
                    def enabled_triggers(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___ScanPattern.Pulse.Custom.Trigger.V]: ...
                    def __init__(self,
                        *,
                        id : typing.Optional[builtins.int] = ...,
                        enabled_triggers : typing.Optional[typing.Iterable[global___ScanPattern.Pulse.Custom.Trigger.V]] = ...,
                        ) -> None: ...
                    def HasField(self, field_name: typing_extensions.Literal[u"id",b"id"]) -> builtins.bool: ...
                    def ClearField(self, field_name: typing_extensions.Literal[u"enabled_triggers",b"enabled_triggers",u"id",b"id"]) -> None: ...

                POINTS_FIELD_NUMBER: builtins.int
                @property
                def points(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ScanPattern.Pulse.Custom.PointTrigger.Point]: ...
                def __init__(self,
                    *,
                    points : typing.Optional[typing.Iterable[global___ScanPattern.Pulse.Custom.PointTrigger.Point]] = ...,
                    ) -> None: ...
                def ClearField(self, field_name: typing_extensions.Literal[u"points",b"points"]) -> None: ...

            ANGLE_TRIGGER_FIELD_NUMBER: builtins.int
            POINT_TRIGGER_FIELD_NUMBER: builtins.int
            DURATION_FIELD_NUMBER: builtins.int
            @property
            def angle_trigger(self) -> global___ScanPattern.Pulse.Custom.AngleTrigger: ...
            @property
            def point_trigger(self) -> global___ScanPattern.Pulse.Custom.PointTrigger: ...
            @property
            def duration(self) -> global___ScanPattern.Pulse.Custom.Duration: ...
            def __init__(self,
                *,
                angle_trigger : typing.Optional[global___ScanPattern.Pulse.Custom.AngleTrigger] = ...,
                point_trigger : typing.Optional[global___ScanPattern.Pulse.Custom.PointTrigger] = ...,
                duration : typing.Optional[global___ScanPattern.Pulse.Custom.Duration] = ...,
                ) -> None: ...
            def HasField(self, field_name: typing_extensions.Literal[u"angle_trigger",b"angle_trigger",u"custom_type",b"custom_type",u"duration",b"duration",u"point_trigger",b"point_trigger"]) -> builtins.bool: ...
            def ClearField(self, field_name: typing_extensions.Literal[u"angle_trigger",b"angle_trigger",u"custom_type",b"custom_type",u"duration",b"duration",u"point_trigger",b"point_trigger"]) -> None: ...
            def WhichOneof(self, oneof_group: typing_extensions.Literal[u"custom_type",b"custom_type"]) -> typing.Optional[typing_extensions.Literal["angle_trigger","point_trigger"]]: ...

        ANGLE_SPACING_FIELD_NUMBER: builtins.int
        TYPE_FIELD_NUMBER: builtins.int
        FRAME_MODE_FIELD_NUMBER: builtins.int
        DISTORTION_CORRECTION_FIELD_NUMBER: builtins.int
        CUSTOM_FIELD_NUMBER: builtins.int
        angle_spacing: builtins.float = ...
        """*
        Unit: [rad]
        –
        This defines the angle within which the horizontal mirror moves between two laser pulses.
        This parameter therefore defines the horizontal sampling resolution.
        """

        type: global___ScanPattern.Pulse.Type.V = ...
        """Refer to [ScanPattern.Pulse.Type](#blickfeld.protocol.config.ScanPattern.Pulse.Type)"""

        frame_mode: global___ScanPattern.Pulse.FrameMode.V = ...
        """Refer to [ScanPattern.Pulse.FrameMode](#blickfeld.protocol.config.ScanPattern.Pulse.FrameMode)"""

        distortion_correction: builtins.bool = ...
        """*
        This parameter defines whether the distortion correction is applied when calculating the laser pulse angles. Default: True
        """

        @property
        def custom(self) -> global___ScanPattern.Pulse.Custom:
            """<blockquote>Introduced in BSL v2.15 and firmware v1.16</blockquote> Refer to [ScanPattern.Pulse.Custom](#blickfeld.protocol.config.ScanPattern.Pulse.Custom)"""
            pass
        def __init__(self,
            *,
            angle_spacing : typing.Optional[builtins.float] = ...,
            type : typing.Optional[global___ScanPattern.Pulse.Type.V] = ...,
            frame_mode : typing.Optional[global___ScanPattern.Pulse.FrameMode.V] = ...,
            distortion_correction : typing.Optional[builtins.bool] = ...,
            custom : typing.Optional[global___ScanPattern.Pulse.Custom] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal[u"angle_spacing",b"angle_spacing",u"custom",b"custom",u"distortion_correction",b"distortion_correction",u"frame_mode",b"frame_mode",u"type",b"type"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal[u"angle_spacing",b"angle_spacing",u"custom",b"custom",u"distortion_correction",b"distortion_correction",u"frame_mode",b"frame_mode",u"type",b"type"]) -> None: ...

    class FrameRate(google.protobuf.message.Message):
        """*
        This section defines the target frame rate for synchronization between several LiDAR devices.
        The feature is described in the [Time synchronization documentation](Sync).
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        TARGET_FIELD_NUMBER: builtins.int
        MAXIMUM_FIELD_NUMBER: builtins.int
        REFERENCE_TIME_OFFSET_FIELD_NUMBER: builtins.int
        target: builtins.float = ...
        """Target frame rate during synchronization between several LiDAR devices"""

        maximum: builtins.float = ...
        """Read-only parameter for maximum achievable frame rate."""

        reference_time_offset: builtins.float = ...
        """*
        In [s]. Adds a constant value to the Unix reference time, starting from 00:00:00 UTC on January 1, 1970.
        It can be used to compensate delays or to interleave LiDAR devices. Default: 0
        """

        def __init__(self,
            *,
            target : typing.Optional[builtins.float] = ...,
            maximum : typing.Optional[builtins.float] = ...,
            reference_time_offset : typing.Optional[builtins.float] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal[u"maximum",b"maximum",u"reference_time_offset",b"reference_time_offset",u"target",b"target"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal[u"maximum",b"maximum",u"reference_time_offset",b"reference_time_offset",u"target",b"target"]) -> None: ...

    class Filter(google.protobuf.message.Message):
        """*
        > Introduced in BSL v2.10 and firmware v1.9

        Filter points and returns by point attributes during the post-processing on the device.
        This can be used to e.g. filter points with low intensity or to enable secondary returns.
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        class Noise(google.protobuf.message.Message):
            """*
            > Introduced in BSL v2.11 and firmware v1.11

            This is a preliminary interface to control the noise filter on the device.
            All points, which have a lower intensity than the minimum intensity calculated by this filter will be filtered out.

            > Changed in firmware v1.15. Please re-adjust filter configurations in scan patterns.

            The internal algorithm implements a non-linear function, which describes the noise level for different ambient light levels.
            The function can be scaled with the gain and shifted with the offset.

            > Before firmware v1.15

            The formula is: minimum_intensity = offset + gain * point.ambient_light_level,
            where the point.ambient_light_level is the ambient light level of the point the laser shoots at.
            """
            DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
            OFFSET_FIELD_NUMBER: builtins.int
            GAIN_FIELD_NUMBER: builtins.int
            ENABLE_FIELD_NUMBER: builtins.int
            offset: builtins.int = ...
            """Can be seen as minimum intensity filter, if there is no ambient light."""

            gain: builtins.float = ...
            """The gain scales a non-linear function, which uses the ambient light level of the point the laser shoots at, as an input."""

            enable: builtins.bool = ...
            """<blockquote>Introduced in BSL v2.17 and firmware v1.18</blockquote>	This flag can be used to disable the internal noise filter completely. By default, the noise filter is enabled."""

            def __init__(self,
                *,
                offset : typing.Optional[builtins.int] = ...,
                gain : typing.Optional[builtins.float] = ...,
                enable : typing.Optional[builtins.bool] = ...,
                ) -> None: ...
            def HasField(self, field_name: typing_extensions.Literal[u"enable",b"enable",u"gain",b"gain",u"offset",b"offset"]) -> builtins.bool: ...
            def ClearField(self, field_name: typing_extensions.Literal[u"enable",b"enable",u"gain",b"gain",u"offset",b"offset"]) -> None: ...

        MAX_NUMBER_OF_RETURNS_PER_POINT_FIELD_NUMBER: builtins.int
        INTENSITY_FIELD_NUMBER: builtins.int
        AMBIENT_LIGHT_LEVEL_FIELD_NUMBER: builtins.int
        RANGE_FIELD_NUMBER: builtins.int
        NOISE_FIELD_NUMBER: builtins.int
        DELETE_POINTS_WITHOUT_RETURNS_FIELD_NUMBER: builtins.int
        max_number_of_returns_per_point: builtins.int = ...
        """Set maximum number of returns per point. By default, secondary returns are disabled. Set this, e.g. to 2, to enable secondary returns."""

        @property
        def intensity(self) -> blickfeld.common_pb2.OptionalValueRange:
            """Filter all points, which intensity values are not within this value range."""
            pass
        @property
        def ambient_light_level(self) -> blickfeld.common_pb2.OptionalValueRange:
            """Filter all points, which ambient light level values are not within this value range."""
            pass
        @property
        def range(self) -> blickfeld.common_pb2.OptionalValueRange:
            """Filter all points, which range values are not within this value range."""
            pass
        @property
        def noise(self) -> global___ScanPattern.Filter.Noise:
            """<blockquote>Introduced in BSL v2.11 and firmware v1.11</blockquote> Refer to [Filter.Noise](#blickfeld.protocol.config.ScanPattern.Filter.Noise)"""
            pass
        delete_points_without_returns: builtins.bool = ...
        """
        <blockquote> Introduced in BSL v2.16 and firmware v1.17</blockquote>
        All points without any returns are filtered if this setting is true.
        With active algorithms, such as background subtraction, this can reduce the bandwidth significantly.
        <br>
        Note:
        It is recommended to not estimate required network bandwidths when this setting is active.
        In scenarios, where from one frame to another, all points have returns (e.g. due to environmental changes),
        the peak bandwidths might increase significantly. This could result, in these scenarios, in frame losses.
        """

        def __init__(self,
            *,
            max_number_of_returns_per_point : typing.Optional[builtins.int] = ...,
            intensity : typing.Optional[blickfeld.common_pb2.OptionalValueRange] = ...,
            ambient_light_level : typing.Optional[blickfeld.common_pb2.OptionalValueRange] = ...,
            range : typing.Optional[blickfeld.common_pb2.OptionalValueRange] = ...,
            noise : typing.Optional[global___ScanPattern.Filter.Noise] = ...,
            delete_points_without_returns : typing.Optional[builtins.bool] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal[u"ambient_light_level",b"ambient_light_level",u"delete_points_without_returns",b"delete_points_without_returns",u"intensity",b"intensity",u"max_number_of_returns_per_point",b"max_number_of_returns_per_point",u"noise",b"noise",u"range",b"range"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal[u"ambient_light_level",b"ambient_light_level",u"delete_points_without_returns",b"delete_points_without_returns",u"intensity",b"intensity",u"max_number_of_returns_per_point",b"max_number_of_returns_per_point",u"noise",b"noise",u"range",b"range"]) -> None: ...

    HORIZONTAL_FIELD_NUMBER: builtins.int
    VERTICAL_FIELD_NUMBER: builtins.int
    PULSE_FIELD_NUMBER: builtins.int
    FRAME_RATE_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    CONSTRAINTS_FIELD_NUMBER: builtins.int
    @property
    def horizontal(self) -> global___ScanPattern.Horizontal:
        """Refer to [ScanPattern.Horizontal](#blickfeld.protocol.config.ScanPattern.Horizontal)"""
        pass
    @property
    def vertical(self) -> global___ScanPattern.Vertical:
        """Refer to [ScanPattern.Vertical](#blickfeld.protocol.config.ScanPattern.Vertical)"""
        pass
    @property
    def pulse(self) -> global___ScanPattern.Pulse:
        """Refer to [ScanPattern.Pulse](#blickfeld.protocol.config.ScanPattern.Pulse)"""
        pass
    @property
    def frame_rate(self) -> global___ScanPattern.FrameRate:
        """Refer to [ScanPattern.FrameRate](#blickfeld.protocol.config.ScanPattern.FrameRate)"""
        pass
    @property
    def filter(self) -> global___ScanPattern.Filter:
        """<blockquote>Introduced in BSL v2.11 and firmware v1.11</blockquote> Refer to [Filter](#blickfeld.protocol.config.ScanPattern.Filter)"""
        pass
    @property
    def constraints(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[blickfeld.common_pb2.Constraint]: ...
    def __init__(self,
        *,
        horizontal : typing.Optional[global___ScanPattern.Horizontal] = ...,
        vertical : typing.Optional[global___ScanPattern.Vertical] = ...,
        pulse : typing.Optional[global___ScanPattern.Pulse] = ...,
        frame_rate : typing.Optional[global___ScanPattern.FrameRate] = ...,
        filter : typing.Optional[global___ScanPattern.Filter] = ...,
        constraints : typing.Optional[typing.Iterable[blickfeld.common_pb2.Constraint]] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal[u"filter",b"filter",u"frame_rate",b"frame_rate",u"horizontal",b"horizontal",u"pulse",b"pulse",u"vertical",b"vertical"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"constraints",b"constraints",u"filter",b"filter",u"frame_rate",b"frame_rate",u"horizontal",b"horizontal",u"pulse",b"pulse",u"vertical",b"vertical"]) -> None: ...
global___ScanPattern = ScanPattern
