"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import blickfeld.common_pb2
import blickfeld.config.advanced_pb2
import blickfeld.config.named_scan_pattern_pb2
import blickfeld.config.product_pb2
import blickfeld.config.scan_pattern_pb2
import blickfeld.error_pb2
import blickfeld.status.main_pb2
import blickfeld.stream.connection_pb2
import blickfeld.stream.event_pb2
import builtins
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import typing
import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor = ...

class Format(_Format, metaclass=_FormatEnumTypeWrapper):
    """*
    The format type of response is an undocumented, internal feature required for the REST API.
    """
    pass
class _Format:
    V = typing.NewType('V', builtins.int)
class _FormatEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_Format.V], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor = ...
    PROTOBUF = Format.V(1)
    JSON = Format.V(2)

PROTOBUF = Format.V(1)
JSON = Format.V(2)
global___Format = Format


class Request(google.protobuf.message.Message):
    """*
    This section describes the different requests a client can send to the server.
    A request is always answered with a response. For every response, there is a request with the same name.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    class Hello(google.protobuf.message.Message):
        """*
        This request is used for initial communication after connecting to a device and testing the established connection.
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        PROTOCOL_VERSION_FIELD_NUMBER: builtins.int
        LIBRARY_VERSION_FIELD_NUMBER: builtins.int
        LANGUAGE_FIELD_NUMBER: builtins.int
        protocol_version: builtins.int = ...
        """Version of the Blickfeld protocol"""

        library_version: typing.Text = ...
        """<blockquote>Introduced in BSL v2.16 and firmware v1.17</blockquote>  Library version"""

        language: blickfeld.common_pb2.Language.V = ...
        """<blockquote>Introduced in BSL v2.16 and firmware v1.17</blockquote>  Library language"""

        def __init__(self,
            *,
            protocol_version : typing.Optional[builtins.int] = ...,
            library_version : typing.Optional[typing.Text] = ...,
            language : typing.Optional[blickfeld.common_pb2.Language.V] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal[u"language",b"language",u"library_version",b"library_version",u"protocol_version",b"protocol_version"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal[u"language",b"language",u"library_version",b"library_version",u"protocol_version",b"protocol_version"]) -> None: ...

    class ProxyHello(google.protobuf.message.Message):
        """*
        Internal use only

        This request is used by internal proxy implementation to forward the correct ip address to the server.
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        IP_ADDRESS_FIELD_NUMBER: builtins.int
        ip_address: typing.Text = ...
        """IP address of the real client"""

        def __init__(self,
            *,
            ip_address : typing.Optional[typing.Text] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal[u"ip_address",b"ip_address"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal[u"ip_address",b"ip_address"]) -> None: ...

    class Developer(google.protobuf.message.Message):
        """*
        Internal use only
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        def __init__(self,
            ) -> None: ...

    class SetScanPattern(google.protobuf.message.Message):
        """*
        This request is used for setting a Scan Pattern.
        A Scan Pattern can either be set by providing a Scan Pattern configuration or a name of a named Scan Pattern.
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        CONFIG_FIELD_NUMBER: builtins.int
        NAME_FIELD_NUMBER: builtins.int
        PERSIST_FIELD_NUMBER: builtins.int
        @property
        def config(self) -> blickfeld.config.scan_pattern_pb2.ScanPattern:
            """Refer to [ScanPattern](#blickfeld.protocol.config.ScanPattern)"""
            pass
        name: typing.Text = ...
        """Set named Scan Pattern, refer to [NamedScanPattern](#blickfeld.protocol.config.NamedScanPattern)"""

        persist: builtins.bool = ...
        """Persists the scan pattern and sets it after a power cycle. Default: False"""

        def __init__(self,
            *,
            config : typing.Optional[blickfeld.config.scan_pattern_pb2.ScanPattern] = ...,
            name : typing.Optional[typing.Text] = ...,
            persist : typing.Optional[builtins.bool] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal[u"config",b"config",u"data",b"data",u"name",b"name",u"persist",b"persist"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal[u"config",b"config",u"data",b"data",u"name",b"name",u"persist",b"persist"]) -> None: ...
        def WhichOneof(self, oneof_group: typing_extensions.Literal[u"data",b"data"]) -> typing.Optional[typing_extensions.Literal["config","name"]]: ...

    class FillScanPattern(google.protobuf.message.Message):
        """*
        This request is used to fill an empty or partially filled scan pattern with the required parameters.
        It will fill the given scan pattern with default values and return the filled scan pattern to the client.
        The filled scan pattern can then be set as input for  [Request.SetScanPattern](#blickfeld.protocol.Request.SetScanPattern).
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        CONFIG_FIELD_NUMBER: builtins.int
        @property
        def config(self) -> blickfeld.config.scan_pattern_pb2.ScanPattern:
            """Refer to [ScanPattern](#blickfeld.protocol.config.ScanPattern)"""
            pass
        def __init__(self,
            *,
            config : typing.Optional[blickfeld.config.scan_pattern_pb2.ScanPattern] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal[u"config",b"config"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal[u"config",b"config"]) -> None: ...

    class GetScanPattern(google.protobuf.message.Message):
        """*
        This request is used to retrieve the currently set [ScanPattern](#blickfeld.protocol.config.ScanPattern).
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        def __init__(self,
            ) -> None: ...

    class Status(google.protobuf.message.Message):
        """*
        This request is used for receiving the current [Status](#blickfeld.protocol.status.Status).
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        def __init__(self,
            ) -> None: ...

    class RunSelfTest(google.protobuf.message.Message):
        """*
        > Introduced in BSL v2.10 and firmware v1.9

        This request triggers a self test of the device.
        It validates the hardware, operates the device, and generates a report.
        The report is currently only accessible by developers.
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        def __init__(self,
            ) -> None: ...

    class SetAdvancedConfig(google.protobuf.message.Message):
        """*
        > Introduced in BSL v2.11 and firmware v1.11

        This request is used for configuring the advanced config.
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        CONFIG_FIELD_NUMBER: builtins.int
        PERSIST_FIELD_NUMBER: builtins.int
        @property
        def config(self) -> blickfeld.config.advanced_pb2.Advanced:
            """Refer to [Advanced](#blickfeld.protocol.config.Advanced)"""
            pass
        persist: builtins.bool = ...
        """Persists the config and sets it after a power cycle. Default: True"""

        def __init__(self,
            *,
            config : typing.Optional[blickfeld.config.advanced_pb2.Advanced] = ...,
            persist : typing.Optional[builtins.bool] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal[u"config",b"config",u"persist",b"persist"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal[u"config",b"config",u"persist",b"persist"]) -> None: ...

    class GetAdvancedConfig(google.protobuf.message.Message):
        """*
        > Introduced in BSL v2.11 and firmware v1.11

        This request is used to retrieve the currently set [Advanced](#blickfeld.protocol.config.Advanced).
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        def __init__(self,
            ) -> None: ...

    class AttemptErrorRecovery(google.protobuf.message.Message):
        """*
        > Introduced in BSL v2.13 and firmware v1.13

        This request can be used to attempt a re-initialization of the device if it is errored.
        A self test is automatically triggered after a successful re-initialization.
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        def __init__(self,
            ) -> None: ...

    class GetScanPatternConstraints(google.protobuf.message.Message):
        """*
        > Introduced in BSL v2.14 and firmware v1.14

        This request returns a list of constraints which are applied on scan patterns.
        The constraints define the constant and dynamic relationships between field values.
        The constraints are equal for a device type and firmware, but might vary for firmware releases and device variants.
        It is mainly used to visualize the constraints in the scan pattern configuration of the web gui.
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        def __init__(self,
            ) -> None: ...

    class GetNamedScanPatterns(google.protobuf.message.Message):
        """*
        > Introduced in BSL v2.15 and firmware v1.16

        This request returns a list of named scan patterns.
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        def __init__(self,
            ) -> None: ...

    class StoreNamedScanPattern(google.protobuf.message.Message):
        """*
        > Introduced in BSL v2.15 and firmware v1.16

        This request sets a named scan patterns.
        The name has to be different of the default scan patterns and can only contain letters, numbers, space, underscore and minus.
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        NAME_FIELD_NUMBER: builtins.int
        CONFIG_FIELD_NUMBER: builtins.int
        name: typing.Text = ...
        """Name"""

        @property
        def config(self) -> blickfeld.config.scan_pattern_pb2.ScanPattern:
            """Refer to [ScanPattern](#blickfeld.protocol.config.ScanPattern)"""
            pass
        def __init__(self,
            *,
            name : typing.Optional[typing.Text] = ...,
            config : typing.Optional[blickfeld.config.scan_pattern_pb2.ScanPattern] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal[u"config",b"config",u"name",b"name"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal[u"config",b"config",u"name",b"name"]) -> None: ...

    class DeleteNamedScanPattern(google.protobuf.message.Message):
        """*
        > Introduced in BSL v2.15 and firmware v1.16

        This request deletes a named scan pattern.
        Default scan patterns can't be deleted.
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        NAME_FIELD_NUMBER: builtins.int
        name: typing.Text = ...
        """Name"""

        def __init__(self,
            *,
            name : typing.Optional[typing.Text] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal[u"name",b"name"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal[u"name",b"name"]) -> None: ...

    HELLO_FIELD_NUMBER: builtins.int
    DEVELOPER_FIELD_NUMBER: builtins.int
    SET_SCAN_PATTERN_FIELD_NUMBER: builtins.int
    FILL_SCAN_PATTERN_FIELD_NUMBER: builtins.int
    GET_SCAN_PATTERN_FIELD_NUMBER: builtins.int
    SUBSCRIBE_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    RUN_SELF_TEST_FIELD_NUMBER: builtins.int
    SET_ADVANCED_CONFIG_FIELD_NUMBER: builtins.int
    GET_ADVANCED_CONFIG_FIELD_NUMBER: builtins.int
    UNSUBSCRIBE_FIELD_NUMBER: builtins.int
    ATTEMPT_ERROR_RECOVERY_FIELD_NUMBER: builtins.int
    GET_SCAN_PATTERN_CONSTRAINTS_FIELD_NUMBER: builtins.int
    GET_NAMED_SCAN_PATTERNS_FIELD_NUMBER: builtins.int
    STORE_NAMED_SCAN_PATTERN_FIELD_NUMBER: builtins.int
    DELETE_NAMED_SCAN_PATTERN_FIELD_NUMBER: builtins.int
    PROXY_HELLO_FIELD_NUMBER: builtins.int
    _ASJSON_FIELD_NUMBER: builtins.int
    ACCEPT_FORMAT_FIELD_NUMBER: builtins.int
    @property
    def hello(self) -> global___Request.Hello:
        """Refer to [Request.Hello](#blickfeld.protocol.Request.Hello)"""
        pass
    @property
    def developer(self) -> global___Request.Developer:
        """Refer to [Request.Developer](#blickfeld.protocol.Request.Developer)"""
        pass
    @property
    def set_scan_pattern(self) -> global___Request.SetScanPattern:
        """Refer to [Request.SetScanPattern](#blickfeld.protocol.Request.SetScanPattern)"""
        pass
    @property
    def fill_scan_pattern(self) -> global___Request.FillScanPattern:
        """Refer to [Request.FillScanPattern](#blickfeld.protocol.Request.FillScanPattern)"""
        pass
    @property
    def get_scan_pattern(self) -> global___Request.GetScanPattern:
        """Refer to [Request.GetScanPattern](#blickfeld.protocol.Request.GetScanPattern)"""
        pass
    @property
    def subscribe(self) -> blickfeld.stream.connection_pb2.Subscribe:
        """Refer to [Subscribe](#blickfeld.protocol.stream.Subscribe)"""
        pass
    @property
    def status(self) -> global___Request.Status:
        """Refer to [Request.Status](#blickfeld.protocol.Request.Status)"""
        pass
    @property
    def run_self_test(self) -> global___Request.RunSelfTest:
        """Refer to [Request.RunSelfTest](#blickfeld.protocol.Request.RunSelfTest)"""
        pass
    @property
    def set_advanced_config(self) -> global___Request.SetAdvancedConfig:
        """<blockquote>Introduced in BSL v2.11 and firmware v1.11</blockquote> Refer to [Request.SetAdvancedConfig](#blickfeld.protocol.Request.SetAdvancedConfig)"""
        pass
    @property
    def get_advanced_config(self) -> global___Request.GetAdvancedConfig:
        """<blockquote>Introduced in BSL v2.11 and firmware v1.11</blockquote> Refer to [Request.GetAdvancedConfig](#blickfeld.protocol.Request.GetAdvancedConfig)"""
        pass
    @property
    def unsubscribe(self) -> blickfeld.stream.connection_pb2.Subscribe:
        """<blockquote>Introduced in BSL v2.13 and firmware v1.13</blockquote> Unsubscribe a stream started with a [Subscribe](#blickfeld.protocol.stream.Subscribe) request."""
        pass
    @property
    def attempt_error_recovery(self) -> global___Request.AttemptErrorRecovery:
        """<blockquote>Introduced in BSL v2.13 and firmware v1.13</blockquote> Refer to [Request.AttemptErrorRecovery](#blickfeld.protocol.Request.AttemptErrorRecovery)"""
        pass
    @property
    def get_scan_pattern_constraints(self) -> global___Request.GetScanPatternConstraints:
        """<blockquote>Introduced in BSL v2.14 and firmware v1.14</blockquote> Refer to [Request.GetScanPatternConstraints](#blickfeld.protocol.Request.GetScanPatternConstraints)"""
        pass
    @property
    def get_named_scan_patterns(self) -> global___Request.GetNamedScanPatterns:
        """<blockquote>Introduced in BSL v2.15 and firmware v1.16</blockquote> Refer to [Request.GetNamedScanPatterns](#blickfeld.protocol.Request.GetNamedScanPatterns)"""
        pass
    @property
    def store_named_scan_pattern(self) -> global___Request.StoreNamedScanPattern:
        """<blockquote>Introduced in BSL v2.15 and firmware v1.16</blockquote> Refer to [Request.StoreNamedScanPattern](#blickfeld.protocol.Request.StoreNamedScanPattern)"""
        pass
    @property
    def delete_named_scan_pattern(self) -> global___Request.DeleteNamedScanPattern:
        """<blockquote>Introduced in BSL v2.15 and firmware v1.16</blockquote> Refer to [Request.DeleteNamedScanPattern](#blickfeld.protocol.Request.DeleteNamedScanPattern)"""
        pass
    @property
    def proxy_hello(self) -> global___Request.ProxyHello:
        """<blockquote>Introduced in BSL v2.16 and firmware v1.17</blockquote> Refer to [Request.ProxyHello](#blickfeld.protocol.Request.ProxyHello)"""
        pass
    _asJSON: typing.Text = ...
    """Internal use only"""

    accept_format: global___Format.V = ...
    """Internal use only"""

    def __init__(self,
        *,
        hello : typing.Optional[global___Request.Hello] = ...,
        developer : typing.Optional[global___Request.Developer] = ...,
        set_scan_pattern : typing.Optional[global___Request.SetScanPattern] = ...,
        fill_scan_pattern : typing.Optional[global___Request.FillScanPattern] = ...,
        get_scan_pattern : typing.Optional[global___Request.GetScanPattern] = ...,
        subscribe : typing.Optional[blickfeld.stream.connection_pb2.Subscribe] = ...,
        status : typing.Optional[global___Request.Status] = ...,
        run_self_test : typing.Optional[global___Request.RunSelfTest] = ...,
        set_advanced_config : typing.Optional[global___Request.SetAdvancedConfig] = ...,
        get_advanced_config : typing.Optional[global___Request.GetAdvancedConfig] = ...,
        unsubscribe : typing.Optional[blickfeld.stream.connection_pb2.Subscribe] = ...,
        attempt_error_recovery : typing.Optional[global___Request.AttemptErrorRecovery] = ...,
        get_scan_pattern_constraints : typing.Optional[global___Request.GetScanPatternConstraints] = ...,
        get_named_scan_patterns : typing.Optional[global___Request.GetNamedScanPatterns] = ...,
        store_named_scan_pattern : typing.Optional[global___Request.StoreNamedScanPattern] = ...,
        delete_named_scan_pattern : typing.Optional[global___Request.DeleteNamedScanPattern] = ...,
        proxy_hello : typing.Optional[global___Request.ProxyHello] = ...,
        _asJSON : typing.Optional[typing.Text] = ...,
        accept_format : typing.Optional[global___Format.V] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal[u"_asJSON",b"_asJSON",u"accept_format",b"accept_format",u"attempt_error_recovery",b"attempt_error_recovery",u"data",b"data",u"delete_named_scan_pattern",b"delete_named_scan_pattern",u"developer",b"developer",u"fill_scan_pattern",b"fill_scan_pattern",u"get_advanced_config",b"get_advanced_config",u"get_named_scan_patterns",b"get_named_scan_patterns",u"get_scan_pattern",b"get_scan_pattern",u"get_scan_pattern_constraints",b"get_scan_pattern_constraints",u"hello",b"hello",u"proxy_hello",b"proxy_hello",u"run_self_test",b"run_self_test",u"set_advanced_config",b"set_advanced_config",u"set_scan_pattern",b"set_scan_pattern",u"status",b"status",u"store_named_scan_pattern",b"store_named_scan_pattern",u"subscribe",b"subscribe",u"unsubscribe",b"unsubscribe"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"_asJSON",b"_asJSON",u"accept_format",b"accept_format",u"attempt_error_recovery",b"attempt_error_recovery",u"data",b"data",u"delete_named_scan_pattern",b"delete_named_scan_pattern",u"developer",b"developer",u"fill_scan_pattern",b"fill_scan_pattern",u"get_advanced_config",b"get_advanced_config",u"get_named_scan_patterns",b"get_named_scan_patterns",u"get_scan_pattern",b"get_scan_pattern",u"get_scan_pattern_constraints",b"get_scan_pattern_constraints",u"hello",b"hello",u"proxy_hello",b"proxy_hello",u"run_self_test",b"run_self_test",u"set_advanced_config",b"set_advanced_config",u"set_scan_pattern",b"set_scan_pattern",u"status",b"status",u"store_named_scan_pattern",b"store_named_scan_pattern",u"subscribe",b"subscribe",u"unsubscribe",b"unsubscribe"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal[u"data",b"data"]) -> typing.Optional[typing_extensions.Literal["hello","developer","set_scan_pattern","fill_scan_pattern","get_scan_pattern","subscribe","status","run_self_test","set_advanced_config","get_advanced_config","unsubscribe","attempt_error_recovery","get_scan_pattern_constraints","get_named_scan_patterns","store_named_scan_pattern","delete_named_scan_pattern","proxy_hello","_asJSON"]]: ...
global___Request = Request

class Response(google.protobuf.message.Message):
    """*
    This section describes the responses a client receives after sending a request to the server.
    For the request that corresponds to a given response, please refer to [Request](#blickfeld.protocol.Request).
    Each response has the same name as the request.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    class Hello(google.protobuf.message.Message):
        """*
        This response is sent out after establishing a connection.
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        class Firmware(google.protobuf.message.Message):
            """*
            > Introduced in BSL v2.16 and firmware v1.17

            Contains all firmware names, versions, and revisions.
            """
            DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
            class ModuleVersionsEntry(google.protobuf.message.Message):
                DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
                KEY_FIELD_NUMBER: builtins.int
                VALUE_FIELD_NUMBER: builtins.int
                key: typing.Text = ...
                @property
                def value(self) -> blickfeld.common_pb2.SoftwareVersion: ...
                def __init__(self,
                    *,
                    key : typing.Optional[typing.Text] = ...,
                    value : typing.Optional[blickfeld.common_pb2.SoftwareVersion] = ...,
                    ) -> None: ...
                def HasField(self, field_name: typing_extensions.Literal[u"key",b"key",u"value",b"value"]) -> builtins.bool: ...
                def ClearField(self, field_name: typing_extensions.Literal[u"key",b"key",u"value",b"value"]) -> None: ...

            VERSION_FIELD_NUMBER: builtins.int
            MODULE_VERSIONS_FIELD_NUMBER: builtins.int
            @property
            def version(self) -> blickfeld.common_pb2.SoftwareVersion:
                """Baseline version of firmware. Refer to [SoftwareVersion](#blickfeld.protocol.SoftwareVersion)."""
                pass
            @property
            def module_versions(self) -> google.protobuf.internal.containers.MessageMap[typing.Text, blickfeld.common_pb2.SoftwareVersion]:
                """Version of software modules. The key of the map is the name and the object is the [SoftwareVersion](#blickfeld.protocol.SoftwareVersion)."""
                pass
            def __init__(self,
                *,
                version : typing.Optional[blickfeld.common_pb2.SoftwareVersion] = ...,
                module_versions : typing.Optional[typing.Mapping[typing.Text, blickfeld.common_pb2.SoftwareVersion]] = ...,
                ) -> None: ...
            def HasField(self, field_name: typing_extensions.Literal[u"version",b"version"]) -> builtins.bool: ...
            def ClearField(self, field_name: typing_extensions.Literal[u"module_versions",b"module_versions",u"version",b"version"]) -> None: ...

        class HardwareModulesEntry(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
            KEY_FIELD_NUMBER: builtins.int
            VALUE_FIELD_NUMBER: builtins.int
            key: typing.Text = ...
            @property
            def value(self) -> blickfeld.common_pb2.HardwareModule: ...
            def __init__(self,
                *,
                key : typing.Optional[typing.Text] = ...,
                value : typing.Optional[blickfeld.common_pb2.HardwareModule] = ...,
                ) -> None: ...
            def HasField(self, field_name: typing_extensions.Literal[u"key",b"key",u"value",b"value"]) -> builtins.bool: ...
            def ClearField(self, field_name: typing_extensions.Literal[u"key",b"key",u"value",b"value"]) -> None: ...

        PROTOCOL_VERSION_FIELD_NUMBER: builtins.int
        LIBRARY_VERSION_FIELD_NUMBER: builtins.int
        LANGUAGE_FIELD_NUMBER: builtins.int
        PRODUCT_FIELD_NUMBER: builtins.int
        SERIAL_NUMBER_FIELD_NUMBER: builtins.int
        LEGACY_SERIAL_NUMBER_FIELD_NUMBER: builtins.int
        FIRMWARE_FIELD_NUMBER: builtins.int
        HARDWARE_MODULES_FIELD_NUMBER: builtins.int
        protocol_version: builtins.int = ...
        """Version of the Blickfeld Protocol"""

        library_version: typing.Text = ...
        """<blockquote>Introduced in BSL v2.16 and firmware v1.17</blockquote> Library version"""

        language: blickfeld.common_pb2.Language.V = ...
        """<blockquote>Introduced in BSL v2.16 and firmware v1.17</blockquote> Library language"""

        product: blickfeld.config.product_pb2.Product.V = ...
        """<blockquote>Introduced in BSL v2.16 and firmware v1.17</blockquote> Refer to [Product](#blickfeld.protocol.config.Product)."""

        serial_number: typing.Text = ...
        """<blockquote>Introduced in BSL v2.16 and firmware v1.17</blockquote> Cube serial number"""

        legacy_serial_number: typing.Text = ...
        """<blockquote>Introduced in BSL v2.16 and firmware v1.17</blockquote> Deprecated legacy serial number"""

        @property
        def firmware(self) -> global___Response.Hello.Firmware:
            """<blockquote>Introduced in BSL v2.16 and firmware v1.17</blockquote> Refer to [Firmware](#blickfeld.protocol.Response.Hello.Firmware)."""
            pass
        @property
        def hardware_modules(self) -> google.protobuf.internal.containers.MessageMap[typing.Text, blickfeld.common_pb2.HardwareModule]:
            """<blockquote>Introduced in BSL v2.16 and firmware v1.17</blockquote> Hardware module map, where the key is the name and the object is the [HardwareModule](#blickfeld.protocol.HardwareModule)."""
            pass
        def __init__(self,
            *,
            protocol_version : typing.Optional[builtins.int] = ...,
            library_version : typing.Optional[typing.Text] = ...,
            language : typing.Optional[blickfeld.common_pb2.Language.V] = ...,
            product : typing.Optional[blickfeld.config.product_pb2.Product.V] = ...,
            serial_number : typing.Optional[typing.Text] = ...,
            legacy_serial_number : typing.Optional[typing.Text] = ...,
            firmware : typing.Optional[global___Response.Hello.Firmware] = ...,
            hardware_modules : typing.Optional[typing.Mapping[typing.Text, blickfeld.common_pb2.HardwareModule]] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal[u"firmware",b"firmware",u"language",b"language",u"legacy_serial_number",b"legacy_serial_number",u"library_version",b"library_version",u"oneof_serial_number",b"oneof_serial_number",u"product",b"product",u"protocol_version",b"protocol_version",u"serial_number",b"serial_number"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal[u"firmware",b"firmware",u"hardware_modules",b"hardware_modules",u"language",b"language",u"legacy_serial_number",b"legacy_serial_number",u"library_version",b"library_version",u"oneof_serial_number",b"oneof_serial_number",u"product",b"product",u"protocol_version",b"protocol_version",u"serial_number",b"serial_number"]) -> None: ...
        def WhichOneof(self, oneof_group: typing_extensions.Literal[u"oneof_serial_number",b"oneof_serial_number"]) -> typing.Optional[typing_extensions.Literal["serial_number","legacy_serial_number"]]: ...

    class ProxyHello(google.protobuf.message.Message):
        """*
        Internal use only
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        def __init__(self,
            ) -> None: ...

    class Developer(google.protobuf.message.Message):
        """*
        Internal use only
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        def __init__(self,
            ) -> None: ...

    class SetScanPattern(google.protobuf.message.Message):
        """*
        This response is sent out after setting a scan pattern.
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        def __init__(self,
            ) -> None: ...

    class FillScanPattern(google.protobuf.message.Message):
        """*
        This response is given after a request to fill a sparse [ScanPattern](#blickfeld.protocol.config.ScanPattern) has been transmitted.
        It returns a scan pattern, the unset fields are filled with default values.
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        CONFIG_FIELD_NUMBER: builtins.int
        @property
        def config(self) -> blickfeld.config.scan_pattern_pb2.ScanPattern:
            """Refer to [ScanPattern](#blickfeld.protocol.config.ScanPattern)"""
            pass
        def __init__(self,
            *,
            config : typing.Optional[blickfeld.config.scan_pattern_pb2.ScanPattern] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal[u"config",b"config"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal[u"config",b"config"]) -> None: ...

    class GetScanPattern(google.protobuf.message.Message):
        """*
        This response is returned after a request to get the current [ScanPattern](#blickfeld.protocol.config.ScanPattern).
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        CONFIG_FIELD_NUMBER: builtins.int
        @property
        def config(self) -> blickfeld.config.scan_pattern_pb2.ScanPattern:
            """Refer to [ScanPattern](#blickfeld.protocol.config.ScanPattern)"""
            pass
        def __init__(self,
            *,
            config : typing.Optional[blickfeld.config.scan_pattern_pb2.ScanPattern] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal[u"config",b"config"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal[u"config",b"config"]) -> None: ...

    class RunSelfTest(google.protobuf.message.Message):
        """*
        > Introduced in BSL v2.10 and firmware v1.9

        This response is returned after a self test.
        The success flag indicates if the hardware is fully operational.
        The generated report is currently only accessible by developers.
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        SUCCESS_FIELD_NUMBER: builtins.int
        success: builtins.bool = ...
        def __init__(self,
            *,
            success : typing.Optional[builtins.bool] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal[u"success",b"success"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal[u"success",b"success"]) -> None: ...

    class SetAdvancedConfig(google.protobuf.message.Message):
        """*
        > Introduced in BSL v2.11 and firmware v1.11

        This response is sent out after setting an SetAdvancedConfig.
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        def __init__(self,
            ) -> None: ...

    class GetAdvancedConfig(google.protobuf.message.Message):
        """*
        > Introduced in BSL v2.11 and firmware v1.11

        This response is returned after a request to get the current [Advanced](#blickfeld.protocol.config.Advanced).
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        CONFIG_FIELD_NUMBER: builtins.int
        @property
        def config(self) -> blickfeld.config.advanced_pb2.Advanced:
            """Refer to [Advanced](#blickfeld.protocol.config.Advanced)"""
            pass
        def __init__(self,
            *,
            config : typing.Optional[blickfeld.config.advanced_pb2.Advanced] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal[u"config",b"config"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal[u"config",b"config"]) -> None: ...

    class AttemptErrorRecovery(google.protobuf.message.Message):
        """*
        > Introduced in BSL v2.13 and firmware v1.13

        This response is sent out after sending AttemptErrorRecovery.
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        def __init__(self,
            ) -> None: ...

    class GetScanPatternConstraints(google.protobuf.message.Message):
        """*
        > Introduced in BSL v2.14 and firmware v1.14

        This response is sent out after sending GetScanPatternConstraints.
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        CONSTRAINTS_FIELD_NUMBER: builtins.int
        @property
        def constraints(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[blickfeld.common_pb2.Constraint]:
            """List of constraints which apply for scan patterns."""
            pass
        def __init__(self,
            *,
            constraints : typing.Optional[typing.Iterable[blickfeld.common_pb2.Constraint]] = ...,
            ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal[u"constraints",b"constraints"]) -> None: ...

    class GetNamedScanPatterns(google.protobuf.message.Message):
        """*
        > Introduced in BSL v2.15 and firmware v1.16

        This response is sent out after sending GetNamedScanPatterns.
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        CONFIGS_FIELD_NUMBER: builtins.int
        @property
        def configs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[blickfeld.config.named_scan_pattern_pb2.NamedScanPattern]:
            """List of named scan patterns, refer to [NamedScanPattern](#blickfeld.protocol.config.NamedScanPattern)"""
            pass
        def __init__(self,
            *,
            configs : typing.Optional[typing.Iterable[blickfeld.config.named_scan_pattern_pb2.NamedScanPattern]] = ...,
            ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal[u"configs",b"configs"]) -> None: ...

    class StoreNamedScanPattern(google.protobuf.message.Message):
        """*
        > Introduced in BSL v2.15 and firmware v1.16

        This response is sent out after sending StoreNamedScanPattern.
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        def __init__(self,
            ) -> None: ...

    class DeleteNamedScanPattern(google.protobuf.message.Message):
        """*
        > Introduced in BSL v2.15 and firmware v1.16

        This response is sent out after sending DeleteNamedScanPattern.
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        def __init__(self,
            ) -> None: ...

    TIMESTAMP_NS_FIELD_NUMBER: builtins.int
    ERROR_FIELD_NUMBER: builtins.int
    HELLO_FIELD_NUMBER: builtins.int
    DEVELOPER_FIELD_NUMBER: builtins.int
    SET_SCAN_PATTERN_FIELD_NUMBER: builtins.int
    FILL_SCAN_PATTERN_FIELD_NUMBER: builtins.int
    GET_SCAN_PATTERN_FIELD_NUMBER: builtins.int
    EVENT_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    RUN_SELF_TEST_FIELD_NUMBER: builtins.int
    SET_ADVANCED_CONFIG_FIELD_NUMBER: builtins.int
    GET_ADVANCED_CONFIG_FIELD_NUMBER: builtins.int
    ATTEMPT_ERROR_RECOVERY_FIELD_NUMBER: builtins.int
    GET_SCAN_PATTERN_CONSTRAINTS_FIELD_NUMBER: builtins.int
    GET_NAMED_SCAN_PATTERNS_FIELD_NUMBER: builtins.int
    STORE_NAMED_SCAN_PATTERN_FIELD_NUMBER: builtins.int
    DELETE_NAMED_SCAN_PATTERN_FIELD_NUMBER: builtins.int
    PROXY_HELLO_FIELD_NUMBER: builtins.int
    _ASJSON_FIELD_NUMBER: builtins.int
    timestamp_ns: builtins.int = ...
    """Unit: [ns] - timestamp when the response is sent out"""

    @property
    def error(self) -> blickfeld.error_pb2.Error:
        """Refer to [Error](#blickfeld.protocol.Error)"""
        pass
    @property
    def hello(self) -> global___Response.Hello:
        """Refer to [Response.Hello](#blickfeld.protocol.Response.Hello)"""
        pass
    @property
    def developer(self) -> global___Response.Developer:
        """Refer to [Response.Developer](#blickfeld.protocol.Response.Developer)"""
        pass
    @property
    def set_scan_pattern(self) -> global___Response.SetScanPattern:
        """Refer to [Response.SetScanPattern](#blickfeld.protocol.Response.SetScanPattern)"""
        pass
    @property
    def fill_scan_pattern(self) -> global___Response.FillScanPattern:
        """Refer to [Response.FillScanPattern](#blickfeld.protocol.Response.FillScanPattern)"""
        pass
    @property
    def get_scan_pattern(self) -> global___Response.GetScanPattern:
        """Refer to [Response.GetScanPattern](#blickfeld.protocol.Response.GetScanPattern)"""
        pass
    @property
    def event(self) -> blickfeld.stream.event_pb2.Event:
        """Refer to [Event](#blickfeld.protocol.stream.Event)"""
        pass
    @property
    def status(self) -> blickfeld.status.main_pb2.Status:
        """Refer to [Response.Status](#blickfeld.protocol.Response.Status)"""
        pass
    @property
    def run_self_test(self) -> global___Response.RunSelfTest:
        """Refer to [Response.RunSelfTest](#blickfeld.protocol.Response.RunSelfTest)"""
        pass
    @property
    def set_advanced_config(self) -> global___Response.SetAdvancedConfig:
        """<blockquote>Introduced in BSL v2.11 and firmware v1.11</blockquote> Refer to [Response.SetAdvanced](#blickfeld.protocol.Response.SetAdvancedConfig)"""
        pass
    @property
    def get_advanced_config(self) -> global___Response.GetAdvancedConfig:
        """<blockquote>Introduced in BSL v2.11 and firmware v1.11</blockquote> Refer to [Response.GetAdvanced](#blickfeld.protocol.Response.GetAdvancedConfig)"""
        pass
    @property
    def attempt_error_recovery(self) -> global___Response.AttemptErrorRecovery:
        """<blockquote>Introduced in BSL v2.13 and firmware v1.13</blockquote> Refer to [Response.AttemptErrorRecovery](#blickfeld.protocol.Response.AttemptErrorRecovery)"""
        pass
    @property
    def get_scan_pattern_constraints(self) -> global___Response.GetScanPatternConstraints:
        """<blockquote>Introduced in BSL v2.14 and firmware v1.14</blockquote> Refer to [Response.GetScanPatternConstraints](#blickfeld.protocol.Response.GetScanPatternConstraints)"""
        pass
    @property
    def get_named_scan_patterns(self) -> global___Response.GetNamedScanPatterns:
        """<blockquote>Introduced in BSL v2.15 and firmware v1.16</blockquote> Refer to [Response.GetNamedScanPatterns](#blickfeld.protocol.Response.GetNamedScanPatterns)"""
        pass
    @property
    def store_named_scan_pattern(self) -> global___Response.StoreNamedScanPattern:
        """<blockquote>Introduced in BSL v2.15 and firmware v1.16</blockquote> Refer to [Response.StoreNamedScanPattern](#blickfeld.protocol.Response.StoreNamedScanPattern)"""
        pass
    @property
    def delete_named_scan_pattern(self) -> global___Response.DeleteNamedScanPattern:
        """<blockquote>Introduced in BSL v2.15 and firmware v1.16</blockquote> Refer to [Response.DeleteNamedScanPattern](#blickfeld.protocol.Response.DeleteNamedScanPattern)"""
        pass
    @property
    def proxy_hello(self) -> global___Response.ProxyHello:
        """<blockquote>Introduced in BSL v2.16 and firmware v1.17</blockquote> Refer to [Response.ProxyHello](#blickfeld.protocol.Response.ProxyHello)"""
        pass
    _asJSON: typing.Text = ...
    """Internal use only"""

    def __init__(self,
        *,
        timestamp_ns : typing.Optional[builtins.int] = ...,
        error : typing.Optional[blickfeld.error_pb2.Error] = ...,
        hello : typing.Optional[global___Response.Hello] = ...,
        developer : typing.Optional[global___Response.Developer] = ...,
        set_scan_pattern : typing.Optional[global___Response.SetScanPattern] = ...,
        fill_scan_pattern : typing.Optional[global___Response.FillScanPattern] = ...,
        get_scan_pattern : typing.Optional[global___Response.GetScanPattern] = ...,
        event : typing.Optional[blickfeld.stream.event_pb2.Event] = ...,
        status : typing.Optional[blickfeld.status.main_pb2.Status] = ...,
        run_self_test : typing.Optional[global___Response.RunSelfTest] = ...,
        set_advanced_config : typing.Optional[global___Response.SetAdvancedConfig] = ...,
        get_advanced_config : typing.Optional[global___Response.GetAdvancedConfig] = ...,
        attempt_error_recovery : typing.Optional[global___Response.AttemptErrorRecovery] = ...,
        get_scan_pattern_constraints : typing.Optional[global___Response.GetScanPatternConstraints] = ...,
        get_named_scan_patterns : typing.Optional[global___Response.GetNamedScanPatterns] = ...,
        store_named_scan_pattern : typing.Optional[global___Response.StoreNamedScanPattern] = ...,
        delete_named_scan_pattern : typing.Optional[global___Response.DeleteNamedScanPattern] = ...,
        proxy_hello : typing.Optional[global___Response.ProxyHello] = ...,
        _asJSON : typing.Optional[typing.Text] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal[u"_asJSON",b"_asJSON",u"attempt_error_recovery",b"attempt_error_recovery",u"data",b"data",u"delete_named_scan_pattern",b"delete_named_scan_pattern",u"developer",b"developer",u"error",b"error",u"event",b"event",u"fill_scan_pattern",b"fill_scan_pattern",u"get_advanced_config",b"get_advanced_config",u"get_named_scan_patterns",b"get_named_scan_patterns",u"get_scan_pattern",b"get_scan_pattern",u"get_scan_pattern_constraints",b"get_scan_pattern_constraints",u"hello",b"hello",u"proxy_hello",b"proxy_hello",u"run_self_test",b"run_self_test",u"set_advanced_config",b"set_advanced_config",u"set_scan_pattern",b"set_scan_pattern",u"status",b"status",u"store_named_scan_pattern",b"store_named_scan_pattern",u"timestamp_ns",b"timestamp_ns"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"_asJSON",b"_asJSON",u"attempt_error_recovery",b"attempt_error_recovery",u"data",b"data",u"delete_named_scan_pattern",b"delete_named_scan_pattern",u"developer",b"developer",u"error",b"error",u"event",b"event",u"fill_scan_pattern",b"fill_scan_pattern",u"get_advanced_config",b"get_advanced_config",u"get_named_scan_patterns",b"get_named_scan_patterns",u"get_scan_pattern",b"get_scan_pattern",u"get_scan_pattern_constraints",b"get_scan_pattern_constraints",u"hello",b"hello",u"proxy_hello",b"proxy_hello",u"run_self_test",b"run_self_test",u"set_advanced_config",b"set_advanced_config",u"set_scan_pattern",b"set_scan_pattern",u"status",b"status",u"store_named_scan_pattern",b"store_named_scan_pattern",u"timestamp_ns",b"timestamp_ns"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal[u"data",b"data"]) -> typing.Optional[typing_extensions.Literal["error","hello","developer","set_scan_pattern","fill_scan_pattern","get_scan_pattern","event","status","run_self_test","set_advanced_config","get_advanced_config","attempt_error_recovery","get_scan_pattern_constraints","get_named_scan_patterns","store_named_scan_pattern","delete_named_scan_pattern","proxy_hello","_asJSON"]]: ...
global___Response = Response
