"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import blickfeld.config.scan_pattern_pb2
import blickfeld.data.algorithm_pb2
import blickfeld.data.scanline_pb2
import builtins
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor = ...

class Frame(google.protobuf.message.Message):
    """*
    This section describes the contents of a point cloud frame.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    class Packed(google.protobuf.message.Message):
        """*
        > Introduced in BSL v2.16 and firmware v1.17

        This format returns point clouds as flat binary structures.
        These can be efficiently encoded & decoded, which increases the performance on low-performance clients significantly.
        The network bandwidth is usually slightly higher as the data is not encoded.

        Note:
        The reference frame concept is handled differently for packed structures.
        To activate the packed format, it is sufficient to set an empty packed message in the reference frame.
        The requested fields need to be selected in the scanlines structure.
        Refer to REF_FRAME_PACKED in the client implementations.
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        LENGTH_FIELD_NUMBER: builtins.int
        CARTESIAN_FIELD_NUMBER: builtins.int
        DIRECTION_FIELD_NUMBER: builtins.int
        RANGE_FIELD_NUMBER: builtins.int
        INTENSITY_FIELD_NUMBER: builtins.int
        AMBIENT_LIGHT_LEVEL_FIELD_NUMBER: builtins.int
        START_OFFSET_NS_FIELD_NUMBER: builtins.int
        POINT_ID_FIELD_NUMBER: builtins.int
        CHANNEL_ID_FIELD_NUMBER: builtins.int
        RETURN_ID_FIELD_NUMBER: builtins.int
        length: builtins.int = ...
        """Length of arrays"""

        cartesian: builtins.bytes = ...
        """Cartesian coordinates. 3-dimensional array in row-major format with [x, y, z] tuples. Unit: [m]. Type: Float32. Byte Order: Big Endian."""

        direction: builtins.bytes = ...
        """Polar coordinates. 2-dimensional array in row-major format with [azimuth, elevation] tuples. Unit: [rad]. Type: Float32. Byte Order: Big Endian."""

        range: builtins.bytes = ...
        """Distance to the return. 1-dimensional array. Unit: [m]. Type: Float32. Byte Order: Big Endian."""

        intensity: builtins.bytes = ...
        """Intensity of the returned laser pulse. 1-dimensional array. Type: UInt32. Byte Order: Big Endian."""

        ambient_light_level: builtins.bytes = ...
        """Ambient light level in the direction of the point. 1-dimensional array. Type: UInt32. Byte Order: Big Endian."""

        start_offset_ns: builtins.bytes = ...
        """Starting time of the point in relation to [Frame.start_time_ns](#blickfeld.protocol.data.Frame.start_time_ns). 1-dimensional array. Unit: [ns]. Type: UInt64. Byte Order: Big Endian."""

        point_id: builtins.bytes = ...
        """Unique point identifier within a frame and scan pattern. 1-dimensional array. Type: UInt32. Byte Order: Big Endian."""

        channel_id: builtins.bytes = ...
        """Identifier of the channel that detected the point. 1-dimensional array. Type: UInt8."""

        return_id: builtins.bytes = ...
        """Identifier of the return. Note: Returns are ordered by intensity not by distance. 1-dimensional array. Type: UInt8."""

        def __init__(self,
            *,
            length : typing.Optional[builtins.int] = ...,
            cartesian : typing.Optional[builtins.bytes] = ...,
            direction : typing.Optional[builtins.bytes] = ...,
            range : typing.Optional[builtins.bytes] = ...,
            intensity : typing.Optional[builtins.bytes] = ...,
            ambient_light_level : typing.Optional[builtins.bytes] = ...,
            start_offset_ns : typing.Optional[builtins.bytes] = ...,
            point_id : typing.Optional[builtins.bytes] = ...,
            channel_id : typing.Optional[builtins.bytes] = ...,
            return_id : typing.Optional[builtins.bytes] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal[u"ambient_light_level",b"ambient_light_level",u"cartesian",b"cartesian",u"channel_id",b"channel_id",u"direction",b"direction",u"intensity",b"intensity",u"length",b"length",u"point_id",b"point_id",u"range",b"range",u"return_id",b"return_id",u"start_offset_ns",b"start_offset_ns"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal[u"ambient_light_level",b"ambient_light_level",u"cartesian",b"cartesian",u"channel_id",b"channel_id",u"direction",b"direction",u"intensity",b"intensity",u"length",b"length",u"point_id",b"point_id",u"range",b"range",u"return_id",b"return_id",u"start_offset_ns",b"start_offset_ns"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    START_TIME_NS_FIELD_NUMBER: builtins.int
    SCAN_PATTERN_FIELD_NUMBER: builtins.int
    IS_RAMP_UP_PHASE_FIELD_NUMBER: builtins.int
    TOTAL_NUMBER_OF_POINTS_FIELD_NUMBER: builtins.int
    TOTAL_NUMBER_OF_RETURNS_FIELD_NUMBER: builtins.int
    SCANLINES_FIELD_NUMBER: builtins.int
    PACKED_FIELD_NUMBER: builtins.int
    ALGORITHMS_FIELD_NUMBER: builtins.int
    id: builtins.int = ...
    """Incremental frame ID since startup of the device"""

    start_time_ns: builtins.int = ...
    """Unit: [s] – start frame timestamp"""

    @property
    def scan_pattern(self) -> blickfeld.config.scan_pattern_pb2.ScanPattern:
        """Refer to [ScanPattern](#blickfeld.protocol.config.ScanPattern)"""
        pass
    is_ramp_up_phase: builtins.bool = ...
    """<blockquote>Introduced in BSL v2.16 and firmware v1.17</blockquote> If the frame_mode in the scan pattern is set to SEPARATE, this value indicates if the given frame was captured during up-ramping or down-ramping."""

    total_number_of_points: builtins.int = ...
    """Number of laser pulses emitted in this frame."""

    total_number_of_returns: builtins.int = ...
    """Number of returned points recorded: Each point of the [total_number_of_points](#blickfeld.protocol.data.Frame.total_number_of_points) can produce several returns."""

    @property
    def scanlines(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[blickfeld.data.scanline_pb2.Scanline]:
        """Refer to [Scanline](#blickfeld.protocol.data.Scanline)"""
        pass
    @property
    def packed(self) -> global___Frame.Packed:
        """<blockquote>Introduced in BSL v2.16 and firmware v1.17</blockquote> Refer to [Packed](#blickfeld.protocol.data.Frame.Packed)"""
        pass
    @property
    def algorithms(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[blickfeld.data.algorithm_pb2.Algorithm]:
        """<blockquote>Introduced in BSL v2.17 and firmware v1.16</blockquote> Refer to [data.Algorithm](#blickfeld.protocol.data.Algorithm). Each algorithm configured can output additional data, which is provided with this field."""
        pass
    def __init__(self,
        *,
        id : typing.Optional[builtins.int] = ...,
        start_time_ns : typing.Optional[builtins.int] = ...,
        scan_pattern : typing.Optional[blickfeld.config.scan_pattern_pb2.ScanPattern] = ...,
        is_ramp_up_phase : typing.Optional[builtins.bool] = ...,
        total_number_of_points : typing.Optional[builtins.int] = ...,
        total_number_of_returns : typing.Optional[builtins.int] = ...,
        scanlines : typing.Optional[typing.Iterable[blickfeld.data.scanline_pb2.Scanline]] = ...,
        packed : typing.Optional[global___Frame.Packed] = ...,
        algorithms : typing.Optional[typing.Iterable[blickfeld.data.algorithm_pb2.Algorithm]] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal[u"id",b"id",u"is_ramp_up_phase",b"is_ramp_up_phase",u"packed",b"packed",u"scan_pattern",b"scan_pattern",u"start_time_ns",b"start_time_ns",u"total_number_of_points",b"total_number_of_points",u"total_number_of_returns",b"total_number_of_returns"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"algorithms",b"algorithms",u"id",b"id",u"is_ramp_up_phase",b"is_ramp_up_phase",u"packed",b"packed",u"scan_pattern",b"scan_pattern",u"scanlines",b"scanlines",u"start_time_ns",b"start_time_ns",u"total_number_of_points",b"total_number_of_points",u"total_number_of_returns",b"total_number_of_returns"]) -> None: ...
global___Frame = Frame
