"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor = ...

class IMU(google.protobuf.message.Message):
    """*
    > Introduced in BSL v2.18 and firmware v1.19

    The Cube has an on-board IMU, which can be used for e.g. mapping applications or static auto-leveling.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    class Sample(google.protobuf.message.Message):
        """*
        Describes a single IMU state.
        Data rate is approx. 1.125 khz.
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        START_OFFSET_NS_FIELD_NUMBER: builtins.int
        ACCELERATION_FIELD_NUMBER: builtins.int
        ANGULAR_VELOCITY_FIELD_NUMBER: builtins.int
        start_offset_ns: builtins.int = ...
        """Unit: [ns] – Offset to [start_time_ns](#blickfeld.protocol.data.IMU.start_time_ns)"""

        @property
        def acceleration(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]:
            """Unit: [g] - Format: [x,y,z] - Measured acceleration for 3-axes."""
            pass
        @property
        def angular_velocity(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]:
            """Unit: [rad/s] - Format: [x,y,z] - Measured angular velocity by gyroscope for 3-axes."""
            pass
        def __init__(self,
            *,
            start_offset_ns : typing.Optional[builtins.int] = ...,
            acceleration : typing.Optional[typing.Iterable[builtins.float]] = ...,
            angular_velocity : typing.Optional[typing.Iterable[builtins.float]] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal[u"start_offset_ns",b"start_offset_ns"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal[u"acceleration",b"acceleration",u"angular_velocity",b"angular_velocity",u"start_offset_ns",b"start_offset_ns"]) -> None: ...

    class Packed(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        LENGTH_FIELD_NUMBER: builtins.int
        START_OFFSET_NS_FIELD_NUMBER: builtins.int
        ACCELERATION_FIELD_NUMBER: builtins.int
        ANGULAR_VELOCITY_FIELD_NUMBER: builtins.int
        length: builtins.int = ...
        """Length of arrays"""

        start_offset_ns: builtins.bytes = ...
        """Starting time of the point in relation to [Data.start_time_ns](#blickfeld.protocol.data.IMU.Data.start_time_ns). 1-dimensional array. Unit: [ns]. Type: UInt64. Byte Order: Big Endian."""

        acceleration: builtins.bytes = ...
        """Accerlation. 3-dimensional array in row-major format with [x, y, z] tuples. Unit: [g]. Type: Float32. Byte Order: Big Endian."""

        angular_velocity: builtins.bytes = ...
        """Angular velocity, measured with gyroscope. 3-dimensional array in row-major format with [x, y, z] tuples. Unit: [rad/s]. Type: Float32. Byte Order: Big Endian."""

        def __init__(self,
            *,
            length : typing.Optional[builtins.int] = ...,
            start_offset_ns : typing.Optional[builtins.bytes] = ...,
            acceleration : typing.Optional[builtins.bytes] = ...,
            angular_velocity : typing.Optional[builtins.bytes] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal[u"acceleration",b"acceleration",u"angular_velocity",b"angular_velocity",u"length",b"length",u"start_offset_ns",b"start_offset_ns"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal[u"acceleration",b"acceleration",u"angular_velocity",b"angular_velocity",u"length",b"length",u"start_offset_ns",b"start_offset_ns"]) -> None: ...

    START_TIME_NS_FIELD_NUMBER: builtins.int
    SAMPLES_FIELD_NUMBER: builtins.int
    PACKED_FIELD_NUMBER: builtins.int
    start_time_ns: builtins.int = ...
    """Unit: [ns] – start timestamp of data. The start_offset_ns in each sample refers to this value. The timestamp is synchronized to the ones in point cloud frames."""

    @property
    def samples(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___IMU.Sample]:
        """Refer to [Sample](#blickfeld.protocol.data.IMU.Sample)"""
        pass
    @property
    def packed(self) -> global___IMU.Packed:
        """Refer to [Packed](#blickfeld.protocol.data.IMU.Packed)"""
        pass
    def __init__(self,
        *,
        start_time_ns : typing.Optional[builtins.int] = ...,
        samples : typing.Optional[typing.Iterable[global___IMU.Sample]] = ...,
        packed : typing.Optional[global___IMU.Packed] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal[u"packed",b"packed",u"start_time_ns",b"start_time_ns"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"packed",b"packed",u"samples",b"samples",u"start_time_ns",b"start_time_ns"]) -> None: ...
global___IMU = IMU
