"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import blickfeld.data.frame_pb2
import blickfeld.data.scanline_pb2
import blickfeld.stream.connection_pb2
import blickfeld.update.hardware_pb2
import builtins
import google.protobuf.descriptor
import google.protobuf.message
import typing
import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor = ...

class PointCloud(google.protobuf.message.Message):
    """*
    A point cloud object can contain either a full frame or a single scan line.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    class Header(google.protobuf.message.Message):
        """*
        This section describes the contents of a point cloud header.
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        LEGACY_CUBE_SERIAL_NUMBER_FIELD_NUMBER: builtins.int
        CUBE_SERIAL_NUMBER_FIELD_NUMBER: builtins.int
        START_TIME_NS_FIELD_NUMBER: builtins.int
        FIRMWARE_VERSION_FIELD_NUMBER: builtins.int
        HARDWARE_VARIANT_FIELD_NUMBER: builtins.int
        SUBSCRIPTION_FIELD_NUMBER: builtins.int
        legacy_cube_serial_number: typing.Text = ...
        """Legacy serial number of the device which recorded the pointcloud"""

        cube_serial_number: typing.Text = ...
        """Serial number of the device which recorded the pointcloud"""

        start_time_ns: builtins.int = ...
        """Unit: [s] - Start timestamp of the requested pointcloud stream"""

        firmware_version: typing.Text = ...
        """Firmware version of the device which recorded the pointcloud"""

        hardware_variant: blickfeld.update.hardware_pb2.HardwareVariant.V = ...
        """Hardware variant of the device which recorded the pointcloud"""

        @property
        def subscription(self) -> blickfeld.stream.connection_pb2.Subscribe.PointCloud:
            """<blockquote>Introduced in BSL v2.16 and firmware v1.17</blockquote> Used & merged subscription for stream"""
            pass
        def __init__(self,
            *,
            legacy_cube_serial_number : typing.Optional[typing.Text] = ...,
            cube_serial_number : typing.Optional[typing.Text] = ...,
            start_time_ns : typing.Optional[builtins.int] = ...,
            firmware_version : typing.Optional[typing.Text] = ...,
            hardware_variant : typing.Optional[blickfeld.update.hardware_pb2.HardwareVariant.V] = ...,
            subscription : typing.Optional[blickfeld.stream.connection_pb2.Subscribe.PointCloud] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal[u"cube_serial_number",b"cube_serial_number",u"firmware_version",b"firmware_version",u"hardware_variant",b"hardware_variant",u"legacy_cube_serial_number",b"legacy_cube_serial_number",u"start_time_ns",b"start_time_ns",u"subscription",b"subscription"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal[u"cube_serial_number",b"cube_serial_number",u"firmware_version",b"firmware_version",u"hardware_variant",b"hardware_variant",u"legacy_cube_serial_number",b"legacy_cube_serial_number",u"start_time_ns",b"start_time_ns",u"subscription",b"subscription"]) -> None: ...

    HEADER_FIELD_NUMBER: builtins.int
    FRAME_FIELD_NUMBER: builtins.int
    SCANLINE_FIELD_NUMBER: builtins.int
    @property
    def header(self) -> global___PointCloud.Header:
        """Refer to [PointCloud.Header](#blickfeld.protocol.data.PointCloud.Header)"""
        pass
    @property
    def frame(self) -> blickfeld.data.frame_pb2.Frame:
        """Refer to [Frame](#blickfeld.protocol.data.Frame)"""
        pass
    @property
    def scanline(self) -> blickfeld.data.scanline_pb2.Scanline:
        """Refer to [Scanline](#blickfeld.protocol.data.Scanline)"""
        pass
    def __init__(self,
        *,
        header : typing.Optional[global___PointCloud.Header] = ...,
        frame : typing.Optional[blickfeld.data.frame_pb2.Frame] = ...,
        scanline : typing.Optional[blickfeld.data.scanline_pb2.Scanline] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal[u"data",b"data",u"frame",b"frame",u"header",b"header",u"scanline",b"scanline"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"data",b"data",u"frame",b"frame",u"header",b"header",u"scanline",b"scanline"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal[u"data",b"data"]) -> typing.Optional[typing_extensions.Literal["header","frame","scanline"]]: ...
global___PointCloud = PointCloud
