"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import typing
import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor = ...

class Point(google.protobuf.message.Message):
    """*
    This section describes the contents of a single point of a point cloud frame or scan line.
    Each point resembles a direction in which the laser has fired.
    From each point (direction) the device can receive several responses/returns, see [Point.Return](#blickfeld.protocol.data.Point.Return).
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    class ErrorFlag(_ErrorFlag, metaclass=_ErrorFlagEnumTypeWrapper):
        """*
        Error flag indicating why a point delivers no valid returns.
        If a flag is set, the point should not be interpreted neither processed.
        Flags are only set temporarily for a short period of time.
        If the error state does not recover, the device will stop operation.
        """
        pass
    class _ErrorFlag:
        V = typing.NewType('V', builtins.int)
    class _ErrorFlagEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ErrorFlag.V], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor = ...
        E_VIBRATION_THRESHOLD_EXCEEDED = Point.ErrorFlag.V(1)
        """The environmental vibration threshold was exceeded. This should not happen in normal operation."""


    E_VIBRATION_THRESHOLD_EXCEEDED = Point.ErrorFlag.V(1)
    """The environmental vibration threshold was exceeded. This should not happen in normal operation."""


    class Return(google.protobuf.message.Message):
        """*
        This section describes the contents of a single return of a point, sorted by intensity.
        A return is created when the LiDAR detects the laser light of the reflection of an object.
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        ID_FIELD_NUMBER: builtins.int
        CARTESIAN_FIELD_NUMBER: builtins.int
        RANGE_FIELD_NUMBER: builtins.int
        INTENSITY_FIELD_NUMBER: builtins.int
        id: builtins.int = ...
        """ID of the return in the point"""

        @property
        def cartesian(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]:
            """Unit: [m] – Cartesian coordinates of the target [x,y,z]"""
            pass
        range: builtins.float = ...
        """Unit: [m] – distance of target to the origin"""

        intensity: builtins.int = ...
        """Intensity of the returned laser pulse"""

        def __init__(self,
            *,
            id : typing.Optional[builtins.int] = ...,
            cartesian : typing.Optional[typing.Iterable[builtins.float]] = ...,
            range : typing.Optional[builtins.float] = ...,
            intensity : typing.Optional[builtins.int] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal[u"id",b"id",u"intensity",b"intensity",u"range",b"range"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal[u"cartesian",b"cartesian",u"id",b"id",u"intensity",b"intensity",u"range",b"range"]) -> None: ...

    class Direction(google.protobuf.message.Message):
        """*
        This section describes the direction and the origin of a point.
        Use these polar coordinates combined with the range information of a given return, if you want to locate the reflection in the spherical coordinatesystem.
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        AZIMUTH_FIELD_NUMBER: builtins.int
        ELEVATION_FIELD_NUMBER: builtins.int
        ORIGIN_FIELD_NUMBER: builtins.int
        azimuth: builtins.float = ...
        """Unit: [rad] - azimuth angle: Angle with respect to y-z plane"""

        elevation: builtins.float = ...
        """Unit: [rad] - elevation angle: Angle with respect to x-y plane"""

        @property
        def origin(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]:
            """Unit: [m] - origin of the laser beam [x,y,z]"""
            pass
        def __init__(self,
            *,
            azimuth : typing.Optional[builtins.float] = ...,
            elevation : typing.Optional[builtins.float] = ...,
            origin : typing.Optional[typing.Iterable[builtins.float]] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal[u"azimuth",b"azimuth",u"elevation",b"elevation"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal[u"azimuth",b"azimuth",u"elevation",b"elevation",u"origin",b"origin"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    RETURNS_FIELD_NUMBER: builtins.int
    START_OFFSET_NS_FIELD_NUMBER: builtins.int
    AMBIENT_LIGHT_LEVEL_FIELD_NUMBER: builtins.int
    DIRECTION_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    ERROR_FLAGS_FIELD_NUMBER: builtins.int
    id: builtins.int = ...
    """Point ID in the corresponding frame"""

    @property
    def returns(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Point.Return]:
        """Refer to [Point.Return](#blickfeld.protocol.data.Point.Return)"""
        pass
    start_offset_ns: builtins.int = ...
    """Unit: [ns] - starting time of the point in relation to [Frame.start_time_ns](#blickfeld.protocol.data.Frame.start_time_ns)"""

    ambient_light_level: builtins.int = ...
    """Ambient light level in the direction of the point"""

    @property
    def direction(self) -> global___Point.Direction:
        """Refer to [Point.Direction](#blickfeld.protocol.data.Point.Direction)"""
        pass
    channel_id: builtins.int = ...
    """ID of the channel that detected the point"""

    @property
    def error_flags(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___Point.ErrorFlag.V]:
        """Refer to [Point.ErrorFlag](#blickfeld.protocol.data.Point.ErrorFlag)"""
        pass
    def __init__(self,
        *,
        id : typing.Optional[builtins.int] = ...,
        returns : typing.Optional[typing.Iterable[global___Point.Return]] = ...,
        start_offset_ns : typing.Optional[builtins.int] = ...,
        ambient_light_level : typing.Optional[builtins.int] = ...,
        direction : typing.Optional[global___Point.Direction] = ...,
        channel_id : typing.Optional[builtins.int] = ...,
        error_flags : typing.Optional[typing.Iterable[global___Point.ErrorFlag.V]] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal[u"ambient_light_level",b"ambient_light_level",u"channel_id",b"channel_id",u"direction",b"direction",u"id",b"id",u"start_offset_ns",b"start_offset_ns"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"ambient_light_level",b"ambient_light_level",u"channel_id",b"channel_id",u"direction",b"direction",u"error_flags",b"error_flags",u"id",b"id",u"returns",b"returns",u"start_offset_ns",b"start_offset_ns"]) -> None: ...
global___Point = Point
