"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import typing
import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor = ...

class TimeSynchronization(google.protobuf.message.Message):
    """*
    > Introduced in BSL v2.18 and firmware v1.19

    This section defines the synchronization status of the server.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    class State(_State, metaclass=_StateEnumTypeWrapper):
        pass
    class _State:
        V = typing.NewType('V', builtins.int)
    class _StateEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_State.V], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor = ...
        STOPPED = TimeSynchronization.State.V(1)
        INITIALIZING = TimeSynchronization.State.V(2)
        SYNCED = TimeSynchronization.State.V(3)
        FAILED = TimeSynchronization.State.V(4)

    STOPPED = TimeSynchronization.State.V(1)
    INITIALIZING = TimeSynchronization.State.V(2)
    SYNCED = TimeSynchronization.State.V(3)
    FAILED = TimeSynchronization.State.V(4)

    class PTP(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        STATE_FIELD_NUMBER: builtins.int
        CLOCK_ID_FIELD_NUMBER: builtins.int
        ONE_WAY_DELAY_FIELD_NUMBER: builtins.int
        SLAVE_TO_MASTER_FIELD_NUMBER: builtins.int
        MASTER_TO_SLAVE_FIELD_NUMBER: builtins.int
        OBSERVED_DRIFT_FIELD_NUMBER: builtins.int
        LAST_PACKET_RECEIVED_FIELD_NUMBER: builtins.int
        state: typing.Text = ...
        """*
        ONLY AVAILABLE FOR PTP, NTP doesnt have a state
        Follwing states can occur:
        init: Initializing,
        flt: Faulty,
        lstn_init: Listening (first time),
        lstn_reset: Listening (subsequent reset),
        pass: Passive (not best master, not announcing),
        uncl: Uncalibrated,
        slv: Worker,
        pmst: Pre-master,
        mst: Master (active),
        dsbl: Disabled,
        ? (unk): Unknown state
        """

        clock_id: typing.Text = ...
        """*
        TODO Find out for NTP!!
        Clock ID
        Port identity of the current best master, as defined by IEEE 1588 standard. This ID is the local clock's ID if the local clock is the best master.
        This parameter is displayed as clock_id or port (host). Port is the PTP clock port number, not the User Datagram Protocol (UDP) port numbers.
        The clock ID is an Extended Unique Identifier (EUI)-64 64-bit ID, converted from the 48-bit MAC address, by inserting 0xfffe at the middle of the MAC address.
        """

        one_way_delay: builtins.float = ...
        """*
        One-way delay
        Current value of one-way delay (or mean-path delay) in seconds, calculated by the ptpd daemon that is in the worker state from the delay request and delay response message exchange.
        Note: If this value remains at zero, it means that no delay response messages are being received, which might be because of a network issue.
        """

        slave_to_master: builtins.float = ...
        """*
        Slave to master
        Intermediate offset value (seconds) extracted from the delay request and delay response message exchange.
        This value is used for computing one-way delay. If the last value was rejected by a filter, the previous value is shown in the log file.
        This value is zero (0) if the delay response messages are not received.
        """

        master_to_slave: builtins.float = ...
        """*
        Master to slave
        Intermediate offset value (seconds) extracted from the sync messages. This value is used for computing the offset value from the master devices.
        If the last value was rejected by a filter, the previous value is shown in the log file.
        """

        observed_drift: builtins.float = ...
        """*
        Observed drift
        The frequency difference between the worker clock and the master clock as measured by the integral accumulator of the clock control proportional integral (PI) servo model.
        This value stabilizes when the clock offset value is stabilized, and this value is used to detect clock stability.
        """

        last_packet_received: typing.Text = ...
        """*
        Last packet Received
        This field shows which message was received last. It displays S for sync messages and D for delay response messages.
        If a worker device logs no D entries, it means that the worker device is not receiving delay response messages because of network issue.
        """

        def __init__(self,
            *,
            state : typing.Optional[typing.Text] = ...,
            clock_id : typing.Optional[typing.Text] = ...,
            one_way_delay : typing.Optional[builtins.float] = ...,
            slave_to_master : typing.Optional[builtins.float] = ...,
            master_to_slave : typing.Optional[builtins.float] = ...,
            observed_drift : typing.Optional[builtins.float] = ...,
            last_packet_received : typing.Optional[typing.Text] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal[u"clock_id",b"clock_id",u"last_packet_received",b"last_packet_received",u"master_to_slave",b"master_to_slave",u"observed_drift",b"observed_drift",u"one_way_delay",b"one_way_delay",u"slave_to_master",b"slave_to_master",u"state",b"state"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal[u"clock_id",b"clock_id",u"last_packet_received",b"last_packet_received",u"master_to_slave",b"master_to_slave",u"observed_drift",b"observed_drift",u"one_way_delay",b"one_way_delay",u"slave_to_master",b"slave_to_master",u"state",b"state"]) -> None: ...

    class NTP(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        FREQUENCY_OFFSET_FIELD_NUMBER: builtins.int
        RMS_JITTER_FIELD_NUMBER: builtins.int
        ALLAN_DEVIATION_FIELD_NUMBER: builtins.int
        CLOCK_DISCIPLINE_TIME_CONSTANT_FIELD_NUMBER: builtins.int
        frequency_offset: builtins.float = ...
        """frequency offset (parts per million - PPM) as in loopstats"""

        rms_jitter: builtins.float = ...
        """RMS jitter (seconds) as in loopstats"""

        allan_deviation: builtins.float = ...
        """Allan deviation (PPM) as in loopstats"""

        clock_discipline_time_constant: builtins.float = ...
        """clock discipline time constant as in loopstats"""

        def __init__(self,
            *,
            frequency_offset : typing.Optional[builtins.float] = ...,
            rms_jitter : typing.Optional[builtins.float] = ...,
            allan_deviation : typing.Optional[builtins.float] = ...,
            clock_discipline_time_constant : typing.Optional[builtins.float] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal[u"allan_deviation",b"allan_deviation",u"clock_discipline_time_constant",b"clock_discipline_time_constant",u"frequency_offset",b"frequency_offset",u"rms_jitter",b"rms_jitter"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal[u"allan_deviation",b"allan_deviation",u"clock_discipline_time_constant",b"clock_discipline_time_constant",u"frequency_offset",b"frequency_offset",u"rms_jitter",b"rms_jitter"]) -> None: ...

    STATE_FIELD_NUMBER: builtins.int
    OFFSET_FROM_MASTER_FIELD_NUMBER: builtins.int
    NTP_FIELD_NUMBER: builtins.int
    PTP_FIELD_NUMBER: builtins.int
    state: global___TimeSynchronization.State.V = ...
    offset_from_master: builtins.float = ...
    """*
    Current offset value from master device in seconds.
    NTP: time offset (seconds) in loopstats
    PTP:
    It is the main output of the PTP engine that is in the worker state.
    This value is the input for clock corrections in the clock servo algorithms. This value is typically measured when estimating the performance of the worker device.
    """

    @property
    def ntp(self) -> global___TimeSynchronization.NTP:
        """Refer to [NTP](#blickfeld.protocol.status.TimeSynchronization.NTP)"""
        pass
    @property
    def ptp(self) -> global___TimeSynchronization.PTP:
        """Refer to [PTP](#blickfeld.protocol.status.TimeSynchronization.PTP)"""
        pass
    def __init__(self,
        *,
        state : typing.Optional[global___TimeSynchronization.State.V] = ...,
        offset_from_master : typing.Optional[builtins.float] = ...,
        ntp : typing.Optional[global___TimeSynchronization.NTP] = ...,
        ptp : typing.Optional[global___TimeSynchronization.PTP] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal[u"kind",b"kind",u"ntp",b"ntp",u"offset_from_master",b"offset_from_master",u"ptp",b"ptp",u"state",b"state"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"kind",b"kind",u"ntp",b"ntp",u"offset_from_master",b"offset_from_master",u"ptp",b"ptp",u"state",b"state"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal[u"kind",b"kind"]) -> typing.Optional[typing_extensions.Literal["ntp","ptp"]]: ...
global___TimeSynchronization = TimeSynchronization
