"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Key = exports.KeyProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const kms_generated_1 = require("./kms.generated");
Object.defineProperty(exports, "KeyProperty", { enumerable: true, get: function () { return kms_generated_1.RosKey; } });
/**
 * A ROS resource type:  `ALIYUN::KMS::Key`
 */
class Key extends ros.Resource {
    /**
     * Create a new `ALIYUN::KMS::Key`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props = {}, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosKey = new kms_generated_1.RosKey(this, id, {
            protectionLevel: props.protectionLevel,
            description: props.description,
            rotationInterval: props.rotationInterval,
            enableAutomaticRotation: props.enableAutomaticRotation,
            pendingWindowInDays: props.pendingWindowInDays === undefined || props.pendingWindowInDays === null ? 30 : props.pendingWindowInDays,
            keySpec: props.keySpec,
            enable: props.enable === undefined || props.enable === null ? true : props.enable,
            keyUsage: props.keyUsage === undefined || props.keyUsage === null ? 'ENCRYPT/DECRYPT' : props.keyUsage,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosKey;
        this.attrKeyId = rosKey.attrKeyId;
    }
}
exports.Key = Key;
//# sourceMappingURL=data:application/json;base64,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