import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeGlobalForwardingRuleConfig extends cdktf.TerraformMetaArguments {
    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_forwarding_rule.html#description ComputeGlobalForwardingRule#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * IP address that this forwarding rule serves.
     *
     * When a client sends traffic to this IP address, the forwarding rule directs the traffic to the target that you specify in the forwarding rule. If you don't specify a reserved IP address, an ephemeral IP address is assigned. Methods for specifying an IP address: * IPv4 dotted decimal, as in `100.1.2.3` * Full URL, as in `https://www.googleapis.com/compute/v1/projects/project_id/regions/region/addresses/address-name` * Partial URL or by name, as in: * `projects/project_id/regions/region/addresses/address-name` * `regions/region/addresses/address-name` * `global/addresses/address-name` * `address-name` The loadBalancingScheme and the forwarding rule's target determine the type of IP address that you can use. For detailed information, refer to [IP address specifications](/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_forwarding_rule.html#ip_address ComputeGlobalForwardingRule#ip_address}
     *
     * @stability stable
     */
    readonly ipAddress?: string;
    /**
     * The IP protocol to which this rule applies.
     *
     * For protocol forwarding, valid options are `TCP`, `UDP`, `ESP`, `AH`, `SCTP` or `ICMP`. For Internal TCP/UDP Load Balancing, the load balancing scheme is `INTERNAL`, and one of `TCP` or `UDP` are valid. For Traffic Director, the load balancing scheme is `INTERNAL_SELF_MANAGED`, and only `TCP`is valid. For Internal HTTP(S) Load Balancing, the load balancing scheme is `INTERNAL_MANAGED`, and only `TCP` is valid. For HTTP(S), SSL Proxy, and TCP Proxy Load Balancing, the load balancing scheme is `EXTERNAL` and only `TCP` is valid. For Network TCP/UDP Load Balancing, the load balancing scheme is `EXTERNAL`, and one of `TCP` or `UDP` is valid.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_forwarding_rule.html#ip_protocol ComputeGlobalForwardingRule#ip_protocol}
     *
     * @stability stable
     */
    readonly ipProtocol?: string;
    /**
     * The IP Version that will be used by this forwarding rule.
     *
     * Valid options are `IPV4` or `IPV6`. This can only be specified for an external global forwarding rule. Possible values: UNSPECIFIED_VERSION, IPV4, IPV6
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_forwarding_rule.html#ip_version ComputeGlobalForwardingRule#ip_version}
     *
     * @stability stable
     */
    readonly ipVersion?: string;
    /**
     * Labels to apply to this rule.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_forwarding_rule.html#labels ComputeGlobalForwardingRule#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Specifies the forwarding rule type.
     *
     * `EXTERNAL` is used for:
     *   Classic Cloud VPN gateways
     *   Protocol forwarding to VMs from an external IP address
     *   The following load balancers: HTTP(S), SSL Proxy, TCP Proxy, and Network TCP/UDP
     * `INTERNAL` is used for:
     *   Protocol forwarding to VMs from an internal IP address
     *   Internal TCP/UDP load balancers
     * `INTERNAL_MANAGED` is used for:
     *   Internal HTTP(S) load balancers
     * `INTERNAL_SELF_MANAGED` is used for:
     *   Traffic Director
     *
     * For more information about forwarding rules, refer to [Forwarding rule concepts](/load-balancing/docs/forwarding-rule-concepts). Possible values: INVALID, INTERNAL, INTERNAL_MANAGED, INTERNAL_SELF_MANAGED, EXTERNAL
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_forwarding_rule.html#load_balancing_scheme ComputeGlobalForwardingRule#load_balancing_scheme}
     *
     * @stability stable
     */
    readonly loadBalancingScheme?: string;
    /**
     * Name of the resource;
     *
     * provided by the client when the resource is created. The name must be 1-63 characters long, and comply with [RFC1035](https://www.ietf.org/rfc/rfc1035.txt). Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_forwarding_rule.html#name ComputeGlobalForwardingRule#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * This field is not used for external load balancing.
     *
     * For `INTERNAL` and `INTERNAL_SELF_MANAGED` load balancing, this field identifies the network that the load balanced IP should belong to for this Forwarding Rule. If this field is not specified, the default network will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_forwarding_rule.html#network ComputeGlobalForwardingRule#network}
     *
     * @stability stable
     */
    readonly network?: string;
    /**
     * When the load balancing scheme is `EXTERNAL`, `INTERNAL_SELF_MANAGED` and `INTERNAL_MANAGED`, you can specify a `port_range`.
     *
     * Use with a forwarding rule that points to a target proxy or a target pool. Do not use with a forwarding rule that points to a backend service. This field is used along with the `target` field for TargetHttpProxy, TargetHttpsProxy, TargetSslProxy, TargetTcpProxy, TargetVpnGateway, TargetPool, TargetInstance. Applicable only when `IPProtocol` is `TCP`, `UDP`, or `SCTP`, only packets addressed to ports in the specified range will be forwarded to `target`. Forwarding rules with the same `[IPAddress, IPProtocol]` pair must have disjoint port ranges. Some types of forwarding target have constraints on the acceptable ports:
     *
     * TargetHttpProxy: 80, 8080
     * TargetHttpsProxy: 443
     * TargetTcpProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995, 1688, 1883, 5222
     * TargetSslProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995, 1688, 1883, 5222
     * TargetVpnGateway: 500, 4500
     *
     * @stability stable
     * @pattern : d+(?:-d+)?
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_forwarding_rule.html#port_range ComputeGlobalForwardingRule#port_range}
     */
    readonly portRange?: string;
    /**
     * The project this resource belongs in.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_forwarding_rule.html#project ComputeGlobalForwardingRule#project}
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The URL of the target resource to receive the matched traffic.
     *
     * For regional forwarding rules, this target must live in the same region as the forwarding rule. For global forwarding rules, this target must be a global load balancing resource. The forwarded traffic must be of a type appropriate to the target object. For `INTERNAL_SELF_MANAGED` load balancing, only `targetHttpProxy` is valid, not `targetHttpsProxy`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_forwarding_rule.html#target ComputeGlobalForwardingRule#target}
     *
     * @stability stable
     */
    readonly target: string;
    /**
     * metadata_filters block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_forwarding_rule.html#metadata_filters ComputeGlobalForwardingRule#metadata_filters}
     *
     * @stability stable
     */
    readonly metadataFilters?: ComputeGlobalForwardingRuleMetadataFilters[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_forwarding_rule.html#timeouts ComputeGlobalForwardingRule#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeGlobalForwardingRuleTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeGlobalForwardingRuleMetadataFiltersFilterLabels {
    /**
     * Name of metadata label.
     *
     * The name can have a maximum length of 1024 characters and must be at least 1 character long.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_forwarding_rule.html#name ComputeGlobalForwardingRule#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The value of the label must match the specified value.
     *
     * value can have a maximum length of 1024 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_forwarding_rule.html#value ComputeGlobalForwardingRule#value}
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function computeGlobalForwardingRuleMetadataFiltersFilterLabelsToTerraform(struct?: ComputeGlobalForwardingRuleMetadataFiltersFilterLabels): any;
/**
 * @stability stable
 */
export interface ComputeGlobalForwardingRuleMetadataFilters {
    /**
     * Specifies how individual `filterLabel` matches within the list of `filterLabel`s contribute towards the overall `metadataFilter` match.
     *
     * Supported values are:
     *
     * MATCH_ANY: At least one of the `filterLabels` must have a matching label in the provided metadata.
     * MATCH_ALL: All `filterLabels` must have matching labels in the provided metadata. Possible values: NOT_SET, MATCH_ALL, MATCH_ANY
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_forwarding_rule.html#filter_match_criteria ComputeGlobalForwardingRule#filter_match_criteria}
     *
     * @stability stable
     */
    readonly filterMatchCriteria: string;
    /**
     * filter_labels block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_forwarding_rule.html#filter_labels ComputeGlobalForwardingRule#filter_labels}
     *
     * @stability stable
     */
    readonly filterLabels: ComputeGlobalForwardingRuleMetadataFiltersFilterLabels[];
}
export declare function computeGlobalForwardingRuleMetadataFiltersToTerraform(struct?: ComputeGlobalForwardingRuleMetadataFilters): any;
/**
 * @stability stable
 */
export interface ComputeGlobalForwardingRuleTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_forwarding_rule.html#create ComputeGlobalForwardingRule#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_forwarding_rule.html#delete ComputeGlobalForwardingRule#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_forwarding_rule.html#update ComputeGlobalForwardingRule#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function computeGlobalForwardingRuleTimeoutsToTerraform(struct?: ComputeGlobalForwardingRuleTimeoutsOutputReference | ComputeGlobalForwardingRuleTimeouts): any;
/**
 * @stability stable
 */
export declare class ComputeGlobalForwardingRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeGlobalForwardingRuleTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeGlobalForwardingRuleTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_global_forwarding_rule.html google_compute_global_forwarding_rule}.
 *
 * @stability stable
 */
export declare class ComputeGlobalForwardingRule extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_global_forwarding_rule.html google_compute_global_forwarding_rule} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeGlobalForwardingRuleConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _ipAddress?;
    /**
     * @stability stable
     */
    get ipAddress(): string;
    /**
     * @stability stable
     */
    set ipAddress(value: string);
    /**
     * @stability stable
     */
    resetIpAddress(): void;
    /**
     * @stability stable
     */
    get ipAddressInput(): string | undefined;
    private _ipProtocol?;
    /**
     * @stability stable
     */
    get ipProtocol(): string;
    /**
     * @stability stable
     */
    set ipProtocol(value: string);
    /**
     * @stability stable
     */
    resetIpProtocol(): void;
    /**
     * @stability stable
     */
    get ipProtocolInput(): string | undefined;
    private _ipVersion?;
    /**
     * @stability stable
     */
    get ipVersion(): string;
    /**
     * @stability stable
     */
    set ipVersion(value: string);
    /**
     * @stability stable
     */
    resetIpVersion(): void;
    /**
     * @stability stable
     */
    get ipVersionInput(): string | undefined;
    /**
     * @stability stable
     */
    get labelFingerprint(): string;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _loadBalancingScheme?;
    /**
     * @stability stable
     */
    get loadBalancingScheme(): string;
    /**
     * @stability stable
     */
    set loadBalancingScheme(value: string);
    /**
     * @stability stable
     */
    resetLoadBalancingScheme(): void;
    /**
     * @stability stable
     */
    get loadBalancingSchemeInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _network?;
    /**
     * @stability stable
     */
    get network(): string;
    /**
     * @stability stable
     */
    set network(value: string);
    /**
     * @stability stable
     */
    resetNetwork(): void;
    /**
     * @stability stable
     */
    get networkInput(): string | undefined;
    private _portRange?;
    /**
     * @stability stable
     */
    get portRange(): string;
    /**
     * @stability stable
     */
    set portRange(value: string);
    /**
     * @stability stable
     */
    resetPortRange(): void;
    /**
     * @stability stable
     */
    get portRangeInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _target?;
    /**
     * @stability stable
     */
    get target(): string;
    /**
     * @stability stable
     */
    set target(value: string);
    /**
     * @stability stable
     */
    get targetInput(): string | undefined;
    private _metadataFilters?;
    /**
     * @stability stable
     */
    get metadataFilters(): ComputeGlobalForwardingRuleMetadataFilters[];
    /**
     * @stability stable
     */
    set metadataFilters(value: ComputeGlobalForwardingRuleMetadataFilters[]);
    /**
     * @stability stable
     */
    resetMetadataFilters(): void;
    /**
     * @stability stable
     */
    get metadataFiltersInput(): ComputeGlobalForwardingRuleMetadataFilters[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ComputeGlobalForwardingRuleTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeGlobalForwardingRuleTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeGlobalForwardingRuleTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
