import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleStorageBucketConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the bucket.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/storage_bucket.html#name DataGoogleStorageBucket#name}
     *
     * @stability stable
     */
    readonly name: string;
}
/**
 * @stability stable
 */
export declare class DataGoogleStorageBucketCors extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get maxAgeSeconds(): number;
    /**
     * @stability stable
     */
    get method(): string[];
    /**
     * @stability stable
     */
    get origin(): string[];
    /**
     * @stability stable
     */
    get responseHeader(): string[];
}
/**
 * @stability stable
 */
export declare class DataGoogleStorageBucketEncryption extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get defaultKmsKeyName(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleStorageBucketLifecycleRuleAction extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get storageClass(): string;
    /**
     * @stability stable
     */
    get type(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleStorageBucketLifecycleRuleCondition extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get age(): number;
    /**
     * @stability stable
     */
    get createdBefore(): string;
    /**
     * @stability stable
     */
    get customTimeBefore(): string;
    /**
     * @stability stable
     */
    get daysSinceCustomTime(): number;
    /**
     * @stability stable
     */
    get daysSinceNoncurrentTime(): number;
    /**
     * @stability stable
     */
    get matchesStorageClass(): string[];
    /**
     * @stability stable
     */
    get noncurrentTimeBefore(): string;
    /**
     * @stability stable
     */
    get numNewerVersions(): number;
    /**
     * @stability stable
     */
    get withState(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleStorageBucketLifecycleRule extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get action(): any;
    /**
     * @stability stable
     */
    get condition(): any;
}
/**
 * @stability stable
 */
export declare class DataGoogleStorageBucketLogging extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get logBucket(): string;
    /**
     * @stability stable
     */
    get logObjectPrefix(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleStorageBucketRetentionPolicy extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get isLocked(): any;
    /**
     * @stability stable
     */
    get retentionPeriod(): number;
}
/**
 * @stability stable
 */
export declare class DataGoogleStorageBucketVersioning extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get enabled(): any;
}
/**
 * @stability stable
 */
export declare class DataGoogleStorageBucketWebsite extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get mainPageSuffix(): string;
    /**
     * @stability stable
     */
    get notFoundPage(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/storage_bucket.html google_storage_bucket}.
 *
 * @stability stable
 */
export declare class DataGoogleStorageBucket extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/storage_bucket.html google_storage_bucket} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataGoogleStorageBucketConfig);
    /**
     * @stability stable
     */
    get bucketPolicyOnly(): any;
    /**
     * @stability stable
     */
    cors(index: string): DataGoogleStorageBucketCors;
    /**
     * @stability stable
     */
    get defaultEventBasedHold(): any;
    /**
     * @stability stable
     */
    encryption(index: string): DataGoogleStorageBucketEncryption;
    /**
     * @stability stable
     */
    get forceDestroy(): any;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    labels(key: string): string;
    /**
     * @stability stable
     */
    lifecycleRule(index: string): DataGoogleStorageBucketLifecycleRule;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    logging(index: string): DataGoogleStorageBucketLogging;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    get requesterPays(): any;
    /**
     * @stability stable
     */
    retentionPolicy(index: string): DataGoogleStorageBucketRetentionPolicy;
    /**
     * @stability stable
     */
    get selfLink(): string;
    /**
     * @stability stable
     */
    get storageClass(): string;
    /**
     * @stability stable
     */
    get uniformBucketLevelAccess(): any;
    /**
     * @stability stable
     */
    get url(): string;
    /**
     * @stability stable
     */
    versioning(index: string): DataGoogleStorageBucketVersioning;
    /**
     * @stability stable
     */
    website(index: string): DataGoogleStorageBucketWebsite;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
