import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface EndpointsServiceIamMemberConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/endpoints_service_iam_member.html#member EndpointsServiceIamMember#member}.
     *
     * @stability stable
     */
    readonly member: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/endpoints_service_iam_member.html#role EndpointsServiceIamMember#role}.
     *
     * @stability stable
     */
    readonly role: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/endpoints_service_iam_member.html#service_name EndpointsServiceIamMember#service_name}.
     *
     * @stability stable
     */
    readonly serviceName: string;
    /**
     * condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/endpoints_service_iam_member.html#condition EndpointsServiceIamMember#condition}
     *
     * @stability stable
     */
    readonly condition?: EndpointsServiceIamMemberCondition;
}
/**
 * @stability stable
 */
export interface EndpointsServiceIamMemberCondition {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/endpoints_service_iam_member.html#description EndpointsServiceIamMember#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/endpoints_service_iam_member.html#expression EndpointsServiceIamMember#expression}.
     *
     * @stability stable
     */
    readonly expression: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/endpoints_service_iam_member.html#title EndpointsServiceIamMember#title}.
     *
     * @stability stable
     */
    readonly title: string;
}
export declare function endpointsServiceIamMemberConditionToTerraform(struct?: EndpointsServiceIamMemberConditionOutputReference | EndpointsServiceIamMemberCondition): any;
/**
 * @stability stable
 */
export declare class EndpointsServiceIamMemberConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): EndpointsServiceIamMemberCondition | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: EndpointsServiceIamMemberCondition | undefined);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _expression?;
    /**
     * @stability stable
     */
    get expression(): string;
    /**
     * @stability stable
     */
    set expression(value: string);
    /**
     * @stability stable
     */
    get expressionInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    set title(value: string);
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/endpoints_service_iam_member.html google_endpoints_service_iam_member}.
 *
 * @stability stable
 */
export declare class EndpointsServiceIamMember extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/endpoints_service_iam_member.html google_endpoints_service_iam_member} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: EndpointsServiceIamMemberConfig);
    /**
     * @stability stable
     */
    get etag(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _member?;
    /**
     * @stability stable
     */
    get member(): string;
    /**
     * @stability stable
     */
    set member(value: string);
    /**
     * @stability stable
     */
    get memberInput(): string | undefined;
    private _role?;
    /**
     * @stability stable
     */
    get role(): string;
    /**
     * @stability stable
     */
    set role(value: string);
    /**
     * @stability stable
     */
    get roleInput(): string | undefined;
    private _serviceName?;
    /**
     * @stability stable
     */
    get serviceName(): string;
    /**
     * @stability stable
     */
    set serviceName(value: string);
    /**
     * @stability stable
     */
    get serviceNameInput(): string | undefined;
    private _condition;
    /**
     * @stability stable
     */
    get condition(): EndpointsServiceIamMemberConditionOutputReference;
    /**
     * @stability stable
     */
    putCondition(value: EndpointsServiceIamMemberCondition): void;
    /**
     * @stability stable
     */
    resetCondition(): void;
    /**
     * @stability stable
     */
    get conditionInput(): EndpointsServiceIamMemberCondition | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
