import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataLossPreventionStoredInfoTypeConfig extends cdktf.TerraformMetaArguments {
    /**
     * A description of the info type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#description DataLossPreventionStoredInfoType#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * User set display name of the info type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#display_name DataLossPreventionStoredInfoType#display_name}
     *
     * @stability stable
     */
    readonly displayName?: string;
    /**
     * The parent of the info type in any of the following formats:.
     *
     * 'projects/{{project}}'
     * 'projects/{{project}}/locations/{{location}}'
     * 'organizations/{{organization_id}}'
     * 'organizations/{{organization_id}}/locations/{{location}}'
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#parent DataLossPreventionStoredInfoType#parent}
     *
     * @stability stable
     */
    readonly parent: string;
    /**
     * dictionary block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#dictionary DataLossPreventionStoredInfoType#dictionary}
     *
     * @stability stable
     */
    readonly dictionary?: DataLossPreventionStoredInfoTypeDictionary;
    /**
     * large_custom_dictionary block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#large_custom_dictionary DataLossPreventionStoredInfoType#large_custom_dictionary}
     *
     * @stability stable
     */
    readonly largeCustomDictionary?: DataLossPreventionStoredInfoTypeLargeCustomDictionary;
    /**
     * regex block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#regex DataLossPreventionStoredInfoType#regex}
     *
     * @stability stable
     */
    readonly regex?: DataLossPreventionStoredInfoTypeRegex;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#timeouts DataLossPreventionStoredInfoType#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataLossPreventionStoredInfoTypeTimeouts;
}
/**
 * @stability stable
 */
export interface DataLossPreventionStoredInfoTypeDictionaryCloudStoragePath {
    /**
     * A url representing a file or path (no wildcards) in Cloud Storage. Example: 'gs://[BUCKET_NAME]/dictionary.txt'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#path DataLossPreventionStoredInfoType#path}
     *
     * @stability stable
     */
    readonly path: string;
}
export declare function dataLossPreventionStoredInfoTypeDictionaryCloudStoragePathToTerraform(struct?: DataLossPreventionStoredInfoTypeDictionaryCloudStoragePathOutputReference | DataLossPreventionStoredInfoTypeDictionaryCloudStoragePath): any;
/**
 * @stability stable
 */
export declare class DataLossPreventionStoredInfoTypeDictionaryCloudStoragePathOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataLossPreventionStoredInfoTypeDictionaryCloudStoragePath | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataLossPreventionStoredInfoTypeDictionaryCloudStoragePath | undefined);
    private _path?;
    /**
     * @stability stable
     */
    get path(): string;
    /**
     * @stability stable
     */
    set path(value: string);
    /**
     * @stability stable
     */
    get pathInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataLossPreventionStoredInfoTypeDictionaryWordList {
    /**
     * Words or phrases defining the dictionary.
     *
     * The dictionary must contain at least one
     * phrase and every phrase must contain at least 2 characters that are letters or digits.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#words DataLossPreventionStoredInfoType#words}
     *
     * @stability stable
     */
    readonly words: string[];
}
export declare function dataLossPreventionStoredInfoTypeDictionaryWordListToTerraform(struct?: DataLossPreventionStoredInfoTypeDictionaryWordListOutputReference | DataLossPreventionStoredInfoTypeDictionaryWordList): any;
/**
 * @stability stable
 */
export declare class DataLossPreventionStoredInfoTypeDictionaryWordListOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataLossPreventionStoredInfoTypeDictionaryWordList | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataLossPreventionStoredInfoTypeDictionaryWordList | undefined);
    private _words?;
    /**
     * @stability stable
     */
    get words(): string[];
    /**
     * @stability stable
     */
    set words(value: string[]);
    /**
     * @stability stable
     */
    get wordsInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface DataLossPreventionStoredInfoTypeDictionary {
    /**
     * cloud_storage_path block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#cloud_storage_path DataLossPreventionStoredInfoType#cloud_storage_path}
     *
     * @stability stable
     */
    readonly cloudStoragePath?: DataLossPreventionStoredInfoTypeDictionaryCloudStoragePath;
    /**
     * word_list block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#word_list DataLossPreventionStoredInfoType#word_list}
     *
     * @stability stable
     */
    readonly wordList?: DataLossPreventionStoredInfoTypeDictionaryWordList;
}
export declare function dataLossPreventionStoredInfoTypeDictionaryToTerraform(struct?: DataLossPreventionStoredInfoTypeDictionaryOutputReference | DataLossPreventionStoredInfoTypeDictionary): any;
/**
 * @stability stable
 */
export declare class DataLossPreventionStoredInfoTypeDictionaryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataLossPreventionStoredInfoTypeDictionary | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataLossPreventionStoredInfoTypeDictionary | undefined);
    private _cloudStoragePath;
    /**
     * @stability stable
     */
    get cloudStoragePath(): DataLossPreventionStoredInfoTypeDictionaryCloudStoragePathOutputReference;
    /**
     * @stability stable
     */
    putCloudStoragePath(value: DataLossPreventionStoredInfoTypeDictionaryCloudStoragePath): void;
    /**
     * @stability stable
     */
    resetCloudStoragePath(): void;
    /**
     * @stability stable
     */
    get cloudStoragePathInput(): DataLossPreventionStoredInfoTypeDictionaryCloudStoragePath | undefined;
    private _wordList;
    /**
     * @stability stable
     */
    get wordList(): DataLossPreventionStoredInfoTypeDictionaryWordListOutputReference;
    /**
     * @stability stable
     */
    putWordList(value: DataLossPreventionStoredInfoTypeDictionaryWordList): void;
    /**
     * @stability stable
     */
    resetWordList(): void;
    /**
     * @stability stable
     */
    get wordListInput(): DataLossPreventionStoredInfoTypeDictionaryWordList | undefined;
}
/**
 * @stability stable
 */
export interface DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldField {
    /**
     * Name describing the field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#name DataLossPreventionStoredInfoType#name}
     *
     * @stability stable
     */
    readonly name: string;
}
export declare function dataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldFieldToTerraform(struct?: DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldFieldOutputReference | DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldField): any;
/**
 * @stability stable
 */
export declare class DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldFieldOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldField | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldField | undefined);
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldTable {
    /**
     * The dataset ID of the table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#dataset_id DataLossPreventionStoredInfoType#dataset_id}
     *
     * @stability stable
     */
    readonly datasetId: string;
    /**
     * The Google Cloud Platform project ID of the project containing the table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#project_id DataLossPreventionStoredInfoType#project_id}
     *
     * @stability stable
     */
    readonly projectId: string;
    /**
     * The name of the table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#table_id DataLossPreventionStoredInfoType#table_id}
     *
     * @stability stable
     */
    readonly tableId: string;
}
export declare function dataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldTableToTerraform(struct?: DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldTableOutputReference | DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldTable): any;
/**
 * @stability stable
 */
export declare class DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldTableOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldTable | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldTable | undefined);
    private _datasetId?;
    /**
     * @stability stable
     */
    get datasetId(): string;
    /**
     * @stability stable
     */
    set datasetId(value: string);
    /**
     * @stability stable
     */
    get datasetIdInput(): string | undefined;
    private _projectId?;
    /**
     * @stability stable
     */
    get projectId(): string;
    /**
     * @stability stable
     */
    set projectId(value: string);
    /**
     * @stability stable
     */
    get projectIdInput(): string | undefined;
    private _tableId?;
    /**
     * @stability stable
     */
    get tableId(): string;
    /**
     * @stability stable
     */
    set tableId(value: string);
    /**
     * @stability stable
     */
    get tableIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryField {
    /**
     * field block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#field DataLossPreventionStoredInfoType#field}
     *
     * @stability stable
     */
    readonly field: DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldField;
    /**
     * table block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#table DataLossPreventionStoredInfoType#table}
     *
     * @stability stable
     */
    readonly table: DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldTable;
}
export declare function dataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldToTerraform(struct?: DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldOutputReference | DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryField): any;
/**
 * @stability stable
 */
export declare class DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryField | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryField | undefined);
    private _field;
    /**
     * @stability stable
     */
    get field(): DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldFieldOutputReference;
    /**
     * @stability stable
     */
    putField(value: DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldField): void;
    /**
     * @stability stable
     */
    get fieldInput(): DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldField | undefined;
    private _table;
    /**
     * @stability stable
     */
    get table(): DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldTableOutputReference;
    /**
     * @stability stable
     */
    putTable(value: DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldTable): void;
    /**
     * @stability stable
     */
    get tableInput(): DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldTable | undefined;
}
/**
 * @stability stable
 */
export interface DataLossPreventionStoredInfoTypeLargeCustomDictionaryCloudStorageFileSet {
    /**
     * The url, in the format 'gs://<bucket>/<path>'. Trailing wildcard in the path is allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#url DataLossPreventionStoredInfoType#url}
     *
     * @stability stable
     */
    readonly url: string;
}
export declare function dataLossPreventionStoredInfoTypeLargeCustomDictionaryCloudStorageFileSetToTerraform(struct?: DataLossPreventionStoredInfoTypeLargeCustomDictionaryCloudStorageFileSetOutputReference | DataLossPreventionStoredInfoTypeLargeCustomDictionaryCloudStorageFileSet): any;
/**
 * @stability stable
 */
export declare class DataLossPreventionStoredInfoTypeLargeCustomDictionaryCloudStorageFileSetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataLossPreventionStoredInfoTypeLargeCustomDictionaryCloudStorageFileSet | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataLossPreventionStoredInfoTypeLargeCustomDictionaryCloudStorageFileSet | undefined);
    private _url?;
    /**
     * @stability stable
     */
    get url(): string;
    /**
     * @stability stable
     */
    set url(value: string);
    /**
     * @stability stable
     */
    get urlInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputPath {
    /**
     * A url representing a file or path (no wildcards) in Cloud Storage. Example: 'gs://[BUCKET_NAME]/dictionary.txt'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#path DataLossPreventionStoredInfoType#path}
     *
     * @stability stable
     */
    readonly path: string;
}
export declare function dataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputPathToTerraform(struct?: DataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputPathOutputReference | DataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputPath): any;
/**
 * @stability stable
 */
export declare class DataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputPathOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputPath | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputPath | undefined);
    private _path?;
    /**
     * @stability stable
     */
    get path(): string;
    /**
     * @stability stable
     */
    set path(value: string);
    /**
     * @stability stable
     */
    get pathInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataLossPreventionStoredInfoTypeLargeCustomDictionary {
    /**
     * big_query_field block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#big_query_field DataLossPreventionStoredInfoType#big_query_field}
     *
     * @stability stable
     */
    readonly bigQueryField?: DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryField;
    /**
     * cloud_storage_file_set block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#cloud_storage_file_set DataLossPreventionStoredInfoType#cloud_storage_file_set}
     *
     * @stability stable
     */
    readonly cloudStorageFileSet?: DataLossPreventionStoredInfoTypeLargeCustomDictionaryCloudStorageFileSet;
    /**
     * output_path block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#output_path DataLossPreventionStoredInfoType#output_path}
     *
     * @stability stable
     */
    readonly outputPath: DataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputPath;
}
export declare function dataLossPreventionStoredInfoTypeLargeCustomDictionaryToTerraform(struct?: DataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputReference | DataLossPreventionStoredInfoTypeLargeCustomDictionary): any;
/**
 * @stability stable
 */
export declare class DataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataLossPreventionStoredInfoTypeLargeCustomDictionary | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataLossPreventionStoredInfoTypeLargeCustomDictionary | undefined);
    private _bigQueryField;
    /**
     * @stability stable
     */
    get bigQueryField(): DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldOutputReference;
    /**
     * @stability stable
     */
    putBigQueryField(value: DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryField): void;
    /**
     * @stability stable
     */
    resetBigQueryField(): void;
    /**
     * @stability stable
     */
    get bigQueryFieldInput(): DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryField | undefined;
    private _cloudStorageFileSet;
    /**
     * @stability stable
     */
    get cloudStorageFileSet(): DataLossPreventionStoredInfoTypeLargeCustomDictionaryCloudStorageFileSetOutputReference;
    /**
     * @stability stable
     */
    putCloudStorageFileSet(value: DataLossPreventionStoredInfoTypeLargeCustomDictionaryCloudStorageFileSet): void;
    /**
     * @stability stable
     */
    resetCloudStorageFileSet(): void;
    /**
     * @stability stable
     */
    get cloudStorageFileSetInput(): DataLossPreventionStoredInfoTypeLargeCustomDictionaryCloudStorageFileSet | undefined;
    private _outputPath;
    /**
     * @stability stable
     */
    get outputPath(): DataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputPathOutputReference;
    /**
     * @stability stable
     */
    putOutputPath(value: DataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputPath): void;
    /**
     * @stability stable
     */
    get outputPathInput(): DataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputPath | undefined;
}
/**
 * @stability stable
 */
export interface DataLossPreventionStoredInfoTypeRegex {
    /**
     * The index of the submatch to extract as findings.
     *
     * When not specified, the entire match is returned. No more than 3 may be included.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#group_indexes DataLossPreventionStoredInfoType#group_indexes}
     *
     * @stability stable
     */
    readonly groupIndexes?: number[];
    /**
     * Pattern defining the regular expression. Its syntax (https://github.com/google/re2/wiki/Syntax) can be found under the google/re2 repository on GitHub.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#pattern DataLossPreventionStoredInfoType#pattern}
     *
     * @stability stable
     */
    readonly pattern: string;
}
export declare function dataLossPreventionStoredInfoTypeRegexToTerraform(struct?: DataLossPreventionStoredInfoTypeRegexOutputReference | DataLossPreventionStoredInfoTypeRegex): any;
/**
 * @stability stable
 */
export declare class DataLossPreventionStoredInfoTypeRegexOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataLossPreventionStoredInfoTypeRegex | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataLossPreventionStoredInfoTypeRegex | undefined);
    private _groupIndexes?;
    /**
     * @stability stable
     */
    get groupIndexes(): number[];
    /**
     * @stability stable
     */
    set groupIndexes(value: number[]);
    /**
     * @stability stable
     */
    resetGroupIndexes(): void;
    /**
     * @stability stable
     */
    get groupIndexesInput(): number[] | undefined;
    private _pattern?;
    /**
     * @stability stable
     */
    get pattern(): string;
    /**
     * @stability stable
     */
    set pattern(value: string);
    /**
     * @stability stable
     */
    get patternInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataLossPreventionStoredInfoTypeTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#create DataLossPreventionStoredInfoType#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#delete DataLossPreventionStoredInfoType#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#update DataLossPreventionStoredInfoType#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function dataLossPreventionStoredInfoTypeTimeoutsToTerraform(struct?: DataLossPreventionStoredInfoTypeTimeoutsOutputReference | DataLossPreventionStoredInfoTypeTimeouts): any;
/**
 * @stability stable
 */
export declare class DataLossPreventionStoredInfoTypeTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataLossPreventionStoredInfoTypeTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataLossPreventionStoredInfoTypeTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html google_data_loss_prevention_stored_info_type}.
 *
 * @stability stable
 */
export declare class DataLossPreventionStoredInfoType extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html google_data_loss_prevention_stored_info_type} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataLossPreventionStoredInfoTypeConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    resetDisplayName(): void;
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _parent?;
    /**
     * @stability stable
     */
    get parent(): string;
    /**
     * @stability stable
     */
    set parent(value: string);
    /**
     * @stability stable
     */
    get parentInput(): string | undefined;
    private _dictionary;
    /**
     * @stability stable
     */
    get dictionary(): DataLossPreventionStoredInfoTypeDictionaryOutputReference;
    /**
     * @stability stable
     */
    putDictionary(value: DataLossPreventionStoredInfoTypeDictionary): void;
    /**
     * @stability stable
     */
    resetDictionary(): void;
    /**
     * @stability stable
     */
    get dictionaryInput(): DataLossPreventionStoredInfoTypeDictionary | undefined;
    private _largeCustomDictionary;
    /**
     * @stability stable
     */
    get largeCustomDictionary(): DataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputReference;
    /**
     * @stability stable
     */
    putLargeCustomDictionary(value: DataLossPreventionStoredInfoTypeLargeCustomDictionary): void;
    /**
     * @stability stable
     */
    resetLargeCustomDictionary(): void;
    /**
     * @stability stable
     */
    get largeCustomDictionaryInput(): DataLossPreventionStoredInfoTypeLargeCustomDictionary | undefined;
    private _regex;
    /**
     * @stability stable
     */
    get regex(): DataLossPreventionStoredInfoTypeRegexOutputReference;
    /**
     * @stability stable
     */
    putRegex(value: DataLossPreventionStoredInfoTypeRegex): void;
    /**
     * @stability stable
     */
    resetRegex(): void;
    /**
     * @stability stable
     */
    get regexInput(): DataLossPreventionStoredInfoTypeRegex | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataLossPreventionStoredInfoTypeTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataLossPreventionStoredInfoTypeTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataLossPreventionStoredInfoTypeTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
