import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface FolderConfig extends cdktf.TerraformMetaArguments {
    /**
     * The folder's display name.
     *
     * A folder's display name must be unique amongst its siblings, e.g. no two folders with the same parent can share the same display name. The display name must start and end with a letter or digit, may contain letters, digits, spaces, hyphens and underscores and can be no longer than 30 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder.html#display_name Folder#display_name}
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * The resource name of the parent Folder or Organization. Must be of the form folders/{folder_id} or organizations/{org_id}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder.html#parent Folder#parent}
     *
     * @stability stable
     */
    readonly parent: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder.html#timeouts Folder#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: FolderTimeouts;
}
/**
 * @stability stable
 */
export interface FolderTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder.html#create Folder#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder.html#delete Folder#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder.html#read Folder#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder.html#update Folder#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function folderTimeoutsToTerraform(struct?: FolderTimeoutsOutputReference | FolderTimeouts): any;
/**
 * @stability stable
 */
export declare class FolderTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): FolderTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: FolderTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/folder.html google_folder}.
 *
 * @stability stable
 */
export declare class Folder extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/folder.html google_folder} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: FolderConfig);
    /**
     * @stability stable
     */
    get createTime(): string;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get folderId(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get lifecycleState(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _parent?;
    /**
     * @stability stable
     */
    get parent(): string;
    /**
     * @stability stable
     */
    set parent(value: string);
    /**
     * @stability stable
     */
    get parentInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): FolderTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: FolderTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): FolderTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
