import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface GoogleProviderConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#access_approval_custom_endpoint GoogleProvider#access_approval_custom_endpoint}.
     *
     * @stability stable
     */
    readonly accessApprovalCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#access_context_manager_custom_endpoint GoogleProvider#access_context_manager_custom_endpoint}.
     *
     * @stability stable
     */
    readonly accessContextManagerCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#access_token GoogleProvider#access_token}.
     *
     * @stability stable
     */
    readonly accessToken?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#active_directory_custom_endpoint GoogleProvider#active_directory_custom_endpoint}.
     *
     * @stability stable
     */
    readonly activeDirectoryCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#apigee_custom_endpoint GoogleProvider#apigee_custom_endpoint}.
     *
     * @stability stable
     */
    readonly apigeeCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#app_engine_custom_endpoint GoogleProvider#app_engine_custom_endpoint}.
     *
     * @stability stable
     */
    readonly appEngineCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#assured_workloads_custom_endpoint GoogleProvider#assured_workloads_custom_endpoint}.
     *
     * @stability stable
     */
    readonly assuredWorkloadsCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#big_query_custom_endpoint GoogleProvider#big_query_custom_endpoint}.
     *
     * @stability stable
     */
    readonly bigQueryCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#bigquery_data_transfer_custom_endpoint GoogleProvider#bigquery_data_transfer_custom_endpoint}.
     *
     * @stability stable
     */
    readonly bigqueryDataTransferCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#bigquery_reservation_custom_endpoint GoogleProvider#bigquery_reservation_custom_endpoint}.
     *
     * @stability stable
     */
    readonly bigqueryReservationCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#bigtable_custom_endpoint GoogleProvider#bigtable_custom_endpoint}.
     *
     * @stability stable
     */
    readonly bigtableCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#billing_custom_endpoint GoogleProvider#billing_custom_endpoint}.
     *
     * @stability stable
     */
    readonly billingCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#billing_project GoogleProvider#billing_project}.
     *
     * @stability stable
     */
    readonly billingProject?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#binary_authorization_custom_endpoint GoogleProvider#binary_authorization_custom_endpoint}.
     *
     * @stability stable
     */
    readonly binaryAuthorizationCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#cloud_asset_custom_endpoint GoogleProvider#cloud_asset_custom_endpoint}.
     *
     * @stability stable
     */
    readonly cloudAssetCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#cloud_billing_custom_endpoint GoogleProvider#cloud_billing_custom_endpoint}.
     *
     * @stability stable
     */
    readonly cloudBillingCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#cloud_build_custom_endpoint GoogleProvider#cloud_build_custom_endpoint}.
     *
     * @stability stable
     */
    readonly cloudBuildCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#cloud_functions_custom_endpoint GoogleProvider#cloud_functions_custom_endpoint}.
     *
     * @stability stable
     */
    readonly cloudFunctionsCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#cloud_identity_custom_endpoint GoogleProvider#cloud_identity_custom_endpoint}.
     *
     * @stability stable
     */
    readonly cloudIdentityCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#cloud_iot_custom_endpoint GoogleProvider#cloud_iot_custom_endpoint}.
     *
     * @stability stable
     */
    readonly cloudIotCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#cloud_resource_manager_custom_endpoint GoogleProvider#cloud_resource_manager_custom_endpoint}.
     *
     * @stability stable
     */
    readonly cloudResourceManagerCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#cloud_run_custom_endpoint GoogleProvider#cloud_run_custom_endpoint}.
     *
     * @stability stable
     */
    readonly cloudRunCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#cloud_scheduler_custom_endpoint GoogleProvider#cloud_scheduler_custom_endpoint}.
     *
     * @stability stable
     */
    readonly cloudSchedulerCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#cloud_tasks_custom_endpoint GoogleProvider#cloud_tasks_custom_endpoint}.
     *
     * @stability stable
     */
    readonly cloudTasksCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#composer_custom_endpoint GoogleProvider#composer_custom_endpoint}.
     *
     * @stability stable
     */
    readonly composerCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#compute_beta_custom_endpoint GoogleProvider#compute_beta_custom_endpoint}.
     *
     * @stability stable
     */
    readonly computeBetaCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#compute_custom_endpoint GoogleProvider#compute_custom_endpoint}.
     *
     * @stability stable
     */
    readonly computeCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#container_analysis_custom_endpoint GoogleProvider#container_analysis_custom_endpoint}.
     *
     * @stability stable
     */
    readonly containerAnalysisCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#container_beta_custom_endpoint GoogleProvider#container_beta_custom_endpoint}.
     *
     * @stability stable
     */
    readonly containerBetaCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#container_custom_endpoint GoogleProvider#container_custom_endpoint}.
     *
     * @stability stable
     */
    readonly containerCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#credentials GoogleProvider#credentials}.
     *
     * @stability stable
     */
    readonly credentials?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#data_catalog_custom_endpoint GoogleProvider#data_catalog_custom_endpoint}.
     *
     * @stability stable
     */
    readonly dataCatalogCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#data_loss_prevention_custom_endpoint GoogleProvider#data_loss_prevention_custom_endpoint}.
     *
     * @stability stable
     */
    readonly dataLossPreventionCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#dataflow_custom_endpoint GoogleProvider#dataflow_custom_endpoint}.
     *
     * @stability stable
     */
    readonly dataflowCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#dataproc_beta_custom_endpoint GoogleProvider#dataproc_beta_custom_endpoint}.
     *
     * @stability stable
     */
    readonly dataprocBetaCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#dataproc_custom_endpoint GoogleProvider#dataproc_custom_endpoint}.
     *
     * @stability stable
     */
    readonly dataprocCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#datastore_custom_endpoint GoogleProvider#datastore_custom_endpoint}.
     *
     * @stability stable
     */
    readonly datastoreCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#deployment_manager_custom_endpoint GoogleProvider#deployment_manager_custom_endpoint}.
     *
     * @stability stable
     */
    readonly deploymentManagerCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#dialogflow_custom_endpoint GoogleProvider#dialogflow_custom_endpoint}.
     *
     * @stability stable
     */
    readonly dialogflowCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#dialogflow_cx_custom_endpoint GoogleProvider#dialogflow_cx_custom_endpoint}.
     *
     * @stability stable
     */
    readonly dialogflowCxCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#dns_custom_endpoint GoogleProvider#dns_custom_endpoint}.
     *
     * @stability stable
     */
    readonly dnsCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#essential_contacts_custom_endpoint GoogleProvider#essential_contacts_custom_endpoint}.
     *
     * @stability stable
     */
    readonly essentialContactsCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#eventarc_custom_endpoint GoogleProvider#eventarc_custom_endpoint}.
     *
     * @stability stable
     */
    readonly eventarcCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#filestore_custom_endpoint GoogleProvider#filestore_custom_endpoint}.
     *
     * @stability stable
     */
    readonly filestoreCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#firestore_custom_endpoint GoogleProvider#firestore_custom_endpoint}.
     *
     * @stability stable
     */
    readonly firestoreCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#game_services_custom_endpoint GoogleProvider#game_services_custom_endpoint}.
     *
     * @stability stable
     */
    readonly gameServicesCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#gke_hub_custom_endpoint GoogleProvider#gke_hub_custom_endpoint}.
     *
     * @stability stable
     */
    readonly gkeHubCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#gkehub_feature_custom_endpoint GoogleProvider#gkehub_feature_custom_endpoint}.
     *
     * @stability stable
     */
    readonly gkehubFeatureCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#healthcare_custom_endpoint GoogleProvider#healthcare_custom_endpoint}.
     *
     * @stability stable
     */
    readonly healthcareCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#iam_credentials_custom_endpoint GoogleProvider#iam_credentials_custom_endpoint}.
     *
     * @stability stable
     */
    readonly iamCredentialsCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#iam_custom_endpoint GoogleProvider#iam_custom_endpoint}.
     *
     * @stability stable
     */
    readonly iamCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#iap_custom_endpoint GoogleProvider#iap_custom_endpoint}.
     *
     * @stability stable
     */
    readonly iapCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#identity_platform_custom_endpoint GoogleProvider#identity_platform_custom_endpoint}.
     *
     * @stability stable
     */
    readonly identityPlatformCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#impersonate_service_account GoogleProvider#impersonate_service_account}.
     *
     * @stability stable
     */
    readonly impersonateServiceAccount?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#impersonate_service_account_delegates GoogleProvider#impersonate_service_account_delegates}.
     *
     * @stability stable
     */
    readonly impersonateServiceAccountDelegates?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#kms_custom_endpoint GoogleProvider#kms_custom_endpoint}.
     *
     * @stability stable
     */
    readonly kmsCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#logging_custom_endpoint GoogleProvider#logging_custom_endpoint}.
     *
     * @stability stable
     */
    readonly loggingCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#memcache_custom_endpoint GoogleProvider#memcache_custom_endpoint}.
     *
     * @stability stable
     */
    readonly memcacheCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#ml_engine_custom_endpoint GoogleProvider#ml_engine_custom_endpoint}.
     *
     * @stability stable
     */
    readonly mlEngineCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#monitoring_custom_endpoint GoogleProvider#monitoring_custom_endpoint}.
     *
     * @stability stable
     */
    readonly monitoringCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#network_management_custom_endpoint GoogleProvider#network_management_custom_endpoint}.
     *
     * @stability stable
     */
    readonly networkManagementCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#network_services_custom_endpoint GoogleProvider#network_services_custom_endpoint}.
     *
     * @stability stable
     */
    readonly networkServicesCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#notebooks_custom_endpoint GoogleProvider#notebooks_custom_endpoint}.
     *
     * @stability stable
     */
    readonly notebooksCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#org_policy_custom_endpoint GoogleProvider#org_policy_custom_endpoint}.
     *
     * @stability stable
     */
    readonly orgPolicyCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#os_config_custom_endpoint GoogleProvider#os_config_custom_endpoint}.
     *
     * @stability stable
     */
    readonly osConfigCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#os_login_custom_endpoint GoogleProvider#os_login_custom_endpoint}.
     *
     * @stability stable
     */
    readonly osLoginCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#privateca_custom_endpoint GoogleProvider#privateca_custom_endpoint}.
     *
     * @stability stable
     */
    readonly privatecaCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#project GoogleProvider#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#pubsub_custom_endpoint GoogleProvider#pubsub_custom_endpoint}.
     *
     * @stability stable
     */
    readonly pubsubCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#pubsub_lite_custom_endpoint GoogleProvider#pubsub_lite_custom_endpoint}.
     *
     * @stability stable
     */
    readonly pubsubLiteCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#redis_custom_endpoint GoogleProvider#redis_custom_endpoint}.
     *
     * @stability stable
     */
    readonly redisCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#region GoogleProvider#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#request_reason GoogleProvider#request_reason}.
     *
     * @stability stable
     */
    readonly requestReason?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#request_timeout GoogleProvider#request_timeout}.
     *
     * @stability stable
     */
    readonly requestTimeout?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#resource_manager_custom_endpoint GoogleProvider#resource_manager_custom_endpoint}.
     *
     * @stability stable
     */
    readonly resourceManagerCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#resource_manager_v2_custom_endpoint GoogleProvider#resource_manager_v2_custom_endpoint}.
     *
     * @stability stable
     */
    readonly resourceManagerV2CustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#runtime_config_custom_endpoint GoogleProvider#runtime_config_custom_endpoint}.
     *
     * @stability stable
     */
    readonly runtimeConfigCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#runtimeconfig_custom_endpoint GoogleProvider#runtimeconfig_custom_endpoint}.
     *
     * @stability stable
     */
    readonly runtimeconfigCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#scopes GoogleProvider#scopes}.
     *
     * @stability stable
     */
    readonly scopes?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#secret_manager_custom_endpoint GoogleProvider#secret_manager_custom_endpoint}.
     *
     * @stability stable
     */
    readonly secretManagerCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#security_center_custom_endpoint GoogleProvider#security_center_custom_endpoint}.
     *
     * @stability stable
     */
    readonly securityCenterCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#service_management_custom_endpoint GoogleProvider#service_management_custom_endpoint}.
     *
     * @stability stable
     */
    readonly serviceManagementCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#service_networking_custom_endpoint GoogleProvider#service_networking_custom_endpoint}.
     *
     * @stability stable
     */
    readonly serviceNetworkingCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#service_usage_custom_endpoint GoogleProvider#service_usage_custom_endpoint}.
     *
     * @stability stable
     */
    readonly serviceUsageCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#source_repo_custom_endpoint GoogleProvider#source_repo_custom_endpoint}.
     *
     * @stability stable
     */
    readonly sourceRepoCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#spanner_custom_endpoint GoogleProvider#spanner_custom_endpoint}.
     *
     * @stability stable
     */
    readonly spannerCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#sql_custom_endpoint GoogleProvider#sql_custom_endpoint}.
     *
     * @stability stable
     */
    readonly sqlCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#storage_custom_endpoint GoogleProvider#storage_custom_endpoint}.
     *
     * @stability stable
     */
    readonly storageCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#storage_transfer_custom_endpoint GoogleProvider#storage_transfer_custom_endpoint}.
     *
     * @stability stable
     */
    readonly storageTransferCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#tags_custom_endpoint GoogleProvider#tags_custom_endpoint}.
     *
     * @stability stable
     */
    readonly tagsCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#tpu_custom_endpoint GoogleProvider#tpu_custom_endpoint}.
     *
     * @stability stable
     */
    readonly tpuCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#user_project_override GoogleProvider#user_project_override}.
     *
     * @stability stable
     */
    readonly userProjectOverride?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#vertex_ai_custom_endpoint GoogleProvider#vertex_ai_custom_endpoint}.
     *
     * @stability stable
     */
    readonly vertexAiCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#vpc_access_custom_endpoint GoogleProvider#vpc_access_custom_endpoint}.
     *
     * @stability stable
     */
    readonly vpcAccessCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#workflows_custom_endpoint GoogleProvider#workflows_custom_endpoint}.
     *
     * @stability stable
     */
    readonly workflowsCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#zone GoogleProvider#zone}.
     *
     * @stability stable
     */
    readonly zone?: string;
    /**
     * Alias name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#alias GoogleProvider#alias}
     *
     * @stability stable
     */
    readonly alias?: string;
    /**
     * batching block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#batching GoogleProvider#batching}
     *
     * @stability stable
     */
    readonly batching?: GoogleProviderBatching;
}
/**
 * @stability stable
 */
export interface GoogleProviderBatching {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#enable_batching GoogleProvider#enable_batching}.
     *
     * @stability stable
     */
    readonly enableBatching?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#send_after GoogleProvider#send_after}.
     *
     * @stability stable
     */
    readonly sendAfter?: string;
}
export declare function googleProviderBatchingToTerraform(struct?: GoogleProviderBatching): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google google}.
 *
 * @stability stable
 */
export declare class GoogleProvider extends cdktf.TerraformProvider {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google google} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: GoogleProviderConfig);
    private _accessApprovalCustomEndpoint?;
    /**
     * @stability stable
     */
    get accessApprovalCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set accessApprovalCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetAccessApprovalCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get accessApprovalCustomEndpointInput(): string | undefined;
    private _accessContextManagerCustomEndpoint?;
    /**
     * @stability stable
     */
    get accessContextManagerCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set accessContextManagerCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetAccessContextManagerCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get accessContextManagerCustomEndpointInput(): string | undefined;
    private _accessToken?;
    /**
     * @stability stable
     */
    get accessToken(): string | undefined;
    /**
     * @stability stable
     */
    set accessToken(value: string | undefined);
    /**
     * @stability stable
     */
    resetAccessToken(): void;
    /**
     * @stability stable
     */
    get accessTokenInput(): string | undefined;
    private _activeDirectoryCustomEndpoint?;
    /**
     * @stability stable
     */
    get activeDirectoryCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set activeDirectoryCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetActiveDirectoryCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get activeDirectoryCustomEndpointInput(): string | undefined;
    private _apigeeCustomEndpoint?;
    /**
     * @stability stable
     */
    get apigeeCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set apigeeCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetApigeeCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get apigeeCustomEndpointInput(): string | undefined;
    private _appEngineCustomEndpoint?;
    /**
     * @stability stable
     */
    get appEngineCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set appEngineCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetAppEngineCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get appEngineCustomEndpointInput(): string | undefined;
    private _assuredWorkloadsCustomEndpoint?;
    /**
     * @stability stable
     */
    get assuredWorkloadsCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set assuredWorkloadsCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetAssuredWorkloadsCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get assuredWorkloadsCustomEndpointInput(): string | undefined;
    private _bigQueryCustomEndpoint?;
    /**
     * @stability stable
     */
    get bigQueryCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set bigQueryCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetBigQueryCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get bigQueryCustomEndpointInput(): string | undefined;
    private _bigqueryDataTransferCustomEndpoint?;
    /**
     * @stability stable
     */
    get bigqueryDataTransferCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set bigqueryDataTransferCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetBigqueryDataTransferCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get bigqueryDataTransferCustomEndpointInput(): string | undefined;
    private _bigqueryReservationCustomEndpoint?;
    /**
     * @stability stable
     */
    get bigqueryReservationCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set bigqueryReservationCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetBigqueryReservationCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get bigqueryReservationCustomEndpointInput(): string | undefined;
    private _bigtableCustomEndpoint?;
    /**
     * @stability stable
     */
    get bigtableCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set bigtableCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetBigtableCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get bigtableCustomEndpointInput(): string | undefined;
    private _billingCustomEndpoint?;
    /**
     * @stability stable
     */
    get billingCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set billingCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetBillingCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get billingCustomEndpointInput(): string | undefined;
    private _billingProject?;
    /**
     * @stability stable
     */
    get billingProject(): string | undefined;
    /**
     * @stability stable
     */
    set billingProject(value: string | undefined);
    /**
     * @stability stable
     */
    resetBillingProject(): void;
    /**
     * @stability stable
     */
    get billingProjectInput(): string | undefined;
    private _binaryAuthorizationCustomEndpoint?;
    /**
     * @stability stable
     */
    get binaryAuthorizationCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set binaryAuthorizationCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetBinaryAuthorizationCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get binaryAuthorizationCustomEndpointInput(): string | undefined;
    private _cloudAssetCustomEndpoint?;
    /**
     * @stability stable
     */
    get cloudAssetCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set cloudAssetCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetCloudAssetCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get cloudAssetCustomEndpointInput(): string | undefined;
    private _cloudBillingCustomEndpoint?;
    /**
     * @stability stable
     */
    get cloudBillingCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set cloudBillingCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetCloudBillingCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get cloudBillingCustomEndpointInput(): string | undefined;
    private _cloudBuildCustomEndpoint?;
    /**
     * @stability stable
     */
    get cloudBuildCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set cloudBuildCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetCloudBuildCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get cloudBuildCustomEndpointInput(): string | undefined;
    private _cloudFunctionsCustomEndpoint?;
    /**
     * @stability stable
     */
    get cloudFunctionsCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set cloudFunctionsCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetCloudFunctionsCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get cloudFunctionsCustomEndpointInput(): string | undefined;
    private _cloudIdentityCustomEndpoint?;
    /**
     * @stability stable
     */
    get cloudIdentityCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set cloudIdentityCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetCloudIdentityCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get cloudIdentityCustomEndpointInput(): string | undefined;
    private _cloudIotCustomEndpoint?;
    /**
     * @stability stable
     */
    get cloudIotCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set cloudIotCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetCloudIotCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get cloudIotCustomEndpointInput(): string | undefined;
    private _cloudResourceManagerCustomEndpoint?;
    /**
     * @stability stable
     */
    get cloudResourceManagerCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set cloudResourceManagerCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetCloudResourceManagerCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get cloudResourceManagerCustomEndpointInput(): string | undefined;
    private _cloudRunCustomEndpoint?;
    /**
     * @stability stable
     */
    get cloudRunCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set cloudRunCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetCloudRunCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get cloudRunCustomEndpointInput(): string | undefined;
    private _cloudSchedulerCustomEndpoint?;
    /**
     * @stability stable
     */
    get cloudSchedulerCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set cloudSchedulerCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetCloudSchedulerCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get cloudSchedulerCustomEndpointInput(): string | undefined;
    private _cloudTasksCustomEndpoint?;
    /**
     * @stability stable
     */
    get cloudTasksCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set cloudTasksCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetCloudTasksCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get cloudTasksCustomEndpointInput(): string | undefined;
    private _composerCustomEndpoint?;
    /**
     * @stability stable
     */
    get composerCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set composerCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetComposerCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get composerCustomEndpointInput(): string | undefined;
    private _computeBetaCustomEndpoint?;
    /**
     * @stability stable
     */
    get computeBetaCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set computeBetaCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetComputeBetaCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get computeBetaCustomEndpointInput(): string | undefined;
    private _computeCustomEndpoint?;
    /**
     * @stability stable
     */
    get computeCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set computeCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetComputeCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get computeCustomEndpointInput(): string | undefined;
    private _containerAnalysisCustomEndpoint?;
    /**
     * @stability stable
     */
    get containerAnalysisCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set containerAnalysisCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetContainerAnalysisCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get containerAnalysisCustomEndpointInput(): string | undefined;
    private _containerBetaCustomEndpoint?;
    /**
     * @stability stable
     */
    get containerBetaCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set containerBetaCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetContainerBetaCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get containerBetaCustomEndpointInput(): string | undefined;
    private _containerCustomEndpoint?;
    /**
     * @stability stable
     */
    get containerCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set containerCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetContainerCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get containerCustomEndpointInput(): string | undefined;
    private _credentials?;
    /**
     * @stability stable
     */
    get credentials(): string | undefined;
    /**
     * @stability stable
     */
    set credentials(value: string | undefined);
    /**
     * @stability stable
     */
    resetCredentials(): void;
    /**
     * @stability stable
     */
    get credentialsInput(): string | undefined;
    private _dataCatalogCustomEndpoint?;
    /**
     * @stability stable
     */
    get dataCatalogCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set dataCatalogCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetDataCatalogCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get dataCatalogCustomEndpointInput(): string | undefined;
    private _dataLossPreventionCustomEndpoint?;
    /**
     * @stability stable
     */
    get dataLossPreventionCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set dataLossPreventionCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetDataLossPreventionCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get dataLossPreventionCustomEndpointInput(): string | undefined;
    private _dataflowCustomEndpoint?;
    /**
     * @stability stable
     */
    get dataflowCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set dataflowCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetDataflowCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get dataflowCustomEndpointInput(): string | undefined;
    private _dataprocBetaCustomEndpoint?;
    /**
     * @stability stable
     */
    get dataprocBetaCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set dataprocBetaCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetDataprocBetaCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get dataprocBetaCustomEndpointInput(): string | undefined;
    private _dataprocCustomEndpoint?;
    /**
     * @stability stable
     */
    get dataprocCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set dataprocCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetDataprocCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get dataprocCustomEndpointInput(): string | undefined;
    private _datastoreCustomEndpoint?;
    /**
     * @stability stable
     */
    get datastoreCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set datastoreCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetDatastoreCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get datastoreCustomEndpointInput(): string | undefined;
    private _deploymentManagerCustomEndpoint?;
    /**
     * @stability stable
     */
    get deploymentManagerCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set deploymentManagerCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetDeploymentManagerCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get deploymentManagerCustomEndpointInput(): string | undefined;
    private _dialogflowCustomEndpoint?;
    /**
     * @stability stable
     */
    get dialogflowCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set dialogflowCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetDialogflowCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get dialogflowCustomEndpointInput(): string | undefined;
    private _dialogflowCxCustomEndpoint?;
    /**
     * @stability stable
     */
    get dialogflowCxCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set dialogflowCxCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetDialogflowCxCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get dialogflowCxCustomEndpointInput(): string | undefined;
    private _dnsCustomEndpoint?;
    /**
     * @stability stable
     */
    get dnsCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set dnsCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetDnsCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get dnsCustomEndpointInput(): string | undefined;
    private _essentialContactsCustomEndpoint?;
    /**
     * @stability stable
     */
    get essentialContactsCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set essentialContactsCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetEssentialContactsCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get essentialContactsCustomEndpointInput(): string | undefined;
    private _eventarcCustomEndpoint?;
    /**
     * @stability stable
     */
    get eventarcCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set eventarcCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetEventarcCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get eventarcCustomEndpointInput(): string | undefined;
    private _filestoreCustomEndpoint?;
    /**
     * @stability stable
     */
    get filestoreCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set filestoreCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetFilestoreCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get filestoreCustomEndpointInput(): string | undefined;
    private _firestoreCustomEndpoint?;
    /**
     * @stability stable
     */
    get firestoreCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set firestoreCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetFirestoreCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get firestoreCustomEndpointInput(): string | undefined;
    private _gameServicesCustomEndpoint?;
    /**
     * @stability stable
     */
    get gameServicesCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set gameServicesCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetGameServicesCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get gameServicesCustomEndpointInput(): string | undefined;
    private _gkeHubCustomEndpoint?;
    /**
     * @stability stable
     */
    get gkeHubCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set gkeHubCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetGkeHubCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get gkeHubCustomEndpointInput(): string | undefined;
    private _gkehubFeatureCustomEndpoint?;
    /**
     * @stability stable
     */
    get gkehubFeatureCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set gkehubFeatureCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetGkehubFeatureCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get gkehubFeatureCustomEndpointInput(): string | undefined;
    private _healthcareCustomEndpoint?;
    /**
     * @stability stable
     */
    get healthcareCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set healthcareCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetHealthcareCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get healthcareCustomEndpointInput(): string | undefined;
    private _iamCredentialsCustomEndpoint?;
    /**
     * @stability stable
     */
    get iamCredentialsCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set iamCredentialsCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetIamCredentialsCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get iamCredentialsCustomEndpointInput(): string | undefined;
    private _iamCustomEndpoint?;
    /**
     * @stability stable
     */
    get iamCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set iamCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetIamCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get iamCustomEndpointInput(): string | undefined;
    private _iapCustomEndpoint?;
    /**
     * @stability stable
     */
    get iapCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set iapCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetIapCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get iapCustomEndpointInput(): string | undefined;
    private _identityPlatformCustomEndpoint?;
    /**
     * @stability stable
     */
    get identityPlatformCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set identityPlatformCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetIdentityPlatformCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get identityPlatformCustomEndpointInput(): string | undefined;
    private _impersonateServiceAccount?;
    /**
     * @stability stable
     */
    get impersonateServiceAccount(): string | undefined;
    /**
     * @stability stable
     */
    set impersonateServiceAccount(value: string | undefined);
    /**
     * @stability stable
     */
    resetImpersonateServiceAccount(): void;
    /**
     * @stability stable
     */
    get impersonateServiceAccountInput(): string | undefined;
    private _impersonateServiceAccountDelegates?;
    /**
     * @stability stable
     */
    get impersonateServiceAccountDelegates(): string[] | undefined;
    /**
     * @stability stable
     */
    set impersonateServiceAccountDelegates(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetImpersonateServiceAccountDelegates(): void;
    /**
     * @stability stable
     */
    get impersonateServiceAccountDelegatesInput(): string[] | undefined;
    private _kmsCustomEndpoint?;
    /**
     * @stability stable
     */
    get kmsCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set kmsCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetKmsCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get kmsCustomEndpointInput(): string | undefined;
    private _loggingCustomEndpoint?;
    /**
     * @stability stable
     */
    get loggingCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set loggingCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetLoggingCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get loggingCustomEndpointInput(): string | undefined;
    private _memcacheCustomEndpoint?;
    /**
     * @stability stable
     */
    get memcacheCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set memcacheCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetMemcacheCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get memcacheCustomEndpointInput(): string | undefined;
    private _mlEngineCustomEndpoint?;
    /**
     * @stability stable
     */
    get mlEngineCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set mlEngineCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetMlEngineCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get mlEngineCustomEndpointInput(): string | undefined;
    private _monitoringCustomEndpoint?;
    /**
     * @stability stable
     */
    get monitoringCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set monitoringCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetMonitoringCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get monitoringCustomEndpointInput(): string | undefined;
    private _networkManagementCustomEndpoint?;
    /**
     * @stability stable
     */
    get networkManagementCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set networkManagementCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetNetworkManagementCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get networkManagementCustomEndpointInput(): string | undefined;
    private _networkServicesCustomEndpoint?;
    /**
     * @stability stable
     */
    get networkServicesCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set networkServicesCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetNetworkServicesCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get networkServicesCustomEndpointInput(): string | undefined;
    private _notebooksCustomEndpoint?;
    /**
     * @stability stable
     */
    get notebooksCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set notebooksCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetNotebooksCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get notebooksCustomEndpointInput(): string | undefined;
    private _orgPolicyCustomEndpoint?;
    /**
     * @stability stable
     */
    get orgPolicyCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set orgPolicyCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetOrgPolicyCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get orgPolicyCustomEndpointInput(): string | undefined;
    private _osConfigCustomEndpoint?;
    /**
     * @stability stable
     */
    get osConfigCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set osConfigCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetOsConfigCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get osConfigCustomEndpointInput(): string | undefined;
    private _osLoginCustomEndpoint?;
    /**
     * @stability stable
     */
    get osLoginCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set osLoginCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetOsLoginCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get osLoginCustomEndpointInput(): string | undefined;
    private _privatecaCustomEndpoint?;
    /**
     * @stability stable
     */
    get privatecaCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set privatecaCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetPrivatecaCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get privatecaCustomEndpointInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string | undefined;
    /**
     * @stability stable
     */
    set project(value: string | undefined);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _pubsubCustomEndpoint?;
    /**
     * @stability stable
     */
    get pubsubCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set pubsubCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetPubsubCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get pubsubCustomEndpointInput(): string | undefined;
    private _pubsubLiteCustomEndpoint?;
    /**
     * @stability stable
     */
    get pubsubLiteCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set pubsubLiteCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetPubsubLiteCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get pubsubLiteCustomEndpointInput(): string | undefined;
    private _redisCustomEndpoint?;
    /**
     * @stability stable
     */
    get redisCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set redisCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetRedisCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get redisCustomEndpointInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _requestReason?;
    /**
     * @stability stable
     */
    get requestReason(): string | undefined;
    /**
     * @stability stable
     */
    set requestReason(value: string | undefined);
    /**
     * @stability stable
     */
    resetRequestReason(): void;
    /**
     * @stability stable
     */
    get requestReasonInput(): string | undefined;
    private _requestTimeout?;
    /**
     * @stability stable
     */
    get requestTimeout(): string | undefined;
    /**
     * @stability stable
     */
    set requestTimeout(value: string | undefined);
    /**
     * @stability stable
     */
    resetRequestTimeout(): void;
    /**
     * @stability stable
     */
    get requestTimeoutInput(): string | undefined;
    private _resourceManagerCustomEndpoint?;
    /**
     * @stability stable
     */
    get resourceManagerCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set resourceManagerCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetResourceManagerCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get resourceManagerCustomEndpointInput(): string | undefined;
    private _resourceManagerV2CustomEndpoint?;
    /**
     * @stability stable
     */
    get resourceManagerV2CustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set resourceManagerV2CustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetResourceManagerV2CustomEndpoint(): void;
    /**
     * @stability stable
     */
    get resourceManagerV2CustomEndpointInput(): string | undefined;
    private _runtimeConfigCustomEndpoint?;
    /**
     * @stability stable
     */
    get runtimeConfigCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set runtimeConfigCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetRuntimeConfigCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get runtimeConfigCustomEndpointInput(): string | undefined;
    private _runtimeconfigCustomEndpoint?;
    /**
     * @stability stable
     */
    get runtimeconfigCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set runtimeconfigCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetRuntimeconfigCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get runtimeconfigCustomEndpointInput(): string | undefined;
    private _scopes?;
    /**
     * @stability stable
     */
    get scopes(): string[] | undefined;
    /**
     * @stability stable
     */
    set scopes(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetScopes(): void;
    /**
     * @stability stable
     */
    get scopesInput(): string[] | undefined;
    private _secretManagerCustomEndpoint?;
    /**
     * @stability stable
     */
    get secretManagerCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set secretManagerCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetSecretManagerCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get secretManagerCustomEndpointInput(): string | undefined;
    private _securityCenterCustomEndpoint?;
    /**
     * @stability stable
     */
    get securityCenterCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set securityCenterCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetSecurityCenterCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get securityCenterCustomEndpointInput(): string | undefined;
    private _serviceManagementCustomEndpoint?;
    /**
     * @stability stable
     */
    get serviceManagementCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set serviceManagementCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetServiceManagementCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get serviceManagementCustomEndpointInput(): string | undefined;
    private _serviceNetworkingCustomEndpoint?;
    /**
     * @stability stable
     */
    get serviceNetworkingCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set serviceNetworkingCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetServiceNetworkingCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get serviceNetworkingCustomEndpointInput(): string | undefined;
    private _serviceUsageCustomEndpoint?;
    /**
     * @stability stable
     */
    get serviceUsageCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set serviceUsageCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetServiceUsageCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get serviceUsageCustomEndpointInput(): string | undefined;
    private _sourceRepoCustomEndpoint?;
    /**
     * @stability stable
     */
    get sourceRepoCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set sourceRepoCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetSourceRepoCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get sourceRepoCustomEndpointInput(): string | undefined;
    private _spannerCustomEndpoint?;
    /**
     * @stability stable
     */
    get spannerCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set spannerCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetSpannerCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get spannerCustomEndpointInput(): string | undefined;
    private _sqlCustomEndpoint?;
    /**
     * @stability stable
     */
    get sqlCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set sqlCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetSqlCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get sqlCustomEndpointInput(): string | undefined;
    private _storageCustomEndpoint?;
    /**
     * @stability stable
     */
    get storageCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set storageCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetStorageCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get storageCustomEndpointInput(): string | undefined;
    private _storageTransferCustomEndpoint?;
    /**
     * @stability stable
     */
    get storageTransferCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set storageTransferCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetStorageTransferCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get storageTransferCustomEndpointInput(): string | undefined;
    private _tagsCustomEndpoint?;
    /**
     * @stability stable
     */
    get tagsCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set tagsCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetTagsCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get tagsCustomEndpointInput(): string | undefined;
    private _tpuCustomEndpoint?;
    /**
     * @stability stable
     */
    get tpuCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set tpuCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetTpuCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get tpuCustomEndpointInput(): string | undefined;
    private _userProjectOverride?;
    /**
     * @stability stable
     */
    get userProjectOverride(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set userProjectOverride(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetUserProjectOverride(): void;
    /**
     * @stability stable
     */
    get userProjectOverrideInput(): boolean | cdktf.IResolvable | undefined;
    private _vertexAiCustomEndpoint?;
    /**
     * @stability stable
     */
    get vertexAiCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set vertexAiCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetVertexAiCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get vertexAiCustomEndpointInput(): string | undefined;
    private _vpcAccessCustomEndpoint?;
    /**
     * @stability stable
     */
    get vpcAccessCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set vpcAccessCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetVpcAccessCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get vpcAccessCustomEndpointInput(): string | undefined;
    private _workflowsCustomEndpoint?;
    /**
     * @stability stable
     */
    get workflowsCustomEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set workflowsCustomEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetWorkflowsCustomEndpoint(): void;
    /**
     * @stability stable
     */
    get workflowsCustomEndpointInput(): string | undefined;
    private _zone?;
    /**
     * @stability stable
     */
    get zone(): string | undefined;
    /**
     * @stability stable
     */
    set zone(value: string | undefined);
    /**
     * @stability stable
     */
    resetZone(): void;
    /**
     * @stability stable
     */
    get zoneInput(): string | undefined;
    private _alias?;
    /**
     * @stability stable
     */
    get alias(): string | undefined;
    /**
     * @stability stable
     */
    set alias(value: string | undefined);
    /**
     * @stability stable
     */
    resetAlias(): void;
    /**
     * @stability stable
     */
    get aliasInput(): string | undefined;
    private _batching?;
    /**
     * @stability stable
     */
    get batching(): GoogleProviderBatching | undefined;
    /**
     * @stability stable
     */
    set batching(value: GoogleProviderBatching | undefined);
    /**
     * @stability stable
     */
    resetBatching(): void;
    /**
     * @stability stable
     */
    get batchingInput(): GoogleProviderBatching | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
