"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResourcePolicy = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const logs_generated_1 = require("./logs.generated");
/**
 * Resource Policy for CloudWatch Log Groups
 *
 * Policies define the operations that are allowed on this resource.
 *
 * You almost never need to define this construct directly.
 *
 * All AWS resources that support resource policies have a method called
 * `addToResourcePolicy()`, which will automatically create a new resource
 * policy if one doesn't exist yet, otherwise it will add to the existing
 * policy.
 *
 * Prefer to use `addToResourcePolicy()` instead.
 */
class ResourcePolicy extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props?.resourcePolicyName,
        });
        /**
         * The IAM policy document for this resource policy.
         */
        this.document = new aws_iam_1.PolicyDocument();
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_logs_ResourcePolicyProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ResourcePolicy);
            }
            throw error;
        }
        new logs_generated_1.CfnResourcePolicy(this, 'ResourcePolicy', {
            policyName: core_1.Lazy.string({
                produce: () => props?.resourcePolicyName ?? core_1.Names.uniqueId(this),
            }),
            policyDocument: core_1.Lazy.string({
                produce: () => JSON.stringify(this.document),
            }),
        });
        if (props?.policyStatements) {
            this.document.addStatements(...props.policyStatements);
        }
    }
}
exports.ResourcePolicy = ResourcePolicy;
_a = JSII_RTTI_SYMBOL_1;
ResourcePolicy[_a] = { fqn: "@aws-cdk/aws-logs.ResourcePolicy", version: "1.181.0" };
//# sourceMappingURL=data:application/json;base64,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