# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables

__all__ = ['ProjectFreezePeriod']


class ProjectFreezePeriod(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cron_timezone: Optional[pulumi.Input[str]] = None,
                 freeze_end: Optional[pulumi.Input[str]] = None,
                 freeze_start: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        ## # ProjectFreezePeriod

        This resource allows you to create and manage freeze periods. For further information on freeze periods, consult the [gitlab documentation](https://docs.gitlab.com/ee/api/freeze_periods.html#create-a-freeze-period).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        schedule = gitlab.ProjectFreezePeriod("schedule",
            project_id=gitlab_project["foo"]["id"],
            freeze_start="0 23 * * 5",
            freeze_end="0 7 * * 1",
            cron_timezone="UTC")
        ```

        ## Import

        GitLab project freeze periods can be imported using an id made up of `project_id:freeze_period_id`, e.g.

        ```sh
         $ pulumi import gitlab:index/projectFreezePeriod:ProjectFreezePeriod schedule "12345:1337"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cron_timezone: The timezone.
        :param pulumi.Input[str] freeze_end: End of the Freeze Period in cron format (e.g. `0 2 * * *`).
        :param pulumi.Input[str] freeze_start: Start of the Freeze Period in cron format (e.g. `0 1 * * *`).
        :param pulumi.Input[str] project_id: The id of the project to add the schedule to.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['cron_timezone'] = cron_timezone
            if freeze_end is None and not opts.urn:
                raise TypeError("Missing required property 'freeze_end'")
            __props__['freeze_end'] = freeze_end
            if freeze_start is None and not opts.urn:
                raise TypeError("Missing required property 'freeze_start'")
            __props__['freeze_start'] = freeze_start
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__['project_id'] = project_id
        super(ProjectFreezePeriod, __self__).__init__(
            'gitlab:index/projectFreezePeriod:ProjectFreezePeriod',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cron_timezone: Optional[pulumi.Input[str]] = None,
            freeze_end: Optional[pulumi.Input[str]] = None,
            freeze_start: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None) -> 'ProjectFreezePeriod':
        """
        Get an existing ProjectFreezePeriod resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cron_timezone: The timezone.
        :param pulumi.Input[str] freeze_end: End of the Freeze Period in cron format (e.g. `0 2 * * *`).
        :param pulumi.Input[str] freeze_start: Start of the Freeze Period in cron format (e.g. `0 1 * * *`).
        :param pulumi.Input[str] project_id: The id of the project to add the schedule to.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["cron_timezone"] = cron_timezone
        __props__["freeze_end"] = freeze_end
        __props__["freeze_start"] = freeze_start
        __props__["project_id"] = project_id
        return ProjectFreezePeriod(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="cronTimezone")
    def cron_timezone(self) -> pulumi.Output[Optional[str]]:
        """
        The timezone.
        """
        return pulumi.get(self, "cron_timezone")

    @property
    @pulumi.getter(name="freezeEnd")
    def freeze_end(self) -> pulumi.Output[str]:
        """
        End of the Freeze Period in cron format (e.g. `0 2 * * *`).
        """
        return pulumi.get(self, "freeze_end")

    @property
    @pulumi.getter(name="freezeStart")
    def freeze_start(self) -> pulumi.Output[str]:
        """
        Start of the Freeze Period in cron format (e.g. `0 1 * * *`).
        """
        return pulumi.get(self, "freeze_start")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        The id of the project to add the schedule to.
        """
        return pulumi.get(self, "project_id")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

