# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['perceval',
 'perceval.backends.core',
 'tests',
 'tests.mocked_package',
 'tests.mocked_package.nested_package']

package_data = \
{'': ['*'],
 'tests': ['data/askbot/*',
           'data/bugzilla/*',
           'data/confluence/*',
           'data/discourse/*',
           'data/dockerhub/*',
           'data/gerrit/*',
           'data/git/*',
           'data/github/*',
           'data/gitlab/*',
           'data/gitter/*',
           'data/googlehits/*',
           'data/groupsio/*',
           'data/hyperkitty/*',
           'data/jenkins/*',
           'data/jira/*',
           'data/launchpad/*',
           'data/mattermost/*',
           'data/mbox/*',
           'data/mediawiki/*',
           'data/meetup/*',
           'data/nntp/*',
           'data/pagure/*',
           'data/phabricator/*',
           'data/pipermail/*',
           'data/redmine/*',
           'data/rocketchat/*',
           'data/rss/*',
           'data/slack/*',
           'data/stackexchange/*',
           'data/supybot/*',
           'data/telegram/*',
           'data/twitter/*',
           'data/utils/*']}

install_requires = \
['PyJWT>=2.4.0,<3.0.0',
 'beautifulsoup4>=4.3.2,<5.0.0',
 'cryptography>=3.3.2,<4.0.0',
 'dulwich>=0.20.0,<0.21.0',
 'feedparser>=6.0.8,<7.0.0',
 'grimoirelab-toolkit>=0.3',
 'python-dateutil>=2.6.0,<3.0.0',
 'requests>=2.7.0,<3.0.0',
 'urllib3>=1.26,<2.0']

extras_require = \
{'docs': ['myst-parser>=0.15.2,<0.16.0', 'furo>=2021.8.31,<2022.0.0']}

entry_points = \
{'console_scripts': ['perceval = perceval.perceval:main']}

setup_kwargs = {
    'name': 'perceval',
    'version': '0.20.0rc14',
    'description': 'Send Sir Perceval on a quest to fetch and gather data from software repositories.',
    'long_description': '# Perceval [![Build Status](https://github.com/chaoss/grimoirelab-perceval/workflows/tests/badge.svg)](https://github.com/chaoss/grimoirelab-perceval/actions?query=workflow:tests+branch:master+event:push) [![Coverage Status](https://img.shields.io/coveralls/chaoss/grimoirelab-perceval.svg)](https://coveralls.io/r/chaoss/grimoirelab-perceval?branch=master) [![PyPI version](https://badge.fury.io/py/perceval.svg)](https://badge.fury.io/py/perceval) [![Documentation in RTD](https://readthedocs.org/projects/perceval/badge/)](http://perceval.readthedocs.io)\n\nSend Sir Perceval on a quest to retrieve and gather data from software\nrepositories.\n\n## Usage\n\n```\nusage: perceval [-g] <backend> [<args>] | --help | --version | --list\n\nSend Sir Perceval on a quest to retrieve and gather data from software\nrepositories.\n\nRepositories are reached using specific backends. The most common backends\nare:\n\n    askbot           Fetch questions and answers from Askbot site\n    bugzilla         Fetch bugs from a Bugzilla server\n    bugzillarest     Fetch bugs from a Bugzilla server (>=5.0) using its REST API\n    confluence       Fetch contents from a Confluence server\n    discourse        Fetch posts from Discourse site\n    dockerhub        Fetch repository data from Docker Hub site\n    gerrit           Fetch reviews from a Gerrit server\n    git              Fetch commits from Git\n    github           Fetch issues, pull requests and repository information from GitHub\n    gitlab           Fetch issues, merge requests from GitLab\n    gitter           Fetch messages from a Gitter room\n    googlehits       Fetch hits from Google API\n    groupsio         Fetch messages from Groups.io\n    hyperkitty       Fetch messages from a HyperKitty archiver\n    jenkins          Fetch builds from a Jenkins server\n    jira             Fetch issues from JIRA issue tracker\n    launchpad        Fetch issues from Launchpad issue tracker\n    mattermost       Fetch posts from a Mattermost server\n    mbox             Fetch messages from MBox files\n    mediawiki        Fetch pages and revisions from a MediaWiki site\n    meetup           Fetch events from a Meetup group\n    nntp             Fetch articles from a NNTP news group\n    pagure           Fetch issues from Pagure\n    phabricator      Fetch tasks from a Phabricator site\n    pipermail        Fetch messages from a Pipermail archiver\n    redmine          Fetch issues from a Redmine server\n    rocketchat       Fetch messages from a Rocket.Chat channel\n    rss              Fetch entries from a RSS feed server\n    slack            Fetch messages from a Slack channel\n    stackexchange    Fetch questions from StackExchange sites\n    supybot          Fetch messages from Supybot log files\n    telegram         Fetch messages from the Telegram server\n    twitter          Fetch tweets from the Twitter Search API\n\noptional arguments:\n  -h, --help            show this help message and exit\n  -v, --version         show version\n  -g, --debug           set debug mode on\n  -l, --list            show available backends\n\nRun \'perceval <backend> --help\' to get information about a specific backend.\n\n```\n\n## Requirements\n\nPerceval requires Python 3.7 or later to run. For other Python\ndependencies, please check the `pyproject.toml` file included\non this repository.\n\nAlso, note that you should have the following packages installed\nin your system:\n\n- git\n- build-essential\n\n## Installation\n\nThere are several ways for installing Perceval on your system: from packages,\nfrom a docker image or from the source code.\n\n### Pip\n\nPerceval can be installed using [pip](https://pip.pypa.io/en/stable/), a tool\nfor installing Python packages. To do it, run the next command:\n\n```\n$ pip3 install perceval\n```\n\n### Docker\n\nA Perceval Docker image is available at [DockerHub](https://hub.docker.com/r/grimoirelab/perceval/).\n\nDetailed information on how to run and/or build this image can be found [here](https://github.com/chaoss/grimoirelab-perceval/tree/master/docker/images/).\n\n### Source code\n\nTo install from the source code you will need to clone the repository first:\n\n```\n$ git clone https://github.com/chaoss/grimoirelab-perceval.git\n```\n\nThen you can execute the following commands:\n```\n$ pip3 install -r requirements.txt\n$ pip3 install .\n```\n\nIn case you are a developer, you should execute the following commands to install Perceval in your working directory (option `-e`) and the packages of requirements_tests.txt.\n```\n$ pip3 install -r requirements.txt\n$ pip3 install -r requirements_tests.txt\n$ pip3 install -e .\n```\n\n## Documentation\n\nDocumentation is generated automatically in the [ReadTheDocs Perceval site](http://perceval.readthedocs.org/).\n\n## References\n\nIf you use Perceval in your research papers, please refer to [Perceval: software project data at your will](https://dl.acm.org/citation.cfm?id=3183475) -- [Pre-print](https://www.researchgate.net/profile/Valerio_Cosentino/publication/325334393_Perceval_Software_Project_Data_at_Your_Will/links/5b066c9fa6fdcc8c2522b07c/Perceval-Software-Project-Data-at-Your-Will.pdf):\n\n### APA style\n\n```\nDueñas, S., Cosentino, V., Robles, G., & Gonzalez-Barahona, J. M. (2018, May). Perceval: software project data at your will. In Proceedings of the 40th International Conference on Software Engineering: Companion Proceeedings (pp. 1-4). ACM.\n```\n\n### BibTeX\n\n```\n@inproceedings{duenas2018perceval,\n  title={Perceval: software project data at your will},\n  author={Due{\\~n}as, Santiago and Cosentino, Valerio and Robles, Gregorio and Gonzalez-Barahona, Jesus M},\n  booktitle={Proceedings of the 40th International Conference on Software Engineering: Companion Proceeedings},\n  pages={1--4},\n  year={2018},\n  organization={ACM}\n}\n```\n\n\n## Examples\n\n### Askbot\n```\n$ perceval askbot \'http://askbot.org/\' --from-date \'2016-01-01\'\n```\n\n### Bugzilla\nTo fetch bugs from Bugzilla, you have two options:\n\na) Use the traditional backend\n\n```\n$ perceval bugzilla \'https://bugzilla.redhat.com/\' --backend-user user --backend-password pass --from-date \'2016-01-01\'\n```\n\nb) Use the REST API backend for Buzilla 5.0 (or higher) servers. We strongly recommend\nthis backend when data is fetched from version servers >=5.0 because the retrieval\nprocess is much faster.\n\n```\n$ perceval bugzillarest \'https://bugzilla.mozilla.org/\' --backend-user user --backend-password pass --from-date \'2016-01-01\'\n```\n\n### Confluence\n```\n$ perceval confluence \'https://wiki.opnfv.org/\' --from-date \'2016-01-01\'\n```\n\n### Discourse\n```\n$ perceval discourse \'https://foro.mozilla-hispano.org/\' --from-date \'2016-01-01\'\n```\n\n### Docker Hub\n```\n$ perceval dockerhub grimoirelab perceval\n```\n\n### Gerrit\nTo run gerrit, you will need an authorized SSH private key:\n\n```\n$ eval `ssh-agent -s`\n$ ssh-add ~/.ssh/id_rsa\nIdentity added: /home/user/.ssh/id_rsa (/home/user/.ssh/id_rsa)\n```\n\nTo run the backend, execute the next command:\n\n```\n$ perceval gerrit --user user \'review.openstack.org\' --from-date \'2016-01-01\'\n```\n\n### Git\n\nTo run this backend execute the next command. Take into account that to run\nthis backend Git program has to be installed on your system.\n\n```\n$ perceval git \'https://github.com/chaoss/grimoirelab-perceval.git\' --from-date \'2016-01-01\'\n```\n\nTo run the backend against a **private git repository**, you must pass the\ncredentials directly in the URL:\n\n```\nperceval git https://<username>:<password>@repository-url\n```\n\nFor example, for private GitHub repositories:\n\n```\n$ perceval git https://<username>:<api-token>@github.com/chaoss/grimoirelab-perceval\n```\n\nGit backend can also work with a Git log file as input. We recommend to use the next command to get the most complete log file.\n\n```\ngit log --raw --numstat --pretty=fuller --decorate=full --parents --reverse --topo-order -M -C -c --remotes=origin --all > /tmp/gitlog.log\n```\n\nThen, to run the backend, just execute any of the next commands:\n\n```\n$ perceval git --git-log \'/tmp/gitlog.log\' \'file:///myrepo.git\'\n```\n\nor\n\n```\n$ perceval git \'/tmp/gitlog.log\'\n```\n\n### GitHub\n```\n$ perceval github elastic logstash --from-date \'2016-01-01\'\n```\n\nThe GitHub backend accepts the categories `issue`, `pull_request` and `repository` which allow to fetch the specific data.\n\n```\n$ perceval github --category issue elastic logstash\n```\n\n### GitLab\n```\n$ perceval gitlab elastic logstash --from-date \'2016-01-01\'\n```\n\n### Gitter\n```\n$ perceval gitter -t \'abcdefghi\' --from-date \'2020-03-18\' \'jenkinsci\' \'jenkins\'\n```\n\n### GoogleHits\n```\n$ perceval googlehits "bitergia grimoirelab"\n```\n\n### Groups.io\n```\n$ perceval groupsio \'updates\' -e \'<me@example.com>\' -p \'my-password\' --from-date \'2016-01-01\'\n```\nIn order to fetch the data from a group, you should first subscribe to it via the Groups.io website.\nIn case you want to know the group names where you are subscribed, you can use the following script: https://gist.github.com/valeriocos/ad33a0b9b2d13a8336230c8c59df3c55\n\n\n### HyperKitty\n```\n$ perceval hyperkitty \'https://lists.mailman3.org/archives/list/mailman-users@mailman3.org\' --from-date 2017-01-01\n```\n\n### Jenkins\n```\n$ perceval jenkins \'https://build.opnfv.org/ci/\'\n```\n\n### JIRA\n```\n$ perceval jira \'https://tickets.puppetlabs.com\' --project PUP --from-date \'2016-01-01\'\n```\n\n### Launchpad\n```\n$ perceval launchpad ubuntu --from-date \'2016-01-01\'\n```\n\n### Mattermost\n```\n$ perceval mattermost \'http://mattermost.example.com\' jgw7jdmjkjf19ffkwnw59i5f9e --from-date \'2016-01-01\' -t \'abcdefghijk\'\n```\n\n### MBox\n```\n$ perceval mbox \'http://example.com\' /tmp/mboxes/\n```\n\n### MediaWiki\n```\n$ perceval mediawiki \'https://wiki.mozilla.org\' --from-date \'2016-06-30\'\n```\n\n### Meetup\n```\n$ perceval meetup \'Software-Development-Analytics\' --from-date \'2016-06-01\' -t abcdefghijk\n```\n\n### NNTP\n```\n$ perceval nntp \'news.mozilla.org\' \'mozilla.dev.project-link\' --offset 10\n```\n\n### Pagure\n```\n$ perceval pagure \'389-ds-base\' --from-date \'2020-03-06\'\n```\n\n### Phabricator\n```\n$ perceval phabricator \'https://secure.phabricator.com/\' -t 123456789abcefe\n```\n\n### Pipermail\n```\n$ perceval pipermail \'https://mail.gnome.org/archives/libart-hackers/\'\n```\n\nPipermail also is able to fetch data from Apache\'s `mod_box` interface:\n```\n$ perceval pipermail \'http://mail-archives.apache.org/mod_mbox/httpd-dev/\'\n```\n\n### Redmine\n```\n$ perceval redmine \'https://www.redmine.org/\' --from-date \'2016-01-01\' -t abcdefghijk\n```\n\n### Rocket.Chat\n\nRocket.Chat backend needs an API token and a User Id to authenticate to the server.\n```\n$ perceval rocketchat -t \'abchdefghij\' -u \'1234abcd\' --from-date \'2020-05-02\' https://open.rocket.chat general\n```\n\n### RSS\n```\n$ perceval rss \'https://blog.bitergia.com/feed/\'\n```\n\n### Slack\n\nSlack backend requires an API token for authentication. Slack apps can be\nused to generate and configure this API token. The scopes required by a Slack\napp for the backend are `channels:history`, `channels:read` and `users:read`.\nTo know more about Slack apps and its integration please refer the\n[Slack apps documentation](https://api.slack.com/start/overview).\nFor more information about the scopes required by a Slack app please refer the\n[Scopes and permissions documentation](https://api.slack.com/scopes).\n\nThe following [script](https://gist.github.com/valeriocos/de31324625a3fab32449cf5d43b24075)\ncan also be used to generate an OAuth2 token to access the Slack API.\n\n```\n$ perceval slack C0001 --from-date 2016-01-12 -t abcedefghijk\n```\n\n### StackExchange\n```\n$ perceval stackexchange --site stackoverflow --tagged python --from-date \'2016-01-01\' -t abcdabcdabcdabcd\n```\n\n### Supybot\n```\n$ perceval supybot \'http://channel.example.com\' /tmp/supybot/\n```\n\n### Telegram\n\nTelegram backend needs an API token to authenticate the bot. In addition and\nin order to fetch messages from a group or channel, privacy settings must be\ndisabled. To know how to create a bot, to obtain its token and to configure it\nplease read the [Telegram Bots docs pages](https://core.telegram.org/bots).\n\nNote that the messages are available on the Telegram server until the bot fetches\nthem, but they will not be kept longer than 24 hours.\n\n```\n$ perceval telegram mybot -t 12345678abcdefgh --chats 1 2 -10\n```\n\n### Twitter\n\nTwitter backend needs a bearer token to authenticate the requests. It can be obtained\nusing the code available on GistGitHub:\nhttps://gist.github.com/valeriocos/7d4d28f72f53fbce49f1512ba77ef5f6\n\n```\n$ perceval twitter grimoirelab -t 12345678abcdefgh\n```\n\n## Community Backends\n\nSome backends are implemented in a seperate repository but not merged into \n[chaoss/grimoirelab-perceval](https://github.com/chaoss/grimoirelab-perceval) \ndue to long-run maintainence reasons. Please feel free to check the backends\nand contact the maintainers for any issues or questions related to them.\n\n- Bundle for Puppet, Inc. ecosystem: [chaoss/grimoirelab-perceval-puppet](https://github.com/chaoss/grimoirelab-perceval-puppet)\n- Bundle for OPNFV ecosystem: [chaoss/grimoirelab-perceval-opnfv](https://github.com/chaoss/grimoirelab-perceval-opnfv)\n- Bundle for Mozilla ecosystem: [chaoss/grimoirelab-perceval-mozilla](https://github.com/chaoss/grimoirelab-perceval-mozilla)\n- Bundle for FINOS ecosystem: [Bitergia/grimoirelab-perceval-finos](https://github.com/Bitergia/grimoirelab-perceval-finos)\n- Weblate backend: [chaoss/grimoirelab-perceval-weblate](https://github.com/chaoss/grimoirelab-perceval-weblate)\n- Zulip backend: [vchrombie/grimoirelab-perceval-zulip](https://github.com/vchrombie/grimoirelab-perceval-zulip)\n- OSF backend: [gitlab.com/open-rit/perceval-osf](https://gitlab.com/open-rit/perceval-osf)\n- Gitee backend: [grimoirelab-gitee/grimoirelab-perceval-gitee](https://github.com/grimoirelab-gitee/grimoirelab-perceval-gitee)\n- Airtable backend: [perceval-backends/grimoirelab-perceval-airtable](https://github.com/perceval-backends/grimoirelab-perceval-airtable)\n- Bitbucket backend: [perceval-backends/grimoirelab-perceval-bitbucket](https://github.com/perceval-backends/grimoirelab-perceval-bitbucket)\n\n## Running tests\n\nPerceval comes with a comprehensive list of unit tests.\nTo run them, in addition to the dependencies installed with Perceval,\nyou need `httpretty`.\n\n## License\n\nLicensed under GNU General Public License (GPL), version 3 or later.\n',
    'author': 'GrimoireLab Developers',
    'author_email': 'None',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://chaoss.github.io/grimoirelab/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
