> **BREAKING CHANGES** (pre-release)
>
> * `> v0.15.5`: updated defaults for UserPoolWithMfa will break deployments for already created userPools. If migrating to a newer version of this package, be sure to set the following in your `cdk.context.json`:
>
>   ```
>     {
>       "@aws-prototyping-sdk/identity:useLegacyMFAProps":true
>     }
>   ```

This module by default deploys a configurable Identity Provider with a default Cognito User Pool. These resources can be used by your website to restrict access to only authenticated users if needed. All settings are configurable and the creation of these AuthN resources can be disabled if needed or configured to use custom AuthN providers i.e. Facebook, Google, etc.

Below is a conceptual view of the default architecture this module creates:

```
Cognito User Pool --------------------> Identity Pool
     |_ User Pool Client                     |_ Unauthenticated IAM Role
                                             |_ Authenticated IAM Role
```

## Migrating Users

If you ever need to migrate users from one cognito user pool to another, you can use this helper utility: https://www.npmjs.com/package/cognito-backup-restore
# API Reference <a name="API Reference" id="api-reference"></a>

## Constructs <a name="Constructs" id="Constructs"></a>

### UserIdentity <a name="UserIdentity" id="@aws-prototyping-sdk/identity.UserIdentity"></a>

Creates a UserPool and Identity Pool with sane defaults configured intended for usage from a web client.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/identity.UserIdentity.Initializer"></a>

```java
import software.aws.awsprototypingsdk.identity.UserIdentity;

UserIdentity.Builder.create(Construct scope, java.lang.String id)
//  .identityPoolOptions(IdentityPoolProps)
//  .userPool(UserPool)
    .build();
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentity.Initializer.parameter.scope">scope</a></code> | <code>software.constructs.Construct</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentity.Initializer.parameter.id">id</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentity.Initializer.parameter.identityPoolOptions">identityPoolOptions</a></code> | <code>software.amazon.awscdk.services.cognito.identitypool.alpha.IdentityPoolProps</code> | Configuration for the Identity Pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentity.Initializer.parameter.userPool">userPool</a></code> | <code>software.amazon.awscdk.services.cognito.UserPool</code> | User provided Cognito UserPool. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@aws-prototyping-sdk/identity.UserIdentity.Initializer.parameter.scope"></a>

- *Type:* software.constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="@aws-prototyping-sdk/identity.UserIdentity.Initializer.parameter.id"></a>

- *Type:* java.lang.String

---

##### `identityPoolOptions`<sup>Optional</sup> <a name="identityPoolOptions" id="@aws-prototyping-sdk/identity.UserIdentity.Initializer.parameter.identityPoolOptions"></a>

- *Type:* software.amazon.awscdk.services.cognito.identitypool.alpha.IdentityPoolProps

Configuration for the Identity Pool.

---

##### `userPool`<sup>Optional</sup> <a name="userPool" id="@aws-prototyping-sdk/identity.UserIdentity.Initializer.parameter.userPool"></a>

- *Type:* software.amazon.awscdk.services.cognito.UserPool
- *Default:* a userpool with mfa will be created.

User provided Cognito UserPool.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentity.toString">toString</a></code> | Returns a string representation of this construct. |

---

##### `toString` <a name="toString" id="@aws-prototyping-sdk/identity.UserIdentity.toString"></a>

```java
public java.lang.String toString()
```

Returns a string representation of this construct.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentity.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@aws-prototyping-sdk/identity.UserIdentity.isConstruct"></a>

```java
import software.aws.awsprototypingsdk.identity.UserIdentity;

UserIdentity.isConstruct(java.lang.Object x)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@aws-prototyping-sdk/identity.UserIdentity.isConstruct.parameter.x"></a>

- *Type:* java.lang.Object

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentity.property.node">node</a></code> | <code>software.constructs.Node</code> | The tree node. |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentity.property.identityPool">identityPool</a></code> | <code>software.amazon.awscdk.services.cognito.identitypool.alpha.IdentityPool</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentity.property.userPool">userPool</a></code> | <code>software.amazon.awscdk.services.cognito.UserPool</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentity.property.userPoolClient">userPoolClient</a></code> | <code>software.amazon.awscdk.services.cognito.UserPoolClient</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@aws-prototyping-sdk/identity.UserIdentity.property.node"></a>

```java
public Node getNode();
```

- *Type:* software.constructs.Node

The tree node.

---

##### `identityPool`<sup>Required</sup> <a name="identityPool" id="@aws-prototyping-sdk/identity.UserIdentity.property.identityPool"></a>

```java
public IdentityPool getIdentityPool();
```

- *Type:* software.amazon.awscdk.services.cognito.identitypool.alpha.IdentityPool

---

##### `userPool`<sup>Required</sup> <a name="userPool" id="@aws-prototyping-sdk/identity.UserIdentity.property.userPool"></a>

```java
public UserPool getUserPool();
```

- *Type:* software.amazon.awscdk.services.cognito.UserPool

---

##### `userPoolClient`<sup>Required</sup> <a name="userPoolClient" id="@aws-prototyping-sdk/identity.UserIdentity.property.userPoolClient"></a>

```java
public UserPoolClient getUserPoolClient();
```

- *Type:* software.amazon.awscdk.services.cognito.UserPoolClient

---


### UserPoolWithMfa <a name="UserPoolWithMfa" id="@aws-prototyping-sdk/identity.UserPoolWithMfa"></a>

Configures a UserPool with MFA across SMS/TOTP using sane defaults.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer"></a>

```java
import software.aws.awsprototypingsdk.identity.UserPoolWithMfa;

UserPoolWithMfa.Builder.create(Construct scope, java.lang.String id)
//  .accountRecovery(AccountRecovery)
//  .advancedSecurityMode(AdvancedSecurityMode)
//  .autoVerify(AutoVerifiedAttrs)
//  .customAttributes(java.util.Map<java.lang.String, ICustomAttribute>)
//  .customSenderKmsKey(IKey)
//  .deletionProtection(java.lang.Boolean)
//  .deviceTracking(DeviceTracking)
//  .email(UserPoolEmail)
//  .enableSmsRole(java.lang.Boolean)
//  .keepOriginal(KeepOriginalAttrs)
//  .lambdaTriggers(UserPoolTriggers)
//  .mfa(Mfa)
//  .mfaMessage(java.lang.String)
//  .mfaSecondFactor(MfaSecondFactor)
//  .passwordPolicy(PasswordPolicy)
//  .removalPolicy(RemovalPolicy)
//  .selfSignUpEnabled(java.lang.Boolean)
//  .signInAliases(SignInAliases)
//  .signInCaseSensitive(java.lang.Boolean)
//  .smsRole(IRole)
//  .smsRoleExternalId(java.lang.String)
//  .snsRegion(java.lang.String)
//  .standardAttributes(StandardAttributes)
//  .userInvitation(UserInvitationConfig)
//  .userPoolName(java.lang.String)
//  .userVerification(UserVerificationConfig)
    .build();
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.scope">scope</a></code> | <code>software.constructs.Construct</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.id">id</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.accountRecovery">accountRecovery</a></code> | <code>software.amazon.awscdk.services.cognito.AccountRecovery</code> | How will a user be able to recover their account? |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.advancedSecurityMode">advancedSecurityMode</a></code> | <code>software.amazon.awscdk.services.cognito.AdvancedSecurityMode</code> | The user pool's Advanced Security Mode. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.autoVerify">autoVerify</a></code> | <code>software.amazon.awscdk.services.cognito.AutoVerifiedAttrs</code> | Attributes which Cognito will look to verify automatically upon user sign up. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.customAttributes">customAttributes</a></code> | <code>java.util.Map<java.lang.String, software.amazon.awscdk.services.cognito.ICustomAttribute></code> | Define a set of custom attributes that can be configured for each user in the user pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.customSenderKmsKey">customSenderKmsKey</a></code> | <code>software.amazon.awscdk.services.kms.IKey</code> | This key will be used to encrypt temporary passwords and authorization codes that Amazon Cognito generates. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.deletionProtection">deletionProtection</a></code> | <code>java.lang.Boolean</code> | Indicates whether the user pool should have deletion protection enabled. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.deviceTracking">deviceTracking</a></code> | <code>software.amazon.awscdk.services.cognito.DeviceTracking</code> | Device tracking settings. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.email">email</a></code> | <code>software.amazon.awscdk.services.cognito.UserPoolEmail</code> | Email settings for a user pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.enableSmsRole">enableSmsRole</a></code> | <code>java.lang.Boolean</code> | Setting this would explicitly enable or disable SMS role creation. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.keepOriginal">keepOriginal</a></code> | <code>software.amazon.awscdk.services.cognito.KeepOriginalAttrs</code> | Attributes which Cognito will look to handle changes to the value of your users' email address and phone number attributes. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.lambdaTriggers">lambdaTriggers</a></code> | <code>software.amazon.awscdk.services.cognito.UserPoolTriggers</code> | Lambda functions to use for supported Cognito triggers. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.mfa">mfa</a></code> | <code>software.amazon.awscdk.services.cognito.Mfa</code> | Configure whether users of this user pool can or are required use MFA to sign in. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.mfaMessage">mfaMessage</a></code> | <code>java.lang.String</code> | The SMS message template sent during MFA verification. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.mfaSecondFactor">mfaSecondFactor</a></code> | <code>software.amazon.awscdk.services.cognito.MfaSecondFactor</code> | Configure the MFA types that users can use in this user pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.passwordPolicy">passwordPolicy</a></code> | <code>software.amazon.awscdk.services.cognito.PasswordPolicy</code> | Password policy for this user pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.removalPolicy">removalPolicy</a></code> | <code>software.amazon.awscdk.RemovalPolicy</code> | Policy to apply when the user pool is removed from the stack. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.selfSignUpEnabled">selfSignUpEnabled</a></code> | <code>java.lang.Boolean</code> | Whether self sign up should be enabled. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.signInAliases">signInAliases</a></code> | <code>software.amazon.awscdk.services.cognito.SignInAliases</code> | Methods in which a user registers or signs in to a user pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.signInCaseSensitive">signInCaseSensitive</a></code> | <code>java.lang.Boolean</code> | Whether sign-in aliases should be evaluated with case sensitivity. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.smsRole">smsRole</a></code> | <code>software.amazon.awscdk.services.iam.IRole</code> | The IAM role that Cognito will assume while sending SMS messages. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.smsRoleExternalId">smsRoleExternalId</a></code> | <code>java.lang.String</code> | The 'ExternalId' that Cognito service must be using when assuming the `smsRole`, if the role is restricted with an 'sts:ExternalId' conditional. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.snsRegion">snsRegion</a></code> | <code>java.lang.String</code> | The region to integrate with SNS to send SMS messages. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.standardAttributes">standardAttributes</a></code> | <code>software.amazon.awscdk.services.cognito.StandardAttributes</code> | The set of attributes that are required for every user in the user pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.userInvitation">userInvitation</a></code> | <code>software.amazon.awscdk.services.cognito.UserInvitationConfig</code> | Configuration around admins signing up users into a user pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.userPoolName">userPoolName</a></code> | <code>java.lang.String</code> | Name of the user pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.userVerification">userVerification</a></code> | <code>software.amazon.awscdk.services.cognito.UserVerificationConfig</code> | Configuration around users signing themselves up to the user pool. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.scope"></a>

- *Type:* software.constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.id"></a>

- *Type:* java.lang.String

---

##### `accountRecovery`<sup>Optional</sup> <a name="accountRecovery" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.accountRecovery"></a>

- *Type:* software.amazon.awscdk.services.cognito.AccountRecovery
- *Default:* AccountRecovery.PHONE_WITHOUT_MFA_AND_EMAIL

How will a user be able to recover their account?

---

##### `advancedSecurityMode`<sup>Optional</sup> <a name="advancedSecurityMode" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.advancedSecurityMode"></a>

- *Type:* software.amazon.awscdk.services.cognito.AdvancedSecurityMode
- *Default:* no value

The user pool's Advanced Security Mode.

---

##### `autoVerify`<sup>Optional</sup> <a name="autoVerify" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.autoVerify"></a>

- *Type:* software.amazon.awscdk.services.cognito.AutoVerifiedAttrs
- *Default:* If `signInAlias` includes email and/or phone, they will be included in `autoVerifiedAttributes` by default. If absent, no attributes will be auto-verified.

Attributes which Cognito will look to verify automatically upon user sign up.

EMAIL and PHONE are the only available options.

---

##### `customAttributes`<sup>Optional</sup> <a name="customAttributes" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.customAttributes"></a>

- *Type:* java.util.Map<java.lang.String, software.amazon.awscdk.services.cognito.ICustomAttribute>
- *Default:* No custom attributes.

Define a set of custom attributes that can be configured for each user in the user pool.

---

##### `customSenderKmsKey`<sup>Optional</sup> <a name="customSenderKmsKey" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.customSenderKmsKey"></a>

- *Type:* software.amazon.awscdk.services.kms.IKey
- *Default:* no key ID configured

This key will be used to encrypt temporary passwords and authorization codes that Amazon Cognito generates.

> [https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-custom-sender-triggers.html](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-custom-sender-triggers.html)

---

##### `deletionProtection`<sup>Optional</sup> <a name="deletionProtection" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.deletionProtection"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Indicates whether the user pool should have deletion protection enabled.

---

##### `deviceTracking`<sup>Optional</sup> <a name="deviceTracking" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.deviceTracking"></a>

- *Type:* software.amazon.awscdk.services.cognito.DeviceTracking
- *Default:* see defaults on each property of DeviceTracking.

Device tracking settings.

---

##### `email`<sup>Optional</sup> <a name="email" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.email"></a>

- *Type:* software.amazon.awscdk.services.cognito.UserPoolEmail
- *Default:* cognito will use the default email configuration

Email settings for a user pool.

---

##### `enableSmsRole`<sup>Optional</sup> <a name="enableSmsRole" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.enableSmsRole"></a>

- *Type:* java.lang.Boolean
- *Default:* CDK will determine based on other properties of the user pool if an SMS role should be created or not.

Setting this would explicitly enable or disable SMS role creation.

When left unspecified, CDK will determine based on other properties if a role is needed or not.

---

##### `keepOriginal`<sup>Optional</sup> <a name="keepOriginal" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.keepOriginal"></a>

- *Type:* software.amazon.awscdk.services.cognito.KeepOriginalAttrs
- *Default:* Nothing is kept.

Attributes which Cognito will look to handle changes to the value of your users' email address and phone number attributes.

EMAIL and PHONE are the only available options.

---

##### `lambdaTriggers`<sup>Optional</sup> <a name="lambdaTriggers" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.lambdaTriggers"></a>

- *Type:* software.amazon.awscdk.services.cognito.UserPoolTriggers
- *Default:* No Lambda triggers.

Lambda functions to use for supported Cognito triggers.

> [https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html)

---

##### `mfa`<sup>Optional</sup> <a name="mfa" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.mfa"></a>

- *Type:* software.amazon.awscdk.services.cognito.Mfa
- *Default:* Mfa.OFF

Configure whether users of this user pool can or are required use MFA to sign in.

---

##### `mfaMessage`<sup>Optional</sup> <a name="mfaMessage" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.mfaMessage"></a>

- *Type:* java.lang.String
- *Default:* 'Your authentication code is {####}.'

The SMS message template sent during MFA verification.

Use '{####}' in the template where Cognito should insert the verification code.

---

##### `mfaSecondFactor`<sup>Optional</sup> <a name="mfaSecondFactor" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.mfaSecondFactor"></a>

- *Type:* software.amazon.awscdk.services.cognito.MfaSecondFactor
- *Default:* { sms: true, otp: false }, if `mfa` is set to `OPTIONAL` or `REQUIRED`. { sms: false, otp: false }, otherwise

Configure the MFA types that users can use in this user pool.

Ignored if `mfa` is set to `OFF`.

---

##### `passwordPolicy`<sup>Optional</sup> <a name="passwordPolicy" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.passwordPolicy"></a>

- *Type:* software.amazon.awscdk.services.cognito.PasswordPolicy
- *Default:* see defaults on each property of PasswordPolicy.

Password policy for this user pool.

---

##### `removalPolicy`<sup>Optional</sup> <a name="removalPolicy" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.removalPolicy"></a>

- *Type:* software.amazon.awscdk.RemovalPolicy
- *Default:* RemovalPolicy.RETAIN

Policy to apply when the user pool is removed from the stack.

---

##### `selfSignUpEnabled`<sup>Optional</sup> <a name="selfSignUpEnabled" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.selfSignUpEnabled"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Whether self sign up should be enabled.

This can be further configured via the `selfSignUp` property.

---

##### `signInAliases`<sup>Optional</sup> <a name="signInAliases" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.signInAliases"></a>

- *Type:* software.amazon.awscdk.services.cognito.SignInAliases
- *Default:* { username: true }

Methods in which a user registers or signs in to a user pool.

Allows either username with aliases OR sign in with email, phone, or both.

Read the sections on usernames and aliases to learn more -
https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html

To match with 'Option 1' in the above link, with a verified email, this property should be set to
`{ username: true, email: true }`. To match with 'Option 2' in the above link with both a verified email and phone
number, this property should be set to `{ email: true, phone: true }`.

---

##### `signInCaseSensitive`<sup>Optional</sup> <a name="signInCaseSensitive" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.signInCaseSensitive"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Whether sign-in aliases should be evaluated with case sensitivity.

For example, when this option is set to false, users will be able to sign in using either `MyUsername` or `myusername`.

---

##### `smsRole`<sup>Optional</sup> <a name="smsRole" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.smsRole"></a>

- *Type:* software.amazon.awscdk.services.iam.IRole
- *Default:* a new IAM role is created

The IAM role that Cognito will assume while sending SMS messages.

---

##### `smsRoleExternalId`<sup>Optional</sup> <a name="smsRoleExternalId" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.smsRoleExternalId"></a>

- *Type:* java.lang.String
- *Default:* No external id will be configured

The 'ExternalId' that Cognito service must be using when assuming the `smsRole`, if the role is restricted with an 'sts:ExternalId' conditional.

Learn more about ExternalId here - https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html

This property will be ignored if `smsRole` is not specified.

---

##### `snsRegion`<sup>Optional</sup> <a name="snsRegion" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.snsRegion"></a>

- *Type:* java.lang.String
- *Default:* The same region as the user pool, with a few exceptions - https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html#user-pool-sms-settings-first-time

The region to integrate with SNS to send SMS messages.

This property will do nothing if SMS configuration is not configured

---

##### `standardAttributes`<sup>Optional</sup> <a name="standardAttributes" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.standardAttributes"></a>

- *Type:* software.amazon.awscdk.services.cognito.StandardAttributes
- *Default:* All standard attributes are optional and mutable.

The set of attributes that are required for every user in the user pool.

Read more on attributes here - https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html

---

##### `userInvitation`<sup>Optional</sup> <a name="userInvitation" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.userInvitation"></a>

- *Type:* software.amazon.awscdk.services.cognito.UserInvitationConfig
- *Default:* see defaults in UserInvitationConfig

Configuration around admins signing up users into a user pool.

---

##### `userPoolName`<sup>Optional</sup> <a name="userPoolName" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.userPoolName"></a>

- *Type:* java.lang.String
- *Default:* automatically generated name by CloudFormation at deploy time

Name of the user pool.

---

##### `userVerification`<sup>Optional</sup> <a name="userVerification" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.userVerification"></a>

- *Type:* software.amazon.awscdk.services.cognito.UserVerificationConfig
- *Default:* see defaults in UserVerificationConfig

Configuration around users signing themselves up to the user pool.

Enable or disable self sign-up via the `selfSignUpEnabled` property.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.applyRemovalPolicy">applyRemovalPolicy</a></code> | Apply the given removal policy to this resource. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.addClient">addClient</a></code> | Add a new app client to this user pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.addDomain">addDomain</a></code> | Associate a domain to this user pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.addResourceServer">addResourceServer</a></code> | Add a new resource server to this user pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.addTrigger">addTrigger</a></code> | Add a lambda trigger to a user pool operation. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.grant">grant</a></code> | Adds an IAM policy statement associated with this user pool to an IAM principal's policy. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.registerIdentityProvider">registerIdentityProvider</a></code> | Register an identity provider with this user pool. |

---

##### `toString` <a name="toString" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.toString"></a>

```java
public java.lang.String toString()
```

Returns a string representation of this construct.

##### `applyRemovalPolicy` <a name="applyRemovalPolicy" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.applyRemovalPolicy"></a>

```java
public void applyRemovalPolicy(RemovalPolicy policy)
```

Apply the given removal policy to this resource.

The Removal Policy controls what happens to this resource when it stops
being managed by CloudFormation, either because you've removed it from the
CDK application or because you've made a change that requires the resource
to be replaced.

The resource can be deleted (`RemovalPolicy.DESTROY`), or left in your AWS
account for data recovery and cleanup later (`RemovalPolicy.RETAIN`).

###### `policy`<sup>Required</sup> <a name="policy" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.applyRemovalPolicy.parameter.policy"></a>

- *Type:* software.amazon.awscdk.RemovalPolicy

---

##### `addClient` <a name="addClient" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.addClient"></a>

```java
public UserPoolClient addClient(java.lang.String id)
public UserPoolClient addClient(java.lang.String id, UserPoolClientOptions options)
```

Add a new app client to this user pool.

###### `id`<sup>Required</sup> <a name="id" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.addClient.parameter.id"></a>

- *Type:* java.lang.String

---

###### `options`<sup>Optional</sup> <a name="options" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.addClient.parameter.options"></a>

- *Type:* software.amazon.awscdk.services.cognito.UserPoolClientOptions

---

##### `addDomain` <a name="addDomain" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.addDomain"></a>

```java
public UserPoolDomain addDomain(java.lang.String id, UserPoolDomainOptions options)
```

Associate a domain to this user pool.

###### `id`<sup>Required</sup> <a name="id" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.addDomain.parameter.id"></a>

- *Type:* java.lang.String

---

###### `options`<sup>Required</sup> <a name="options" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.addDomain.parameter.options"></a>

- *Type:* software.amazon.awscdk.services.cognito.UserPoolDomainOptions

---

##### `addResourceServer` <a name="addResourceServer" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.addResourceServer"></a>

```java
public UserPoolResourceServer addResourceServer(java.lang.String id, UserPoolResourceServerOptions options)
```

Add a new resource server to this user pool.

###### `id`<sup>Required</sup> <a name="id" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.addResourceServer.parameter.id"></a>

- *Type:* java.lang.String

---

###### `options`<sup>Required</sup> <a name="options" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.addResourceServer.parameter.options"></a>

- *Type:* software.amazon.awscdk.services.cognito.UserPoolResourceServerOptions

---

##### `addTrigger` <a name="addTrigger" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.addTrigger"></a>

```java
public void addTrigger(UserPoolOperation operation, IFunction fn)
```

Add a lambda trigger to a user pool operation.

> [https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html)

###### `operation`<sup>Required</sup> <a name="operation" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.addTrigger.parameter.operation"></a>

- *Type:* software.amazon.awscdk.services.cognito.UserPoolOperation

---

###### `fn`<sup>Required</sup> <a name="fn" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.addTrigger.parameter.fn"></a>

- *Type:* software.amazon.awscdk.services.lambda.IFunction

---

##### `grant` <a name="grant" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.grant"></a>

```java
public Grant grant(IGrantable grantee, java.lang.String actions)
```

Adds an IAM policy statement associated with this user pool to an IAM principal's policy.

###### `grantee`<sup>Required</sup> <a name="grantee" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.grant.parameter.grantee"></a>

- *Type:* software.amazon.awscdk.services.iam.IGrantable

---

###### `actions`<sup>Required</sup> <a name="actions" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.grant.parameter.actions"></a>

- *Type:* java.lang.String

---

##### `registerIdentityProvider` <a name="registerIdentityProvider" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.registerIdentityProvider"></a>

```java
public void registerIdentityProvider(IUserPoolIdentityProvider provider)
```

Register an identity provider with this user pool.

###### `provider`<sup>Required</sup> <a name="provider" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.registerIdentityProvider.parameter.provider"></a>

- *Type:* software.amazon.awscdk.services.cognito.IUserPoolIdentityProvider

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.isOwnedResource">isOwnedResource</a></code> | Returns true if the construct was created by CDK, and false otherwise. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.isResource">isResource</a></code> | Check whether the given construct is a Resource. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.fromUserPoolArn">fromUserPoolArn</a></code> | Import an existing user pool based on its ARN. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.fromUserPoolId">fromUserPoolId</a></code> | Import an existing user pool based on its id. |

---

##### `isConstruct` <a name="isConstruct" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.isConstruct"></a>

```java
import software.aws.awsprototypingsdk.identity.UserPoolWithMfa;

UserPoolWithMfa.isConstruct(java.lang.Object x)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.isConstruct.parameter.x"></a>

- *Type:* java.lang.Object

Any object.

---

##### `isOwnedResource` <a name="isOwnedResource" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.isOwnedResource"></a>

```java
import software.aws.awsprototypingsdk.identity.UserPoolWithMfa;

UserPoolWithMfa.isOwnedResource(IConstruct construct)
```

Returns true if the construct was created by CDK, and false otherwise.

###### `construct`<sup>Required</sup> <a name="construct" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.isOwnedResource.parameter.construct"></a>

- *Type:* software.constructs.IConstruct

---

##### `isResource` <a name="isResource" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.isResource"></a>

```java
import software.aws.awsprototypingsdk.identity.UserPoolWithMfa;

UserPoolWithMfa.isResource(IConstruct construct)
```

Check whether the given construct is a Resource.

###### `construct`<sup>Required</sup> <a name="construct" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.isResource.parameter.construct"></a>

- *Type:* software.constructs.IConstruct

---

##### `fromUserPoolArn` <a name="fromUserPoolArn" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.fromUserPoolArn"></a>

```java
import software.aws.awsprototypingsdk.identity.UserPoolWithMfa;

UserPoolWithMfa.fromUserPoolArn(Construct scope, java.lang.String id, java.lang.String userPoolArn)
```

Import an existing user pool based on its ARN.

###### `scope`<sup>Required</sup> <a name="scope" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.fromUserPoolArn.parameter.scope"></a>

- *Type:* software.constructs.Construct

---

###### `id`<sup>Required</sup> <a name="id" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.fromUserPoolArn.parameter.id"></a>

- *Type:* java.lang.String

---

###### `userPoolArn`<sup>Required</sup> <a name="userPoolArn" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.fromUserPoolArn.parameter.userPoolArn"></a>

- *Type:* java.lang.String

---

##### `fromUserPoolId` <a name="fromUserPoolId" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.fromUserPoolId"></a>

```java
import software.aws.awsprototypingsdk.identity.UserPoolWithMfa;

UserPoolWithMfa.fromUserPoolId(Construct scope, java.lang.String id, java.lang.String userPoolId)
```

Import an existing user pool based on its id.

###### `scope`<sup>Required</sup> <a name="scope" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.fromUserPoolId.parameter.scope"></a>

- *Type:* software.constructs.Construct

---

###### `id`<sup>Required</sup> <a name="id" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.fromUserPoolId.parameter.id"></a>

- *Type:* java.lang.String

---

###### `userPoolId`<sup>Required</sup> <a name="userPoolId" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.fromUserPoolId.parameter.userPoolId"></a>

- *Type:* java.lang.String

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.property.node">node</a></code> | <code>software.constructs.Node</code> | The tree node. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.property.env">env</a></code> | <code>software.amazon.awscdk.ResourceEnvironment</code> | The environment this resource belongs to. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.property.stack">stack</a></code> | <code>software.amazon.awscdk.Stack</code> | The stack in which this resource is defined. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.property.identityProviders">identityProviders</a></code> | <code>java.util.List<software.amazon.awscdk.services.cognito.IUserPoolIdentityProvider></code> | Get all identity providers registered with this user pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.property.userPoolArn">userPoolArn</a></code> | <code>java.lang.String</code> | The ARN of the user pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.property.userPoolId">userPoolId</a></code> | <code>java.lang.String</code> | The physical ID of this user pool resource. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.property.userPoolProviderName">userPoolProviderName</a></code> | <code>java.lang.String</code> | User pool provider name. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.property.userPoolProviderUrl">userPoolProviderUrl</a></code> | <code>java.lang.String</code> | User pool provider URL. |

---

##### `node`<sup>Required</sup> <a name="node" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.property.node"></a>

```java
public Node getNode();
```

- *Type:* software.constructs.Node

The tree node.

---

##### `env`<sup>Required</sup> <a name="env" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.property.env"></a>

```java
public ResourceEnvironment getEnv();
```

- *Type:* software.amazon.awscdk.ResourceEnvironment

The environment this resource belongs to.

For resources that are created and managed by the CDK
(generally, those created by creating new class instances like Role, Bucket, etc.),
this is always the same as the environment of the stack they belong to;
however, for imported resources
(those obtained from static methods like fromRoleArn, fromBucketName, etc.),
that might be different than the stack they were imported into.

---

##### `stack`<sup>Required</sup> <a name="stack" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.property.stack"></a>

```java
public Stack getStack();
```

- *Type:* software.amazon.awscdk.Stack

The stack in which this resource is defined.

---

##### `identityProviders`<sup>Required</sup> <a name="identityProviders" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.property.identityProviders"></a>

```java
public java.util.List<IUserPoolIdentityProvider> getIdentityProviders();
```

- *Type:* java.util.List<software.amazon.awscdk.services.cognito.IUserPoolIdentityProvider>

Get all identity providers registered with this user pool.

---

##### `userPoolArn`<sup>Required</sup> <a name="userPoolArn" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.property.userPoolArn"></a>

```java
public java.lang.String getUserPoolArn();
```

- *Type:* java.lang.String

The ARN of the user pool.

---

##### `userPoolId`<sup>Required</sup> <a name="userPoolId" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.property.userPoolId"></a>

```java
public java.lang.String getUserPoolId();
```

- *Type:* java.lang.String

The physical ID of this user pool resource.

---

##### `userPoolProviderName`<sup>Required</sup> <a name="userPoolProviderName" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.property.userPoolProviderName"></a>

```java
public java.lang.String getUserPoolProviderName();
```

- *Type:* java.lang.String

User pool provider name.

---

##### `userPoolProviderUrl`<sup>Required</sup> <a name="userPoolProviderUrl" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.property.userPoolProviderUrl"></a>

```java
public java.lang.String getUserPoolProviderUrl();
```

- *Type:* java.lang.String

User pool provider URL.

---


## Structs <a name="Structs" id="Structs"></a>

### UserIdentityProps <a name="UserIdentityProps" id="@aws-prototyping-sdk/identity.UserIdentityProps"></a>

Properties which configures the Identity Pool.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/identity.UserIdentityProps.Initializer"></a>

```java
import software.aws.awsprototypingsdk.identity.UserIdentityProps;

UserIdentityProps.builder()
//  .identityPoolOptions(IdentityPoolProps)
//  .userPool(UserPool)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentityProps.property.identityPoolOptions">identityPoolOptions</a></code> | <code>software.amazon.awscdk.services.cognito.identitypool.alpha.IdentityPoolProps</code> | Configuration for the Identity Pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentityProps.property.userPool">userPool</a></code> | <code>software.amazon.awscdk.services.cognito.UserPool</code> | User provided Cognito UserPool. |

---

##### `identityPoolOptions`<sup>Optional</sup> <a name="identityPoolOptions" id="@aws-prototyping-sdk/identity.UserIdentityProps.property.identityPoolOptions"></a>

```java
public IdentityPoolProps getIdentityPoolOptions();
```

- *Type:* software.amazon.awscdk.services.cognito.identitypool.alpha.IdentityPoolProps

Configuration for the Identity Pool.

---

##### `userPool`<sup>Optional</sup> <a name="userPool" id="@aws-prototyping-sdk/identity.UserIdentityProps.property.userPool"></a>

```java
public UserPool getUserPool();
```

- *Type:* software.amazon.awscdk.services.cognito.UserPool
- *Default:* a userpool with mfa will be created.

User provided Cognito UserPool.

---

### UserPoolWithMfaProps <a name="UserPoolWithMfaProps" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps"></a>

UserPoolWithMfa props.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.Initializer"></a>

```java
import software.aws.awsprototypingsdk.identity.UserPoolWithMfaProps;

UserPoolWithMfaProps.builder()
//  .accountRecovery(AccountRecovery)
//  .advancedSecurityMode(AdvancedSecurityMode)
//  .autoVerify(AutoVerifiedAttrs)
//  .customAttributes(java.util.Map<java.lang.String, ICustomAttribute>)
//  .customSenderKmsKey(IKey)
//  .deletionProtection(java.lang.Boolean)
//  .deviceTracking(DeviceTracking)
//  .email(UserPoolEmail)
//  .enableSmsRole(java.lang.Boolean)
//  .keepOriginal(KeepOriginalAttrs)
//  .lambdaTriggers(UserPoolTriggers)
//  .mfa(Mfa)
//  .mfaMessage(java.lang.String)
//  .mfaSecondFactor(MfaSecondFactor)
//  .passwordPolicy(PasswordPolicy)
//  .removalPolicy(RemovalPolicy)
//  .selfSignUpEnabled(java.lang.Boolean)
//  .signInAliases(SignInAliases)
//  .signInCaseSensitive(java.lang.Boolean)
//  .smsRole(IRole)
//  .smsRoleExternalId(java.lang.String)
//  .snsRegion(java.lang.String)
//  .standardAttributes(StandardAttributes)
//  .userInvitation(UserInvitationConfig)
//  .userPoolName(java.lang.String)
//  .userVerification(UserVerificationConfig)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.accountRecovery">accountRecovery</a></code> | <code>software.amazon.awscdk.services.cognito.AccountRecovery</code> | How will a user be able to recover their account? |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.advancedSecurityMode">advancedSecurityMode</a></code> | <code>software.amazon.awscdk.services.cognito.AdvancedSecurityMode</code> | The user pool's Advanced Security Mode. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.autoVerify">autoVerify</a></code> | <code>software.amazon.awscdk.services.cognito.AutoVerifiedAttrs</code> | Attributes which Cognito will look to verify automatically upon user sign up. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.customAttributes">customAttributes</a></code> | <code>java.util.Map<java.lang.String, software.amazon.awscdk.services.cognito.ICustomAttribute></code> | Define a set of custom attributes that can be configured for each user in the user pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.customSenderKmsKey">customSenderKmsKey</a></code> | <code>software.amazon.awscdk.services.kms.IKey</code> | This key will be used to encrypt temporary passwords and authorization codes that Amazon Cognito generates. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.deletionProtection">deletionProtection</a></code> | <code>java.lang.Boolean</code> | Indicates whether the user pool should have deletion protection enabled. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.deviceTracking">deviceTracking</a></code> | <code>software.amazon.awscdk.services.cognito.DeviceTracking</code> | Device tracking settings. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.email">email</a></code> | <code>software.amazon.awscdk.services.cognito.UserPoolEmail</code> | Email settings for a user pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.enableSmsRole">enableSmsRole</a></code> | <code>java.lang.Boolean</code> | Setting this would explicitly enable or disable SMS role creation. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.keepOriginal">keepOriginal</a></code> | <code>software.amazon.awscdk.services.cognito.KeepOriginalAttrs</code> | Attributes which Cognito will look to handle changes to the value of your users' email address and phone number attributes. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.lambdaTriggers">lambdaTriggers</a></code> | <code>software.amazon.awscdk.services.cognito.UserPoolTriggers</code> | Lambda functions to use for supported Cognito triggers. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.mfa">mfa</a></code> | <code>software.amazon.awscdk.services.cognito.Mfa</code> | Configure whether users of this user pool can or are required use MFA to sign in. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.mfaMessage">mfaMessage</a></code> | <code>java.lang.String</code> | The SMS message template sent during MFA verification. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.mfaSecondFactor">mfaSecondFactor</a></code> | <code>software.amazon.awscdk.services.cognito.MfaSecondFactor</code> | Configure the MFA types that users can use in this user pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.passwordPolicy">passwordPolicy</a></code> | <code>software.amazon.awscdk.services.cognito.PasswordPolicy</code> | Password policy for this user pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.removalPolicy">removalPolicy</a></code> | <code>software.amazon.awscdk.RemovalPolicy</code> | Policy to apply when the user pool is removed from the stack. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.selfSignUpEnabled">selfSignUpEnabled</a></code> | <code>java.lang.Boolean</code> | Whether self sign up should be enabled. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.signInAliases">signInAliases</a></code> | <code>software.amazon.awscdk.services.cognito.SignInAliases</code> | Methods in which a user registers or signs in to a user pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.signInCaseSensitive">signInCaseSensitive</a></code> | <code>java.lang.Boolean</code> | Whether sign-in aliases should be evaluated with case sensitivity. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.smsRole">smsRole</a></code> | <code>software.amazon.awscdk.services.iam.IRole</code> | The IAM role that Cognito will assume while sending SMS messages. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.smsRoleExternalId">smsRoleExternalId</a></code> | <code>java.lang.String</code> | The 'ExternalId' that Cognito service must be using when assuming the `smsRole`, if the role is restricted with an 'sts:ExternalId' conditional. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.snsRegion">snsRegion</a></code> | <code>java.lang.String</code> | The region to integrate with SNS to send SMS messages. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.standardAttributes">standardAttributes</a></code> | <code>software.amazon.awscdk.services.cognito.StandardAttributes</code> | The set of attributes that are required for every user in the user pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.userInvitation">userInvitation</a></code> | <code>software.amazon.awscdk.services.cognito.UserInvitationConfig</code> | Configuration around admins signing up users into a user pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.userPoolName">userPoolName</a></code> | <code>java.lang.String</code> | Name of the user pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.userVerification">userVerification</a></code> | <code>software.amazon.awscdk.services.cognito.UserVerificationConfig</code> | Configuration around users signing themselves up to the user pool. |

---

##### `accountRecovery`<sup>Optional</sup> <a name="accountRecovery" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.accountRecovery"></a>

```java
public AccountRecovery getAccountRecovery();
```

- *Type:* software.amazon.awscdk.services.cognito.AccountRecovery
- *Default:* AccountRecovery.PHONE_WITHOUT_MFA_AND_EMAIL

How will a user be able to recover their account?

---

##### `advancedSecurityMode`<sup>Optional</sup> <a name="advancedSecurityMode" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.advancedSecurityMode"></a>

```java
public AdvancedSecurityMode getAdvancedSecurityMode();
```

- *Type:* software.amazon.awscdk.services.cognito.AdvancedSecurityMode
- *Default:* no value

The user pool's Advanced Security Mode.

---

##### `autoVerify`<sup>Optional</sup> <a name="autoVerify" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.autoVerify"></a>

```java
public AutoVerifiedAttrs getAutoVerify();
```

- *Type:* software.amazon.awscdk.services.cognito.AutoVerifiedAttrs
- *Default:* If `signInAlias` includes email and/or phone, they will be included in `autoVerifiedAttributes` by default. If absent, no attributes will be auto-verified.

Attributes which Cognito will look to verify automatically upon user sign up.

EMAIL and PHONE are the only available options.

---

##### `customAttributes`<sup>Optional</sup> <a name="customAttributes" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.customAttributes"></a>

```java
public java.util.Map<java.lang.String, ICustomAttribute> getCustomAttributes();
```

- *Type:* java.util.Map<java.lang.String, software.amazon.awscdk.services.cognito.ICustomAttribute>
- *Default:* No custom attributes.

Define a set of custom attributes that can be configured for each user in the user pool.

---

##### `customSenderKmsKey`<sup>Optional</sup> <a name="customSenderKmsKey" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.customSenderKmsKey"></a>

```java
public IKey getCustomSenderKmsKey();
```

- *Type:* software.amazon.awscdk.services.kms.IKey
- *Default:* no key ID configured

This key will be used to encrypt temporary passwords and authorization codes that Amazon Cognito generates.

> [https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-custom-sender-triggers.html](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-custom-sender-triggers.html)

---

##### `deletionProtection`<sup>Optional</sup> <a name="deletionProtection" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.deletionProtection"></a>

```java
public java.lang.Boolean getDeletionProtection();
```

- *Type:* java.lang.Boolean
- *Default:* false

Indicates whether the user pool should have deletion protection enabled.

---

##### `deviceTracking`<sup>Optional</sup> <a name="deviceTracking" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.deviceTracking"></a>

```java
public DeviceTracking getDeviceTracking();
```

- *Type:* software.amazon.awscdk.services.cognito.DeviceTracking
- *Default:* see defaults on each property of DeviceTracking.

Device tracking settings.

---

##### `email`<sup>Optional</sup> <a name="email" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.email"></a>

```java
public UserPoolEmail getEmail();
```

- *Type:* software.amazon.awscdk.services.cognito.UserPoolEmail
- *Default:* cognito will use the default email configuration

Email settings for a user pool.

---

##### `enableSmsRole`<sup>Optional</sup> <a name="enableSmsRole" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.enableSmsRole"></a>

```java
public java.lang.Boolean getEnableSmsRole();
```

- *Type:* java.lang.Boolean
- *Default:* CDK will determine based on other properties of the user pool if an SMS role should be created or not.

Setting this would explicitly enable or disable SMS role creation.

When left unspecified, CDK will determine based on other properties if a role is needed or not.

---

##### `keepOriginal`<sup>Optional</sup> <a name="keepOriginal" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.keepOriginal"></a>

```java
public KeepOriginalAttrs getKeepOriginal();
```

- *Type:* software.amazon.awscdk.services.cognito.KeepOriginalAttrs
- *Default:* Nothing is kept.

Attributes which Cognito will look to handle changes to the value of your users' email address and phone number attributes.

EMAIL and PHONE are the only available options.

---

##### `lambdaTriggers`<sup>Optional</sup> <a name="lambdaTriggers" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.lambdaTriggers"></a>

```java
public UserPoolTriggers getLambdaTriggers();
```

- *Type:* software.amazon.awscdk.services.cognito.UserPoolTriggers
- *Default:* No Lambda triggers.

Lambda functions to use for supported Cognito triggers.

> [https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html)

---

##### `mfa`<sup>Optional</sup> <a name="mfa" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.mfa"></a>

```java
public Mfa getMfa();
```

- *Type:* software.amazon.awscdk.services.cognito.Mfa
- *Default:* Mfa.OFF

Configure whether users of this user pool can or are required use MFA to sign in.

---

##### `mfaMessage`<sup>Optional</sup> <a name="mfaMessage" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.mfaMessage"></a>

```java
public java.lang.String getMfaMessage();
```

- *Type:* java.lang.String
- *Default:* 'Your authentication code is {####}.'

The SMS message template sent during MFA verification.

Use '{####}' in the template where Cognito should insert the verification code.

---

##### `mfaSecondFactor`<sup>Optional</sup> <a name="mfaSecondFactor" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.mfaSecondFactor"></a>

```java
public MfaSecondFactor getMfaSecondFactor();
```

- *Type:* software.amazon.awscdk.services.cognito.MfaSecondFactor
- *Default:* { sms: true, otp: false }, if `mfa` is set to `OPTIONAL` or `REQUIRED`. { sms: false, otp: false }, otherwise

Configure the MFA types that users can use in this user pool.

Ignored if `mfa` is set to `OFF`.

---

##### `passwordPolicy`<sup>Optional</sup> <a name="passwordPolicy" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.passwordPolicy"></a>

```java
public PasswordPolicy getPasswordPolicy();
```

- *Type:* software.amazon.awscdk.services.cognito.PasswordPolicy
- *Default:* see defaults on each property of PasswordPolicy.

Password policy for this user pool.

---

##### `removalPolicy`<sup>Optional</sup> <a name="removalPolicy" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.removalPolicy"></a>

```java
public RemovalPolicy getRemovalPolicy();
```

- *Type:* software.amazon.awscdk.RemovalPolicy
- *Default:* RemovalPolicy.RETAIN

Policy to apply when the user pool is removed from the stack.

---

##### `selfSignUpEnabled`<sup>Optional</sup> <a name="selfSignUpEnabled" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.selfSignUpEnabled"></a>

```java
public java.lang.Boolean getSelfSignUpEnabled();
```

- *Type:* java.lang.Boolean
- *Default:* false

Whether self sign up should be enabled.

This can be further configured via the `selfSignUp` property.

---

##### `signInAliases`<sup>Optional</sup> <a name="signInAliases" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.signInAliases"></a>

```java
public SignInAliases getSignInAliases();
```

- *Type:* software.amazon.awscdk.services.cognito.SignInAliases
- *Default:* { username: true }

Methods in which a user registers or signs in to a user pool.

Allows either username with aliases OR sign in with email, phone, or both.

Read the sections on usernames and aliases to learn more -
https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html

To match with 'Option 1' in the above link, with a verified email, this property should be set to
`{ username: true, email: true }`. To match with 'Option 2' in the above link with both a verified email and phone
number, this property should be set to `{ email: true, phone: true }`.

---

##### `signInCaseSensitive`<sup>Optional</sup> <a name="signInCaseSensitive" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.signInCaseSensitive"></a>

```java
public java.lang.Boolean getSignInCaseSensitive();
```

- *Type:* java.lang.Boolean
- *Default:* true

Whether sign-in aliases should be evaluated with case sensitivity.

For example, when this option is set to false, users will be able to sign in using either `MyUsername` or `myusername`.

---

##### `smsRole`<sup>Optional</sup> <a name="smsRole" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.smsRole"></a>

```java
public IRole getSmsRole();
```

- *Type:* software.amazon.awscdk.services.iam.IRole
- *Default:* a new IAM role is created

The IAM role that Cognito will assume while sending SMS messages.

---

##### `smsRoleExternalId`<sup>Optional</sup> <a name="smsRoleExternalId" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.smsRoleExternalId"></a>

```java
public java.lang.String getSmsRoleExternalId();
```

- *Type:* java.lang.String
- *Default:* No external id will be configured

The 'ExternalId' that Cognito service must be using when assuming the `smsRole`, if the role is restricted with an 'sts:ExternalId' conditional.

Learn more about ExternalId here - https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html

This property will be ignored if `smsRole` is not specified.

---

##### `snsRegion`<sup>Optional</sup> <a name="snsRegion" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.snsRegion"></a>

```java
public java.lang.String getSnsRegion();
```

- *Type:* java.lang.String
- *Default:* The same region as the user pool, with a few exceptions - https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html#user-pool-sms-settings-first-time

The region to integrate with SNS to send SMS messages.

This property will do nothing if SMS configuration is not configured

---

##### `standardAttributes`<sup>Optional</sup> <a name="standardAttributes" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.standardAttributes"></a>

```java
public StandardAttributes getStandardAttributes();
```

- *Type:* software.amazon.awscdk.services.cognito.StandardAttributes
- *Default:* All standard attributes are optional and mutable.

The set of attributes that are required for every user in the user pool.

Read more on attributes here - https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html

---

##### `userInvitation`<sup>Optional</sup> <a name="userInvitation" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.userInvitation"></a>

```java
public UserInvitationConfig getUserInvitation();
```

- *Type:* software.amazon.awscdk.services.cognito.UserInvitationConfig
- *Default:* see defaults in UserInvitationConfig

Configuration around admins signing up users into a user pool.

---

##### `userPoolName`<sup>Optional</sup> <a name="userPoolName" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.userPoolName"></a>

```java
public java.lang.String getUserPoolName();
```

- *Type:* java.lang.String
- *Default:* automatically generated name by CloudFormation at deploy time

Name of the user pool.

---

##### `userVerification`<sup>Optional</sup> <a name="userVerification" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.userVerification"></a>

```java
public UserVerificationConfig getUserVerification();
```

- *Type:* software.amazon.awscdk.services.cognito.UserVerificationConfig
- *Default:* see defaults in UserVerificationConfig

Configuration around users signing themselves up to the user pool.

Enable or disable self sign-up via the `selfSignUpEnabled` property.

---



