"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserPoolWithMfa = exports.USE_LEGACY_MFA_PROPS_CONTEXT_KEY = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const pdk_nag_1 = require("@aws-prototyping-sdk/pdk-nag");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_cognito_1 = require("aws-cdk-lib/aws-cognito");
/**
 * Boolean context to indicate whether legacy MFA props should be used.
 *
 * @deprecated
 */
exports.USE_LEGACY_MFA_PROPS_CONTEXT_KEY = "@aws-prototyping-sdk/identity:useLegacyMFAProps";
/**
 * Legacy Userpool Props which configures MFA for SMS only.
 */
const LEGACY_DEFAULT_PROPS = {
    deletionProtection: true,
    passwordPolicy: {
        minLength: 8,
        requireLowercase: true,
        requireUppercase: true,
        requireDigits: true,
        requireSymbols: true,
        tempPasswordValidity: aws_cdk_lib_1.Duration.days(3),
    },
    advancedSecurityMode: aws_cognito_1.AdvancedSecurityMode.ENFORCED,
    mfa: aws_cognito_1.Mfa.REQUIRED,
    accountRecovery: aws_cognito_1.AccountRecovery.EMAIL_ONLY,
    autoVerify: {
        email: true,
    },
};
/**
 * Userpool default props which configure MFA across SMS/TOTP.
 */
const DEFAULT_PROPS = {
    deletionProtection: true,
    passwordPolicy: {
        minLength: 8,
        requireLowercase: true,
        requireUppercase: true,
        requireDigits: true,
        requireSymbols: true,
        tempPasswordValidity: aws_cdk_lib_1.Duration.days(3),
    },
    mfa: aws_cognito_1.Mfa.REQUIRED,
    mfaSecondFactor: { sms: true, otp: true },
    signInCaseSensitive: false,
    advancedSecurityMode: aws_cognito_1.AdvancedSecurityMode.ENFORCED,
    signInAliases: { username: true, email: true },
    accountRecovery: aws_cognito_1.AccountRecovery.EMAIL_ONLY,
    selfSignUpEnabled: false,
    standardAttributes: {
        phoneNumber: { required: false },
        email: { required: true },
        givenName: { required: true },
        familyName: { required: true },
    },
    autoVerify: {
        email: true,
        phone: true,
    },
    keepOriginal: {
        email: true,
        phone: true,
    },
};
/**
 * Configures a UserPool with MFA across SMS/TOTP using sane defaults.
 */
class UserPoolWithMfa extends aws_cognito_1.UserPool {
    constructor(scope, id, props) {
        super(scope, id, {
            ...(shouldUseLegacyProps(scope) ? LEGACY_DEFAULT_PROPS : DEFAULT_PROPS),
            ...props,
        });
        const stack = aws_cdk_lib_1.Stack.of(this);
        ["AwsSolutions-IAM5", "AwsPrototyping-IAMNoWildcardPermissions"].forEach((RuleId) => {
            pdk_nag_1.PDKNag.addResourceSuppressionsByPathNoThrow(stack, `${pdk_nag_1.PDKNag.getStackPrefix(stack)}${id}/UserPool/smsRole/Resource`, [
                {
                    id: RuleId,
                    reason: "MFA requires sending a text to a users phone number which cannot be known at deployment time.",
                    appliesTo: ["Resource::*"],
                },
            ]);
        });
    }
}
_a = JSII_RTTI_SYMBOL_1;
UserPoolWithMfa[_a] = { fqn: "@aws-prototyping-sdk/identity.UserPoolWithMfa", version: "0.18.18" };
exports.UserPoolWithMfa = UserPoolWithMfa;
/**
 * Determines if legacy props should be used by looking at the control flag in cdk context.
 *
 * @param scope construct scope.
 */
const shouldUseLegacyProps = (scope) => scope.node.tryGetContext(exports.USE_LEGACY_MFA_PROPS_CONTEXT_KEY);
//# sourceMappingURL=data:application/json;base64,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