# Copyright 2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License").
# You may not use this file except in compliance with the License.
# A copy of the License is located at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# or in the "license" file accompanying this file. This file is distributed
# on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
# express or implied. See the License for the specific language governing
# permissions and limitations under the License.

from mxnet import nd


def load_gp_params():
    return nd.array(
        [
            [412263.3050, 8.0703, 57.3620],
            [387.5274, 5.0673, 4.2793],
            [41625.4972, 6.7450, 9.5796],
            [2639.2794, 3.6458, 5.1566],
            [4423.1468, 6.0896, 5.1452],
            [19065.0601, 4.2969, 13.6918],
            [28449.8824, 4.7820, 10.6377],
            [300837.0179, 6.8132, 41.2674],
            [1374.7983, 4.3378, 4.0292],
            [5304.0383, 6.1224, 1.1865],
        ]
    ).expand_dims(axis=2)


def load_exact_mean():
    return nd.array(
        [
            [
                329.91,
                318.8,
                326.58,
                352.84,
                395.77,
                452.58,
                519.87,
                594.14,
                672.03,
                750.42,
                826.4,
                897.05,
                959.22,
                1009.3,
                1043.4,
                1057.1,
                1046.3,
                1007.4,
                938.3,
                838.59,
                710.16,
                557.29,
                386.44,
                370.18,
                341.38,
                330.33,
                338.16,
                364.32,
                406.87,
                462.85,
                528.8,
                601.17,
                676.64,
                752.21,
                825.11,
                892.63,
                951.82,
                999.28,
                1031.1,
                1043.2,
                1031.2,
                991.72,
                922.39,
                822.75,
                694.55,
                541.99,
                371.45,
                376.02,
                347.33,
                336.44,
                344.41,
                370.61,
                412.98,
                468.49,
                533.61,
                604.78,
                678.67,
                752.35,
                823.15,
                888.47,
                945.49,
                990.94,
                1021.1,
                1031.7,
                1018.8,
                978.69,
                909.16,
                809.66,
                681.91,
                529.99,
                360.27,
                377.02,
                348.76,
                338.32,
                346.72,
                373.3,
                415.97,
                471.67,
                536.82,
                607.84,
                681.37,
                754.49,
                824.52,
                888.89,
                944.83,
                989.13,
                1018.1,
                1027.7,
                1013.8,
                973.03,
                903.11,
                803.53,
                676.04,
                524.73,
                355.89,
                374.28,
                346.91,
                337.34,
                346.63,
                374.14,
                417.81,
                474.57,
                540.85,
                613.01,
                687.65,
                761.74,
                832.55,
                897.41,
                953.51,
                997.61,
                1026,
                1034.8,
                1020.1,
                978.36,
                907.64,
                807.53,
                679.87,
                528.79,
                360.61,
                368.96,
                343.04,
                334.91,
                345.67,
                374.79,
                420.26,
                479.07,
                547.66,
                622.33,
                699.59,
                776.26,
                849.41,
                916.22,
                973.7,
                1018.5,
                1047.1,
                1055.3,
                1039.6,
                996.64,
                924.63,
                823.41,
                694.98,
                543.61,
                375.65,
                362.13,
                338.31,
                332.23,
                345.12,
                376.54,
                424.62,
                486.44,
                558.45,
                636.92,
                718.19,
                798.86,
                875.77,
                945.81,
                1005.8,
                1052.2,
                1081.3,
                1089.2,
                1072.4,
                1027.9,
                954.1,
                851.17,
                721.38,
                569.17,
                400.96,
                358.65,
            ],
            [
                26.239,
                26.612,
                26.31,
                25.441,
                24.318,
                23.394,
                23.112,
                23.72,
                25.148,
                27.001,
                28.699,
                29.716,
                29.81,
                29.155,
                28.283,
                27.875,
                28.464,
                30.184,
                32.67,
                35.15,
                36.697,
                36.53,
                34.26,
                26.079,
                26.356,
                26.123,
                25.377,
                24.269,
                23.133,
                22.412,
                22.513,
                23.625,
                25.603,
                27.972,
                30.08,
                31.355,
                31.549,
                30.869,
                29.916,
                29.444,
                30.048,
                31.882,
                34.561,
                37.256,
                38.964,
                38.84,
                36.463,
                27.34,
                27.022,
                26.272,
                25.145,
                23.828,
                22.661,
                22.071,
                22.427,
                23.876,
                26.22,
                28.935,
                31.326,
                32.793,
                33.079,
                32.405,
                31.404,
                30.873,
                31.438,
                33.276,
                35.992,
                38.735,
                40.468,
                40.314,
                37.834,
                28.936,
                28.179,
                27.044,
                25.629,
                24.14,
                22.91,
                22.342,
                22.777,
                24.33,
                26.785,
                29.604,
                32.084,
                33.617,
                33.942,
                33.274,
                32.242,
                31.649,
                32.13,
                33.871,
                36.492,
                39.148,
                40.809,
                40.599,
                38.075,
                30.565,
                29.545,
                28.174,
                26.574,
                24.953,
                23.624,
                22.961,
                23.278,
                24.681,
                26.963,
                29.608,
                31.943,
                33.377,
                33.648,
                32.951,
                31.886,
                31.224,
                31.584,
                33.16,
                35.596,
                38.088,
                39.641,
                39.41,
                36.961,
                31.817,
                30.693,
                29.225,
                27.539,
                25.826,
                24.371,
                23.51,
                23.538,
                24.562,
                26.408,
                28.617,
                30.572,
                31.727,
                31.828,
                31.044,
                29.925,
                29.185,
                29.41,
                30.789,
                33.006,
                35.314,
                36.788,
                36.628,
                34.415,
                32.283,
                31.18,
                29.725,
                28.034,
                26.271,
                24.68,
                23.561,
                23.184,
                23.667,
                24.883,
                26.449,
                27.832,
                28.549,
                28.369,
                27.435,
                26.235,
                25.413,
                25.505,
                26.693,
                28.702,
                30.862,
                32.327,
                32.358,
                30.553,
                25.266,
            ],
            [
                128.95,
                122.39,
                120.64,
                123.55,
                130.36,
                139.91,
                150.88,
                162.03,
                172.42,
                181.48,
                189.02,
                195.16,
                200.19,
                204.44,
                208.13,
                211.28,
                213.65,
                214.75,
                213.92,
                210.41,
                203.54,
                192.86,
                178.23,
                163.31,
                155.31,
                151.08,
                150.99,
                154.77,
                161.58,
                170.28,
                179.68,
                188.74,
                196.76,
                203.4,
                208.68,
                212.85,
                216.27,
                219.23,
                221.88,
                224.12,
                225.6,
                225.74,
                223.82,
                219.07,
                210.87,
                198.8,
                182.79,
                174.14,
                167.52,
                164.42,
                165.1,
                169.16,
                175.75,
                183.73,
                191.99,
                199.65,
                206.14,
                211.3,
                215.28,
                218.42,
                221.08,
                223.54,
                225.85,
                227.84,
                229.03,
                228.78,
                226.33,
                220.92,
                211.96,
                199.07,
                182.29,
                173.98,
                167.47,
                164.48,
                165.21,
                169.22,
                175.62,
                183.29,
                191.13,
                198.31,
                204.34,
                209.12,
                212.84,
                215.87,
                218.56,
                221.15,
                223.64,
                225.77,
                227.02,
                226.7,
                224.03,
                218.3,
                208.92,
                195.62,
                178.46,
                166,
                158.67,
                155.08,
                155.45,
                159.35,
                165.87,
                173.86,
                182.19,
                189.98,
                196.7,
                202.2,
                206.66,
                210.38,
                213.7,
                216.82,
                219.71,
                222.07,
                223.4,
                223,
                220.13,
                214.1,
                204.4,
                190.8,
                173.44,
                154.11,
                145.46,
                140.96,
                140.92,
                144.95,
                152.12,
                161.23,
                171.03,
                180.51,
                189,
                196.23,
                202.23,
                207.24,
                211.54,
                215.29,
                218.49,
                220.88,
                221.98,
                221.18,
                217.81,
                211.23,
                201.01,
                186.99,
                169.34,
                142.18,
                132.2,
                126.9,
                126.73,
                131.35,
                139.83,
                150.86,
                163.06,
                175.18,
                186.35,
                196.06,
                204.16,
                210.78,
                216.11,
                220.35,
                223.51,
                225.44,
                225.78,
                224.02,
                219.59,
                211.98,
                200.83,
                186.04,
                167.83,
                139.73,
            ],
            [
                70.415,
                63.185,
                60.465,
                60.591,
                60.143,
                57.038,
                52.504,
                50.145,
                52.795,
                59.874,
                67.577,
                71.705,
                70.705,
                66.507,
                62.829,
                62.672,
                66.912,
                74.551,
                83.744,
                92.514,
                98.891,
                100.95,
                97.216,
                79.011,
                69.417,
                63.16,
                61.764,
                63.012,
                62.935,
                59.324,
                53.838,
                50.763,
                53.311,
                60.684,
                68.47,
                72.03,
                69.915,
                64.583,
                60.254,
                60.045,
                64.612,
                72.707,
                82.445,
                91.957,
                99.291,
                102.29,
                99.127,
                78.038,
                68.621,
                62.845,
                62.133,
                63.938,
                63.956,
                59.934,
                53.875,
                50.547,
                53.377,
                61.309,
                69.423,
                72.78,
                70.092,
                64.277,
                59.88,
                59.941,
                64.754,
                72.791,
                82.217,
                91.458,
                98.799,
                102.05,
                99.099,
                79.084,
                69.517,
                63.545,
                62.667,
                64.294,
                64.063,
                59.786,
                53.71,
                50.862,
                54.69,
                63.816,
                72.863,
                76.62,
                73.907,
                67.976,
                63.596,
                63.71,
                68.311,
                75.671,
                84.059,
                92.247,
                98.83,
                101.68,
                98.532,
                82.217,
                72.301,
                65.592,
                63.804,
                64.591,
                63.807,
                59.46,
                53.943,
                52.302,
                57.788,
                68.623,
                78.974,
                83.346,
                80.57,
                74.14,
                69.092,
                68.491,
                72.306,
                78.769,
                86.214,
                93.562,
                99.537,
                102.01,
                98.59,
                85.922,
                75.755,
                68.142,
                65.06,
                64.61,
                63.112,
                58.883,
                54.354,
                54.334,
                61.656,
                74.067,
                85.316,
                89.653,
                85.894,
                77.776,
                70.782,
                68.475,
                71.193,
                77.305,
                85.039,
                93.058,
                99.781,
                102.83,
                99.672,
                87.851,
                77.836,
                69.584,
                65.269,
                63.539,
                61.355,
                57.414,
                54.058,
                55.603,
                64.259,
                77.282,
                88.15,
                91.02,
                84.779,
                73.49,
                63.277,
                58.54,
                60.333,
                67.279,
                77.276,
                88.242,
                97.786,
                102.97,
                101.07,
                80.395,
            ],
            [
                41.641,
                40.194,
                40.186,
                42.23,
                46.594,
                53.121,
                61.229,
                70.012,
                78.439,
                85.592,
                90.892,
                94.251,
                96.067,
                97.076,
                98.062,
                99.52,
                101.37,
                102.81,
                102.42,
                98.456,
                89.282,
                73.864,
                52.127,
                46.345,
                44.621,
                43.544,
                43.912,
                46.325,
                51.036,
                57.864,
                66.199,
                75.106,
                83.524,
                90.514,
                95.492,
                98.379,
                99.607,
                99.965,
                100.3,
                101.19,
                102.58,
                103.72,
                103.16,
                99.119,
                89.886,
                74.352,
                52.377,
                47.029,
                45.418,
                44.464,
                44.971,
                47.544,
                52.44,
                59.48,
                68.047,
                77.196,
                85.846,
                93.031,
                98.137,
                101.06,
                102.23,
                102.43,
                102.55,
                103.18,
                104.36,
                105.36,
                104.77,
                100.79,
                91.703,
                76.343,
                54.515,
                46.417,
                44.725,
                43.69,
                44.133,
                46.678,
                51.605,
                58.757,
                67.538,
                77.004,
                86.064,
                93.719,
                99.307,
                102.67,
                104.17,
                104.59,
                104.77,
                105.37,
                106.44,
                107.34,
                106.73,
                102.87,
                94.051,
                79.104,
                57.779,
                45.332,
                43.46,
                42.227,
                42.471,
                44.847,
                49.673,
                56.832,
                65.762,
                75.54,
                85.07,
                93.32,
                99.567,
                103.57,
                105.62,
                106.39,
                106.74,
                107.3,
                108.21,
                108.9,
                108.17,
                104.36,
                95.857,
                81.497,
                60.997,
                44.582,
                42.54,
                41.092,
                41.092,
                43.223,
                47.848,
                54.899,
                63.862,
                73.848,
                83.763,
                92.548,
                99.412,
                104.02,
                106.56,
                107.63,
                108.02,
                108.36,
                108.88,
                109.12,
                108.03,
                104.13,
                95.9,
                82.242,
                62.844,
                44.76,
                42.661,
                41.081,
                40.875,
                42.75,
                47.106,
                53.93,
                62.761,
                72.751,
                82.824,
                91.901,
                99.134,
                104.1,
                106.86,
                107.94,
                108.05,
                107.85,
                107.62,
                107.08,
                105.35,
                101.14,
                93.104,
                80.215,
                62.151,
                43.724,
            ],
            [
                118.98,
                118.77,
                114.81,
                110.94,
                111.76,
                120.81,
                139.03,
                164.13,
                191.14,
                214.26,
                229.24,
                235.31,
                235.48,
                234.91,
                237.59,
                243.43,
                247.56,
                242.8,
                224.16,
                192.83,
                156.88,
                128.03,
                116.11,
                114.56,
                120.47,
                121.48,
                119.8,
                119.4,
                124.67,
                138.61,
                161.35,
                189.66,
                217.79,
                239.51,
                250.63,
                250.97,
                244.63,
                238.01,
                236.21,
                239.67,
                243.29,
                239.03,
                220.99,
                189.83,
                153.87,
                125.62,
                115.76,
                113.73,
                119.34,
                120.43,
                119.35,
                120.07,
                126.81,
                142.28,
                166.27,
                195.25,
                223.31,
                244.16,
                253.68,
                251.93,
                243.39,
                234.99,
                232.27,
                235.87,
                240.45,
                237.39,
                220.08,
                188.86,
                152.21,
                123.36,
                113.8,
                112.5,
                117.39,
                117.83,
                116.14,
                116.19,
                122.09,
                136.48,
                159.24,
                187.11,
                214.47,
                235.32,
                245.61,
                245.23,
                238.46,
                231.97,
                231.22,
                236.76,
                243.08,
                241.27,
                224.36,
                192.43,
                154.12,
                123.17,
                111.77,
                111.84,
                116.07,
                115.81,
                113.28,
                112.16,
                116.42,
                128.77,
                149.41,
                175.62,
                202.44,
                224.24,
                237.01,
                240.27,
                237.61,
                235.01,
                237.45,
                245.27,
                252.98,
                251.67,
                234.34,
                200.95,
                160.12,
                125.78,
                110.61,
                111.8,
                115.85,
                115.53,
                112.91,
                111.46,
                114.95,
                126.08,
                145.37,
                170.67,
                197.62,
                221.06,
                236.98,
                244.41,
                246.13,
                247.26,
                252.18,
                261.08,
                268.7,
                266.51,
                247.75,
                212.36,
                168.66,
                130.37,
                110.27,
                111.49,
                115.98,
                116.58,
                115.25,
                115.16,
                119.79,
                131.68,
                151.41,
                177.19,
                205.1,
                230.34,
                248.92,
                259.5,
                264.14,
                267.18,
                272.48,
                280.25,
                285.71,
                281.08,
                260.09,
                222.65,
                176.54,
                134.76,
                109.72,
                113.52,
            ],
            [
                193.76,
                175.38,
                162.27,
                160.36,
                172.25,
                195.97,
                225.74,
                254.47,
                276.83,
                291.1,
                299.03,
                303.88,
                308.06,
                311.91,
                314.25,
                314.13,
                312.28,
                310.93,
                311.97,
                314.65,
                314.29,
                303.4,
                274.7,
                224.26,
                207.31,
                188.71,
                175.68,
                174.45,
                187.74,
                213.48,
                245.57,
                276.56,
                300.69,
                315.98,
                324.06,
                328.17,
                330.76,
                332.29,
                331.78,
                328.62,
                323.95,
                320.4,
                320.06,
                321.98,
                320.97,
                308.8,
                277.58,
                228.89,
                211.58,
                193.09,
                180.66,
                180.38,
                194.76,
                221.52,
                254.41,
                285.92,
                310.33,
                325.71,
                333.69,
                337.44,
                339.35,
                339.79,
                337.84,
                333.07,
                326.89,
                322.18,
                321.12,
                322.62,
                321.14,
                308.02,
                275.04,
                226.62,
                208.9,
                190.91,
                179.59,
                180.54,
                195.75,
                222.62,
                254.92,
                285.45,
                308.91,
                323.71,
                331.58,
                335.58,
                337.83,
                338.47,
                336.46,
                331.43,
                324.91,
                319.91,
                318.63,
                319.91,
                318.05,
                304.27,
                270.31,
                220.88,
                202.94,
                185.9,
                176.17,
                178.56,
                194.36,
                220.62,
                251.31,
                279.83,
                301.61,
                315.58,
                323.64,
                328.59,
                332.13,
                334.02,
                333.01,
                328.67,
                322.59,
                317.79,
                316.49,
                317.49,
                315.17,
                300.91,
                266.66,
                215.01,
                197.33,
                181.72,
                173.93,
                177.86,
                194.01,
                219.16,
                247.65,
                273.68,
                293.62,
                306.99,
                315.73,
                322.31,
                327.86,
                331.65,
                332.18,
                328.96,
                323.58,
                319.06,
                317.57,
                318.01,
                314.99,
                300.29,
                266.31,
                211.08,
                194.33,
                180.62,
                174.97,
                180.35,
                196.57,
                220.29,
                246.36,
                269.94,
                288.33,
                301.58,
                311.6,
                320.31,
                328.22,
                334.09,
                336.21,
                334.05,
                329.23,
                324.7,
                322.64,
                322.07,
                318.01,
                302.85,
                269.56,
                210.47,
            ],
            [
                379.51,
                379.84,
                395.91,
                427.92,
                473.69,
                529.07,
                588.7,
                647.08,
                699.6,
                743.3,
                777.29,
                802.52,
                821.09,
                835.21,
                846.12,
                853.17,
                853.52,
                842.42,
                814.09,
                763.04,
                685.5,
                580.62,
                451.07,
                410.65,
                399.71,
                402.4,
                421.14,
                455.94,
                504.31,
                561.69,
                622.3,
                680.28,
                730.75,
                770.76,
                799.62,
                818.74,
                830.83,
                838.79,
                844.48,
                847.73,
                845.89,
                834.15,
                806.4,
                756.67,
                680.62,
                576.86,
                447.69,
                414.98,
                404.12,
                407.11,
                426.47,
                462.19,
                511.7,
                570.26,
                631.84,
                690.32,
                740.61,
                779.61,
                806.68,
                823.39,
                832.79,
                838.15,
                841.71,
                843.6,
                841.34,
                830.09,
                803.55,
                755.43,
                681.02,
                578.58,
                450.14,
                410.03,
                397.89,
                399.64,
                418.02,
                453.23,
                502.83,
                562.11,
                624.99,
                685.17,
                737.35,
                778.23,
                806.94,
                824.96,
                835.31,
                841.33,
                845.37,
                847.71,
                845.99,
                835.41,
                809.68,
                762.41,
                688.78,
                586.93,
                458.78,
                401.4,
                387.35,
                387.06,
                403.58,
                437.47,
                486.6,
                546.53,
                611.24,
                674.4,
                730.49,
                775.86,
                809.27,
                831.79,
                846.08,
                855.24,
                861.51,
                865.15,
                863.91,
                853.15,
                826.78,
                778.64,
                704.06,
                601.31,
                472.38,
                394.53,
                378.79,
                376.46,
                391,
                423.41,
                472.04,
                532.82,
                600,
                667.24,
                728.84,
                780.73,
                821.08,
                850.34,
                870.52,
                884.23,
                893.36,
                898.07,
                896.23,
                883.52,
                854.27,
                802.83,
                725,
                619.43,
                488.37,
                393.66,
                377.18,
                373.6,
                386.72,
                418.08,
                466.56,
                528.58,
                598.73,
                670.77,
                738.81,
                798.32,
                846.78,
                883.81,
                910.59,
                929.03,
                940.55,
                945.15,
                940.84,
                923.78,
                888.98,
                831.54,
                748.02,
                637.69,
                503.18,
                392.42,
            ],
            [
                41.737,
                33.076,
                24.388,
                16.425,
                10.052,
                6.4268,
                6.8474,
                12.206,
                22.299,
                35.43,
                48.68,
                58.883,
                63.898,
                63.561,
                59.771,
                55.585,
                53.758,
                55.447,
                59.744,
                64.226,
                66.185,
                63.872,
                57.142,
                51.474,
                43.482,
                34.651,
                25.854,
                17.828,
                11.468,
                8.0229,
                8.9065,
                15.065,
                26.203,
                40.365,
                54.275,
                64.445,
                68.619,
                66.805,
                61.329,
                55.764,
                53.26,
                55.074,
                60.078,
                65.417,
                67.947,
                65.656,
                58.396,
                51.897,
                43.901,
                35.098,
                26.31,
                18.242,
                11.813,
                8.3517,
                9.3741,
                15.887,
                27.558,
                42.285,
                56.579,
                66.77,
                70.543,
                68.02,
                61.774,
                55.659,
                53.001,
                55.044,
                60.453,
                66.077,
                68.523,
                65.69,
                57.541,
                51.467,
                43.599,
                34.896,
                26.14,
                18.03,
                11.515,
                7.9791,
                8.9882,
                15.567,
                27.362,
                42.223,
                56.617,
                66.867,
                70.691,
                68.278,
                62.263,
                56.511,
                54.28,
                56.674,
                62.18,
                67.505,
                69.216,
                65.307,
                55.944,
                50.993,
                43.278,
                34.645,
                25.895,
                17.776,
                11.289,
                7.8312,
                8.9214,
                15.506,
                27.173,
                41.794,
                55.957,
                66.162,
                70.288,
                68.58,
                63.578,
                58.925,
                57.59,
                60.424,
                65.773,
                70.355,
                70.884,
                65.589,
                54.893,
                51.015,
                43.422,
                34.798,
                26.04,
                18.023,
                11.818,
                8.7764,
                10.249,
                16.969,
                28.395,
                42.451,
                55.976,
                65.827,
                70.181,
                69.366,
                65.74,
                62.552,
                62.332,
                65.609,
                70.634,
                74.263,
                73.492,
                66.863,
                55.035,
                51.552,
                44.063,
                35.433,
                26.729,
                19.01,
                13.424,
                11.212,
                13.437,
                20.492,
                31.624,
                44.814,
                57.244,
                66.265,
                70.467,
                70.32,
                67.965,
                66.186,
                67.005,
                70.615,
                75.233,
                77.94,
                76.092,
                68.545,
                56.119,
                49.486,
            ],
            [
                75.287,
                73.758,
                72.659,
                72.035,
                71.962,
                72.496,
                73.613,
                75.186,
                76.995,
                78.785,
                80.34,
                81.53,
                82.325,
                82.764,
                82.909,
                82.804,
                82.474,
                81.942,
                81.26,
                80.525,
                79.851,
                79.319,
                78.904,
                81.595,
                81.221,
                81.035,
                80.886,
                80.722,
                80.593,
                80.601,
                80.828,
                81.284,
                81.896,
                82.541,
                83.098,
                83.49,
                83.696,
                83.727,
                83.595,
                83.288,
                82.784,
                82.081,
                81.234,
                80.368,
                79.638,
                79.167,
                78.954,
                81.439,
                81.784,
                82.216,
                82.507,
                82.564,
                82.436,
                82.264,
                82.193,
                82.307,
                82.599,
                82.99,
                83.378,
                83.682,
                83.857,
                83.881,
                83.732,
                83.374,
                82.773,
                81.934,
                80.937,
                79.941,
                79.139,
                78.685,
                78.595,
                78.829,
                79.15,
                79.549,
                79.794,
                79.799,
                79.638,
                79.482,
                79.503,
                79.802,
                80.367,
                81.098,
                81.857,
                82.52,
                83.002,
                83.256,
                83.251,
                82.957,
                82.36,
                81.493,
                80.463,
                79.451,
                78.668,
                78.274,
                78.283,
                76.309,
                76.127,
                76.043,
                75.873,
                75.58,
                75.277,
                75.155,
                75.391,
                76.059,
                77.103,
                78.362,
                79.636,
                80.745,
                81.574,
                82.07,
                82.22,
                82.031,
                81.527,
                80.773,
                79.89,
                79.055,
                78.46,
                78.234,
                78.365,
                76.287,
                75.462,
                74.722,
                73.96,
                73.203,
                72.608,
                72.384,
                72.692,
                73.569,
                74.899,
                76.456,
                77.981,
                79.261,
                80.174,
                80.69,
                80.844,
                80.699,
                80.328,
                79.815,
                79.271,
                78.83,
                78.618,
                78.695,
                78.994,
                80.444,
                79.175,
                77.895,
                76.574,
                75.301,
                74.273,
                73.708,
                73.754,
                74.41,
                75.518,
                76.813,
                78.012,
                78.905,
                79.401,
                79.532,
                79.402,
                79.144,
                78.872,
                78.674,
                78.616,
                78.746,
                79.081,
                79.576,
                80.082,
                77.239,
            ],
        ]
    )


def load_exact_std():
    return nd.array(
        [
            [
                62.202,
                61.116,
                60.813,
                60.657,
                60.515,
                60.403,
                60.333,
                60.297,
                60.282,
                60.276,
                60.275,
                60.275,
                60.276,
                60.282,
                60.297,
                60.333,
                60.403,
                60.515,
                60.657,
                60.813,
                61.116,
                62.202,
                65.704,
                62.155,
                59.724,
                59.199,
                59.129,
                59.061,
                58.969,
                58.9,
                58.866,
                58.85,
                58.838,
                58.826,
                58.819,
                58.819,
                58.826,
                58.838,
                58.85,
                58.866,
                58.9,
                58.969,
                59.061,
                59.129,
                59.199,
                59.724,
                62.155,
                61.374,
                59.422,
                59.048,
                58.973,
                58.87,
                58.764,
                58.706,
                58.692,
                58.689,
                58.68,
                58.665,
                58.654,
                58.654,
                58.665,
                58.68,
                58.689,
                58.692,
                58.706,
                58.764,
                58.87,
                58.973,
                59.048,
                59.422,
                61.374,
                61.321,
                59.489,
                59.128,
                59.023,
                58.892,
                58.773,
                58.716,
                58.708,
                58.711,
                58.704,
                58.688,
                58.675,
                58.675,
                58.688,
                58.704,
                58.711,
                58.708,
                58.716,
                58.773,
                58.892,
                59.023,
                59.128,
                59.489,
                61.321,
                61.374,
                59.422,
                59.048,
                58.973,
                58.87,
                58.764,
                58.706,
                58.692,
                58.689,
                58.68,
                58.665,
                58.654,
                58.654,
                58.665,
                58.68,
                58.689,
                58.692,
                58.706,
                58.764,
                58.87,
                58.973,
                59.048,
                59.422,
                61.374,
                62.155,
                59.724,
                59.199,
                59.129,
                59.061,
                58.969,
                58.9,
                58.866,
                58.85,
                58.838,
                58.826,
                58.819,
                58.819,
                58.826,
                58.838,
                58.85,
                58.866,
                58.9,
                58.969,
                59.061,
                59.129,
                59.199,
                59.724,
                62.155,
                65.704,
                62.202,
                61.116,
                60.813,
                60.657,
                60.515,
                60.403,
                60.333,
                60.297,
                60.282,
                60.276,
                60.275,
                60.275,
                60.276,
                60.282,
                60.297,
                60.333,
                60.403,
                60.515,
                60.657,
                60.813,
                61.116,
                62.202,
                65.704,
                65.704,
            ],
            [
                4.6693,
                4.6057,
                4.5913,
                4.5803,
                4.5721,
                4.5684,
                4.5667,
                4.5655,
                4.5644,
                4.5637,
                4.5633,
                4.5633,
                4.5637,
                4.5644,
                4.5655,
                4.5667,
                4.5684,
                4.5721,
                4.5803,
                4.5913,
                4.6057,
                4.6693,
                4.9388,
                4.6701,
                4.4794,
                4.4525,
                4.4488,
                4.4409,
                4.4349,
                4.4328,
                4.4317,
                4.4306,
                4.4299,
                4.4295,
                4.4293,
                4.4293,
                4.4295,
                4.4299,
                4.4306,
                4.4317,
                4.4328,
                4.4349,
                4.4409,
                4.4488,
                4.4525,
                4.4794,
                4.6701,
                4.618,
                4.4607,
                4.44,
                4.4336,
                4.4245,
                4.4199,
                4.4191,
                4.4183,
                4.4169,
                4.4162,
                4.416,
                4.416,
                4.416,
                4.416,
                4.4162,
                4.4169,
                4.4183,
                4.4191,
                4.4199,
                4.4245,
                4.4336,
                4.44,
                4.4607,
                4.618,
                4.616,
                4.4654,
                4.4433,
                4.434,
                4.4239,
                4.4199,
                4.4198,
                4.419,
                4.4175,
                4.4167,
                4.4166,
                4.4166,
                4.4166,
                4.4166,
                4.4167,
                4.4175,
                4.419,
                4.4198,
                4.4199,
                4.4239,
                4.434,
                4.4433,
                4.4654,
                4.616,
                4.618,
                4.4607,
                4.44,
                4.4336,
                4.4245,
                4.4199,
                4.4191,
                4.4183,
                4.4169,
                4.4162,
                4.416,
                4.416,
                4.416,
                4.416,
                4.4162,
                4.4169,
                4.4183,
                4.4191,
                4.4199,
                4.4245,
                4.4336,
                4.44,
                4.4607,
                4.618,
                4.6701,
                4.4794,
                4.4525,
                4.4488,
                4.4409,
                4.4349,
                4.4328,
                4.4317,
                4.4306,
                4.4299,
                4.4295,
                4.4293,
                4.4293,
                4.4295,
                4.4299,
                4.4306,
                4.4317,
                4.4328,
                4.4349,
                4.4409,
                4.4488,
                4.4525,
                4.4794,
                4.6701,
                4.9388,
                4.6693,
                4.6057,
                4.5913,
                4.5803,
                4.5721,
                4.5684,
                4.5667,
                4.5655,
                4.5644,
                4.5637,
                4.5633,
                4.5633,
                4.5637,
                4.5644,
                4.5655,
                4.5667,
                4.5684,
                4.5721,
                4.5803,
                4.5913,
                4.6057,
                4.6693,
                4.9388,
                4.9388,
            ],
            [
                10.6,
                10.437,
                10.384,
                10.335,
                10.304,
                10.29,
                10.28,
                10.271,
                10.264,
                10.261,
                10.259,
                10.259,
                10.261,
                10.264,
                10.271,
                10.28,
                10.29,
                10.304,
                10.335,
                10.384,
                10.437,
                10.6,
                11.514,
                10.618,
                10.069,
                10.028,
                10.002,
                9.9658,
                9.9464,
                9.9396,
                9.9341,
                9.9288,
                9.9256,
                9.9239,
                9.9228,
                9.9228,
                9.9239,
                9.9256,
                9.9288,
                9.9341,
                9.9396,
                9.9464,
                9.9658,
                10.002,
                10.028,
                10.069,
                10.618,
                10.505,
                10.051,
                10.003,
                9.9655,
                9.9329,
                9.9221,
                9.9184,
                9.9114,
                9.9045,
                9.9017,
                9.9012,
                9.9009,
                9.9009,
                9.9012,
                9.9017,
                9.9045,
                9.9114,
                9.9184,
                9.9221,
                9.9329,
                9.9655,
                10.003,
                10.051,
                10.505,
                10.492,
                10.043,
                9.9813,
                9.9381,
                9.9089,
                9.9031,
                9.9013,
                9.8936,
                9.8858,
                9.8829,
                9.8828,
                9.8828,
                9.8828,
                9.8828,
                9.8829,
                9.8858,
                9.8936,
                9.9013,
                9.9031,
                9.9089,
                9.9381,
                9.9813,
                10.043,
                10.492,
                10.505,
                10.051,
                10.003,
                9.9655,
                9.9329,
                9.9221,
                9.9184,
                9.9114,
                9.9045,
                9.9017,
                9.9012,
                9.9009,
                9.9009,
                9.9012,
                9.9017,
                9.9045,
                9.9114,
                9.9184,
                9.9221,
                9.9329,
                9.9655,
                10.003,
                10.051,
                10.505,
                10.618,
                10.069,
                10.028,
                10.002,
                9.9658,
                9.9464,
                9.9396,
                9.9341,
                9.9288,
                9.9256,
                9.9239,
                9.9228,
                9.9228,
                9.9239,
                9.9256,
                9.9288,
                9.9341,
                9.9396,
                9.9464,
                9.9658,
                10.002,
                10.028,
                10.069,
                10.618,
                11.514,
                10.6,
                10.437,
                10.384,
                10.335,
                10.304,
                10.29,
                10.28,
                10.271,
                10.264,
                10.261,
                10.259,
                10.259,
                10.261,
                10.264,
                10.271,
                10.28,
                10.29,
                10.304,
                10.335,
                10.384,
                10.437,
                10.6,
                11.514,
                11.514,
            ],
            [
                5.8917,
                5.847,
                5.803,
                5.7866,
                5.7789,
                5.7729,
                5.7707,
                5.7687,
                5.7674,
                5.7671,
                5.7668,
                5.7668,
                5.7671,
                5.7674,
                5.7687,
                5.7707,
                5.7729,
                5.7789,
                5.7866,
                5.803,
                5.847,
                5.8917,
                6.4598,
                5.9005,
                5.5807,
                5.5595,
                5.5222,
                5.5167,
                5.5118,
                5.507,
                5.5059,
                5.5046,
                5.5038,
                5.5035,
                5.5033,
                5.5033,
                5.5035,
                5.5038,
                5.5046,
                5.5059,
                5.507,
                5.5118,
                5.5167,
                5.5222,
                5.5595,
                5.5807,
                5.9005,
                5.8645,
                5.566,
                5.5328,
                5.502,
                5.4976,
                5.4912,
                5.4879,
                5.487,
                5.4852,
                5.4848,
                5.4846,
                5.4843,
                5.4843,
                5.4846,
                5.4848,
                5.4852,
                5.487,
                5.4879,
                5.4912,
                5.4976,
                5.502,
                5.5328,
                5.566,
                5.8645,
                5.8339,
                5.534,
                5.507,
                5.4832,
                5.4774,
                5.4694,
                5.467,
                5.4663,
                5.4643,
                5.4639,
                5.4638,
                5.4634,
                5.4634,
                5.4638,
                5.4639,
                5.4643,
                5.4663,
                5.467,
                5.4694,
                5.4774,
                5.4832,
                5.507,
                5.534,
                5.8339,
                5.8645,
                5.566,
                5.5328,
                5.502,
                5.4976,
                5.4912,
                5.4879,
                5.487,
                5.4852,
                5.4848,
                5.4846,
                5.4843,
                5.4843,
                5.4846,
                5.4848,
                5.4852,
                5.487,
                5.4879,
                5.4912,
                5.4976,
                5.502,
                5.5328,
                5.566,
                5.8645,
                5.9005,
                5.5807,
                5.5595,
                5.5222,
                5.5167,
                5.5118,
                5.507,
                5.5059,
                5.5046,
                5.5038,
                5.5035,
                5.5033,
                5.5033,
                5.5035,
                5.5038,
                5.5046,
                5.5059,
                5.507,
                5.5118,
                5.5167,
                5.5222,
                5.5595,
                5.5807,
                5.9005,
                6.4598,
                5.8917,
                5.847,
                5.803,
                5.7866,
                5.7789,
                5.7729,
                5.7707,
                5.7687,
                5.7674,
                5.7671,
                5.7668,
                5.7668,
                5.7671,
                5.7674,
                5.7687,
                5.7707,
                5.7729,
                5.7789,
                5.7866,
                5.803,
                5.847,
                5.8917,
                6.4598,
                6.4598,
            ],
            [
                5.6763,
                5.5919,
                5.567,
                5.5445,
                5.5302,
                5.5238,
                5.5196,
                5.5158,
                5.513,
                5.5114,
                5.5108,
                5.5108,
                5.5114,
                5.513,
                5.5158,
                5.5196,
                5.5238,
                5.5302,
                5.5445,
                5.567,
                5.5919,
                5.6763,
                6.1243,
                5.6824,
                5.4021,
                5.3783,
                5.3679,
                5.3509,
                5.3416,
                5.3385,
                5.336,
                5.3336,
                5.3322,
                5.3315,
                5.3309,
                5.3309,
                5.3315,
                5.3322,
                5.3336,
                5.336,
                5.3385,
                5.3416,
                5.3509,
                5.3679,
                5.3783,
                5.4021,
                5.6824,
                5.6208,
                5.3897,
                5.3653,
                5.3488,
                5.3329,
                5.3275,
                5.3261,
                5.3231,
                5.3201,
                5.3189,
                5.3187,
                5.3184,
                5.3184,
                5.3187,
                5.3189,
                5.3201,
                5.3231,
                5.3261,
                5.3275,
                5.3329,
                5.3488,
                5.3653,
                5.3897,
                5.6208,
                5.617,
                5.3904,
                5.3595,
                5.339,
                5.324,
                5.3207,
                5.3202,
                5.3169,
                5.3134,
                5.3122,
                5.3121,
                5.312,
                5.312,
                5.3121,
                5.3122,
                5.3134,
                5.3169,
                5.3202,
                5.3207,
                5.324,
                5.339,
                5.3595,
                5.3904,
                5.617,
                5.6208,
                5.3897,
                5.3653,
                5.3488,
                5.3329,
                5.3275,
                5.3261,
                5.3231,
                5.3201,
                5.3189,
                5.3187,
                5.3184,
                5.3184,
                5.3187,
                5.3189,
                5.3201,
                5.3231,
                5.3261,
                5.3275,
                5.3329,
                5.3488,
                5.3653,
                5.3897,
                5.6208,
                5.6824,
                5.4021,
                5.3783,
                5.3679,
                5.3509,
                5.3416,
                5.3385,
                5.336,
                5.3336,
                5.3322,
                5.3315,
                5.3309,
                5.3309,
                5.3315,
                5.3322,
                5.3336,
                5.336,
                5.3385,
                5.3416,
                5.3509,
                5.3679,
                5.3783,
                5.4021,
                5.6824,
                6.1243,
                5.6763,
                5.5919,
                5.567,
                5.5445,
                5.5302,
                5.5238,
                5.5196,
                5.5158,
                5.513,
                5.5114,
                5.5108,
                5.5108,
                5.5114,
                5.513,
                5.5158,
                5.5196,
                5.5238,
                5.5302,
                5.5445,
                5.567,
                5.5919,
                5.6763,
                6.1243,
                6.1243,
            ],
            [
                15.404,
                15.259,
                15.168,
                15.109,
                15.087,
                15.07,
                15.059,
                15.055,
                15.051,
                15.049,
                15.047,
                15.047,
                15.049,
                15.051,
                15.055,
                15.059,
                15.07,
                15.087,
                15.109,
                15.168,
                15.259,
                15.404,
                16.812,
                15.43,
                14.606,
                14.573,
                14.493,
                14.455,
                14.448,
                14.437,
                14.429,
                14.426,
                14.424,
                14.422,
                14.422,
                14.422,
                14.422,
                14.424,
                14.426,
                14.429,
                14.437,
                14.448,
                14.455,
                14.493,
                14.573,
                14.606,
                15.43,
                15.313,
                14.587,
                14.524,
                14.447,
                14.422,
                14.413,
                14.399,
                14.395,
                14.394,
                14.39,
                14.388,
                14.389,
                14.389,
                14.388,
                14.39,
                14.394,
                14.395,
                14.399,
                14.413,
                14.422,
                14.447,
                14.524,
                14.587,
                15.313,
                15.264,
                14.528,
                14.456,
                14.393,
                14.377,
                14.366,
                14.349,
                14.346,
                14.345,
                14.341,
                14.339,
                14.34,
                14.34,
                14.339,
                14.341,
                14.345,
                14.346,
                14.349,
                14.366,
                14.377,
                14.393,
                14.456,
                14.528,
                15.264,
                15.313,
                14.587,
                14.524,
                14.447,
                14.422,
                14.413,
                14.399,
                14.395,
                14.394,
                14.39,
                14.388,
                14.389,
                14.389,
                14.388,
                14.39,
                14.394,
                14.395,
                14.399,
                14.413,
                14.422,
                14.447,
                14.524,
                14.587,
                15.313,
                15.43,
                14.606,
                14.573,
                14.493,
                14.455,
                14.448,
                14.437,
                14.429,
                14.426,
                14.424,
                14.422,
                14.422,
                14.422,
                14.422,
                14.424,
                14.426,
                14.429,
                14.437,
                14.448,
                14.455,
                14.493,
                14.573,
                14.606,
                15.43,
                16.812,
                15.404,
                15.259,
                15.168,
                15.109,
                15.087,
                15.07,
                15.059,
                15.055,
                15.051,
                15.049,
                15.047,
                15.047,
                15.049,
                15.051,
                15.055,
                15.059,
                15.07,
                15.087,
                15.109,
                15.168,
                15.259,
                15.404,
                16.812,
                16.812,
            ],
            [
                11.994,
                11.873,
                11.788,
                11.733,
                11.712,
                11.695,
                11.683,
                11.678,
                11.675,
                11.672,
                11.67,
                11.67,
                11.672,
                11.675,
                11.678,
                11.683,
                11.695,
                11.712,
                11.733,
                11.788,
                11.873,
                11.994,
                13.178,
                12.023,
                11.358,
                11.328,
                11.255,
                11.221,
                11.214,
                11.204,
                11.196,
                11.194,
                11.191,
                11.189,
                11.189,
                11.189,
                11.189,
                11.191,
                11.194,
                11.196,
                11.204,
                11.214,
                11.221,
                11.255,
                11.328,
                11.358,
                12.023,
                11.93,
                11.341,
                11.283,
                11.215,
                11.193,
                11.185,
                11.171,
                11.166,
                11.165,
                11.162,
                11.16,
                11.16,
                11.16,
                11.16,
                11.162,
                11.165,
                11.166,
                11.171,
                11.185,
                11.193,
                11.215,
                11.283,
                11.341,
                11.93,
                11.881,
                11.284,
                11.222,
                11.168,
                11.154,
                11.144,
                11.128,
                11.124,
                11.124,
                11.12,
                11.118,
                11.118,
                11.118,
                11.118,
                11.12,
                11.124,
                11.124,
                11.128,
                11.144,
                11.154,
                11.168,
                11.222,
                11.284,
                11.881,
                11.93,
                11.341,
                11.283,
                11.215,
                11.193,
                11.185,
                11.171,
                11.166,
                11.165,
                11.162,
                11.16,
                11.16,
                11.16,
                11.16,
                11.162,
                11.165,
                11.166,
                11.171,
                11.185,
                11.193,
                11.215,
                11.283,
                11.341,
                11.93,
                12.023,
                11.358,
                11.328,
                11.255,
                11.221,
                11.214,
                11.204,
                11.196,
                11.194,
                11.191,
                11.189,
                11.189,
                11.189,
                11.189,
                11.191,
                11.194,
                11.196,
                11.204,
                11.214,
                11.221,
                11.255,
                11.328,
                11.358,
                12.023,
                13.178,
                11.994,
                11.873,
                11.788,
                11.733,
                11.712,
                11.695,
                11.683,
                11.678,
                11.675,
                11.672,
                11.67,
                11.67,
                11.672,
                11.675,
                11.678,
                11.683,
                11.695,
                11.712,
                11.733,
                11.788,
                11.873,
                11.994,
                13.178,
                13.178,
            ],
            [
                45.261,
                44.52,
                44.323,
                44.162,
                44.037,
                43.973,
                43.944,
                43.922,
                43.9,
                43.881,
                43.871,
                43.871,
                43.881,
                43.9,
                43.922,
                43.944,
                43.973,
                44.037,
                44.162,
                44.323,
                44.52,
                45.261,
                48.529,
                45.281,
                43.171,
                42.914,
                42.863,
                42.755,
                42.67,
                42.636,
                42.62,
                42.603,
                42.588,
                42.581,
                42.58,
                42.58,
                42.581,
                42.588,
                42.603,
                42.62,
                42.636,
                42.67,
                42.755,
                42.863,
                42.914,
                43.171,
                45.281,
                44.753,
                43.038,
                42.82,
                42.723,
                42.601,
                42.538,
                42.526,
                42.517,
                42.495,
                42.476,
                42.471,
                42.475,
                42.475,
                42.471,
                42.476,
                42.495,
                42.517,
                42.526,
                42.538,
                42.601,
                42.723,
                42.82,
                43.038,
                44.753,
                44.736,
                43.082,
                42.828,
                42.692,
                42.561,
                42.506,
                42.505,
                42.499,
                42.475,
                42.454,
                42.449,
                42.453,
                42.453,
                42.449,
                42.454,
                42.475,
                42.499,
                42.505,
                42.506,
                42.561,
                42.692,
                42.828,
                43.082,
                44.736,
                44.753,
                43.038,
                42.82,
                42.723,
                42.601,
                42.538,
                42.526,
                42.517,
                42.495,
                42.476,
                42.471,
                42.475,
                42.475,
                42.471,
                42.476,
                42.495,
                42.517,
                42.526,
                42.538,
                42.601,
                42.723,
                42.82,
                43.038,
                44.753,
                45.281,
                43.171,
                42.914,
                42.863,
                42.755,
                42.67,
                42.636,
                42.62,
                42.603,
                42.588,
                42.581,
                42.58,
                42.58,
                42.581,
                42.588,
                42.603,
                42.62,
                42.636,
                42.67,
                42.755,
                42.863,
                42.914,
                43.171,
                45.281,
                48.529,
                45.261,
                44.52,
                44.323,
                44.162,
                44.037,
                43.973,
                43.944,
                43.922,
                43.9,
                43.881,
                43.871,
                43.871,
                43.881,
                43.9,
                43.922,
                43.944,
                43.973,
                44.037,
                44.162,
                44.323,
                44.52,
                45.261,
                48.529,
                48.529,
            ],
            [
                4.5187,
                4.4744,
                4.4501,
                4.433,
                4.4268,
                4.4222,
                4.4187,
                4.4174,
                4.4167,
                4.4159,
                4.4154,
                4.4154,
                4.4159,
                4.4167,
                4.4174,
                4.4187,
                4.4222,
                4.4268,
                4.433,
                4.4501,
                4.4744,
                4.5187,
                4.9177,
                4.5256,
                4.2875,
                4.2783,
                4.2574,
                4.2455,
                4.2434,
                4.2405,
                4.2382,
                4.2374,
                4.2368,
                4.2362,
                4.2361,
                4.2361,
                4.2362,
                4.2368,
                4.2374,
                4.2382,
                4.2405,
                4.2434,
                4.2455,
                4.2574,
                4.2783,
                4.2875,
                4.5256,
                4.4897,
                4.2819,
                4.2649,
                4.2439,
                4.2359,
                4.2338,
                4.2301,
                4.2283,
                4.2281,
                4.2273,
                4.2267,
                4.2267,
                4.2267,
                4.2267,
                4.2273,
                4.2281,
                4.2283,
                4.2301,
                4.2338,
                4.2359,
                4.2439,
                4.2649,
                4.2819,
                4.4897,
                4.4781,
                4.2679,
                4.2471,
                4.2289,
                4.2238,
                4.2214,
                4.2168,
                4.2152,
                4.2153,
                4.2144,
                4.2137,
                4.2138,
                4.2138,
                4.2137,
                4.2144,
                4.2153,
                4.2152,
                4.2168,
                4.2214,
                4.2238,
                4.2289,
                4.2471,
                4.2679,
                4.4781,
                4.4897,
                4.2819,
                4.2649,
                4.2439,
                4.2359,
                4.2338,
                4.2301,
                4.2283,
                4.2281,
                4.2273,
                4.2267,
                4.2267,
                4.2267,
                4.2267,
                4.2273,
                4.2281,
                4.2283,
                4.2301,
                4.2338,
                4.2359,
                4.2439,
                4.2649,
                4.2819,
                4.4897,
                4.5256,
                4.2875,
                4.2783,
                4.2574,
                4.2455,
                4.2434,
                4.2405,
                4.2382,
                4.2374,
                4.2368,
                4.2362,
                4.2361,
                4.2361,
                4.2362,
                4.2368,
                4.2374,
                4.2382,
                4.2405,
                4.2434,
                4.2455,
                4.2574,
                4.2783,
                4.2875,
                4.5256,
                4.9177,
                4.5187,
                4.4744,
                4.4501,
                4.433,
                4.4268,
                4.4222,
                4.4187,
                4.4174,
                4.4167,
                4.4159,
                4.4154,
                4.4154,
                4.4159,
                4.4167,
                4.4174,
                4.4187,
                4.4222,
                4.4268,
                4.433,
                4.4501,
                4.4744,
                4.5187,
                4.9177,
                4.9177,
            ],
            [
                1.3486,
                1.3332,
                1.3187,
                1.3103,
                1.3068,
                1.3037,
                1.3015,
                1.3006,
                1.2999,
                1.2991,
                1.2986,
                1.2986,
                1.2991,
                1.2999,
                1.3006,
                1.3015,
                1.3037,
                1.3068,
                1.3103,
                1.3187,
                1.3332,
                1.3486,
                1.506,
                1.3566,
                1.2758,
                1.2693,
                1.2573,
                1.2531,
                1.2522,
                1.2503,
                1.2489,
                1.2484,
                1.2479,
                1.2475,
                1.2474,
                1.2474,
                1.2475,
                1.2479,
                1.2484,
                1.2489,
                1.2503,
                1.2522,
                1.2531,
                1.2573,
                1.2693,
                1.2758,
                1.3566,
                1.345,
                1.2709,
                1.2607,
                1.2507,
                1.248,
                1.2463,
                1.2442,
                1.2434,
                1.2432,
                1.2425,
                1.242,
                1.242,
                1.242,
                1.242,
                1.2425,
                1.2432,
                1.2434,
                1.2442,
                1.2463,
                1.248,
                1.2507,
                1.2607,
                1.2709,
                1.345,
                1.335,
                1.2613,
                1.2528,
                1.2457,
                1.2438,
                1.2416,
                1.239,
                1.2384,
                1.2384,
                1.2377,
                1.2372,
                1.2373,
                1.2373,
                1.2372,
                1.2377,
                1.2384,
                1.2384,
                1.239,
                1.2416,
                1.2438,
                1.2457,
                1.2528,
                1.2613,
                1.335,
                1.345,
                1.2709,
                1.2607,
                1.2507,
                1.248,
                1.2463,
                1.2442,
                1.2434,
                1.2432,
                1.2425,
                1.242,
                1.242,
                1.242,
                1.242,
                1.2425,
                1.2432,
                1.2434,
                1.2442,
                1.2463,
                1.248,
                1.2507,
                1.2607,
                1.2709,
                1.345,
                1.3566,
                1.2758,
                1.2693,
                1.2573,
                1.2531,
                1.2522,
                1.2503,
                1.2489,
                1.2484,
                1.2479,
                1.2475,
                1.2474,
                1.2474,
                1.2475,
                1.2479,
                1.2484,
                1.2489,
                1.2503,
                1.2522,
                1.2531,
                1.2573,
                1.2693,
                1.2758,
                1.3566,
                1.506,
                1.3486,
                1.3332,
                1.3187,
                1.3103,
                1.3068,
                1.3037,
                1.3015,
                1.3006,
                1.2999,
                1.2991,
                1.2986,
                1.2986,
                1.2991,
                1.2999,
                1.3006,
                1.3015,
                1.3037,
                1.3068,
                1.3103,
                1.3187,
                1.3332,
                1.3486,
                1.506,
                1.506,
            ],
        ]
    )


def load_xfull():
    return nd.array(
        [
            [0.0, 1.0],
            [0.0, 2.0],
            [0.0, 3.0],
            [0.0, 4.0],
            [0.0, 5.0],
            [0.0, 6.0],
            [0.0, 7.0],
            [0.0, 8.0],
            [0.0, 9.0],
            [0.0, 10.0],
            [0.0, 11.0],
            [0.0, 12.0],
            [0.0, 13.0],
            [0.0, 14.0],
            [0.0, 15.0],
            [0.0, 16.0],
            [0.0, 17.0],
            [0.0, 18.0],
            [0.0, 19.0],
            [0.0, 20.0],
            [0.0, 21.0],
            [0.0, 22.0],
            [0.0, 23.0],
            [1.0, 0.0],
            [1.0, 1.0],
            [1.0, 2.0],
            [1.0, 3.0],
            [1.0, 4.0],
            [1.0, 5.0],
            [1.0, 6.0],
            [1.0, 7.0],
            [1.0, 8.0],
            [1.0, 9.0],
            [1.0, 10.0],
            [1.0, 11.0],
            [1.0, 12.0],
            [1.0, 13.0],
            [1.0, 14.0],
            [1.0, 15.0],
            [1.0, 16.0],
            [1.0, 17.0],
            [1.0, 18.0],
            [1.0, 19.0],
            [1.0, 20.0],
            [1.0, 21.0],
            [1.0, 22.0],
            [1.0, 23.0],
            [2.0, 0.0],
            [2.0, 1.0],
            [2.0, 2.0],
            [2.0, 3.0],
            [2.0, 4.0],
            [2.0, 5.0],
            [2.0, 6.0],
            [2.0, 7.0],
            [2.0, 8.0],
            [2.0, 9.0],
            [2.0, 10.0],
            [2.0, 11.0],
            [2.0, 12.0],
            [2.0, 13.0],
            [2.0, 14.0],
            [2.0, 15.0],
            [2.0, 16.0],
            [2.0, 17.0],
            [2.0, 18.0],
            [2.0, 19.0],
            [2.0, 20.0],
            [2.0, 21.0],
            [2.0, 22.0],
            [2.0, 23.0],
            [3.0, 0.0],
            [3.0, 1.0],
            [3.0, 2.0],
            [3.0, 3.0],
            [3.0, 4.0],
            [3.0, 5.0],
            [3.0, 6.0],
            [3.0, 7.0],
            [3.0, 8.0],
            [3.0, 9.0],
            [3.0, 10.0],
            [3.0, 11.0],
            [3.0, 12.0],
            [3.0, 13.0],
            [3.0, 14.0],
            [3.0, 15.0],
            [3.0, 16.0],
            [3.0, 17.0],
            [3.0, 18.0],
            [3.0, 19.0],
            [3.0, 20.0],
            [3.0, 21.0],
            [3.0, 22.0],
            [3.0, 23.0],
            [4.0, 0.0],
            [4.0, 1.0],
            [4.0, 2.0],
            [4.0, 3.0],
            [4.0, 4.0],
            [4.0, 5.0],
            [4.0, 6.0],
            [4.0, 7.0],
            [4.0, 8.0],
            [4.0, 9.0],
            [4.0, 10.0],
            [4.0, 11.0],
            [4.0, 12.0],
            [4.0, 13.0],
            [4.0, 14.0],
            [4.0, 15.0],
            [4.0, 16.0],
            [4.0, 17.0],
            [4.0, 18.0],
            [4.0, 19.0],
            [4.0, 20.0],
            [4.0, 21.0],
            [4.0, 22.0],
            [4.0, 23.0],
            [5.0, 0.0],
            [5.0, 1.0],
            [5.0, 2.0],
            [5.0, 3.0],
            [5.0, 4.0],
            [5.0, 5.0],
            [5.0, 6.0],
            [5.0, 7.0],
            [5.0, 8.0],
            [5.0, 9.0],
            [5.0, 10.0],
            [5.0, 11.0],
            [5.0, 12.0],
            [5.0, 13.0],
            [5.0, 14.0],
            [5.0, 15.0],
            [5.0, 16.0],
            [5.0, 17.0],
            [5.0, 18.0],
            [5.0, 19.0],
            [5.0, 20.0],
            [5.0, 21.0],
            [5.0, 22.0],
            [5.0, 23.0],
            [6.0, 0.0],
            [6.0, 1.0],
            [6.0, 2.0],
            [6.0, 3.0],
            [6.0, 4.0],
            [6.0, 5.0],
            [6.0, 6.0],
            [6.0, 7.0],
            [6.0, 8.0],
            [6.0, 9.0],
            [6.0, 10.0],
            [6.0, 11.0],
            [6.0, 12.0],
            [6.0, 13.0],
            [6.0, 14.0],
            [6.0, 15.0],
            [6.0, 16.0],
            [6.0, 17.0],
            [6.0, 18.0],
            [6.0, 19.0],
            [6.0, 20.0],
            [6.0, 21.0],
            [6.0, 22.0],
            [6.0, 23.0],
            [0.0, 0.0],
            [0.0, 1.0],
            [0.0, 2.0],
            [0.0, 3.0],
            [0.0, 4.0],
            [0.0, 5.0],
            [0.0, 6.0],
            [0.0, 7.0],
            [0.0, 8.0],
            [0.0, 9.0],
            [0.0, 10.0],
            [0.0, 11.0],
            [0.0, 12.0],
            [0.0, 13.0],
            [0.0, 14.0],
            [0.0, 15.0],
            [0.0, 16.0],
            [0.0, 17.0],
            [0.0, 18.0],
            [0.0, 19.0],
            [0.0, 20.0],
            [0.0, 21.0],
            [0.0, 22.0],
            [0.0, 23.0],
            [1.0, 0.0],
            [1.0, 1.0],
            [1.0, 2.0],
            [1.0, 3.0],
            [1.0, 4.0],
            [1.0, 5.0],
            [1.0, 6.0],
            [1.0, 7.0],
            [1.0, 8.0],
            [1.0, 9.0],
            [1.0, 10.0],
            [1.0, 11.0],
            [1.0, 12.0],
            [1.0, 13.0],
            [1.0, 14.0],
            [1.0, 15.0],
            [1.0, 16.0],
            [1.0, 17.0],
            [1.0, 18.0],
            [1.0, 19.0],
            [1.0, 20.0],
            [1.0, 21.0],
            [1.0, 22.0],
            [1.0, 23.0],
            [2.0, 0.0],
            [2.0, 1.0],
            [2.0, 2.0],
            [2.0, 3.0],
            [2.0, 4.0],
            [2.0, 5.0],
            [2.0, 6.0],
            [2.0, 7.0],
            [2.0, 8.0],
            [2.0, 9.0],
            [2.0, 10.0],
            [2.0, 11.0],
            [2.0, 12.0],
            [2.0, 13.0],
            [2.0, 14.0],
            [2.0, 15.0],
            [2.0, 16.0],
            [2.0, 17.0],
            [2.0, 18.0],
            [2.0, 19.0],
            [2.0, 20.0],
            [2.0, 21.0],
            [2.0, 22.0],
            [2.0, 23.0],
            [3.0, 0.0],
            [3.0, 1.0],
            [3.0, 2.0],
            [3.0, 3.0],
            [3.0, 4.0],
            [3.0, 5.0],
            [3.0, 6.0],
            [3.0, 7.0],
            [3.0, 8.0],
            [3.0, 9.0],
            [3.0, 10.0],
            [3.0, 11.0],
            [3.0, 12.0],
            [3.0, 13.0],
            [3.0, 14.0],
            [3.0, 15.0],
            [3.0, 16.0],
            [3.0, 17.0],
            [3.0, 18.0],
            [3.0, 19.0],
            [3.0, 20.0],
            [3.0, 21.0],
            [3.0, 22.0],
            [3.0, 23.0],
            [4.0, 0.0],
            [4.0, 1.0],
            [4.0, 2.0],
            [4.0, 3.0],
            [4.0, 4.0],
            [4.0, 5.0],
            [4.0, 6.0],
            [4.0, 7.0],
            [4.0, 8.0],
            [4.0, 9.0],
            [4.0, 10.0],
            [4.0, 11.0],
            [4.0, 12.0],
            [4.0, 13.0],
            [4.0, 14.0],
            [4.0, 15.0],
            [4.0, 16.0],
            [4.0, 17.0],
            [4.0, 18.0],
            [4.0, 19.0],
            [4.0, 20.0],
            [4.0, 21.0],
            [4.0, 22.0],
            [4.0, 23.0],
            [5.0, 0.0],
            [5.0, 1.0],
            [5.0, 2.0],
            [5.0, 3.0],
            [5.0, 4.0],
            [5.0, 5.0],
            [5.0, 6.0],
            [5.0, 7.0],
            [5.0, 8.0],
            [5.0, 9.0],
            [5.0, 10.0],
            [5.0, 11.0],
            [5.0, 12.0],
            [5.0, 13.0],
            [5.0, 14.0],
            [5.0, 15.0],
            [5.0, 16.0],
            [5.0, 17.0],
            [5.0, 18.0],
            [5.0, 19.0],
            [5.0, 20.0],
            [5.0, 21.0],
            [5.0, 22.0],
            [5.0, 23.0],
            [6.0, 0.0],
            [6.0, 1.0],
            [6.0, 2.0],
            [6.0, 3.0],
            [6.0, 4.0],
            [6.0, 5.0],
            [6.0, 6.0],
            [6.0, 7.0],
            [6.0, 8.0],
            [6.0, 9.0],
            [6.0, 10.0],
            [6.0, 11.0],
            [6.0, 12.0],
            [6.0, 13.0],
            [6.0, 14.0],
            [6.0, 15.0],
            [6.0, 16.0],
            [6.0, 17.0],
            [6.0, 18.0],
            [6.0, 19.0],
            [6.0, 20.0],
            [6.0, 21.0],
            [6.0, 22.0],
            [6.0, 23.0],
            [0.0, 0.0],
        ]
    ).expand_dims(axis=0)


def load_ytrain():
    return nd.array(
        [
            [
                3.392694091796875000e02,
                3.198630065917968750e02,
                3.210045776367187500e02,
                3.175798950195312500e02,
                3.130137023925781250e02,
                4.615182800292968750e02,
                5.757534179687500000e02,
                5.871689453125000000e02,
                6.362899780273437500e02,
                6.785616455078125000e02,
                7.677511596679687500e02,
                9.501369628906250000e02,
                1.041723754882812500e03,
                1.016529663085937500e03,
                9.112100219726562500e02,
                1.019965759277343750e03,
                1.019977172851562500e03,
                1.055456665039062500e03,
                1.033710083007812500e03,
                7.803538818359375000e02,
                7.322830810546875000e02,
                4.934931640625000000e02,
                3.872488708496093750e02,
                3.655593566894531250e02,
                3.747031860351562500e02,
                3.518378906250000000e02,
                3.621347045898437500e02,
                3.427054748535156250e02,
                3.461187133789062500e02,
                4.992009277343750000e02,
                6.488584594726562500e02,
                6.145890502929687500e02,
                6.888356323242187500e02,
                7.624086914062500000e02,
                7.517237548828125000e02,
                9.593036499023437500e02,
                9.810502319335937500e02,
                1.038287719726562500e03,
                9.249543457031250000e02,
                1.033710083007812500e03,
                1.079497680664062500e03,
                1.050879028320312500e03,
                9.673059082031250000e02,
                7.490639038085937500e02,
                7.319063720703125000e02,
                4.854908752441406250e02,
                3.826940612792968750e02,
                3.644178161621093750e02,
                3.667009277343750000e02,
                3.506963500976562500e02,
                3.438470458984375000e02,
                3.267123413085937500e02,
                3.347031860351562500e02,
                4.923515930175781250e02,
                6.385730590820312500e02,
                6.180136718750000000e02,
                6.766895141601562500e02,
                6.880822143554687500e02,
                7.643150634765625000e02,
                1.010810485839843750e03,
                1.053173461914062500e03,
                1.042876708984375000e03,
                9.570091552734375000e02,
                1.054303710937500000e03,
                1.118424682617187500e03,
                1.089805908203125000e03,
                9.661757812500000000e02,
                7.852968139648437500e02,
                7.608903808593750000e02,
                4.912100524902343750e02,
                3.803995361328125000e02,
                3.586986389160156250e02,
                3.667009277343750000e02,
                3.461187133789062500e02,
                3.609817199707031250e02,
                3.449771728515625000e02,
                3.404109497070312500e02,
                4.843721313476562500e02,
                6.560958862304687500e02,
                6.214497680664062500e02,
                6.937899780273437500e02,
                7.357191772460937500e02,
                7.421917724609375000e02,
                9.673173217773437500e02,
                9.375456542968750000e02,
                8.986301269531250000e02,
                9.787671508789062500e02,
                1.026849365234375000e03,
                9.684703369140625000e02,
                9.066552734375000000e02,
                8.253767089843750000e02,
                7.277055053710937500e02,
                7.002625732421875000e02,
                4.809360656738281250e02,
                3.712785339355468750e02,
                3.518378906250000000e02,
                3.552625427246093750e02,
                3.426940612792968750e02,
                3.438470458984375000e02,
                3.324201049804687500e02,
                3.278538818359375000e02,
                4.923401794433593750e02,
                6.351483764648437500e02,
                6.054566040039062500e02,
                6.796917724609375000e02,
                6.983789672851562500e02,
                7.273287963867187500e02,
                9.192237548828125000e02,
                9.512785644531250000e02,
                9.547260131835937500e02,
                9.169406127929687500e02,
                1.023401855468750000e03,
                1.011940612792968750e03,
                1.018824218750000000e03,
                9.146575317382812500e02,
                8.070548095703125000e02,
                7.444863281250000000e02,
                5.072031860351562500e02,
                3.998287658691406250e02,
                3.575570678710937500e02,
                3.598401794433593750e02,
                3.438356018066406250e02,
                3.472716979980468750e02,
                3.381278686523437500e02,
                3.426940612792968750e02,
                6.206963500976562500e02,
                5.837442626953125000e02,
                6.111643676757812500e02,
                7.471689453125000000e02,
                7.593721313476562500e02,
                8.070548095703125000e02,
                9.604451904296875000e02,
                1.025707763671875000e03,
                9.741781005859375000e02,
                9.364155273437500000e02,
                1.019965759277343750e03,
                1.085216918945312500e03,
                9.970662231445312500e02,
                8.929109497070312500e02,
                7.597374267578125000e02,
                7.505822143554687500e02,
                5.083447570800781250e02,
                3.986872253417968750e02,
                3.689954223632812500e02,
                3.769862976074218750e02,
                3.506849365234375000e02,
                3.552739868164062500e02,
                3.404223632812500000e02,
                3.312785339355468750e02,
                5.711757812500000000e02,
                5.403310546875000000e02,
                6.317237548828125000e02,
                7.059703369140625000e02,
                7.517579956054687500e02,
                8.024657592773437500e02,
                1.046301391601562500e03,
                1.109269409179687500e03,
                1.121860717773437500e03,
                1.015388122558593750e03,
                1.094383544921875000e03,
                1.151620971679687500e03,
                1.062317382812500000e03,
                1.077191772460937500e03,
                8.036187133789062500e02,
                7.216096191406250000e02,
                5.003424682617187500e02,
                3.964041137695312500e02,
                3.735616455078125000e02,
            ],
            [
                2.263374519348144531e01,
                2.932098770141601562e01,
                2.932098770141601562e01,
                2.949245452880859375e01,
                2.880658531188964844e01,
                2.657750320434570312e01,
                2.263374519348144531e01,
                1.886145401000976562e01,
                2.434842300415039062e01,
                3.137860107421875000e01,
                2.400548744201660156e01,
                2.897805213928222656e01,
                3.377914810180664062e01,
                3.360768127441406250e01,
                3.240740585327148438e01,
                3.275034332275390625e01,
                2.880658531188964844e01,
                2.743484306335449219e01,
                3.755144119262695312e01,
                3.635116577148437500e01,
                3.703703689575195312e01,
                4.098079681396484375e01,
                3.275034332275390625e01,
                2.897805213928222656e01,
                3.086419677734375000e01,
                2.726337432861328125e01,
                1.920438957214355469e01,
                2.777777862548828125e01,
                2.846364974975585938e01,
                2.331961631774902344e01,
                1.406035709381103516e01,
                2.640603637695312500e01,
                2.537722969055175781e01,
                2.572016525268554688e01,
                3.240740585327148438e01,
                2.743484306335449219e01,
                2.897805213928222656e01,
                2.726337432861328125e01,
                2.006172752380371094e01,
                3.069272994995117188e01,
                3.000685882568359375e01,
                2.503429412841796875e01,
                3.000685882568359375e01,
                3.858024597167968750e01,
                3.789437484741210938e01,
                3.240740585327148438e01,
                3.480795669555664062e01,
                2.589163208007812500e01,
                2.263374519348144531e01,
                1.954732513427734375e01,
                1.920438957214355469e01,
                1.817558288574218750e01,
                2.006172752380371094e01,
                1.543209838867187500e01,
                1.406035709381103516e01,
                2.280521202087402344e01,
                3.275034332275390625e01,
                3.412208557128906250e01,
                3.360768127441406250e01,
                3.446501922607421875e01,
                3.515089035034179688e01,
                3.395061874389648438e01,
                2.846364974975585938e01,
                2.949245452880859375e01,
                3.017832565307617188e01,
                2.777777862548828125e01,
                3.446501922607421875e01,
                4.526749038696289062e01,
                3.943758392333984375e01,
                4.818244171142578125e01,
                3.737997436523437500e01,
                3.480795669555664062e01,
                2.400548744201660156e01,
                2.623456764221191406e01,
                2.760630989074707031e01,
                2.846364974975585938e01,
                2.932098770141601562e01,
                1.851851844787597656e01,
                2.383401870727539062e01,
                2.914951896667480469e01,
                2.897805213928222656e01,
                2.709190750122070312e01,
                3.343621444702148438e01,
                3.292181015014648438e01,
                3.772290802001953125e01,
                3.858024597167968750e01,
                3.326474761962890625e01,
                2.589163208007812500e01,
                3.172153663635253906e01,
                3.377914810180664062e01,
                4.406721496582031250e01,
                4.749657058715820312e01,
                4.406721496582031250e01,
                3.446501922607421875e01,
                3.960905456542968750e01,
                3.463648986816406250e01,
                3.189300346374511719e01,
                3.034979438781738281e01,
                3.069272994995117188e01,
                2.880658531188964844e01,
                2.897805213928222656e01,
                2.143346977233886719e01,
                2.331961631774902344e01,
                2.520576095581054688e01,
                2.109053421020507812e01,
                2.777777862548828125e01,
                3.000685882568359375e01,
                3.017832565307617188e01,
                3.343621444702148438e01,
                3.223593902587890625e01,
                2.503429412841796875e01,
                3.446501922607421875e01,
                3.343621444702148438e01,
                2.812071418762207031e01,
                2.897805213928222656e01,
                3.995198822021484375e01,
                3.377914810180664062e01,
                3.515089035034179688e01,
                3.703703689575195312e01,
                2.897805213928222656e01,
                2.366255187988281250e01,
                2.812071418762207031e01,
                2.760630989074707031e01,
                2.143346977233886719e01,
                2.743484306335449219e01,
                2.589163208007812500e01,
                2.177640533447265625e01,
                2.057613182067871094e01,
                3.292181015014648438e01,
                2.486282539367675781e01,
                2.589163208007812500e01,
                4.200960159301757812e01,
                3.086419677734375000e01,
                3.412208557128906250e01,
                3.840877914428710938e01,
                3.155006790161132812e01,
                3.600823211669921875e01,
                3.669410324096679688e01,
                3.446501922607421875e01,
                3.720850372314453125e01,
                4.406721496582031250e01,
                3.326474761962890625e01,
                3.532236099243164062e01,
                3.858024597167968750e01,
                3.275034332275390625e01,
                2.194787406921386719e01,
                2.897805213928222656e01,
                2.863511657714843750e01,
                2.469135856628417969e01,
                2.331961631774902344e01,
                2.554869651794433594e01,
                2.143346977233886719e01,
                2.486282539367675781e01,
                2.743484306335449219e01,
                2.383401870727539062e01,
                3.069272994995117188e01,
                2.794924545288085938e01,
                2.812071418762207031e01,
                2.434842300415039062e01,
                1.989026069641113281e01,
                1.971879196166992188e01,
                2.194787406921386719e01,
                2.486282539367675781e01,
                3.360768127441406250e01,
                3.343621444702148438e01,
                3.206447219848632812e01,
                3.034979438781738281e01,
                2.349108314514160156e01,
            ],
            [
                1.214824981689453125e02,
                1.192518844604492188e02,
                1.103294448852539062e02,
                1.139327392578125000e02,
                1.137611541748046875e02,
                1.456760406494140625e02,
                1.597460479736328125e02,
                1.443033599853515625e02,
                1.691832580566406250e02,
                1.798215484619140625e02,
                1.918325347900390625e02,
                1.990391235351562500e02,
                1.932052154541015625e02,
                2.007549743652343750e02,
                2.069320526123046875e02,
                2.084763183593750000e02,
                2.134523010253906250e02,
                2.148249816894531250e02,
                2.132807159423828125e02,
                2.143102264404296875e02,
                2.086479034423828125e02,
                1.935483856201171875e02,
                1.743308105468750000e02,
                1.717570343017578125e02,
                1.662662963867187500e02,
                1.657515411376953125e02,
                1.580301971435546875e02,
                1.626630096435546875e02,
                1.640356903076171875e02,
                1.841111907958984375e02,
                2.000686340332031250e02,
                1.853122863769531250e02,
                2.057309570312500000e02,
                2.074468078613281250e02,
                2.151681518554687500e02,
                2.095058288574218750e02,
                2.088194885253906250e02,
                2.156829071044921875e02,
                2.189430389404296875e02,
                2.215168151855468750e02,
                2.287234039306640625e02,
                2.292381591796875000e02,
                2.230610809326171875e02,
                2.177419281005859375e02,
                2.115648651123046875e02,
                1.921757049560546875e02,
                1.741592254638671875e02,
                1.535689697265625000e02,
                1.590597076416015625e02,
                1.606039733886718750e02,
                1.568291015625000000e02,
                1.571722717285156250e02,
                1.575154418945312500e02,
                1.911461944580078125e02,
                1.866849670410156250e02,
                1.885724029541015625e02,
                2.033287506103515625e02,
                2.115648651123046875e02,
                2.316403503417968750e02,
                2.280370635986328125e02,
                2.302676696777343750e02,
                2.395332946777343750e02,
                2.343857269287109375e02,
                2.278654785156250000e02,
                2.285518188476562500e02,
                2.268359680175781250e02,
                2.184282836914062500e02,
                2.112216949462890625e02,
                2.155113220214843750e02,
                2.148249816894531250e02,
                1.988675384521484375e02,
                1.842827758789062500e02,
                1.726149597167968750e02,
                1.806794738769531250e02,
                1.762182617187500000e02,
                1.774193572998046875e02,
                1.835964355468750000e02,
                1.964653472900390625e02,
                2.240905914306640625e02,
                1.781056976318359375e02,
                1.878860626220703125e02,
                1.969801025390625000e02,
                2.091626586914062500e02,
                2.098489990234375000e02,
                2.163692474365234375e02,
                2.210020599365234375e02,
                2.251201171875000000e02,
                2.242621765136718750e02,
                2.196293792724609375e02,
                2.276938934326171875e02,
                2.225463256835937500e02,
                2.210020599365234375e02,
                2.047014465332031250e02,
                1.944063110351562500e02,
                1.722717895507812500e02,
                1.523678741455078125e02,
                1.559711761474609375e02,
                1.551132507324218750e02,
                1.513383636474609375e02,
                1.544269104003906250e02,
                1.530542144775390625e02,
                1.871997222900390625e02,
                1.799931335449218750e02,
                1.717570343017578125e02,
                1.935483856201171875e02,
                1.969801025390625000e02,
                2.067604675292968750e02,
                2.228894958496093750e02,
                2.105353393554687500e02,
                2.149965667724609375e02,
                2.024708251953125000e02,
                2.409059753417968750e02,
                2.491420745849609375e02,
                2.283802337646484375e02,
                2.213452301025390625e02,
                2.198009643554687500e02,
                2.007549743652343750e02,
                1.859986267089843750e02,
                1.739876403808593750e02,
                1.583733673095703125e02,
                1.376115264892578125e02,
                1.377831115722656250e02,
                1.362388458251953125e02,
                1.353809204101562500e02,
                1.431022644042968750e02,
                1.695264282226562500e02,
                1.822237548828125000e02,
                1.703843536376953125e02,
                1.896019287109375000e02,
                1.983527832031250000e02,
                2.048730316162109375e02,
                2.052162017822265625e02,
                2.062457122802734375e02,
                2.081331481933593750e02,
                2.047014465332031250e02,
                2.149965667724609375e02,
                2.047014465332031250e02,
                2.055593719482421875e02,
                2.227179107666015625e02,
                2.113932800292968750e02,
                1.998970489501953125e02,
                1.817089843750000000e02,
                1.657515411376953125e02,
                1.499656829833984375e02,
                1.364104309082031250e02,
                1.312628631591796875e02,
                1.283459167480468750e02,
                1.250857925415039062e02,
                1.264584732055664062e02,
                1.654083709716796875e02,
                1.798215484619140625e02,
                1.643788604736328125e02,
                1.904598541259765625e02,
                1.921757049560546875e02,
                2.069320526123046875e02,
                2.215168151855468750e02,
                2.185998687744140625e02,
                2.246053466796875000e02,
                2.259780426025390625e02,
                2.304392547607421875e02,
                2.283802337646484375e02,
                2.264927978515625000e02,
                2.222031555175781250e02,
                2.115648651123046875e02,
                2.010981445312500000e02,
                1.944063110351562500e02,
                1.676389770507812500e02,
                1.460192108154296875e02,
            ],
            [
                6.946183013916015625e01,
                6.226533126831054688e01,
                6.007509231567382812e01,
                5.913642120361328125e01,
                5.788485717773437500e01,
                6.289111328125000000e01,
                4.787234115600585938e01,
                5.287859725952148438e01,
                5.287859725952148438e01,
                6.038798522949218750e01,
                6.570713043212890625e01,
                7.196495819091796875e01,
                7.352941131591796875e01,
                6.007509231567382812e01,
                5.851063919067382812e01,
                6.695870208740234375e01,
                6.289111328125000000e01,
                7.259073638916015625e01,
                9.355444335937500000e01,
                8.573216247558593750e01,
                9.793492126464843750e01,
                1.013767242431640625e02,
                1.004380493164062500e02,
                7.884856414794921875e01,
                6.727159118652343750e01,
                6.351689529418945312e01,
                6.351689529418945312e01,
                6.226533126831054688e01,
                6.289111328125000000e01,
                6.821026611328125000e01,
                4.630788421630859375e01,
                5.162703323364257812e01,
                5.037546920776367188e01,
                6.070087432861328125e01,
                6.821026611328125000e01,
                7.446808624267578125e01,
                7.415519714355468750e01,
                6.758448028564453125e01,
                6.539424133300781250e01,
                6.602002716064453125e01,
                6.226533126831054688e01,
                7.133917236328125000e01,
                8.854818725585937500e01,
                8.823529052734375000e01,
                1.041927413940429688e02,
                1.029411773681640625e02,
                9.699624633789062500e01,
                7.634542846679687500e01,
                6.758448028564453125e01,
                6.445556640625000000e01,
                6.351689529418945312e01,
                6.101376724243164062e01,
                5.976220321655273438e01,
                6.789736938476562500e01,
                5.225281524658203125e01,
                4.724655914306640625e01,
                5.131414413452148438e01,
                6.508135223388671875e01,
                7.478097534179687500e01,
                7.384230041503906250e01,
                6.163954925537109375e01,
                6.476846313476562500e01,
                6.414267730712890625e01,
                5.694618225097656250e01,
                6.508135223388671875e01,
                6.914893341064453125e01,
                7.947434234619140625e01,
                8.604505920410156250e01,
                1.001251602172851562e02,
                9.793492126464843750e01,
                9.167709350585937500e01,
                7.790988922119140625e01,
                6.789736938476562500e01,
                6.633291625976562500e01,
                6.351689529418945312e01,
                6.226533126831054688e01,
                6.195244216918945312e01,
                6.476846313476562500e01,
                5.225281524658203125e01,
                5.068836212158203125e01,
                5.413016128540039062e01,
                5.757196426391601562e01,
                7.352941131591796875e01,
                7.321652221679687500e01,
                7.196495819091796875e01,
                6.163954925537109375e01,
                5.882352828979492188e01,
                6.414267730712890625e01,
                6.476846313476562500e01,
                7.790988922119140625e01,
                9.824781036376953125e01,
                8.604505920410156250e01,
                1.026282882690429688e02,
                1.091989974975585938e02,
                1.073216552734375000e02,
                8.541927337646484375e01,
                7.415519714355468750e01,
                6.852315521240234375e01,
                6.289111328125000000e01,
                6.070087432861328125e01,
                6.101376724243164062e01,
                6.414267730712890625e01,
                5.256570816040039062e01,
                4.943679428100585938e01,
                6.070087432861328125e01,
                7.571965026855468750e01,
                8.792240142822265625e01,
                8.698372650146484375e01,
                7.822277832031250000e01,
                7.133917236328125000e01,
                7.227784729003906250e01,
                6.602002716064453125e01,
                6.883604431152343750e01,
                6.977471923828125000e01,
                7.978723144531250000e01,
                9.042552947998046875e01,
                1.057571945190429688e02,
                1.007509384155273438e02,
                9.762202453613281250e01,
                8.479349517822265625e01,
                7.165206146240234375e01,
                6.821026611328125000e01,
                6.226533126831054688e01,
                6.195244216918945312e01,
                7.478097534179687500e01,
                5.882352828979492188e01,
                4.974968719482421875e01,
                5.381727218627929688e01,
                6.007509231567382812e01,
                7.259073638916015625e01,
                7.603253936767578125e01,
                8.573216247558593750e01,
                8.698372650146484375e01,
                8.041301727294921875e01,
                7.853566741943359375e01,
                8.197747039794921875e01,
                7.603253936767578125e01,
                8.948686218261718750e01,
                8.948686218261718750e01,
                9.230287933349609375e01,
                9.230287933349609375e01,
                9.511889648437500000e01,
                9.543179321289062500e01,
                8.823529052734375000e01,
                8.166458129882812500e01,
                7.133917236328125000e01,
                6.195244216918945312e01,
                6.038798522949218750e01,
                5.976220321655273438e01,
                6.883604431152343750e01,
                4.849812316894531250e01,
                5.319149017333984375e01,
                6.382978820800781250e01,
                7.634542846679687500e01,
                9.261576843261718750e01,
                1.001251602172851562e02,
                8.573216247558593750e01,
                6.539424133300781250e01,
                5.600751113891601562e01,
                5.694618225097656250e01,
                5.538172531127929688e01,
                6.382978820800781250e01,
                7.790988922119140625e01,
                8.197747039794921875e01,
                1.029411773681640625e02,
                1.135794754028320312e02,
                1.004380493164062500e02,
                8.479349517822265625e01,
            ],
            [
                4.069791030883789062e01,
                4.158940505981445312e01,
                3.891365432739257812e01,
                3.942435073852539062e01,
                4.057055664062500000e01,
                6.334054946899414062e01,
                5.866785430908203125e01,
                6.113219451904296875e01,
                7.438232421875000000e01,
                8.779418945312500000e01,
                9.533239746093750000e01,
                9.737519073486328125e01,
                9.609780883789062500e01,
                9.724783325195312500e01,
                9.839658355712890625e01,
                1.000573120117187500e02,
                1.004406509399414062e02,
                1.027394256591796875e02,
                9.839658355712890625e01,
                1.037621002197265625e02,
                9.520503997802734375e01,
                7.690779113769531250e01,
                4.783494567871093750e01,
                4.464849853515625000e01,
                4.490448379516601562e01,
                4.630667495727539062e01,
                4.362837600708007812e01,
                4.528655242919921875e01,
                4.452114105224609375e01,
                6.675624084472656250e01,
                7.067881011962890625e01,
                6.830870819091796875e01,
                7.859780883789062500e01,
                9.124427032470703125e01,
                9.673586273193359375e01,
                9.367167663574218750e01,
                9.852394104003906250e01,
                9.699057769775390625e01,
                9.647988128662109375e01,
                1.008239974975585938e02,
                1.017180328369140625e02,
                1.015906753540039062e02,
                1.017193069458007812e02,
                9.545848083496093750e01,
                9.341441345214843750e01,
                7.792536926269531250e01,
                5.165945053100585938e01,
                4.707080841064453125e01,
                4.719816589355468750e01,
                4.643275451660156250e01,
                4.579597473144531250e01,
                4.656138610839843750e01,
                4.732552337646484375e01,
                7.882450103759765625e01,
                7.118950653076171875e01,
                7.361691284179687500e01,
                8.600611114501953125e01,
                1.018466644287109375e02,
                9.929190063476562500e01,
                1.051681137084960938e02,
                1.092536926269531250e02,
                1.017180328369140625e02,
                1.055514526367187500e02,
                1.087442703247070312e02,
                1.073382568359375000e02,
                1.014620513916015625e02,
                1.061895065307617188e02,
                9.954534149169921875e01,
                9.418109893798828125e01,
                7.562786865234375000e01,
                4.923586273193359375e01,
                4.630540084838867188e01,
                4.643275451660156250e01,
                4.643275451660156250e01,
                4.477585220336914062e01,
                4.541263198852539062e01,
                4.388181304931640625e01,
                6.921293640136718750e01,
                7.013372039794921875e01,
                6.910977935791015625e01,
                8.690015411376953125e01,
                1.012073364257812500e02,
                1.023560867309570312e02,
                1.006953659057617188e02,
                9.967396545410156250e01,
                9.980132293701171875e01,
                1.022287292480468750e02,
                1.095096817016601562e02,
                1.096370315551757812e02,
                1.024847183227539062e02,
                1.031240463256835938e02,
                1.026120758056640625e02,
                9.277508544921875000e01,
                7.511716461181640625e01,
                4.872771453857421875e01,
                4.273560714721679688e01,
                4.311894989013671875e01,
                4.107997894287109375e01,
                3.980641937255859375e01,
                4.006113052368164062e01,
                3.853158569335937500e01,
                6.669383239746093750e01,
                6.282093811035156250e01,
                6.205807495117187500e01,
                8.000127410888671875e01,
                9.022160339355468750e01,
                9.839531707763671875e01,
                9.941798400878906250e01,
                1.023573608398437500e02,
                1.008239974975585938e02,
                1.035061111450195312e02,
                1.044001541137695312e02,
                1.088716278076171875e02,
                1.124477844238281250e02,
                1.075929718017578125e02,
                1.008239974975585938e02,
                9.622644042968750000e01,
                9.073229980468750000e01,
                6.257386779785156250e01,
                4.311894989013671875e01,
                4.299032211303710938e01,
                4.273815536499023438e01,
                4.095262527465820312e01,
                4.082526779174804688e01,
                4.146204757690429688e01,
                7.409832000732421875e01,
                6.358507537841796875e01,
                6.754330444335937500e01,
                8.396331787109375000e01,
                9.405374145507812500e01,
                1.013346939086914062e02,
                1.063155899047851562e02,
                1.123204269409179688e02,
                1.139798812866210938e02,
                1.114251174926757812e02,
                1.038894577026367188e02,
                1.175560379028320312e02,
                1.093823242187500000e02,
                1.097656631469726562e02,
                1.035061111450195312e02,
                9.890728759765625000e01,
                9.341568756103515625e01,
                6.959373474121093750e01,
                4.503183746337890625e01,
                4.515919494628906250e01,
                4.388308715820312500e01,
                4.069791030883789062e01,
                4.082526779174804688e01,
                4.069791030883789062e01,
                6.576541137695312500e01,
                6.329724884033203125e01,
                6.716250610351562500e01,
                8.204534149169921875e01,
                9.405374145507812500e01,
                1.003120193481445312e02,
                1.045287857055664062e02,
                1.082335739135742188e02,
                1.067002029418945312e02,
                1.054215469360351562e02,
                1.070835418701171875e02,
                1.100216522216796875e02,
                1.037608261108398438e02,
                9.865257263183593750e01,
                9.775852966308593750e01,
                9.711793518066406250e01,
                8.137290191650390625e01,
                4.974656295776367188e01,
                4.464849853515625000e01,
            ],
            [
                1.140194625854492188e02,
                1.181511993408203125e02,
                1.222866744995117188e02,
                1.147717056274414062e02,
                1.102619781494140625e02,
                1.170284423828125000e02,
                1.421856231689453125e02,
                1.713136291503906250e02,
                1.703555450439453125e02,
                1.906886291503906250e02,
                2.291916198730468750e02,
                2.488061370849609375e02,
                2.491841278076171875e02,
                2.295696105957031250e02,
                2.412574920654296875e02,
                2.488061370849609375e02,
                2.601235046386718750e02,
                2.408869781494140625e02,
                2.397492523193359375e02,
                2.078667602539062500e02,
                1.358046417236328125e02,
                1.249139251708984375e02,
                1.219124221801757812e02,
                1.155202102661132812e02,
                1.162761993408203125e02,
                1.196519470214843750e02,
                1.245359268188476562e02,
                1.189034423828125000e02,
                1.162761993408203125e02,
                1.410591278076171875e02,
                1.515793457031250000e02,
                2.093974609375000000e02,
                2.220247039794921875e02,
                2.397567291259765625e02,
                2.518263397216796875e02,
                2.555950622558593750e02,
                2.435254516601562500e02,
                2.242926635742187500e02,
                1.980613708496093750e02,
                2.208907165527343750e02,
                2.337163238525390625e02,
                2.310778503417968750e02,
                1.957934112548828125e02,
                1.893824920654296875e02,
                1.403068847656250000e02,
                1.264146728515625000e02,
                1.207821884155273438e02,
                1.155239486694335938e02,
                1.166504516601562500e02,
                1.189071884155273438e02,
                1.252881698608398438e02,
                1.192814407348632812e02,
                1.158982009887695312e02,
                1.414371185302734375e02,
                1.583345794677734375e02,
                2.112799377441406250e02,
                2.442814331054687500e02,
                2.499401245117187500e02,
                2.529528503417968750e02,
                2.495583801269531250e02,
                2.552208099365234375e02,
                2.488061370849609375e02,
                2.465456542968750000e02,
                2.503181152343750000e02,
                2.552208099365234375e02,
                2.559693145751953125e02,
                2.484281463623046875e02,
                2.325860748291015625e02,
                1.423989562988281250e02,
                1.241654205322265625e02,
                1.192739486694335938e02,
                1.155202102661132812e02,
                1.158944625854492188e02,
                1.185254516601562500e02,
                1.256624221801757812e02,
                1.189034423828125000e02,
                1.155239486694335938e02,
                1.403106231689453125e02,
                1.538323364257812500e02,
                2.082634735107421875e02,
                2.152357788085937500e02,
                2.340943145751953125e02,
                2.457896728515625000e02,
                2.461676635742187500e02,
                2.337163238525390625e02,
                2.363622741699218750e02,
                2.261751556396484375e02,
                2.431474609375000000e02,
                2.427694549560546875e02,
                2.205127258300781250e02,
                1.759880218505859375e02,
                1.863398132324218750e02,
                1.354266510009765625e02,
                1.200299377441406250e02,
                1.158982009887695312e02,
                1.110142211914062500e02,
                1.098877258300781250e02,
                1.125187149047851562e02,
                1.181549377441406250e02,
                1.113884735107421875e02,
                1.065119781494140625e02,
                1.335516510009765625e02,
                1.425636291503906250e02,
                1.694386291503906250e02,
                1.718562927246093750e02,
                1.916429595947265625e02,
                2.276871185302734375e02,
                2.446556854248046875e02,
                2.371145172119140625e02,
                2.333420715332031250e02,
                2.186302337646484375e02,
                2.431474609375000000e02,
                2.593675231933593750e02,
                2.529565887451171875e02,
                2.537088317871093750e02,
                2.352245483398437500e02,
                1.369311370849609375e02,
                1.219049377441406250e02,
                1.173989486694335938e02,
                1.132709579467773438e02,
                1.125187149047851562e02,
                1.151459579467773438e02,
                1.204079360961914062e02,
                1.140194625854492188e02,
                1.102619781494140625e02,
                1.327994079589843750e02,
                1.433121185302734375e02,
                1.943188629150390625e02,
                1.980651245117187500e02,
                2.193824920654296875e02,
                2.363622741699218750e02,
                2.540868225097656250e02,
                2.544648132324218750e02,
                2.593712463378906250e02,
                2.537125701904296875e02,
                2.457896728515625000e02,
                2.578592834472656250e02,
                2.601235046386718750e02,
                2.533308410644531250e02,
                2.446594238281250000e02,
                1.469086761474609375e02,
                1.222829360961914062e02,
                1.185291900634765625e02,
                1.147717056274414062e02,
                1.136414642333984375e02,
                1.151459579467773438e02,
                1.215344314575195312e02,
                1.136414642333984375e02,
                1.102619781494140625e02,
                1.331736602783203125e02,
                1.436901245117187500e02,
                1.984767913818359375e02,
                1.948652648925781250e02,
                2.276796417236328125e02,
                2.597492370605468750e02,
                2.631399841308593750e02,
                2.593675231933593750e02,
                2.604977416992187500e02,
                2.805651245117187500e02,
                2.882223205566406250e02,
                2.730014953613281250e02,
                2.786601867675781250e02,
                2.714932556152343750e02,
                2.461676635742187500e02,
                1.472866821289062500e02,
                1.256661682128906250e02,
                1.222829360961914062e02,
                1.166504516601562500e02,
            ],
            [
                1.792779235839843750e02,
                1.680313415527343750e02,
                1.694005432128906250e02,
                1.666689300537109375e02,
                1.663317413330078125e02,
                1.772343292236328125e02,
                2.585524597167968750e02,
                2.466008148193359375e02,
                2.790497131347656250e02,
                2.776839294433593750e02,
                2.957867736816406250e02,
                3.036410217285156250e02,
                2.995436096191406250e02,
                3.166212463378906250e02,
                3.152520446777343750e02,
                3.149114379882812500e02,
                3.258412780761718750e02,
                3.009093933105468750e02,
                3.087636108398437500e02,
                3.152520446777343750e02,
                3.179870605468750000e02,
                3.080824279785156250e02,
                2.722173156738281250e02,
                2.232629394531250000e02,
                2.017779235839843750e02,
                1.908719329833984375e02,
                1.860967254638671875e02,
                1.802997283935546875e02,
                1.782561340332031250e02,
                1.860933227539062500e02,
                2.691450805664062500e02,
                2.848569335937500000e02,
                3.053474121093750000e02,
                3.067132263183593750e02,
                3.442847290039062500e02,
                3.296015014648437500e02,
                3.268699035644531250e02,
                3.381403198242187500e02,
                3.203746643066406250e02,
                3.319856872558593750e02,
                3.405279235839843750e02,
                3.094482421875000000e02,
                3.073978271484375000e02,
                3.220844726562500000e02,
                3.265258789062500000e02,
                3.121764221191406250e02,
                2.705075073242187500e02,
                2.285047760009765625e02,
                2.080279235839843750e02,
                1.952997283935546875e02,
                1.932561340332031250e02,
                1.891689300537109375e02,
                1.867813415527343750e02,
                1.939373321533203125e02,
                2.598126831054687500e02,
                2.913453674316406250e02,
                3.084230346679687500e02,
                3.128610229492187500e02,
                3.299421081542968750e02,
                3.436069335937500000e02,
                3.336954956054687500e02,
                3.504325561523437500e02,
                3.330143127441406250e02,
                3.220810546875000000e02,
                3.391621398925781250e02,
                3.183310546875000000e02,
                3.050068054199218750e02,
                3.261818847656250000e02,
                3.299421081542968750e02,
                3.125204467773437500e02,
                2.691450805664062500e02,
                2.244005432128906250e02,
                2.059877319335937500e02,
                1.949625396728515625e02,
                1.925749359130859375e02,
                1.888283386230468750e02,
                1.884877319335937500e02,
                2.018937377929687500e02,
                2.729019165039062500e02,
                2.940769653320312500e02,
                3.244788818359375000e02,
                3.173024597167968750e02,
                3.381403198242187500e02,
                3.272104797363281250e02,
                3.466791687011718750e02,
                3.354053039550781250e02,
                3.289169006347656250e02,
                3.401873168945312500e02,
                3.425749206542968750e02,
                3.149114379882812500e02,
                3.039850158691406250e02,
                3.227656555175781250e02,
                3.237908630371093750e02,
                3.128610229492187500e02,
                2.708480834960937500e02,
                2.315735626220703125e02,
                1.884809265136718750e02,
                1.803031311035156250e02,
                1.813249359130859375e02,
                1.809809265136718750e02,
                1.799591217041015625e02,
                2.236273803710937500e02,
                2.558242492675781250e02,
                2.780245361328125000e02,
                3.012465820312500000e02,
                3.026158142089843750e02,
                3.309673156738281250e02,
                3.227690734863281250e02,
                3.282322998046875000e02,
                3.265258789062500000e02,
                3.357459106445312500e02,
                3.347207031250000000e02,
                3.381403198242187500e02,
                3.149148559570312500e02,
                3.162806396484375000e02,
                3.237908630371093750e02,
                3.097922363281250000e02,
                3.036410217285156250e02,
                2.612874755859375000e02,
                2.131403198242187500e02,
                1.905313415527343750e02,
                1.799625396728515625e02,
                1.782561340332031250e02,
                1.799591217041015625e02,
                1.779155273437500000e02,
                2.352384185791015625e02,
                2.548024597167968750e02,
                2.619686584472656250e02,
                2.992030029296875000e02,
                2.961273803710937500e02,
                3.138862304687500000e02,
                3.343800964355468750e02,
                3.330143127441406250e02,
                3.227690734863281250e02,
                3.152520446777343750e02,
                3.234502868652343750e02,
                3.323330993652343750e02,
                3.145708312988281250e02,
                3.002247924804687500e02,
                3.142302551269531250e02,
                3.193528747558593750e02,
                3.036376037597656250e02,
                2.551464538574218750e02,
                2.176907348632812500e02,
                1.946185302734375000e02,
                1.799625396728515625e02,
                1.802997283935546875e02,
                1.772343292236328125e02,
                1.809809265136718750e02,
                2.389918212890625000e02,
                2.565054626464843750e02,
                2.534298400878906250e02,
                2.937363891601562500e02,
                2.971525878906250000e02,
                3.091076354980468750e02,
                3.309638977050781250e02,
                3.336954956054687500e02,
                3.323297119140625000e02,
                3.251566772460937500e02,
                3.504359741210937500e02,
                3.449693603515625000e02,
                3.149114379882812500e02,
                3.104734191894531250e02,
                3.268630676269531250e02,
                3.268664855957031250e02,
                3.094482421875000000e02,
                2.691450805664062500e02,
                2.232697601318359375e02,
            ],
            [
                3.947381896972656250e02,
                3.778378295898437500e02,
                3.702280273437500000e02,
                3.660050659179687500e02,
                5.198479614257812500e02,
                5.274493408203125000e02,
                5.730996704101562500e02,
                5.959121704101562500e02,
                6.664611206054687500e02,
                7.358361206054687500e02,
                7.853547363281250000e02,
                8.268750000000000000e02,
                8.395861206054687500e02,
                8.141723022460937500e02,
                7.938428955078125000e02,
                8.760134887695312500e02,
                8.827871704101562500e02,
                8.395861206054687500e02,
                7.845185546875000000e02,
                7.489273681640625000e02,
                7.396115112304687500e02,
                5.734966430664062500e02,
                4.420692443847656250e02,
                4.124830932617187500e02,
                4.260135192871093750e02,
                4.116385192871093750e02,
                4.048817443847656250e02,
                4.031925659179687500e02,
                5.739357910156250000e02,
                5.967567749023437500e02,
                6.246536865234375000e02,
                6.195861206054687500e02,
                6.803969726562500000e02,
                7.751942749023437500e02,
                8.345017089843750000e02,
                7.743496704101562500e02,
                8.057009887695312500e02,
                8.124746704101562500e02,
                8.209459228515625000e02,
                8.539949340820312500e02,
                8.624661865234375000e02,
                8.192482910156250000e02,
                7.955321044921875000e02,
                7.692736206054687500e02,
                7.235134887695312500e02,
                5.726942749023437500e02,
                4.370101318359375000e02,
                4.133446044921875000e02,
                4.243243103027343750e02,
                4.133361511230468750e02,
                4.175675659179687500e02,
                4.226351318359375000e02,
                6.288598022460937500e02,
                6.711232910156250000e02,
                6.356503295898437500e02,
                6.880321044921875000e02,
                7.989189453125000000e02,
                8.972044067382812500e02,
                9.039780273437500000e02,
                8.709290771484375000e02,
                8.870354614257812500e02,
                8.734797363281250000e02,
                8.522973022460937500e02,
                8.921199340820312500e02,
                8.904138793945312500e02,
                8.607685546875000000e02,
                8.175591430664062500e02,
                7.299240112304687500e02,
                7.065709228515625000e02,
                5.743750000000000000e02,
                4.446114807128906250e02,
                3.998057556152343750e02,
                4.184121704101562500e02,
                3.998057556152343750e02,
                4.048733215332031250e02,
                4.065709533691406250e02,
                5.190033569335937500e02,
                5.959121704101562500e02,
                6.178969726562500000e02,
                6.588767089843750000e02,
                7.070354614257812500e02,
                7.896115112304687500e02,
                7.921536865234375000e02,
                7.870607910156250000e02,
                8.260303955078125000e02,
                7.921452636718750000e02,
                8.031588134765625000e02,
                8.683868408203125000e02,
                8.311148681640625000e02,
                7.896030273437500000e02,
                7.565625000000000000e02,
                7.112838134765625000e02,
                6.664696044921875000e02,
                5.337584228515625000e02,
                3.998057556152343750e02,
                3.803716125488281250e02,
                3.854391784667968750e02,
                3.676858215332031250e02,
                3.634628295898437500e02,
                3.685473022460937500e02,
                4.919510192871093750e02,
                5.536571044921875000e02,
                5.578800659179687500e02,
                5.790033569335937500e02,
                6.474830932617187500e02,
                7.463935546875000000e02,
                7.879053955078125000e02,
                8.090878295898437500e02,
                8.073901977539062500e02,
                7.692651977539062500e02,
                8.277280273437500000e02,
                8.700844726562500000e02,
                8.794088134765625000e02,
                8.345101318359375000e02,
                8.667060546875000000e02,
                7.523226318359375000e02,
                7.353800659179687500e02,
                6.554982910156250000e02,
                5.232178955078125000e02,
                3.938935852050781250e02,
                4.116469726562500000e02,
                3.896790466308593750e02,
                3.820608215332031250e02,
                3.854391784667968750e02,
                5.274408569335937500e02,
                6.001351318359375000e02,
                6.212753295898437500e02,
                6.322634887695312500e02,
                7.045017089843750000e02,
                8.387500000000000000e02,
                8.997381591796875000e02,
                8.912669067382812500e02,
                8.988851318359375000e02,
                8.548310546875000000e02,
                8.912669067382812500e02,
                9.107601318359375000e02,
                9.132939453125000000e02,
                8.497550659179687500e02,
                9.056672363281250000e02,
                8.285726318359375000e02,
                7.514780273437500000e02,
                6.580405273437500000e02,
                5.257601318359375000e02,
                3.837500000000000000e02,
                3.981250000000000000e02,
                3.964358215332031250e02,
                3.719172363281250000e02,
                3.829053955078125000e02,
                5.206756591796875000e02,
                5.705574340820312500e02,
                5.553463134765625000e02,
                6.233530273437500000e02,
                6.994172363281250000e02,
                8.336571044921875000e02,
                9.226182250976562500e02,
                9.056672363281250000e02,
                9.276942749023437500e02,
                8.683952636718750000e02,
                8.929560546875000000e02,
                1.004788879394531250e03,
                9.675169067382812500e02,
                9.285473022460937500e02,
                8.827955932617187500e02,
                8.014611206054687500e02,
                7.599493408203125000e02,
                5.938006591796875000e02,
                4.463006896972656250e02,
                3.896790466308593750e02,
            ],
            [
                4.006647109985351562e01,
                3.545051574707031250e01,
                2.289512634277343750e01,
                1.772525787353515625e01,
                1.070901012420654297e01,
                9.231905937194824219e00,
                7.016248226165771484e00,
                1.070901012420654297e01,
                1.920236396789550781e01,
                3.766617584228515625e01,
                4.523633575439453125e01,
                5.409896469116210938e01,
                6.776218414306640625e01,
                6.720827484130859375e01,
                5.816100311279296875e01,
                5.243722152709960938e01,
                5.649925994873046875e01,
                5.243722152709960938e01,
                6.037666320800781250e01,
                6.573117065429687500e01,
                6.831610107421875000e01,
                6.185376739501953125e01,
                5.391432952880859375e01,
                4.911373519897460938e01,
                4.689807891845703125e01,
                2.861890602111816406e01,
                2.437223052978515625e01,
                1.901772499084472656e01,
                1.052437210083007812e01,
                8.124076843261718750e00,
                7.385524272918701172e00,
                1.107828617095947266e01,
                2.621861076354980469e01,
                4.671343994140625000e01,
                5.539143371582031250e01,
                5.889955520629882812e01,
                7.200886535644531250e01,
                6.776218414306640625e01,
                6.093057632446289062e01,
                5.742245101928710938e01,
                5.391432952880859375e01,
                5.612998580932617188e01,
                5.723781204223632812e01,
                6.794682312011718750e01,
                6.443869781494140625e01,
                6.277695846557617188e01,
                6.517725372314453125e01,
                5.225258636474609375e01,
                5.040620422363281250e01,
                3.489660263061523438e01,
                2.381831550598144531e01,
                1.790989685058593750e01,
                1.181683921813964844e01,
                8.493352890014648438e00,
                8.493352890014648438e00,
                1.827917289733886719e01,
                3.175775527954101562e01,
                5.003692626953125000e01,
                5.649925994873046875e01,
                6.739290618896484375e01,
                7.090103149414062500e01,
                6.517725372314453125e01,
                5.889955520629882812e01,
                5.760708999633789062e01,
                5.760708999633789062e01,
                5.594534683227539062e01,
                5.889955520629882812e01,
                7.348596954345703125e01,
                7.256277465820312500e01,
                6.517725372314453125e01,
                5.982274627685546875e01,
                5.631462478637695312e01,
                4.689807891845703125e01,
                3.101920318603515625e01,
                2.511078262329101562e01,
                2.344903945922851562e01,
                1.144756317138671875e01,
                7.570162296295166016e00,
                7.200886249542236328e00,
                1.347858238220214844e01,
                2.566469764709472656e01,
                4.209748840332031250e01,
                4.745199584960937500e01,
                6.425405883789062500e01,
                7.920974731445312500e01,
                6.905464935302734375e01,
                5.539143371582031250e01,
                5.280649948120117188e01,
                5.059084320068359375e01,
                5.077547836303710938e01,
                5.631462478637695312e01,
                6.462333679199218750e01,
                7.163958740234375000e01,
                5.631462478637695312e01,
                5.668389892578125000e01,
                4.412850952148437500e01,
                4.080502319335937500e01,
                3.157311630249023438e01,
                2.234121131896972656e01,
                2.012555313110351562e01,
                1.532496261596679688e01,
                9.047266960144042969e00,
                9.970458030700683594e00,
                1.366322040557861328e01,
                2.677252578735351562e01,
                4.375923156738281250e01,
                5.483751678466796875e01,
                6.351551055908203125e01,
                7.994830322265625000e01,
                7.330133056640625000e01,
                6.240768051147460938e01,
                6.351551055908203125e01,
                5.834564208984375000e01,
                5.631462478637695312e01,
                7.200886535644531250e01,
                7.477843475341796875e01,
                7.071639251708984375e01,
                6.517725372314453125e01,
                5.409896469116210938e01,
                4.966765213012695312e01,
                4.560561370849609375e01,
                3.526588058471679688e01,
                2.307976341247558594e01,
                2.455686759948730469e01,
                1.366322040557861328e01,
                8.862628936767578125e00,
                7.016248226165771484e00,
                1.403249645233154297e01,
                2.437223052978515625e01,
                4.394387054443359375e01,
                5.132939529418945312e01,
                6.277695846557617188e01,
                7.293205261230468750e01,
                6.591580200195312500e01,
                6.351551055908203125e01,
                6.296159362792968750e01,
                6.333087158203125000e01,
                6.628507995605468750e01,
                7.182422637939453125e01,
                7.754800415039062500e01,
                7.644017791748046875e01,
                6.259231948852539062e01,
                5.280649948120117188e01,
                5.409896469116210938e01,
                4.911373519897460938e01,
                3.120384025573730469e01,
                2.474150657653808594e01,
                2.049483108520507812e01,
                1.310930538177490234e01,
                9.601181983947753906e00,
                8.493352890014648438e00,
                1.643279266357421875e01,
                5.096011734008789062e01,
                4.837518310546875000e01,
                4.966765213012695312e01,
                6.333087158203125000e01,
                7.440915679931640625e01,
                7.274741363525390625e01,
                6.683899688720703125e01,
                6.517725372314453125e01,
                6.831610107421875000e01,
                6.702363586425781250e01,
                7.607089996337890625e01,
                7.662481689453125000e01,
                7.828656005859375000e01,
                6.499261474609375000e01,
                6.093057632446289062e01,
                5.040620422363281250e01,
            ],
            [
                7.309510040283203125e01,
                7.324276733398437500e01,
                7.250443267822265625e01,
                7.250443267822265625e01,
                7.132309722900390625e01,
                7.265209960937500000e01,
                7.279976654052734375e01,
                7.545776367187500000e01,
                7.649143218994140625e01,
                7.870643615722656250e01,
                8.165977478027343750e01,
                8.254577636718750000e01,
                8.210277557373046875e01,
                8.313644409179687500e01,
                8.313644409179687500e01,
                8.298877716064453125e01,
                8.254577636718750000e01,
                8.225044250488281250e01,
                8.062610626220703125e01,
                8.106910705566406250e01,
                7.959243774414062500e01,
                7.974010467529296875e01,
                7.841110229492187500e01,
                8.033077239990234375e01,
                8.062610626220703125e01,
                8.254577636718750000e01,
                8.136444091796875000e01,
                8.092144012451171875e01,
                8.092144012451171875e01,
                8.033077239990234375e01,
                8.151210784912109375e01,
                8.136444091796875000e01,
                8.121677398681640625e01,
                8.225044250488281250e01,
                8.343177795410156250e01,
                8.313644409179687500e01,
                8.254577636718750000e01,
                8.210277557373046875e01,
                8.343177795410156250e01,
                8.254577636718750000e01,
                8.225044250488281250e01,
                8.151210784912109375e01,
                8.121677398681640625e01,
                8.062610626220703125e01,
                7.974010467529296875e01,
                7.885410308837890625e01,
                7.900177001953125000e01,
                8.018310546875000000e01,
                8.225044250488281250e01,
                8.225044250488281250e01,
                8.269344329833984375e01,
                8.239810943603515625e01,
                8.033077239990234375e01,
                8.136444091796875000e01,
                8.225044250488281250e01,
                8.284111022949218750e01,
                8.269344329833984375e01,
                8.239810943603515625e01,
                8.225044250488281250e01,
                8.328411102294921875e01,
                8.357944488525390625e01,
                8.343177795410156250e01,
                8.594211578369140625e01,
                8.417011260986328125e01,
                8.357944488525390625e01,
                8.269344329833984375e01,
                8.018310546875000000e01,
                8.106910705566406250e01,
                7.841110229492187500e01,
                7.988777160644531250e01,
                7.914943695068359375e01,
                7.988777160644531250e01,
                7.959243774414062500e01,
                8.136444091796875000e01,
                8.195510864257812500e01,
                8.239810943603515625e01,
                8.165977478027343750e01,
                8.180744171142578125e01,
                8.047843933105468750e01,
                8.121677398681640625e01,
                8.151210784912109375e01,
                8.298877716064453125e01,
                8.180744171142578125e01,
                8.313644409179687500e01,
                8.180744171142578125e01,
                8.328411102294921875e01,
                8.328411102294921875e01,
                8.313644409179687500e01,
                8.165977478027343750e01,
                8.151210784912109375e01,
                7.929710388183593750e01,
                7.900177001953125000e01,
                7.826343536376953125e01,
                7.796810150146484375e01,
                7.826343536376953125e01,
                7.708209991455078125e01,
                7.309510040283203125e01,
                7.368576812744140625e01,
                7.324276733398437500e01,
                7.250443267822265625e01,
                7.294743347167968750e01,
                7.206143188476562500e01,
                7.265209960937500000e01,
                7.442410278320312500e01,
                7.575309753417968750e01,
                7.870643615722656250e01,
                8.062610626220703125e01,
                8.106910705566406250e01,
                8.180744171142578125e01,
                8.313644409179687500e01,
                8.254577636718750000e01,
                8.180744171142578125e01,
                8.328411102294921875e01,
                8.254577636718750000e01,
                7.959243774414062500e01,
                7.782043457031250000e01,
                7.841110229492187500e01,
                7.767276763916015625e01,
                7.767276763916015625e01,
                7.722976684570312500e01,
                7.516242980957031250e01,
                7.531009674072265625e01,
                7.619609832763671875e01,
                7.457176971435546875e01,
                7.442410278320312500e01,
                7.398110198974609375e01,
                7.324276733398437500e01,
                7.368576812744140625e01,
                7.398110198974609375e01,
                7.708209991455078125e01,
                7.841110229492187500e01,
                7.885410308837890625e01,
                7.988777160644531250e01,
                7.929710388183593750e01,
                7.900177001953125000e01,
                8.033077239990234375e01,
                7.900177001953125000e01,
                8.062610626220703125e01,
                7.885410308837890625e01,
                7.841110229492187500e01,
                7.988777160644531250e01,
                8.003543853759765625e01,
                7.914943695068359375e01,
                8.018310546875000000e01,
                7.914943695068359375e01,
                7.870643615722656250e01,
                7.560543060302734375e01,
                7.457176971435546875e01,
                7.442410278320312500e01,
                7.442410278320312500e01,
                7.368576812744140625e01,
                7.471943664550781250e01,
                7.412876892089843750e01,
                7.634376525878906250e01,
                8.018310546875000000e01,
                7.855876922607421875e01,
                7.959243774414062500e01,
                7.959243774414062500e01,
                7.855876922607421875e01,
                8.047843933105468750e01,
                7.944477081298828125e01,
                7.900177001953125000e01,
                7.796810150146484375e01,
                7.811576843261718750e01,
                7.974010467529296875e01,
                7.914943695068359375e01,
                7.988777160644531250e01,
                7.974010467529296875e01,
            ],
        ]
    )
