# Generated by Django 5.2.5 on 2025-10-02 22:11

import django.db.models.deletion
import encrypted_model_fields.fields
import isapilib.mixin.cte
import isapilib.mixin.venta
import isapilib.mixin.vin
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Agente',
            fields=[
                ('agente', models.CharField(db_column='Agente', max_length=10, primary_key=True, serialize=False, unique=True)),
                ('nombre', models.CharField(blank=True, db_column='Nombre', max_length=100, null=True)),
                ('tipo', models.CharField(blank=True, db_column='Tipo', max_length=15, null=True)),
                ('categoria', models.CharField(blank=True, db_column='Categoria', max_length=50, null=True)),
                ('familia', models.CharField(blank=True, db_column='Familia', max_length=50, null=True)),
                ('zona', models.CharField(blank=True, db_column='Zona', max_length=30, null=True)),
                ('grupo', models.CharField(blank=True, db_column='Grupo', max_length=50, null=True)),
                ('estatus', models.CharField(db_column='Estatus', default='ALTA', max_length=15)),
                ('alta', models.DateTimeField(blank=True, db_column='Alta', null=True)),
                ('baja', models.DateTimeField(blank=True, db_column='Baja', null=True)),
                ('direccion', models.CharField(blank=True, db_column='Direccion', max_length=100, null=True)),
                ('colonia', models.CharField(blank=True, db_column='Colonia', max_length=255, null=True)),
                ('poblacion', models.CharField(blank=True, db_column='Poblacion', max_length=30, null=True)),
                ('estado', models.CharField(blank=True, db_column='Estado', max_length=30, null=True)),
                ('pais', models.CharField(blank=True, db_column='Pais', max_length=30, null=True)),
                ('codigo_postal', models.CharField(blank=True, db_column='CodigoPostal', max_length=15, null=True)),
                ('rfc', models.CharField(blank=True, db_column='RFC', max_length=20, null=True)),
                ('curp', models.CharField(blank=True, db_column='CURP', max_length=30, null=True)),
                ('email', models.CharField(blank=True, db_column='eMail', max_length=50, null=True)),
                ('id_planta', models.CharField(blank=True, db_column='IdPlanta', max_length=10, null=True)),
                ('personal_nombres', models.CharField(db_column='PersonalNombres', max_length=40)),
                ('personal_apellido_paterno', models.CharField(db_column='PersonalApellidoPaterno', max_length=30)),
                ('personal_apellido_materno', models.CharField(db_column='PersonalApellidoMaterno', max_length=30)),
            ],
            options={
                'db_table': 'Agente',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='Almacen',
            fields=[
                ('almacen', models.CharField(db_column='Almacen', max_length=10, primary_key=True, serialize=False)),
                ('rama', models.CharField(blank=True, db_column='Rama', max_length=20, null=True)),
                ('nombre', models.CharField(db_column='Nombre', max_length=100)),
                ('direccion', models.CharField(blank=True, db_column='Direccion', max_length=100, null=True)),
                ('categoria', models.CharField(blank=True, db_column='Categoria', max_length=50, null=True)),
                ('tipo', models.CharField(blank=True, db_column='Tipo', max_length=15, null=True)),
                ('sucursal', models.IntegerField(db_column='Sucursal')),
            ],
            options={
                'db_table': 'Alm',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='Art',
            fields=[
                ('articulo', models.CharField(db_column='Articulo', max_length=20, primary_key=True, serialize=False)),
                ('descripcion1', models.CharField(blank=True, db_column='Descripcion1', max_length=100, null=True)),
                ('descripcion2', models.CharField(blank=True, db_column='Descripcion2', max_length=255, null=True)),
                ('grupo', models.CharField(blank=True, db_column='Grupo', max_length=50, null=True)),
                ('categoria', models.CharField(blank=True, db_column='Categoria', max_length=50, null=True)),
                ('fabricante', models.CharField(blank=True, db_column='Fabricante', max_length=50, null=True)),
                ('impuesto1', models.FloatField(db_column='Impuesto1')),
                ('impuesto2', models.FloatField(blank=True, db_column='Impuesto2', null=True)),
                ('impuesto3', models.FloatField(blank=True, db_column='Impuesto3', null=True)),
                ('tipo', models.CharField(db_column='Tipo', max_length=20)),
                ('precio_lista', models.DecimalField(blank=True, db_column='PrecioLista', decimal_places=4, max_digits=19, null=True)),
                ('estatus', models.CharField(db_column='Estatus', default='ALTA', max_length=15)),
                ('usuario', models.CharField(blank=True, db_column='Usuario', max_length=10, null=True)),
                ('precio2', models.DecimalField(blank=True, db_column='Precio2', decimal_places=4, max_digits=19, null=True)),
                ('precio3', models.DecimalField(blank=True, db_column='Precio3', decimal_places=4, max_digits=19, null=True)),
                ('precio4', models.DecimalField(blank=True, db_column='Precio4', decimal_places=4, max_digits=19, null=True)),
                ('precio5', models.DecimalField(blank=True, db_column='Precio5', decimal_places=4, max_digits=19, null=True)),
                ('precio6', models.DecimalField(blank=True, db_column='Precio6', decimal_places=4, max_digits=19, null=True)),
                ('precio7', models.DecimalField(blank=True, db_column='Precio7', decimal_places=4, max_digits=19, null=True)),
                ('precio8', models.DecimalField(blank=True, db_column='Precio8', decimal_places=4, max_digits=19, null=True)),
                ('precio9', models.DecimalField(blank=True, db_column='Precio9', decimal_places=4, max_digits=19, null=True)),
                ('precio10', models.DecimalField(blank=True, db_column='Precio10', decimal_places=4, max_digits=19, null=True)),
                ('situacion', models.CharField(blank=True, db_column='Situacion', max_length=50, null=True)),
                ('tipo_compra', models.CharField(blank=True, db_column='TipoCompra', max_length=20, null=True)),
                ('retencion1', models.FloatField(blank=True, db_column='Retencion1', null=True)),
                ('retencion2', models.FloatField(blank=True, db_column='Retencion2', null=True)),
                ('retencion3', models.FloatField(blank=True, db_column='Retencion3', null=True)),
                ('modelo', models.CharField(blank=True, db_column='Modelo', max_length=4, null=True)),
                ('direccion', models.CharField(blank=True, db_column='Direccion', max_length=100, null=True)),
                ('direccion_numero', models.CharField(blank=True, db_column='DireccionNumero', max_length=20, null=True)),
                ('direccion_numero_int', models.CharField(blank=True, db_column='DireccionNumeroInt', max_length=20, null=True)),
                ('observaciones', models.CharField(blank=True, db_column='Observaciones', max_length=100, null=True)),
                ('colonia', models.CharField(blank=True, db_column='Colonia', max_length=100, null=True)),
                ('delegacion', models.CharField(blank=True, db_column='Delegacion', max_length=100, null=True)),
                ('poblacion', models.CharField(blank=True, db_column='Poblacion', max_length=100, null=True)),
                ('estado', models.CharField(blank=True, db_column='Estado', max_length=30, null=True)),
                ('pais', models.CharField(blank=True, db_column='Pais', max_length=30, null=True)),
                ('codigo_postal', models.CharField(blank=True, db_column='CodigoPostal', max_length=15, null=True)),
                ('tipo_impuesto1', models.CharField(blank=True, db_column='TipoImpuesto1', max_length=10, null=True)),
                ('tipo_impuesto2', models.CharField(blank=True, db_column='TipoImpuesto2', max_length=10, null=True)),
                ('tipo_impuesto3', models.CharField(blank=True, db_column='TipoImpuesto3', max_length=10, null=True)),
                ('unidad_cantidad', models.FloatField(blank=True, db_column='UnidadCantidad', null=True)),
            ],
            options={
                'db_table': 'Art',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='ArtCosto',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('empresa', models.CharField(db_column='Empresa', max_length=5)),
                ('ultimo_costo', models.FloatField(blank=True, db_column='UltimoCosto', null=True)),
                ('costo_promedio', models.FloatField(blank=True, db_column='CostoPromedio', null=True)),
                ('costo_estandar', models.FloatField(blank=True, db_column='CostoEstandar', null=True)),
                ('costo_reposicion', models.FloatField(blank=True, db_column='CostoReposicion', null=True)),
                ('ultimo_costo_sin_gastos', models.FloatField(blank=True, db_column='UltimoCostoSinGastos', null=True)),
            ],
            options={
                'db_table': 'ArtCosto',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='ArtExistenciaNeta',
            fields=[
                ('articulo', models.CharField(db_column='Articulo', max_length=10, primary_key=True, serialize=False)),
                ('empresa', models.CharField(db_column='Empresa', max_length=10)),
                ('almacen', models.CharField(db_column='Almacen', max_length=10)),
                ('moneda', models.CharField(db_column='Moneda', max_length=10)),
                ('existencia', models.CharField(db_column='Existencia', max_length=10)),
            ],
            options={
                'db_table': 'ArtExistenciaNeta',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='Compra',
            fields=[
                ('id', models.AutoField(db_column='ID', primary_key=True, serialize=False, unique=True)),
                ('importe', models.DecimalField(blank=True, db_column='Importe', decimal_places=4, max_digits=19, null=True)),
                ('impuestos', models.DecimalField(blank=True, db_column='Impuestos', decimal_places=4, max_digits=19, null=True)),
            ],
            options={
                'db_table': 'Compra',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='Cte',
            fields=[
                ('cliente', models.CharField(db_column='Cliente', max_length=10, primary_key=True, serialize=False)),
                ('nombre', models.CharField(blank=True, db_column='Nombre', max_length=254, null=True)),
                ('nombre_corto', models.CharField(blank=True, db_column='NombreCorto', max_length=20, null=True)),
                ('direccion', models.CharField(blank=True, db_column='Direccion', max_length=100, null=True)),
                ('direccion_numero', models.CharField(blank=True, db_column='DireccionNumero', max_length=50, null=True)),
                ('observaciones', models.CharField(blank=True, db_column='Observaciones', max_length=100, null=True)),
                ('delegacion', models.CharField(blank=True, db_column='Delegacion', max_length=100, null=True)),
                ('colonia', models.CharField(blank=True, db_column='Colonia', max_length=100, null=True)),
                ('poblacion', models.CharField(blank=True, db_column='Poblacion', max_length=100, null=True)),
                ('estado', models.CharField(blank=True, db_column='Estado', max_length=30, null=True)),
                ('pais', models.CharField(blank=True, db_column='Pais', max_length=100, null=True)),
                ('zona', models.CharField(blank=True, db_column='Zona', max_length=30, null=True)),
                ('codigo_postal', models.CharField(blank=True, db_column='CodigoPostal', max_length=15, null=True)),
                ('rfc', models.CharField(blank=True, db_column='RFC', max_length=15, null=True)),
                ('curp', models.CharField(blank=True, db_column='CURP', max_length=30, null=True)),
                ('telefonos', models.CharField(blank=True, db_column='Telefonos', max_length=100, null=True)),
                ('telefonos_lada', models.CharField(blank=True, db_column='TelefonosLada', max_length=6, null=True)),
                ('contacto1', models.CharField(blank=True, db_column='Contacto1', max_length=50, null=True)),
                ('contacto2', models.CharField(blank=True, db_column='Contacto2', max_length=50, null=True)),
                ('extencion1', models.CharField(blank=True, db_column='Extencion1', max_length=10, null=True)),
                ('extencion2', models.CharField(blank=True, db_column='Extencion2', max_length=10, null=True)),
                ('email', models.CharField(blank=True, db_column='eMail', max_length=50, null=True)),
                ('email1', models.CharField(blank=True, db_column='eMail1', max_length=50, null=True)),
                ('email2', models.CharField(blank=True, db_column='eMail2', max_length=50, null=True)),
                ('categoria', models.CharField(blank=True, db_column='Categoria', max_length=50, null=True)),
                ('tipo', models.CharField(blank=True, db_column='Tipo', max_length=15, null=True)),
                ('situacion', models.CharField(blank=True, db_column='Situacion', max_length=50, null=True)),
                ('agente_servicio', models.CharField(blank=True, db_column='AgenteServicio', max_length=10, null=True)),
                ('estatus', models.CharField(db_column='Estatus', default='ALTA', max_length=15)),
                ('ultimo_cambio', models.DateTimeField(blank=True, db_column='UltimoCambio', null=True)),
                ('descripcion1', models.CharField(blank=True, db_column='Descripcion1', max_length=50, null=True)),
                ('descripcion2', models.CharField(blank=True, db_column='Descripcion2', max_length=50, null=True)),
                ('descripcion3', models.CharField(blank=True, db_column='Descripcion3', max_length=50, null=True)),
                ('descripcion4', models.CharField(blank=True, db_column='Descripcion4', max_length=50, null=True)),
                ('descripcion5', models.CharField(blank=True, db_column='Descripcion5', max_length=50, null=True)),
                ('descripcion6', models.CharField(blank=True, db_column='Descripcion6', max_length=50, null=True)),
                ('descripcion7', models.CharField(blank=True, db_column='Descripcion7', max_length=50, null=True)),
                ('descripcion8', models.CharField(blank=True, db_column='Descripcion8', max_length=50, null=True)),
                ('descripcion9', models.CharField(blank=True, db_column='Descripcion9', max_length=50, null=True)),
                ('descripcion10', models.CharField(blank=True, db_column='Descripcion10', max_length=50, null=True)),
                ('descripcion11', models.CharField(blank=True, db_column='Descripcion11', max_length=50, null=True)),
                ('descripcion12', models.CharField(blank=True, db_column='Descripcion12', max_length=50, null=True)),
                ('descripcion13', models.CharField(blank=True, db_column='Descripcion13', max_length=50, null=True)),
                ('descripcion14', models.CharField(blank=True, db_column='Descripcion14', max_length=50, null=True)),
                ('descripcion15', models.CharField(blank=True, db_column='Descripcion15', max_length=50, null=True)),
                ('descripcion16', models.CharField(blank=True, db_column='Descripcion16', max_length=50, null=True)),
                ('descripcion17', models.CharField(blank=True, db_column='Descripcion17', max_length=50, null=True)),
                ('descripcion18', models.CharField(blank=True, db_column='Descripcion18', max_length=50, null=True)),
                ('descripcion19', models.CharField(blank=True, db_column='Descripcion19', max_length=50, null=True)),
                ('descripcion20', models.CharField(blank=True, db_column='Descripcion20', max_length=50, null=True)),
                ('personal_nombres', models.CharField(blank=True, db_column='PersonalNombres', max_length=50, null=True)),
                ('personal_apellido_paterno', models.CharField(blank=True, db_column='PersonalApellidoPaterno', max_length=50, null=True)),
                ('personal_apellido_materno', models.CharField(blank=True, db_column='PersonalApellidoMaterno', max_length=50, null=True)),
                ('personal_direccion', models.CharField(blank=True, db_column='PersonalDireccion', max_length=100, null=True)),
                ('personal_entrecalles', models.CharField(blank=True, db_column='PersonalEntreCalles', max_length=100, null=True)),
                ('personal_plano', models.CharField(blank=True, db_column='PersonalPlano', max_length=15, null=True)),
                ('personal_delegacion', models.CharField(blank=True, db_column='PersonalDelegacion', max_length=100, null=True)),
                ('personal_colonia', models.CharField(blank=True, db_column='PersonalColonia', max_length=100, null=True)),
                ('personal_poblacion', models.CharField(blank=True, db_column='PersonalPoblacion', max_length=100, null=True)),
                ('personal_estado', models.CharField(blank=True, db_column='PersonalEstado', max_length=30, null=True)),
                ('personal_pais', models.CharField(blank=True, db_column='PersonalPais', max_length=30, null=True)),
                ('personal_zona', models.CharField(blank=True, db_column='PersonalZona', max_length=30, null=True)),
                ('personal_codigo_postal', models.CharField(blank=True, db_column='PersonalCodigoPostal', max_length=15, null=True)),
                ('personal_telefonos', models.CharField(blank=True, db_column='PersonalTelefonos', max_length=100, null=True)),
                ('personal_telefonos_lada', models.CharField(blank=True, db_column='PersonalTelefonosLada', max_length=6, null=True)),
                ('personal_telefono_movil', models.CharField(blank=True, db_column='PersonalTelefonoMovil', max_length=30, null=True)),
                ('personal_sms', models.BooleanField(blank=True, db_column='PersonalSMS', null=True)),
                ('fecha_nacimiento', models.DateTimeField(blank=True, db_column='FechaNacimiento', null=True)),
                ('sexo', models.CharField(blank=True, db_column='Sexo', max_length=20, null=True)),
                ('fecha1', models.DateTimeField(blank=True, db_column='Fecha1', null=True)),
                ('fecha2', models.DateTimeField(blank=True, db_column='Fecha2', null=True)),
                ('fecha3', models.DateTimeField(blank=True, db_column='Fecha3', null=True)),
                ('fecha4', models.DateTimeField(blank=True, db_column='Fecha4', null=True)),
                ('fecha5', models.DateTimeField(blank=True, db_column='Fecha5', null=True)),
                ('usuario', models.CharField(blank=True, db_column='Usuario', max_length=10, null=True)),
                ('fiscal_regimen', models.CharField(blank=True, db_column='FiscalRegimen', max_length=30, null=True)),
                ('contactar', models.CharField(blank=True, db_column='Contactar', max_length=30, null=True)),
            ],
            options={
                'db_table': 'Cte',
                'managed': False,
            },
            bases=(models.Model, isapilib.mixin.cte.CteMixin),
        ),
        migrations.CreateModel(
            name='Empresa',
            fields=[
                ('empresa', models.CharField(db_column='Empresa', max_length=5, primary_key=True, serialize=False)),
                ('nombre', models.CharField(blank=True, db_column='Nombre', max_length=100, null=True)),
                ('grupo', models.CharField(blank=True, db_column='Grupo', max_length=100, null=True)),
                ('direccion', models.CharField(blank=True, db_column='Direccion', max_length=100, null=True)),
                ('direccion_numero', models.CharField(blank=True, db_column='DireccionNumero', max_length=20, null=True)),
                ('direccion_numero_int', models.CharField(blank=True, db_column='DireccionNumeroInt', max_length=20, null=True)),
                ('colonia', models.CharField(blank=True, db_column='Colonia', max_length=100, null=True)),
                ('poblacion', models.CharField(blank=True, db_column='Poblacion', max_length=30, null=True)),
                ('estado', models.CharField(blank=True, db_column='Estado', max_length=30, null=True)),
                ('pais', models.CharField(blank=True, db_column='Pais', max_length=30, null=True)),
                ('codigo_postal', models.CharField(blank=True, db_column='CodigoPostal', max_length=15, null=True)),
                ('telefonos', models.CharField(blank=True, db_column='Telefonos', max_length=100, null=True)),
                ('rfc', models.CharField(blank=True, db_column='RFC', max_length=20, null=True)),
                ('tipo', models.CharField(blank=True, db_column='Tipo', max_length=20, null=True)),
            ],
            options={
                'db_table': 'Empresa',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='FormaPagoTipo',
            fields=[
                ('tipo', models.CharField(max_length=50, primary_key=True, serialize=False)),
                ('sobre_precio', models.FloatField(blank=True, db_column='SobrePrecio', null=True)),
            ],
            options={
                'db_table': 'FormaPagoTipo',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='InterfacesPredefinidas',
            fields=[
                ('interfaz_id', models.IntegerField(unique=True)),
                ('renglon_id', models.IntegerField(blank=True, db_column='RenglonID', null=True)),
                ('interfaz', models.CharField(db_column='Interfaz', max_length=100, primary_key=True, serialize=False)),
                ('marca', models.CharField(db_column='Marca', max_length=50)),
                ('estatus', models.BooleanField(db_column='Estatus')),
                ('reenvio_rango', models.BooleanField(db_column='ReenvioRango')),
                ('abrir_mov', models.BooleanField(db_column='AbrirMov')),
                ('reenvio_multiple', models.BooleanField(db_column='ReenvioMultiple')),
                ('descripcion', models.CharField(blank=True, db_column='Descripcion', max_length=100, null=True)),
            ],
            options={
                'db_table': 'CA_InterfacesPredefinidas',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='InterfacesPredefinidasDEmpresa',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('renglon_id', models.IntegerField(blank=True, db_column='RenglonID', null=True)),
                ('clave', models.CharField(db_column='Clave', max_length=50)),
                ('descripcion', models.CharField(db_column='Descripcion', max_length=100)),
                ('valor_default', models.CharField(blank=True, db_column='ValorDefault', max_length=255, null=True)),
            ],
            options={
                'db_table': 'CA_InterfacesPredefinidasDEmpresa',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='ListaPreciosD',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('lista', models.CharField(db_column='Lista', max_length=20)),
                ('moneda', models.CharField(db_column='Moneda', max_length=10)),
                ('precio', models.DecimalField(blank=True, db_column='Precio', decimal_places=4, max_digits=18, null=True)),
                ('codigo_cliente', models.CharField(blank=True, db_column='CodigoCliente', max_length=20, null=True)),
                ('margen', models.FloatField(blank=True, db_column='Margen', null=True)),
                ('region', models.CharField(blank=True, db_column='Region', max_length=50, null=True)),
            ],
            options={
                'db_table': 'ListaPreciosD',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='MaestroTipoOrdenOperacion',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('marca', models.CharField(db_column='Marca', max_length=10)),
                ('interfaz', models.CharField(db_column='Interfaz', max_length=100)),
                ('tipo_orden_operacion', models.CharField(db_column='TipoOrdenOperacion', max_length=50)),
                ('valor', models.CharField(db_column='Valor', max_length=50)),
            ],
            options={
                'db_table': 'CA_MaestroTipoOrdenOperacionporInterfaz',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='MensajeLista',
            fields=[
                ('mensaje', models.IntegerField(primary_key=True, serialize=False)),
                ('descripcion', models.CharField(blank=True, max_length=255, null=True)),
                ('tipo', models.CharField(blank=True, default='ERROR', max_length=50, null=True)),
                ('ie', models.BooleanField(blank=True, default=0, null=True)),
            ],
            options={
                'db_table': 'MensajeLista',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='ParametrosSucursal',
            fields=[
                ('empresa', models.CharField(db_column='Empresa', max_length=5)),
                ('sucursal', models.IntegerField(db_column='Sucursal')),
                ('clave', models.CharField(db_column='Clave', max_length=30, primary_key=True, serialize=False)),
                ('descripcion', models.CharField(blank=True, db_column='Descripcion', max_length=200, null=True)),
                ('grupo', models.CharField(blank=True, db_column='Grupo', max_length=20, null=True)),
                ('valor', models.CharField(blank=True, db_column='Valor', max_length=100, null=True)),
            ],
            options={
                'db_table': 'CA_CatParametrosSucursal',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='SerieLote',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('serie_lote', models.CharField(db_column='SerieLote', max_length=50)),
                ('existencia', models.FloatField(blank=True, db_column='Existencia', null=True)),
            ],
            options={
                'db_table': 'SerieLote',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='Sucursal',
            fields=[
                ('sucursal', models.IntegerField(db_column='Sucursal', primary_key=True, serialize=False)),
                ('nombre', models.CharField(blank=True, db_column='Nombre', max_length=100, null=True)),
                ('prefijo', models.CharField(blank=True, db_column='Prefijo', max_length=5, null=True)),
                ('estatus', models.CharField(db_column='Estatus', default='ALTA', max_length=15)),
                ('rfc', models.CharField(blank=True, db_column='RFC', max_length=20, null=True)),
                ('alta', models.DateTimeField(blank=True, db_column='Alta', null=True)),
                ('almacen_principal', models.CharField(blank=True, db_column='AlmacenPrincipal', max_length=10, null=True)),
                ('cliente', models.CharField(blank=True, db_column='Cliente', max_length=10, null=True)),
                ('categoria', models.CharField(blank=True, db_column='Categoria', max_length=50, null=True)),
                ('ip', models.CharField(blank=True, db_column='IP', max_length=20, null=True)),
                ('fiscal_regimen', models.CharField(blank=True, db_column='FiscalRegimen', max_length=30, null=True)),
                ('version', models.CharField(blank=True, db_column='Version', max_length=25, null=True)),
                ('gwmbac', models.CharField(blank=True, db_column='GWMBAC', max_length=11, null=True)),
            ],
            options={
                'db_table': 'Sucursal',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='TipoOrdenOperacion',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('interfaz', models.CharField(db_column='Interfaz', max_length=100)),
                ('operacion_planta', models.CharField(db_column='OrdenOperacionPlanta', max_length=50)),
                ('operacion_intelisis', models.CharField(db_column='OrdenOperacionIntelisis', max_length=50)),
            ],
            options={
                'db_table': 'CA_MapeoTipoOrdenOperacion',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='Usuario',
            fields=[
                ('usuario', models.CharField(db_column='Usuario', max_length=10, primary_key=True, serialize=False)),
                ('nombre', models.CharField(db_column='Nombre', max_length=100)),
                ('sucursal', models.IntegerField(db_column='Sucursal')),
                ('email', models.CharField(db_column='eMail', max_length=50)),
                ('estatus', models.CharField(db_column='Estatus', default='ALTA', max_length=15)),
            ],
            options={
                'db_table': 'Usuario',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='Venta',
            fields=[
                ('id', models.AutoField(db_column='ID', primary_key=True, serialize=False, unique=True)),
                ('mov', models.CharField(db_column='Mov', max_length=20)),
                ('mov_id', models.CharField(blank=True, db_column='MovID', max_length=20, null=True)),
                ('fecha_emision', models.DateTimeField(blank=True, db_column='FechaEmision', null=True)),
                ('ultimo_cambio', models.DateTimeField(blank=True, db_column='UltimoCambio', null=True)),
                ('concepto', models.CharField(blank=True, db_column='Concepto', default='Publico', max_length=50, null=True)),
                ('uen', models.IntegerField(blank=True, db_column='UEN', null=True)),
                ('moneda', models.CharField(db_column='Moneda', default='Pesos', max_length=10)),
                ('tipo_cambio', models.FloatField(blank=True, db_column='TipoCambio', default=1, null=True)),
                ('referencia', models.CharField(blank=True, db_column='Referencia', max_length=50, null=True)),
                ('observaciones', models.CharField(blank=True, db_column='Observaciones', max_length=100, null=True)),
                ('estatus', models.CharField(blank=True, db_column='Estatus', default='SINAFECTAR', max_length=15, null=True)),
                ('situacion', models.CharField(blank=True, db_column='Situacion', max_length=50, null=True)),
                ('situacion_fecha', models.DateTimeField(blank=True, db_column='SituacionFecha', null=True)),
                ('situacion_usuario', models.CharField(blank=True, db_column='SituacionUsuario', max_length=10, null=True)),
                ('situacion_nota', models.CharField(blank=True, db_column='SituacionNota', max_length=100, null=True)),
                ('fecha_requerida', models.DateTimeField(blank=True, db_column='FechaRequerida', null=True)),
                ('hora_requerida', models.CharField(blank=True, db_column='HoraRequerida', max_length=5, null=True)),
                ('condicion', models.CharField(blank=True, db_column='Condicion', max_length=50, null=True)),
                ('servicio_tipo', models.CharField(blank=True, db_column='ServicioTipo', max_length=50, null=True)),
                ('servicio_contrato', models.CharField(blank=True, db_column='ServicioContrato', max_length=20, null=True)),
                ('servicio_contrato_id', models.CharField(blank=True, db_column='ServicioContratoID', max_length=20, null=True)),
                ('servicio_contrato_tipo', models.CharField(blank=True, db_column='ServicioContratoTipo', max_length=50, null=True)),
                ('servicio_descripcion', models.CharField(blank=True, db_column='ServicioDescripcion', max_length=100, null=True)),
                ('servicio_fecha', models.DateTimeField(auto_now=True, db_column='ServicioFecha', null=True)),
                ('servicio_flotilla', models.BooleanField(blank=True, db_column='ServicioFlotilla', null=True)),
                ('servicio_rampa', models.BooleanField(blank=True, db_column='ServicioRampa', null=True)),
                ('servicio_identificador', models.CharField(blank=True, db_column='ServicioIdentificador', max_length=20, null=True)),
                ('servicio_placas', models.CharField(blank=True, db_column='ServicioPlacas', max_length=20, null=True)),
                ('servicio_kms', models.IntegerField(blank=True, db_column='ServicioKms', null=True)),
                ('servicio_tipo_orden', models.CharField(blank=True, db_column='ServicioTipoOrden', default='Publico', max_length=20, null=True)),
                ('servicio_tipo_operacion', models.CharField(blank=True, db_column='ServicioTipoOperacion', default='Publico', max_length=50, null=True)),
                ('servicio_siniestro', models.CharField(blank=True, db_column='ServicioSiniestro', max_length=20, null=True)),
                ('servicio_deducible_importe', models.DecimalField(blank=True, db_column='ServicioDeducibleImporte', decimal_places=4, max_digits=19, null=True)),
                ('servicio_numero', models.FloatField(blank=True, db_column='ServicioNumero', default=1, null=True)),
                ('servicio_numero_economico', models.CharField(blank=True, db_column='ServicioNumeroEconomico', max_length=20, null=True)),
                ('servicio_aseguradora', models.CharField(blank=True, db_column='ServicioAseguradora', max_length=10, null=True)),
                ('servicio_puntual', models.BooleanField(blank=True, db_column='ServicioPuntual', null=True)),
                ('servicio_poliza', models.CharField(blank=True, db_column='ServicioPoliza', max_length=20, null=True)),
                ('origen', models.CharField(blank=True, db_column='Origen', max_length=20, null=True)),
                ('origen_id', models.CharField(blank=True, db_column='OrigenID', max_length=20, null=True)),
                ('servicio_modelo', models.CharField(blank=True, db_column='ServicioModelo', max_length=4, null=True)),
                ('sucursal_destino', models.IntegerField(blank=True, db_column='SucursalDestino', null=True)),
                ('comentarios', models.TextField(blank=True, db_column='Comentarios', null=True)),
                ('fecha_entrega', models.DateTimeField(blank=True, db_column='FechaEntrega', null=True)),
                ('hora_recepcion', models.CharField(blank=True, db_column='HoraRecepcion', max_length=5, null=True)),
                ('lista_precios_esp', models.CharField(blank=True, db_column='ListaPreciosEsp', default='Precio Publico', max_length=20, null=True)),
                ('endosar_a', models.CharField(blank=True, db_column='EndosarA', max_length=10, null=True)),
                ('forma_pago_tipo', models.CharField(blank=True, db_column='FormaPagoTipo', max_length=50, null=True)),
                ('causa', models.CharField(blank=True, db_column='Causa', max_length=50, null=True)),
            ],
            options={
                'db_table': 'Venta',
                'managed': False,
            },
            bases=(models.Model, isapilib.mixin.venta.VentaMixin),
        ),
        migrations.CreateModel(
            name='VentaD',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('renglon', models.FloatField(db_column='Renglon')),
                ('renglon_sub', models.IntegerField(db_column='RenglonSub')),
                ('renglon_id', models.IntegerField(blank=True, db_column='RenglonID', null=True)),
                ('renglon_tipo', models.CharField(blank=True, db_column='RenglonTipo', max_length=1, null=True)),
                ('cantidad', models.FloatField(blank=True, db_column='Cantidad', null=True)),
                ('precio', models.FloatField(blank=True, db_column='Precio', null=True)),
                ('precio_sugerido', models.FloatField(blank=True, db_column='PrecioSugerido', null=True)),
                ('impuesto1', models.FloatField(blank=True, db_column='Impuesto1', null=True)),
                ('impuesto2', models.FloatField(blank=True, db_column='Impuesto2', null=True)),
                ('impuesto3', models.FloatField(blank=True, db_column='Impuesto3', null=True)),
                ('descripcion_extra', models.CharField(blank=True, db_column='DescripcionExtra', max_length=100, null=True)),
                ('costo', models.DecimalField(blank=True, db_column='Costo', decimal_places=4, max_digits=19, null=True)),
                ('aplica', models.CharField(blank=True, db_column='Aplica', max_length=20, null=True)),
                ('aplica_id', models.CharField(blank=True, db_column='AplicaID', max_length=20, null=True)),
                ('unidad', models.CharField(blank=True, db_column='Unidad', max_length=50, null=True)),
                ('fecha_requerida', models.DateTimeField(blank=True, db_column='FechaRequerida', null=True)),
                ('hora_requerida', models.CharField(blank=True, db_column='HoraRequerida', max_length=5, null=True)),
                ('departamento', models.IntegerField(blank=True, db_column='Departamento', null=True)),
                ('uen', models.IntegerField(blank=True, db_column='UEN', null=True)),
                ('precio_lista', models.DecimalField(blank=True, db_column='PrecioLista', decimal_places=4, max_digits=19, null=True)),
                ('tipo_impuesto1', models.CharField(blank=True, db_column='TipoImpuesto1', max_length=10, null=True)),
                ('tipo_impuesto2', models.CharField(blank=True, db_column='TipoImpuesto2', max_length=10, null=True)),
                ('tipo_impuesto3', models.CharField(blank=True, db_column='TipoImpuesto3', max_length=10, null=True)),
                ('retencion1', models.FloatField(blank=True, db_column='Retencion1', null=True)),
                ('retencion2', models.FloatField(blank=True, db_column='Retencion2', null=True)),
                ('retencion3', models.FloatField(blank=True, db_column='Retencion3', null=True)),
                ('tipo_retencion1', models.CharField(blank=True, db_column='TipoRetencion1', max_length=10, null=True)),
                ('tipo_retencion2', models.CharField(blank=True, db_column='TipoRetencion2', max_length=10, null=True)),
                ('tipo_retencion3', models.CharField(blank=True, db_column='TipoRetencion3', max_length=10, null=True)),
                ('comentarios', models.CharField(blank=True, db_column='Comentarios', max_length=250, null=True)),
                ('servicio_tipo_orden', models.CharField(blank=True, db_column='ServicioTipoOrden', max_length=20, null=True)),
                ('articulo_actual', models.CharField(blank=True, db_column='ArticuloActual', max_length=20, null=True)),
                ('ut', models.FloatField(blank=True, db_column='UT', null=True)),
                ('cc_tiempo_tab', models.FloatField(blank=True, db_column='CCTiempoTab', null=True)),
                ('paquete', models.IntegerField(db_column='Paquete')),
                ('descuento_linea', models.FloatField(blank=True, db_column='DescuentoLinea', null=True)),
                ('descuento_importe', models.DecimalField(blank=True, db_column='DescuentoImporte', decimal_places=4, max_digits=19, null=True)),
                ('cantidad_pendiente', models.FloatField(blank=True, db_column='CantidadPendiente', null=True)),
            ],
            options={
                'db_table': 'VentaD',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='VentaTraspasarArticulos',
            fields=[
                ('venta', models.IntegerField(db_column='ID')),
                ('estacion', models.IntegerField(db_column='Estacion')),
                ('rid', models.AutoField(db_column='RID', primary_key=True, serialize=False, unique=True)),
                ('codigo', models.CharField(blank=True, db_column='Codigo', max_length=30, null=True)),
                ('cantidad', models.FloatField(blank=True, db_column='Cantidad', null=True)),
                ('precio', models.FloatField(blank=True, db_column='Precio', null=True)),
                ('costo', models.FloatField(blank=True, db_column='Costo', null=True)),
                ('accion', models.CharField(blank=True, db_column='Accion', max_length=20, null=True)),
                ('referencia', models.CharField(blank=True, db_column='Referencia', max_length=50, null=True)),
                ('aplica_mov', models.CharField(blank=True, db_column='AplicaMov', max_length=20, null=True)),
                ('aplica_mov_id', models.CharField(blank=True, db_column='AplicaMovID', max_length=20, null=True)),
                ('sin_validar_reservado', models.BooleanField(db_column='SinValidarReservado', default=False)),
                ('paquete', models.IntegerField(blank=True, db_column='Paquete', null=True)),
                ('usuario', models.CharField(blank=True, db_column='Usuario', default='SOPDESA', max_length=20, null=True)),
                ('contrasena', models.CharField(blank=True, db_column='Contrasena', max_length=40, null=True)),
                ('descuento_linea', models.DecimalField(blank=True, db_column='DescuentoLinea', decimal_places=4, max_digits=19, null=True)),
                ('descuento_importe', models.DecimalField(blank=True, db_column='DescuentoImporte', decimal_places=4, max_digits=19, null=True)),
                ('renglon', models.FloatField(blank=True, db_column='Renglon', null=True)),
                ('origen', models.CharField(blank=True, max_length=100, null=True)),
            ],
            options={
                'db_table': 'VentaTraspasarArticulos',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='Vin',
            fields=[
                ('vin', models.CharField(db_column='VIN', max_length=20, primary_key=True, serialize=False)),
                ('km', models.IntegerField(blank=True, db_column='Km', null=True)),
                ('motor', models.CharField(blank=True, db_column='Motor', max_length=20, null=True)),
                ('fecha', models.DateTimeField(blank=True, db_column='Fecha', null=True)),
                ('conductor', models.CharField(blank=True, db_column='Conductor', max_length=10, null=True)),
                ('alta', models.DateTimeField(blank=True, db_column='Alta', null=True)),
                ('placas', models.CharField(blank=True, db_column='Placas', max_length=20, null=True)),
                ('garantia_vencimiento', models.DateTimeField(blank=True, db_column='GarantiaVencimiento', null=True)),
                ('registro', models.CharField(blank=True, db_column='Registro', max_length=20, null=True)),
                ('fecha_carta_credito', models.DateTimeField(blank=True, db_column='FechaCartaCredito', null=True)),
                ('fecha_factura', models.DateTimeField(blank=True, db_column='FechaFactura', null=True)),
                ('fecha_ultimo_servicio', models.DateTimeField(blank=True, db_column='FechaUltimoServicio', null=True)),
                ('fecha_siguiente_servicio', models.DateTimeField(blank=True, db_column='FechaSiguienteServicio', null=True)),
                ('costo', models.FloatField(blank=True, db_column='Costo', null=True)),
                ('modelo', models.CharField(blank=True, db_column='Modelo', max_length=4, null=True)),
                ('tipo_compra', models.CharField(blank=True, db_column='TipoCompra', max_length=1, null=True)),
                ('folio_factura_compra', models.CharField(blank=True, db_column='FolioFacturaCompra', max_length=15, null=True)),
                ('fecha_factura_compra', models.DateTimeField(blank=True, db_column='FechaFacturaCompra', null=True)),
                ('descripcion1', models.CharField(blank=True, db_column='Descripcion1', max_length=38, null=True)),
                ('descripcion2', models.CharField(blank=True, db_column='Descripcion2', max_length=38, null=True)),
                ('color_exterior', models.CharField(blank=True, db_column='ColorExterior', max_length=10, null=True)),
                ('color_exterior_descripcion', models.CharField(blank=True, db_column='ColorExteriorDescripcion', max_length=50, null=True)),
                ('color_interior', models.CharField(blank=True, db_column='ColorInterior', max_length=10, null=True)),
                ('color_interior_descripcion', models.CharField(blank=True, db_column='ColorInteriorDescripcion', max_length=50, null=True)),
                ('fecha_pago', models.DateTimeField(blank=True, db_column='FechaPago', null=True)),
                ('venta_id', models.IntegerField(blank=True, db_column='VentaID', null=True)),
                ('estatus', models.CharField(db_column='Estatus', default='ALTA', max_length=15)),
                ('situacion', models.CharField(blank=True, db_column='Situacion', max_length=50, null=True)),
                ('situacion_fecha', models.DateTimeField(blank=True, db_column='SituacionFecha', null=True)),
                ('tipo_venta', models.CharField(blank=True, db_column='TipoVenta', max_length=1, null=True)),
                ('kilometraje_inicial', models.IntegerField(blank=True, db_column='KilometrajeInicial', null=True)),
                ('cilindros', models.IntegerField(blank=True, db_column='Cilindros', null=True)),
                ('puertas', models.CharField(blank=True, db_column='Puertas', max_length=30, null=True)),
                ('pasajeros', models.IntegerField(blank=True, db_column='Pasajeros', null=True)),
                ('capacidad_carga', models.IntegerField(blank=True, db_column='CapacidadCarga', null=True)),
                ('combustible', models.CharField(blank=True, db_column='Combustible', max_length=20, null=True)),
                ('primera_llamada', models.DateTimeField(blank=True, db_column='PrimeraLlamada', null=True)),
                ('comentarios_primera_llamada', models.CharField(blank=True, db_column='ComentariosPrimeraLLamada', max_length=1000, null=True)),
                ('segunda_llamada', models.DateTimeField(blank=True, db_column='SegundaLlamada', null=True)),
                ('comentarios_segunda_llamada', models.CharField(blank=True, db_column='ComentariosSegundaLLamada', max_length=1000, null=True)),
                ('tercera_llamada', models.DateTimeField(blank=True, db_column='TerceraLlamada', null=True)),
                ('comentarios_tercera_llamada', models.CharField(blank=True, db_column='ComentariosTerceraLLamada', max_length=1000, null=True)),
                ('demo', models.BooleanField(blank=True, db_column='VehiculoDemo', null=True)),
            ],
            options={
                'db_table': 'VIN',
                'managed': False,
            },
            bases=(models.Model, isapilib.mixin.vin.VinMixin),
        ),
        migrations.CreateModel(
            name='VinAccesorio',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('descripcion', models.CharField(blank=True, db_column='Descripcion', max_length=100, null=True)),
                ('precio_contado', models.DecimalField(blank=True, db_column='PrecioContado', decimal_places=4, max_digits=19, null=True)),
            ],
            options={
                'db_table': 'VinAccesorio',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='VinTipoAccesorio',
            fields=[
                ('tipo', models.CharField(db_column='Tipo', max_length=50, primary_key=True, serialize=False)),
                ('afecta_costo', models.BooleanField(db_column='AfectaCosto')),
                ('afecta_precio', models.BooleanField(db_column='AfectaPrecio')),
                ('afecta_gasto', models.BooleanField(db_column='AfectaGasto')),
            ],
            options={
                'db_table': 'VinTipoAccesorio',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='ConnectionAPI',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('alias', models.CharField(blank=True, max_length=40, null=True)),
                ('user', models.CharField(max_length=40)),
                ('password', encrypted_model_fields.fields.EncryptedCharField()),
                ('host', models.CharField(max_length=40)),
                ('port', models.CharField(blank=True, max_length=80, null=True)),
                ('nombre_db', models.CharField(max_length=80)),
                ('empresa', models.CharField(blank=True, max_length=80, null=True)),
                ('version', models.IntegerField(default=6000)),
                ('allow_test', models.BooleanField(default=False)),
                ('extra_data', models.JSONField(blank=True, default=dict, null=True)),
            ],
            options={
                'db_table': 'isapilib_connectionapi',
                'ordering': ['host', 'port', 'id'],
                'unique_together': {('host', 'port', 'nombre_db')},
            },
        ),
        migrations.CreateModel(
            name='BranchAPI',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sucursal', models.IntegerField()),
                ('gwmbac', models.CharField(blank=True, max_length=100, null=True, unique=True)),
                ('connection', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='branches', to='isapilib.connectionapi')),
            ],
            options={
                'db_table': 'isapilib_branchapi',
                'ordering': ['connection', 'id'],
            },
        ),
        migrations.CreateModel(
            name='UserAPI',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('password', models.CharField(max_length=128, verbose_name='password')),
                ('last_login', models.DateTimeField(blank=True, null=True, verbose_name='last login')),
                ('username', models.CharField(max_length=30, unique=True)),
                ('is_superuser', models.BooleanField(default=False)),
                ('branch', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='users', to='isapilib.branchapi')),
                ('permissions', models.ManyToManyField(related_name='permissions', to='isapilib.branchapi')),
            ],
            options={
                'db_table': 'isapilib_userapi',
                'ordering': ['username', 'id'],
            },
        ),
        migrations.CreateModel(
            name='ApiLogs',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('tipo', models.CharField(max_length=120)),
                ('header', models.TextField()),
                ('request', models.TextField()),
                ('response', models.TextField()),
                ('status', models.IntegerField(null=True)),
                ('url', models.TextField()),
                ('interfaz', models.CharField(max_length=120)),
                ('fecharegistro', models.DateTimeField()),
                ('response_time', models.IntegerField(default=0)),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='logs', to='isapilib.userapi')),
            ],
            options={
                'db_table': 'api_logs',
                'ordering': ['-fecharegistro'],
            },
        ),
    ]
