import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
/**
 * (experimental) Statement provider for service [grafana](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmanagedserviceforgrafana.html).
 *
 * @experimental
 */
export declare class Grafana extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [grafana](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmanagedserviceforgrafana.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to create a workspace.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toCreateWorkspace(): this;
    /**
     * (experimental) Grants permission to delete a workspace.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toDeleteWorkspace(): this;
    /**
     * (experimental) Grants permission to describe a workspace.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toDescribeWorkspace(): this;
    /**
     * (experimental) Grants permission to list the permissions on a wokspace.
     *
     * Access Level: List
     *
     * @experimental
     */
    toListPermissions(): this;
    /**
     * (experimental) Grants permission to list workspaces.
     *
     * Access Level: List
     *
     * @experimental
     */
    toListWorkspaces(): this;
    /**
     * (experimental) Grants permission to modify the permissions on a workspace.
     *
     * Access Level: Permissions management
     *
     * @experimental
     */
    toUpdatePermissions(): this;
    /**
     * (experimental) Grants permission to modify a workspace.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toUpdateWorkspace(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type workspace to the statement.
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onWorkspace(resourceId: string, account?: string, region?: string, partition?: string): this;
}
