ORACLE_ABI = [
    {
        "members": [
            {"name": "base", "offset": 0, "type": "BaseEntry"},
            {"name": "pair_id", "offset": 3, "type": "felt"},
            {"name": "price", "offset": 4, "type": "felt"},
            {"name": "volume", "offset": 5, "type": "felt"},
        ],
        "name": "SpotEntry",
        "size": 6,
        "type": "struct",
    },
    {
        "members": [
            {"name": "timestamp", "offset": 0, "type": "felt"},
            {"name": "source", "offset": 1, "type": "felt"},
            {"name": "publisher", "offset": 2, "type": "felt"},
        ],
        "name": "BaseEntry",
        "size": 3,
        "type": "struct",
    },
    {
        "members": [
            {"name": "id", "offset": 0, "type": "felt"},
            {"name": "decimals", "offset": 1, "type": "felt"},
            {"name": "is_abstract_currency", "offset": 2, "type": "felt"},
            {"name": "starknet_address", "offset": 3, "type": "felt"},
            {"name": "ethereum_address", "offset": 4, "type": "felt"},
        ],
        "name": "Currency",
        "size": 5,
        "type": "struct",
    },
    {
        "members": [
            {"name": "id", "offset": 0, "type": "felt"},
            {"name": "quote_currency_id", "offset": 1, "type": "felt"},
            {"name": "base_currency_id", "offset": 2, "type": "felt"},
        ],
        "name": "Pair",
        "size": 3,
        "type": "struct",
    },
    {
        "members": [
            {"name": "timestamp", "offset": 0, "type": "felt"},
            {"name": "value", "offset": 1, "type": "felt"},
            {"name": "aggregation_mode", "offset": 2, "type": "felt"},
            {"name": "num_sources_aggregated", "offset": 3, "type": "felt"},
        ],
        "name": "Checkpoint",
        "size": 4,
        "type": "struct",
    },
    {
        "data": [
            {"name": "old_publisher_registry_address", "type": "felt"},
            {"name": "new_publisher_registry_address", "type": "felt"},
        ],
        "keys": [],
        "name": "UpdatedPublisherRegistryAddress",
        "type": "event",
    },
    {
        "data": [{"name": "new_entry", "type": "SpotEntry"}],
        "keys": [],
        "name": "SubmittedSpotEntry",
        "type": "event",
    },
    {
        "data": [{"name": "currency", "type": "Currency"}],
        "keys": [],
        "name": "SubmittedCurrency",
        "type": "event",
    },
    {
        "data": [{"name": "currency", "type": "Currency"}],
        "keys": [],
        "name": "UpdatedCurrency",
        "type": "event",
    },
    {
        "data": [{"name": "pair", "type": "Pair"}],
        "keys": [],
        "name": "SubmittedPair",
        "type": "event",
    },
    {
        "data": [{"name": "implementation", "type": "felt"}],
        "keys": [],
        "name": "Upgraded",
        "type": "event",
    },
    {
        "data": [
            {"name": "previousAdminAddress", "type": "felt"},
            {"name": "newAdminAddress", "type": "felt"},
        ],
        "keys": [],
        "name": "AdminAddressChanged",
        "type": "event",
    },
    {
        "inputs": [
            {"name": "proxy_admin", "type": "felt"},
            {"name": "publisher_registry_address", "type": "felt"},
            {"name": "currencies_len", "type": "felt"},
            {"name": "currencies", "type": "Currency*"},
            {"name": "pairs_len", "type": "felt"},
            {"name": "pairs", "type": "Pair*"},
        ],
        "name": "initializer",
        "outputs": [],
        "type": "function",
    },
    {
        "inputs": [
            {"name": "pair_id", "type": "felt"},
            {"name": "sources_len", "type": "felt"},
            {"name": "sources", "type": "felt*"},
        ],
        "name": "get_spot_entries_for_sources",
        "outputs": [
            {"name": "entries_len", "type": "felt"},
            {"name": "entries", "type": "SpotEntry*"},
        ],
        "stateMutability": "view",
        "type": "function",
    },
    {
        "inputs": [{"name": "pair_id", "type": "felt"}],
        "name": "get_spot_entries",
        "outputs": [
            {"name": "entries_len", "type": "felt"},
            {"name": "entries", "type": "SpotEntry*"},
        ],
        "stateMutability": "view",
        "type": "function",
    },
    {
        "inputs": [
            {"name": "pair_id", "type": "felt"},
            {"name": "source", "type": "felt"},
        ],
        "name": "get_spot_entry",
        "outputs": [{"name": "entry", "type": "SpotEntry"}],
        "stateMutability": "view",
        "type": "function",
    },
    {
        "inputs": [
            {"name": "pair_id", "type": "felt"},
            {"name": "source", "type": "felt"},
        ],
        "name": "get_future_entry",
        "outputs": [{"name": "entry", "type": "SpotEntry"}],
        "stateMutability": "view",
        "type": "function",
    },
    {
        "inputs": [{"name": "pair_id", "type": "felt"}],
        "name": "get_spot_median",
        "outputs": [
            {"name": "price", "type": "felt"},
            {"name": "decimals", "type": "felt"},
            {"name": "last_updated_timestamp", "type": "felt"},
            {"name": "num_sources_aggregated", "type": "felt"},
        ],
        "stateMutability": "view",
        "type": "function",
    },
    {
        "inputs": [
            {"name": "pair_id", "type": "felt"},
            {"name": "aggregation_mode", "type": "felt"},
        ],
        "name": "get_spot",
        "outputs": [
            {"name": "price", "type": "felt"},
            {"name": "decimals", "type": "felt"},
            {"name": "last_updated_timestamp", "type": "felt"},
            {"name": "num_sources_aggregated", "type": "felt"},
        ],
        "stateMutability": "view",
        "type": "function",
    },
    {
        "inputs": [
            {"name": "pair_id", "type": "felt"},
            {"name": "aggregation_mode", "type": "felt"},
            {"name": "sources_len", "type": "felt"},
            {"name": "sources", "type": "felt*"},
        ],
        "name": "get_spot_for_sources",
        "outputs": [
            {"name": "price", "type": "felt"},
            {"name": "decimals", "type": "felt"},
            {"name": "last_updated_timestamp", "type": "felt"},
            {"name": "num_sources_aggregated", "type": "felt"},
        ],
        "stateMutability": "view",
        "type": "function",
    },
    {
        "inputs": [],
        "name": "get_publisher_registry_address",
        "outputs": [{"name": "publisher_registry_address", "type": "felt"}],
        "stateMutability": "view",
        "type": "function",
    },
    {
        "inputs": [{"name": "pair_id", "type": "felt"}],
        "name": "get_decimals",
        "outputs": [{"name": "decimals", "type": "felt"}],
        "stateMutability": "view",
        "type": "function",
    },
    {
        "inputs": [{"name": "new_entry", "type": "SpotEntry"}],
        "name": "publish_spot_entry",
        "outputs": [],
        "type": "function",
    },
    {
        "inputs": [
            {"name": "new_entries_len", "type": "felt"},
            {"name": "new_entries", "type": "SpotEntry*"},
        ],
        "name": "publish_spot_entries",
        "outputs": [],
        "type": "function",
    },
    {
        "inputs": [{"name": "publisher_registry_address", "type": "felt"}],
        "name": "update_publisher_registry_address",
        "outputs": [],
        "type": "function",
    },
    {
        "inputs": [{"name": "currency", "type": "Currency"}],
        "name": "add_currency",
        "outputs": [],
        "type": "function",
    },
    {
        "inputs": [{"name": "currency", "type": "Currency"}],
        "name": "update_currency",
        "outputs": [],
        "type": "function",
    },
    {
        "inputs": [{"name": "pair", "type": "Pair"}],
        "name": "add_pair",
        "outputs": [],
        "type": "function",
    },
    {
        "inputs": [{"name": "key", "type": "felt"}],
        "name": "get_latest_checkpoint_index",
        "outputs": [{"name": "latest", "type": "felt"}],
        "stateMutability": "view",
        "type": "function",
    },
    {
        "inputs": [{"name": "key", "type": "felt"}, {"name": "index", "type": "felt"}],
        "name": "get_checkpoint",
        "outputs": [{"name": "checkpoint", "type": "Checkpoint"}],
        "stateMutability": "view",
        "type": "function",
    },
    {
        "inputs": [],
        "name": "get_sources_threshold",
        "outputs": [{"name": "threshold", "type": "felt"}],
        "stateMutability": "view",
        "type": "function",
    },
    {
        "inputs": [{"name": "new_implementation", "type": "felt"}],
        "name": "upgrade",
        "outputs": [],
        "type": "function",
    },
    {
        "inputs": [{"name": "new_admin_address", "type": "felt"}],
        "name": "set_admin_address",
        "outputs": [],
        "type": "function",
    },
    {
        "inputs": [],
        "name": "get_implementation_hash",
        "outputs": [{"name": "address", "type": "felt"}],
        "stateMutability": "view",
        "type": "function",
    },
    {
        "inputs": [],
        "name": "get_admin_address",
        "outputs": [{"name": "admin_address", "type": "felt"}],
        "stateMutability": "view",
        "type": "function",
    },
    {
        "inputs": [
            {"name": "pair_id", "type": "felt"},
            {"name": "aggregation_mode", "type": "felt"},
        ],
        "name": "set_checkpoint",
        "outputs": [],
        "type": "function",
    },
    {
        "inputs": [{"name": "threshold", "type": "felt"}],
        "name": "set_sources_threshold",
        "outputs": [],
        "type": "function",
    },
]
