# Generated by Django 3.2.4 on 2021-07-26 00:40

import _socket
from django.conf import settings
import django.contrib.sites.managers
from django.db import migrations, models
import django.db.models.deletion
import django_audit_fields.fields.hostname_modification_field
import django_audit_fields.fields.userfield
import django_audit_fields.fields.uuid_auto_field
import django_audit_fields.models.audit_model_mixin
import django_revision.revision_field
import edc_model.models.fields.other_charfield
import edc_model.models.validators.date
import edc_protocol.validators
import edc_utils.date
import edc_visit_tracking.managers
import simple_history.models
import uuid


class Migration(migrations.Migration):

    dependencies = [
        ("meta_lists", "0011_auto_20210624_0225"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("sites", "0002_alter_domain_unique"),
        ("meta_subject", "0066_auto_20210721_0335"),
    ]

    operations = [
        migrations.CreateModel(
            name="ComplicationsGlycemia",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.models.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="COMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "cataracts",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("NO_EXAM", "Exam not performed"),
                        ],
                        max_length=15,
                        verbose_name="Presence of cataracts",
                    ),
                ),
                (
                    "fundoscopy",
                    models.CharField(
                        choices=[
                            ("no_retinopathy", "No retinopathy"),
                            ("background_retinopathy", "Background retinopathy"),
                            (
                                "pre_proliferative_retinopathy",
                                "Pre-proliferative retinopathy",
                            ),
                            ("proliferative_retinopathy", "Proliferative retinopathy"),
                            ("maculopathy", "Maculopathy"),
                            ("NO_EXAM", "Exam not performed"),
                        ],
                        max_length=35,
                        verbose_name="Fundoscopy",
                    ),
                ),
                (
                    "foot_skin_condition",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("NO_EXAM", "Exam not performed"),
                        ],
                        max_length=15,
                        verbose_name="Is the skin of the foot intact and in good condition?",
                    ),
                ),
                (
                    "foot_fungal_infection",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("NO_EXAM", "Exam not performed"),
                        ],
                        max_length=15,
                        verbose_name="Is there any fungal infection on the foot?",
                    ),
                ),
                (
                    "foot_sores",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("NO_EXAM", "Exam not performed"),
                        ],
                        max_length=15,
                        verbose_name="Are there any foot sores?",
                    ),
                ),
                (
                    "foot_callouses",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("NO_EXAM", "Exam not performed"),
                        ],
                        max_length=15,
                        verbose_name="Are there any callouses on the foot?",
                    ),
                ),
                (
                    "dp_pulse",
                    models.CharField(
                        choices=[
                            ("present", "Present"),
                            ("absent", "Absent"),
                            ("NO_EXAM", "Exam not performed"),
                        ],
                        max_length=15,
                        verbose_name="Dorsalis pedis pulse",
                    ),
                ),
                (
                    "pt_pulse",
                    models.CharField(
                        choices=[
                            ("present", "Present"),
                            ("absent", "Absent"),
                            ("NO_EXAM", "Exam not performed"),
                        ],
                        max_length=15,
                        verbose_name="Posterior tibial pulse",
                    ),
                ),
                (
                    "at_reflex",
                    models.CharField(
                        choices=[
                            ("present", "Present"),
                            ("absent", "Absent"),
                            ("NO_EXAM", "Exam not performed"),
                        ],
                        max_length=15,
                        verbose_name="Achilles tendon reflex",
                    ),
                ),
                (
                    "nds_vpt_left",
                    models.CharField(
                        choices=[
                            ("NORMAL", "Normal"),
                            ("ABNORMAL", "Abnormal"),
                            ("NO_EXAM", "No exam performed"),
                        ],
                        help_text="128-Hz tuning fork; apex of big toe. Normal: can distinguish vibrating/Not vibrating",
                        max_length=15,
                        verbose_name="Vibration perception threshold (left)",
                    ),
                ),
                (
                    "nds_vpt_right",
                    models.CharField(
                        choices=[
                            ("NORMAL", "Normal"),
                            ("ABNORMAL", "Abnormal"),
                            ("NO_EXAM", "No exam performed"),
                        ],
                        help_text="128-Hz tuning fork; apex of big toe. Normal: can distinguish vibrating/Not vibrating",
                        max_length=15,
                        verbose_name="Vibration perception threshold (right)",
                    ),
                ),
                (
                    "nds_tp_left",
                    models.CharField(
                        choices=[
                            ("NORMAL", "Normal"),
                            ("ABNORMAL", "Abnormal"),
                            ("NO_EXAM", "No exam performed"),
                        ],
                        help_text="Use tuning fork with beaker of ice/warm water",
                        max_length=15,
                        verbose_name="Temperature perception on dorsum of foot (left)",
                    ),
                ),
                (
                    "nds_tp_right",
                    models.CharField(
                        choices=[
                            ("NORMAL", "Normal"),
                            ("ABNORMAL", "Abnormal"),
                            ("NO_EXAM", "No exam performed"),
                        ],
                        help_text="Use tuning fork with beaker of ice/warm water",
                        max_length=15,
                        verbose_name="Temperature perception on dorsum of foot (right)",
                    ),
                ),
                (
                    "nds_pp_left",
                    models.CharField(
                        choices=[
                            ("NORMAL", "Normal"),
                            ("ABNORMAL", "Abnormal"),
                            ("NO_EXAM", "No exam performed"),
                        ],
                        help_text="Use tuning fork with beaker of ice/warm water",
                        max_length=15,
                        verbose_name="Pin-Prick (left)",
                    ),
                ),
                (
                    "nds_pp_right",
                    models.CharField(
                        choices=[
                            ("NORMAL", "Normal"),
                            ("ABNORMAL", "Abnormal"),
                            ("NO_EXAM", "No exam performed"),
                        ],
                        help_text="Use tuning fork with beaker of ice/warm water",
                        max_length=15,
                        verbose_name="Pin-Prick (right)",
                    ),
                ),
                (
                    "nds_achilles_reflex_left",
                    models.CharField(
                        choices=[
                            ("present", "Present"),
                            (
                                "present_with_reinforcement",
                                "Present with reinforcement",
                            ),
                            ("absent", "Absent"),
                            ("NO_EXAM", "Exam not performed"),
                        ],
                        max_length=30,
                        verbose_name="Achilles reflex (left)",
                    ),
                ),
                (
                    "nds_achilles_reflex_right",
                    models.CharField(
                        choices=[
                            ("present", "Present"),
                            (
                                "present_with_reinforcement",
                                "Present with reinforcement",
                            ),
                            ("absent", "Absent"),
                            ("NO_EXAM", "Exam not performed"),
                        ],
                        max_length=30,
                        verbose_name="Achilles reflex (right)",
                    ),
                ),
                (
                    "first_metatarsal_left",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("NO_EXAM", "Exam not performed"),
                        ],
                        max_length=15,
                        verbose_name="First metatarsal (left)",
                    ),
                ),
                (
                    "first_metatarsal_right",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("NO_EXAM", "Exam not performed"),
                        ],
                        max_length=15,
                        verbose_name="First metatarsal (right)",
                    ),
                ),
                (
                    "third_metatarsal_left",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("NO_EXAM", "Exam not performed"),
                        ],
                        max_length=15,
                        verbose_name="Third metatarsal (left)",
                    ),
                ),
                (
                    "third_metatarsal_right",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("NO_EXAM", "Exam not performed"),
                        ],
                        max_length=15,
                        verbose_name="Third metatarsal (right)",
                    ),
                ),
                (
                    "fifth_metatarsal_left",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("NO_EXAM", "Exam not performed"),
                        ],
                        max_length=15,
                        verbose_name="Fifth metatarsal (left)",
                    ),
                ),
                (
                    "fifth_metatarsal_right",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("NO_EXAM", "Exam not performed"),
                        ],
                        max_length=15,
                        verbose_name="Fifth metatarsal (right)",
                    ),
                ),
                (
                    "plantar_surface_left",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("NO_EXAM", "Exam not performed"),
                        ],
                        max_length=15,
                        verbose_name="Plantar surface of distal hallux (left)",
                    ),
                ),
                (
                    "plantar_surface_right",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("NO_EXAM", "Exam not performed"),
                        ],
                        max_length=15,
                        verbose_name="Plantar surface of distal hallux (right)",
                    ),
                ),
                (
                    "dns_walking",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("NO_EXAM", "Exam not performed"),
                        ],
                        max_length=15,
                        verbose_name="Are you experiencing unsteadiness in walking?",
                    ),
                ),
                (
                    "dns_burning",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("NO_EXAM", "Exam not performed"),
                        ],
                        max_length=15,
                        verbose_name="Do you have burning, aching pain or tenderness in your legs or feet?",
                    ),
                ),
                (
                    "dns_tingling",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("NO_EXAM", "Exam not performed"),
                        ],
                        max_length=15,
                        verbose_name="Do you have prickling or tingling sensation in your legs or feet?",
                    ),
                ),
                (
                    "dns_numbness",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("NO_EXAM", "Exam not performed"),
                        ],
                        max_length=15,
                        verbose_name="Are you experiencing any numbness or loss of feeling in your legs or feet?",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="meta_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Complications (Raised Glycemia)",
                "verbose_name_plural": "Complications (Raised Glycemia)",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="HistoricalComplicationsGlycemia",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.models.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="COMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "cataracts",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("NO_EXAM", "Exam not performed"),
                        ],
                        max_length=15,
                        verbose_name="Presence of cataracts",
                    ),
                ),
                (
                    "fundoscopy",
                    models.CharField(
                        choices=[
                            ("no_retinopathy", "No retinopathy"),
                            ("background_retinopathy", "Background retinopathy"),
                            (
                                "pre_proliferative_retinopathy",
                                "Pre-proliferative retinopathy",
                            ),
                            ("proliferative_retinopathy", "Proliferative retinopathy"),
                            ("maculopathy", "Maculopathy"),
                            ("NO_EXAM", "Exam not performed"),
                        ],
                        max_length=35,
                        verbose_name="Fundoscopy",
                    ),
                ),
                (
                    "foot_skin_condition",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("NO_EXAM", "Exam not performed"),
                        ],
                        max_length=15,
                        verbose_name="Is the skin of the foot intact and in good condition?",
                    ),
                ),
                (
                    "foot_fungal_infection",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("NO_EXAM", "Exam not performed"),
                        ],
                        max_length=15,
                        verbose_name="Is there any fungal infection on the foot?",
                    ),
                ),
                (
                    "foot_sores",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("NO_EXAM", "Exam not performed"),
                        ],
                        max_length=15,
                        verbose_name="Are there any foot sores?",
                    ),
                ),
                (
                    "foot_callouses",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("NO_EXAM", "Exam not performed"),
                        ],
                        max_length=15,
                        verbose_name="Are there any callouses on the foot?",
                    ),
                ),
                (
                    "dp_pulse",
                    models.CharField(
                        choices=[
                            ("present", "Present"),
                            ("absent", "Absent"),
                            ("NO_EXAM", "Exam not performed"),
                        ],
                        max_length=15,
                        verbose_name="Dorsalis pedis pulse",
                    ),
                ),
                (
                    "pt_pulse",
                    models.CharField(
                        choices=[
                            ("present", "Present"),
                            ("absent", "Absent"),
                            ("NO_EXAM", "Exam not performed"),
                        ],
                        max_length=15,
                        verbose_name="Posterior tibial pulse",
                    ),
                ),
                (
                    "at_reflex",
                    models.CharField(
                        choices=[
                            ("present", "Present"),
                            ("absent", "Absent"),
                            ("NO_EXAM", "Exam not performed"),
                        ],
                        max_length=15,
                        verbose_name="Achilles tendon reflex",
                    ),
                ),
                (
                    "nds_vpt_left",
                    models.CharField(
                        choices=[
                            ("NORMAL", "Normal"),
                            ("ABNORMAL", "Abnormal"),
                            ("NO_EXAM", "No exam performed"),
                        ],
                        help_text="128-Hz tuning fork; apex of big toe. Normal: can distinguish vibrating/Not vibrating",
                        max_length=15,
                        verbose_name="Vibration perception threshold (left)",
                    ),
                ),
                (
                    "nds_vpt_right",
                    models.CharField(
                        choices=[
                            ("NORMAL", "Normal"),
                            ("ABNORMAL", "Abnormal"),
                            ("NO_EXAM", "No exam performed"),
                        ],
                        help_text="128-Hz tuning fork; apex of big toe. Normal: can distinguish vibrating/Not vibrating",
                        max_length=15,
                        verbose_name="Vibration perception threshold (right)",
                    ),
                ),
                (
                    "nds_tp_left",
                    models.CharField(
                        choices=[
                            ("NORMAL", "Normal"),
                            ("ABNORMAL", "Abnormal"),
                            ("NO_EXAM", "No exam performed"),
                        ],
                        help_text="Use tuning fork with beaker of ice/warm water",
                        max_length=15,
                        verbose_name="Temperature perception on dorsum of foot (left)",
                    ),
                ),
                (
                    "nds_tp_right",
                    models.CharField(
                        choices=[
                            ("NORMAL", "Normal"),
                            ("ABNORMAL", "Abnormal"),
                            ("NO_EXAM", "No exam performed"),
                        ],
                        help_text="Use tuning fork with beaker of ice/warm water",
                        max_length=15,
                        verbose_name="Temperature perception on dorsum of foot (right)",
                    ),
                ),
                (
                    "nds_pp_left",
                    models.CharField(
                        choices=[
                            ("NORMAL", "Normal"),
                            ("ABNORMAL", "Abnormal"),
                            ("NO_EXAM", "No exam performed"),
                        ],
                        help_text="Use tuning fork with beaker of ice/warm water",
                        max_length=15,
                        verbose_name="Pin-Prick (left)",
                    ),
                ),
                (
                    "nds_pp_right",
                    models.CharField(
                        choices=[
                            ("NORMAL", "Normal"),
                            ("ABNORMAL", "Abnormal"),
                            ("NO_EXAM", "No exam performed"),
                        ],
                        help_text="Use tuning fork with beaker of ice/warm water",
                        max_length=15,
                        verbose_name="Pin-Prick (right)",
                    ),
                ),
                (
                    "nds_achilles_reflex_left",
                    models.CharField(
                        choices=[
                            ("present", "Present"),
                            (
                                "present_with_reinforcement",
                                "Present with reinforcement",
                            ),
                            ("absent", "Absent"),
                            ("NO_EXAM", "Exam not performed"),
                        ],
                        max_length=30,
                        verbose_name="Achilles reflex (left)",
                    ),
                ),
                (
                    "nds_achilles_reflex_right",
                    models.CharField(
                        choices=[
                            ("present", "Present"),
                            (
                                "present_with_reinforcement",
                                "Present with reinforcement",
                            ),
                            ("absent", "Absent"),
                            ("NO_EXAM", "Exam not performed"),
                        ],
                        max_length=30,
                        verbose_name="Achilles reflex (right)",
                    ),
                ),
                (
                    "first_metatarsal_left",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("NO_EXAM", "Exam not performed"),
                        ],
                        max_length=15,
                        verbose_name="First metatarsal (left)",
                    ),
                ),
                (
                    "first_metatarsal_right",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("NO_EXAM", "Exam not performed"),
                        ],
                        max_length=15,
                        verbose_name="First metatarsal (right)",
                    ),
                ),
                (
                    "third_metatarsal_left",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("NO_EXAM", "Exam not performed"),
                        ],
                        max_length=15,
                        verbose_name="Third metatarsal (left)",
                    ),
                ),
                (
                    "third_metatarsal_right",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("NO_EXAM", "Exam not performed"),
                        ],
                        max_length=15,
                        verbose_name="Third metatarsal (right)",
                    ),
                ),
                (
                    "fifth_metatarsal_left",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("NO_EXAM", "Exam not performed"),
                        ],
                        max_length=15,
                        verbose_name="Fifth metatarsal (left)",
                    ),
                ),
                (
                    "fifth_metatarsal_right",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("NO_EXAM", "Exam not performed"),
                        ],
                        max_length=15,
                        verbose_name="Fifth metatarsal (right)",
                    ),
                ),
                (
                    "plantar_surface_left",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("NO_EXAM", "Exam not performed"),
                        ],
                        max_length=15,
                        verbose_name="Plantar surface of distal hallux (left)",
                    ),
                ),
                (
                    "plantar_surface_right",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("NO_EXAM", "Exam not performed"),
                        ],
                        max_length=15,
                        verbose_name="Plantar surface of distal hallux (right)",
                    ),
                ),
                (
                    "dns_walking",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("NO_EXAM", "Exam not performed"),
                        ],
                        max_length=15,
                        verbose_name="Are you experiencing unsteadiness in walking?",
                    ),
                ),
                (
                    "dns_burning",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("NO_EXAM", "Exam not performed"),
                        ],
                        max_length=15,
                        verbose_name="Do you have burning, aching pain or tenderness in your legs or feet?",
                    ),
                ),
                (
                    "dns_tingling",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("NO_EXAM", "Exam not performed"),
                        ],
                        max_length=15,
                        verbose_name="Do you have prickling or tingling sensation in your legs or feet?",
                    ),
                ),
                (
                    "dns_numbness",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("NO_EXAM", "Exam not performed"),
                        ],
                        max_length=15,
                        verbose_name="Are you experiencing any numbness or loss of feeling in your legs or feet?",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="meta_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Complications (Raised Glycemia)",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.RemoveField(
            model_name="historicaladditionalscreening",
            name="history_user",
        ),
        migrations.RemoveField(
            model_name="historicaladditionalscreening",
            name="site",
        ),
        migrations.RemoveField(
            model_name="historicaladditionalscreening",
            name="subject_visit",
        ),
        migrations.AlterField(
            model_name="complications",
            name="fundoscopy",
            field=models.CharField(
                choices=[
                    ("no_retinopathy", "No retinopathy"),
                    ("background_retinopathy", "Background retinopathy"),
                    ("pre_proliferative_retinopathy", "Pre-proliferative retinopathy"),
                    ("proliferative_retinopathy", "Proliferative retinopathy"),
                    ("maculopathy", "Maculopathy"),
                    ("NO_EXAM", "Exam not performed"),
                ],
                max_length=35,
                verbose_name="Fundoscopy",
            ),
        ),
        migrations.AlterField(
            model_name="historicalcomplications",
            name="fundoscopy",
            field=models.CharField(
                choices=[
                    ("no_retinopathy", "No retinopathy"),
                    ("background_retinopathy", "Background retinopathy"),
                    ("pre_proliferative_retinopathy", "Pre-proliferative retinopathy"),
                    ("proliferative_retinopathy", "Proliferative retinopathy"),
                    ("maculopathy", "Maculopathy"),
                    ("NO_EXAM", "Exam not performed"),
                ],
                max_length=35,
                verbose_name="Fundoscopy",
            ),
        ),
        migrations.AlterField(
            model_name="historicalmedicationadherence",
            name="other_missed_pill_reason",
            field=edc_model.models.fields.other_charfield.OtherCharField(
                blank=True,
                max_length=150,
                null=True,
                verbose_name="If other, please specify ...",
            ),
        ),
        migrations.AlterField(
            model_name="medicationadherence",
            name="other_missed_pill_reason",
            field=edc_model.models.fields.other_charfield.OtherCharField(
                blank=True,
                max_length=150,
                null=True,
                verbose_name="If other, please specify ...",
            ),
        ),
        migrations.AlterField(
            model_name="subjectvisitmissed",
            name="missed_reasons",
            field=models.ManyToManyField(
                blank=True,
                related_name="meta_missed_reasons",
                to="meta_lists.SubjectVisitMissedReasons",
            ),
        ),
        migrations.DeleteModel(
            name="AdditionalScreening",
        ),
        migrations.DeleteModel(
            name="HistoricalAdditionalScreening",
        ),
        migrations.AddIndex(
            model_name="complicationsglycemia",
            index=models.Index(
                fields=["subject_visit", "site", "id"],
                name="meta_subjec_subject_3c1655_idx",
            ),
        ),
    ]
