# Generated by Django 3.2.6 on 2021-08-23 13:12

import _socket
import django.contrib.sites.managers
import django.core.validators
import django.db.models.deletion
import django_audit_fields.fields.hostname_modification_field
import django_audit_fields.fields.userfield
import django_audit_fields.fields.uuid_auto_field
import django_audit_fields.models.audit_model_mixin
import django_revision.revision_field
import edc_model.models.fields.other_charfield
import edc_model.models.validators.date
import edc_protocol.validators
import edc_utils.date
import edc_visit_tracking.managers
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("sites", "0002_alter_domain_unique"),
        ("meta_subject", "0081_auto_20210817_2306"),
    ]

    operations = [
        migrations.CreateModel(
            name="HealthEconomicsSimple",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.models.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="COMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "education_in_years",
                    models.IntegerField(
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(30),
                        ],
                        verbose_name="How many years of education did you complete?",
                    ),
                ),
                (
                    "education_certificate",
                    models.CharField(
                        choices=[
                            ("primary", "Primary Certificate"),
                            ("secondary", "Secondary Certificate"),
                            ("tertiary", "post-Secondary/Tertiary/College"),
                            ("OTHER", "Other, please specify ..."),
                            ("N/A", "Not applicable, never went to school"),
                        ],
                        max_length=50,
                        null=True,
                        verbose_name="What is your highest education certificate?",
                    ),
                ),
                (
                    "education_certificate_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "education_certificate_tertiary",
                    models.CharField(
                        blank=True,
                        max_length=50,
                        null=True,
                        verbose_name="If your highest education certificate above is `Tertiary`, what type of tertiary certificate?",
                    ),
                ),
                (
                    "primary_school",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        max_length=15,
                        verbose_name="Did you go to primary/elementary school?",
                    ),
                ),
                (
                    "primary_school_in_years",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(10),
                        ],
                        verbose_name="If YES, for how many years",
                    ),
                ),
                (
                    "secondary_school",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        max_length=15,
                        verbose_name="Did you go to secondary school?",
                    ),
                ),
                (
                    "secondary_school_in_years",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(10),
                        ],
                        verbose_name="If YES, for how many years",
                    ),
                ),
                (
                    "higher_education",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        max_length=15,
                        verbose_name="Did you go to higher education?",
                    ),
                ),
                (
                    "higher_education_in_years",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(20),
                        ],
                        verbose_name="If YES, for how many years",
                    ),
                ),
                (
                    "occupation",
                    models.CharField(
                        max_length=50,
                        verbose_name="What is your occupation/profession?",
                    ),
                ),
                (
                    "marital_status",
                    models.CharField(
                        choices=[
                            ("never_married", "Never married"),
                            ("married", "Currently married"),
                            ("separated", "Separated"),
                            ("divorced", "Divorced"),
                            ("widowed", "Widow / Spinster"),
                        ],
                        max_length=25,
                        verbose_name="Marital status",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="meta_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Health Economics (M3)",
                "verbose_name_plural": "Health Economics (M3)",
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
    ]
