# Generated by Django 3.2.11 on 2022-03-24 00:04

import django.core.validators
from django.db import migrations, models
import django_crypto_fields.fields.encrypted_text_field
import edc_model.models.validators.date
import edc_protocol.validators


class Migration(migrations.Migration):

    dependencies = [
        ('meta_subject', '0101_auto_20220316_2147'),
    ]

    operations = [
        migrations.RemoveField(
            model_name='delivery',
            name='informant_contact',
        ),
        migrations.RemoveField(
            model_name='delivery',
            name='informant_is_patient',
        ),
        migrations.RemoveField(
            model_name='historicaldelivery',
            name='informant_contact',
        ),
        migrations.RemoveField(
            model_name='historicaldelivery',
            name='informant_is_patient',
        ),
        migrations.AddField(
            model_name='delivery',
            name='info_available',
            field=models.CharField(choices=[('Yes', 'Yes'), ('No', 'No')], default='Yes', help_text='If NO, please explain below', max_length=5, verbose_name='Were you able to obtain a report on the delivery?'),
        ),
        migrations.AddField(
            model_name='delivery',
            name='info_not_available_reason',
            field=models.TextField(null=True, verbose_name='If the report was not available, please explain?'),
        ),
        migrations.AddField(
            model_name='delivery',
            name='info_source',
            field=models.CharField(choices=[('patient', 'Study participant'), ('OTHER', 'Other'), ('N/A', 'Not applicable')], default='patient', max_length=25, verbose_name='Who / what is the MAIN source of this information?'),
        ),
        migrations.AddField(
            model_name='delivery',
            name='info_source_other',
            field=django_crypto_fields.fields.encrypted_text_field.EncryptedTextField(blank=True, help_text=' (Encryption: AES local)', max_length=71, null=True, verbose_name='If not reported from study participant, please give the name and contact details of the informant.'),
        ),
        migrations.AddField(
            model_name='historicaldelivery',
            name='info_available',
            field=models.CharField(choices=[('Yes', 'Yes'), ('No', 'No')], default='Yes', help_text='If NO, please explain below', max_length=5, verbose_name='Were you able to obtain a report on the delivery?'),
        ),
        migrations.AddField(
            model_name='historicaldelivery',
            name='info_not_available_reason',
            field=models.TextField(null=True, verbose_name='If the report was not available, please explain?'),
        ),
        migrations.AddField(
            model_name='historicaldelivery',
            name='info_source',
            field=models.CharField(choices=[('patient', 'Study participant'), ('OTHER', 'Other'), ('N/A', 'Not applicable')], default='patient', max_length=25, verbose_name='Who / what is the MAIN source of this information?'),
        ),
        migrations.AddField(
            model_name='historicaldelivery',
            name='info_source_other',
            field=django_crypto_fields.fields.encrypted_text_field.EncryptedTextField(blank=True, help_text=' (Encryption: AES local)', max_length=71, null=True, verbose_name='If not reported from study participant, please give the name and contact details of the informant.'),
        ),
        migrations.AddField(
            model_name='historicalmedicationadherence',
            name='pill_count_performed',
            field=models.CharField(choices=[('Yes', 'Yes'), ('No', 'No')], default='Yes', max_length=5, verbose_name='Was a pill count performed'),
        ),
        migrations.AddField(
            model_name='medicationadherence',
            name='pill_count_performed',
            field=models.CharField(choices=[('Yes', 'Yes'), ('No', 'No')], default='Yes', max_length=5, verbose_name='Was a pill count performed'),
        ),
        migrations.AlterField(
            model_name='delivery',
            name='delivery_datetime',
            field=models.DateTimeField(help_text='If TIME unknown, estimate', null=True, validators=[edc_model.models.validators.date.datetime_not_future, edc_protocol.validators.datetime_not_before_study_start], verbose_name='Date and time of delivery :'),
        ),
        migrations.AlterField(
            model_name='delivery',
            name='delivery_ga',
            field=models.IntegerField(null=True, validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(45)], verbose_name='Gestational age at delivery'),
        ),
        migrations.AlterField(
            model_name='delivery',
            name='delivery_location',
            field=models.CharField(choices=[('home', 'At home'), ('hospital_clinic', 'Hospital / Clinic'), ('OTHER', 'Other location, specify'), ('N/A', 'Not applicable')], default='N/A', max_length=25, verbose_name='Where did the delivery occur?'),
        ),
        migrations.AlterField(
            model_name='delivery',
            name='delivery_time_estimated',
            field=models.CharField(choices=[('Yes', 'Yes'), ('No', 'No'), ('N/A', 'Not applicable')], max_length=3, verbose_name='Is the delivery TIME estimated?'),
        ),
        migrations.AlterField(
            model_name='delivery',
            name='fetal_outcome_count',
            field=models.IntegerField(help_text='Each to be reported individually below', null=True, verbose_name='Number of births / fetal / neonatal outcomes'),
        ),
        migrations.AlterField(
            model_name='delivery',
            name='gm_treated',
            field=models.CharField(choices=[('Yes', 'Yes'), ('No', 'No'), ('N/A', 'Not applicable')], default='N/A', max_length=5, verbose_name='Was the participant treated for gestational diabetes?'),
        ),
        migrations.AlterField(
            model_name='delivery',
            name='informant_relation',
            field=models.CharField(choices=[('husband_wife', 'Husband/wife'), ('Parent', 'Parent'), ('child', 'Child'), ('unknown', 'Unknown'), ('OTHER', 'Other'), ('hospital_clinic', 'Hospital / Clinic records'), ('N/A', 'Not applicable')], default='N/A', max_length=25, verbose_name='Informants relationship to the participant?'),
        ),
        migrations.AlterField(
            model_name='delivery',
            name='maternal_outcome',
            field=models.CharField(choices=[('no_complications', 'No complications'), ('complications_full_recovery', 'Complications with full recovery'), ('complications_ongoing_recovery', 'Complications with ongoing recovery'), ('dead', 'Maternal mortality'), ('N/A', 'Not applicable')], default='N/A', max_length=50, verbose_name='What was the maternal outcome of the pregnancy?'),
        ),
        migrations.AlterField(
            model_name='historicaldelivery',
            name='delivery_datetime',
            field=models.DateTimeField(help_text='If TIME unknown, estimate', null=True, validators=[edc_model.models.validators.date.datetime_not_future, edc_protocol.validators.datetime_not_before_study_start], verbose_name='Date and time of delivery :'),
        ),
        migrations.AlterField(
            model_name='historicaldelivery',
            name='delivery_ga',
            field=models.IntegerField(null=True, validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(45)], verbose_name='Gestational age at delivery'),
        ),
        migrations.AlterField(
            model_name='historicaldelivery',
            name='delivery_location',
            field=models.CharField(choices=[('home', 'At home'), ('hospital_clinic', 'Hospital / Clinic'), ('OTHER', 'Other location, specify'), ('N/A', 'Not applicable')], default='N/A', max_length=25, verbose_name='Where did the delivery occur?'),
        ),
        migrations.AlterField(
            model_name='historicaldelivery',
            name='delivery_time_estimated',
            field=models.CharField(choices=[('Yes', 'Yes'), ('No', 'No'), ('N/A', 'Not applicable')], max_length=3, verbose_name='Is the delivery TIME estimated?'),
        ),
        migrations.AlterField(
            model_name='historicaldelivery',
            name='fetal_outcome_count',
            field=models.IntegerField(help_text='Each to be reported individually below', null=True, verbose_name='Number of births / fetal / neonatal outcomes'),
        ),
        migrations.AlterField(
            model_name='historicaldelivery',
            name='gm_treated',
            field=models.CharField(choices=[('Yes', 'Yes'), ('No', 'No'), ('N/A', 'Not applicable')], default='N/A', max_length=5, verbose_name='Was the participant treated for gestational diabetes?'),
        ),
        migrations.AlterField(
            model_name='historicaldelivery',
            name='informant_relation',
            field=models.CharField(choices=[('husband_wife', 'Husband/wife'), ('Parent', 'Parent'), ('child', 'Child'), ('unknown', 'Unknown'), ('OTHER', 'Other'), ('hospital_clinic', 'Hospital / Clinic records'), ('N/A', 'Not applicable')], default='N/A', max_length=25, verbose_name='Informants relationship to the participant?'),
        ),
        migrations.AlterField(
            model_name='historicaldelivery',
            name='maternal_outcome',
            field=models.CharField(choices=[('no_complications', 'No complications'), ('complications_full_recovery', 'Complications with full recovery'), ('complications_ongoing_recovery', 'Complications with ongoing recovery'), ('dead', 'Maternal mortality'), ('N/A', 'Not applicable')], default='N/A', max_length=50, verbose_name='What was the maternal outcome of the pregnancy?'),
        ),
        migrations.AlterField(
            model_name='historicalsubjectvisit',
            name='last_alive_date',
            field=models.DateField(blank=True, help_text='Will be validated on the Death report', null=True, validators=[edc_protocol.validators.date_not_before_study_start, edc_model.models.validators.date.date_not_future], verbose_name='Date participant last known alive'),
        ),
        migrations.AlterField(
            model_name='historicalsubjectvisit',
            name='survival_status',
            field=models.CharField(choices=[('alive', 'Alive'), ('dead', 'Deceased'), ('unknown', 'Unknown')], default='alive', help_text='If YES, submit Death report', max_length=10, null=True, verbose_name="Participant's survival status"),
        ),
        migrations.AlterField(
            model_name='subjectvisit',
            name='last_alive_date',
            field=models.DateField(blank=True, help_text='Will be validated on the Death report', null=True, validators=[edc_protocol.validators.date_not_before_study_start, edc_model.models.validators.date.date_not_future], verbose_name='Date participant last known alive'),
        ),
        migrations.AlterField(
            model_name='subjectvisit',
            name='survival_status',
            field=models.CharField(choices=[('alive', 'Alive'), ('dead', 'Deceased'), ('unknown', 'Unknown')], default='alive', help_text='If YES, submit Death report', max_length=10, null=True, verbose_name="Participant's survival status"),
        ),
    ]
