"""
Fiat and crypto currencies data.

Fiat currency names from:
    https://en.wikipedia.org/wiki/ISO_4217
    https://github.com/blossomfinance/iso-4217-currencies/blob/master/data/iso-4217.json
Crypto currency names and decimal degits from:
    https://www.coinbase.com
    https://github.com/crypti/cryptocurrencies/blob/master/cryptocurrencies.json
Flag emojis from:
    https://emojipedia.org/search/?q=Turkmenistan
    https://github.com/opencollective/country-currency-emoji-flags/blob/main/currency-data.json
Symbols from:
    https://github.com/arshadkazmi42/currency-symbols/blob/master/currency_symbols/constants.py
"""

FIAT_CURRENCIES = {
    "AED": {
        "name": "United Arab Emirates Dirham",
        "sympol": "د.إ",
        "flag": "🇦🇪",
        "decimal_degits": 2,
    },
    "AFN": {"name": "Afghan Afghani", "sympol": "؋", "flag": "🇦🇫", "decimal_degits": 0},
    "ALL": {"name": "Albanian Lek", "sympol": "L", "flag": "🇦🇱", "decimal_degits": 0},
    "AMD": {"name": "Armenian Dram", "sympol": "֏", "flag": "🇦🇲", "decimal_degits": 0},
    "ANG": {
        "name": "Netherlands Antillean guilder",
        "sympol": "ƒ",
        "flag": "🇳🇱",
        "decimal_degits": 2,
    },
    "AOA": {
        "name": "Angolan kwanza",
        "sympol": "Kz",
        "flag": "🇦🇴",
        "decimal_degits": 0,
    },
    "ARS": {"name": "Argentine Peso", "sympol": "$", "flag": "🇦🇷", "decimal_degits": 2},
    "AUD": {
        "name": "Australian Dollar",
        "sympol": "$",
        "flag": "🇦🇺",
        "decimal_degits": 2,
    },
    "AWG": {"name": "Aruban florin", "sympol": "ƒ", "flag": "🇦🇼", "decimal_degits": 0},
    "AZN": {
        "name": "Azerbaijani Manat",
        "sympol": "₼",
        "flag": "🇦🇿",
        "decimal_degits": 2,
    },
    "BAM": {
        "name": "Bosnia-Herzegovina Convertible Mark",
        "sympol": "KM",
        "flag": "🇧🇦",
        "decimal_degits": 2,
    },
    "BBD": {
        "name": "Barbadian Dollar",
        "sympol": "$",
        "flag": "🇧🇧",
        "decimal_degits": 2,
    },
    "BDT": {
        "name": "Bangladeshi Taka",
        "sympol": "৳",
        "flag": "🇧🇩",
        "decimal_degits": 2,
    },
    "BGN": {"name": "Bulgarian Lev", "sympol": "лв", "flag": "🇧🇬", "decimal_degits": 2},
    "BHD": {
        "name": "Bahraini Dinar",
        "sympol": ".د.ب",
        "flag": "🇧🇭",
        "decimal_degits": 3,
    },
    "BIF": {
        "name": "Burundian Franc",
        "sympol": "FBu",
        "flag": "🇧🇮",
        "decimal_degits": 0,
    },
    "BMD": {
        "name": "Bermudian Dollars",
        "sympol": "$",
        "flag": "🇧🇲",
        "decimal_degits": 2,
    },
    "BND": {"name": "Brunei Dollar", "sympol": "$", "flag": "🇧🇳", "decimal_degits": 2},
    "BOB": {
        "name": "Bolivian Boliviano",
        "sympol": "$b",
        "flag": "🇧🇴",
        "decimal_degits": 2,
    },
    "BRL": {
        "name": "Brazilian Real",
        "sympol": "R$",
        "flag": "🇧🇷",
        "decimal_degits": 2,
    },
    "BSD": {
        "name": "Bahamian Dollar",
        "sympol": "$",
        "flag": "🇧🇸",
        "decimal_degits": 2,
    },
    "BTN": {
        "name": "Bhutanese ngultrum",
        "sympol": "Nu.",
        "flag": "🇧🇹",
        "decimal_degits": 0,
    },
    "BWP": {"name": "Botswanan Pula", "sympol": "P", "flag": "🇧🇼", "decimal_degits": 2},
    "BYN": {
        "name": "Belarusian ruble",
        "sympol": "Br",
        "flag": "🇧🇾",
        "decimal_degits": 2,
    },
    "BYR": {
        "name": "Belarusian Ruble",
        "sympol": "Br",
        "flag": "🇧🇾",
        "decimal_degits": 2,
    },
    "BZD": {
        "name": "Belize Dollar",
        "sympol": "BZ$",
        "flag": "🇧🇿",
        "decimal_degits": 2,
    },
    "CAD": {
        "name": "Canadian Dollar",
        "sympol": "$",
        "flag": "🇨🇦",
        "decimal_degits": 2,
    },
    "CDF": {
        "name": "Congolese Franc",
        "sympol": "FC",
        "flag": "🇨🇩",
        "decimal_degits": 2,
    },
    "CHF": {"name": "Swiss Franc", "sympol": "CHF", "flag": "🇨🇭", "decimal_degits": 2},
    "CLF": {
        "name": "Unidad de Fomento",
        "sympol": "UF",
        "flag": "🇨🇱",
        "decimal_degits": 2,
    },
    "CLP": {"name": "Chilean Peso", "sympol": "$", "flag": "🇨🇱", "decimal_degits": 0},
    "CNY": {"name": "Chinese Yuan", "sympol": "¥", "flag": "🇨🇳", "decimal_degits": 2},
    "COP": {"name": "Colombian Peso", "sympol": "$", "flag": "🇨🇴", "decimal_degits": 0},
    "CRC": {
        "name": "Costa Rican Colón",
        "sympol": "₡",
        "flag": "🇨🇷",
        "decimal_degits": 0,
    },
    "CUC": {
        "name": "Cuban convertible peso",
        "sympol": "$",
        "flag": "🇨🇺",
        "decimal_degits": 0,
    },
    "CVE": {
        "name": "Cape Verdean Escudo",
        "sympol": "$",
        "flag": "🇨🇻",
        "decimal_degits": 2,
    },
    "CZK": {
        "name": "Czech Republic Koruna",
        "sympol": "Kč",
        "flag": "🇨🇿",
        "decimal_degits": 2,
    },
    "DJF": {
        "name": "Djiboutian Franc",
        "sympol": "Fdj",
        "flag": "🇩🇯",
        "decimal_degits": 0,
    },
    "DKK": {"name": "Danish Krone", "sympol": "kr", "flag": "🇩🇰", "decimal_degits": 2},
    "DOP": {
        "name": "Dominican Peso",
        "sympol": "RD$",
        "flag": "🇩🇴",
        "decimal_degits": 2,
    },
    "DZD": {
        "name": "Algerian Dinar",
        "sympol": "دج",
        "flag": "🇩🇿",
        "decimal_degits": 2,
    },
    "EGP": {"name": "Egyptian Pound", "sympol": "£", "flag": "🇪🇬", "decimal_degits": 2},
    "ETB": {
        "name": "Ethiopian Birr",
        "sympol": "Br",
        "flag": "🇪🇹",
        "decimal_degits": 2,
    },
    "EUR": {"name": "Euro", "sympol": "€", "flag": "🇪🇺", "decimal_degits": 2},
    "FJD": {"name": "Fiji dollar", "sympol": "$", "flag": "🇫🇯", "decimal_degits": 0},
    "FKP": {
        "name": "Falkland Islands Pound",
        "sympol": "£",
        "flag": "🇫🇰",
        "decimal_degits": 2,
    },
    "GBP": {
        "name": "British Pound Sterling",
        "sympol": "£",
        "flag": "🇬🇧",
        "decimal_degits": 2,
    },
    "GEL": {"name": "Georgian Lari", "sympol": "₾", "flag": "🇬🇪", "decimal_degits": 2},
    "GHS": {
        "name": "Ghanaian Cedi",
        "sympol": "GH₵",
        "flag": "🇬🇭",
        "decimal_degits": 2,
    },
    "GIP": {
        "name": "Gibraltar pound",
        "sympol": "£",
        "flag": "🇬🇮",
        "decimal_degits": 0,
    },
    "GMD": {"name": "Gambian dalasi", "sympol": "D", "flag": "🇬🇲", "decimal_degits": 0},
    "GNF": {"name": "Guinean Franc", "sympol": "FG", "flag": "🇬🇳", "decimal_degits": 0},
    "GTQ": {
        "name": "Guatemalan Quetzal",
        "sympol": "Q",
        "flag": "🇬🇹",
        "decimal_degits": 2,
    },
    "GYD": {
        "name": "Guyanese Dollar",
        "sympol": "$",
        "flag": "🇬🇾",
        "decimal_degits": 2,
    },
    "HKD": {
        "name": "Hong Kong Dollar",
        "sympol": "$",
        "flag": "🇭🇰",
        "decimal_degits": 2,
    },
    "HNL": {
        "name": "Honduran Lempira",
        "sympol": "L",
        "flag": "🇭🇳",
        "decimal_degits": 2,
    },
    "HRK": {"name": "Croatian Kuna", "sympol": "kn", "flag": "🇭🇷", "decimal_degits": 2},
    "HTG": {"name": "Haitian gourde", "sympol": "G", "flag": "🇭🇹", "decimal_degits": 0},
    "HUF": {
        "name": "Hungarian Forint",
        "sympol": "Ft",
        "flag": "🇭🇺",
        "decimal_degits": 0,
    },
    "IDR": {
        "name": "Indonesian Rupiah",
        "sympol": "Rp",
        "flag": "🇮🇩",
        "decimal_degits": 0,
    },
    "ILS": {
        "name": "Israeli New Sheqel",
        "sympol": "₪",
        "flag": "🇮🇱",
        "decimal_degits": 2,
    },
    "INR": {"name": "Indian Rupee", "sympol": "₹", "flag": "🇮🇳", "decimal_degits": 2},
    "IQD": {"name": "Iraqi Dinar", "sympol": "ع.د", "flag": "🇮🇶", "decimal_degits": 0},
    "ISK": {
        "name": "Icelandic Króna",
        "sympol": "kr",
        "flag": "🇮🇸",
        "decimal_degits": 0,
    },
    "JMD": {
        "name": "Jamaican Dollar",
        "sympol": "J$",
        "flag": "🇯🇲",
        "decimal_degits": 2,
    },
    "JOD": {
        "name": "Jordanian Dinar",
        "sympol": "JD",
        "flag": "🇯🇴",
        "decimal_degits": 3,
    },
    "JPY": {"name": "Japanese Yen", "sympol": "¥", "flag": "🇯🇵", "decimal_degits": 0},
    "KES": {
        "name": "Kenyan Shilling",
        "sympol": "KSh",
        "flag": "🇰🇪",
        "decimal_degits": 2,
    },
    "KGS": {
        "name": "Kyrgyzstani som",
        "sympol": "лв",
        "flag": "🇰🇬",
        "decimal_degits": 0,
    },
    "KHR": {"name": "Cambodian Riel", "sympol": "៛", "flag": "🇰🇭", "decimal_degits": 2},
    "KMF": {
        "name": "Comorian Franc",
        "sympol": "CF",
        "flag": "🇰🇲",
        "decimal_degits": 0,
    },
    "KRW": {
        "name": "South Korean Won",
        "sympol": "₩",
        "flag": "🇰🇷",
        "decimal_degits": 0,
    },
    "KWD": {"name": "Kuwaiti Dinar", "sympol": "KD", "flag": "🇰🇼", "decimal_degits": 3},
    "KYD": {
        "name": "Cayman Islands dollar",
        "sympol": "$",
        "flag": "🇰🇾",
        "decimal_degits": 0,
    },
    "KZT": {
        "name": "Kazakhstani Tenge",
        "sympol": "лв",
        "flag": "🇰🇿",
        "decimal_degits": 2,
    },
    "LAK": {"name": "Lao kip", "sympol": "₭", "flag": "🇱🇦", "decimal_degits": 12},
    "LBP": {"name": "Lebanese Pound", "sympol": "£", "flag": "🇱🇧", "decimal_degits": 0},
    "LKR": {
        "name": "Sri Lankan Rupee",
        "sympol": "₨",
        "flag": "🇱🇰",
        "decimal_degits": 2,
    },
    "LRD": {
        "name": "Liberian dollar",
        "sympol": "$",
        "flag": "🇱🇷",
        "decimal_degits": 0,
    },
    "LSL": {"name": "Lesotho loti", "sympol": "M", "flag": "🇱🇸", "decimal_degits": 0},
    "LYD": {"name": "Libyan Dinar", "sympol": "LD", "flag": "🇱🇾", "decimal_degits": 3},
    "MAD": {
        "name": "Moroccan Dirham",
        "sympol": "MAD",
        "flag": "🇲🇦",
        "decimal_degits": 2,
    },
    "MDL": {"name": "Moldovan Leu", "sympol": "lei", "flag": "🇲🇩", "decimal_degits": 2},
    "MGA": {
        "name": "Malagasy Ariary",
        "sympol": "Ar",
        "flag": "🇲🇬",
        "decimal_degits": 0,
    },
    "MKD": {
        "name": "Macedonian Denar",
        "sympol": "ден",
        "flag": "🇲🇰",
        "decimal_degits": 2,
    },
    "MMK": {"name": "Myanma Kyat", "sympol": "K", "flag": "🇲🇲", "decimal_degits": 0},
    "MNT": {
        "name": "Mongolian Tughrik",
        "sympol": "₮",
        "flag": "🇲🇳",
        "decimal_degits": 2,
    },
    "MOP": {
        "name": "Macanese Pataca",
        "sympol": "MOP$",
        "flag": "🇲🇴",
        "decimal_degits": 2,
    },
    "MRO": {
        "name": "Mauritanian ouguiya",
        "sympol": "UM",
        "flag": "🇲🇷",
        "decimal_degits": 0,
    },
    "MUR": {
        "name": "Mauritian Rupee",
        "sympol": "₨",
        "flag": "🇲🇺",
        "decimal_degits": 0,
    },
    "MVR": {
        "name": "Maldivian rufiyaa",
        "sympol": "Rf",
        "flag": "🇲🇻",
        "decimal_degits": 0,
    },
    "MWK": {
        "name": "Malawian kwacha",
        "sympol": "MK",
        "flag": "🇲🇼",
        "decimal_degits": 0,
    },
    "MXN": {"name": "Mexican Peso", "sympol": "$", "flag": "🇲🇽", "decimal_degits": 2},
    "MYR": {
        "name": "Malaysian Ringgit",
        "sympol": "RM",
        "flag": "🇲🇾",
        "decimal_degits": 2,
    },
    "MZN": {
        "name": "Mozambican Metical",
        "sympol": "MT",
        "flag": "🇲🇿",
        "decimal_degits": 2,
    },
    "NAD": {
        "name": "Namibian Dollar",
        "sympol": "$",
        "flag": "🇳🇦",
        "decimal_degits": 2,
    },
    "NGN": {"name": "Nigerian Naira", "sympol": "₦", "flag": "🇳🇬", "decimal_degits": 2},
    "NIO": {
        "name": "Nicaraguan Córdoba",
        "sympol": "C$",
        "flag": "🇳🇮",
        "decimal_degits": 2,
    },
    "NOK": {
        "name": "Norwegian Krone",
        "sympol": "kr",
        "flag": "🇳🇴",
        "decimal_degits": 2,
    },
    "NPR": {"name": "Nepalese Rupee", "sympol": "₨", "flag": "🇳🇵", "decimal_degits": 2},
    "NZD": {
        "name": "New Zealand Dollar",
        "sympol": "$",
        "flag": "🇳🇿",
        "decimal_degits": 2,
    },
    "OMR": {"name": "Omani Rial", "sympol": "﷼", "flag": "🇴🇲", "decimal_degits": 3},
    "PAB": {
        "name": "Panamanian Balboa",
        "sympol": "B/.",
        "flag": "🇵🇦",
        "decimal_degits": 2,
    },
    "PEN": {
        "name": "Peruvian Nuevo Sol",
        "sympol": "S/.",
        "flag": "🇵🇪",
        "decimal_degits": 2,
    },
    "PGK": {
        "name": "Papua New Guinean kina",
        "sympol": "K",
        "flag": "🇵🇬",
        "decimal_degits": 0,
    },
    "PHP": {
        "name": "Philippine Peso",
        "sympol": "₱",
        "flag": "🇵🇭",
        "decimal_degits": 2,
    },
    "PKR": {
        "name": "Pakistani Rupee",
        "sympol": "₨",
        "flag": "🇵🇰",
        "decimal_degits": 0,
    },
    "PLN": {"name": "Polish Zloty", "sympol": "zł", "flag": "🇵🇱", "decimal_degits": 2},
    "PYG": {
        "name": "Paraguayan Guarani",
        "sympol": "Gs",
        "flag": "🇵🇾",
        "decimal_degits": 0,
    },
    "QAR": {"name": "Qatari Rial", "sympol": "﷼", "flag": "🇶🇦", "decimal_degits": 2},
    "RON": {"name": "Romanian Leu", "sympol": "lei", "flag": "🇷🇴", "decimal_degits": 2},
    "RSD": {
        "name": "Serbian Dinar",
        "sympol": "Дин.",
        "flag": "🇷🇸",
        "decimal_degits": 0,
    },
    "RUB": {"name": "Russian Ruble", "sympol": "₽", "flag": "🇷🇺", "decimal_degits": 2},
    "RWF": {"name": "Rwandan Franc", "sympol": "R₣", "flag": "🇷🇼", "decimal_degits": 0},
    "SAR": {"name": "Saudi Riyal", "sympol": "﷼", "flag": "🇸🇦", "decimal_degits": 2},
    "SBD": {
        "name": "Solomon Islands dollar",
        "sympol": "$",
        "flag": "🇸🇧",
        "decimal_degits": 0,
    },
    "SCR": {
        "name": "Seychelles rupee",
        "sympol": "₨",
        "flag": "🇸🇨",
        "decimal_degits": 0,
    },
    "SEK": {"name": "Swedish Krona", "sympol": "kr", "flag": "🇸🇪", "decimal_degits": 2},
    "SHP": {
        "name": "Saint Helena pound",
        "sympol": "£",
        "flag": "🇸🇭",
        "decimal_degits": 0,
    },
    "SKK": {"name": "Slovak koruna", "sympol": "", "flag": "🇸🇰", "decimal_degits": 2},
    "SLL": {
        "name": "Sierra Leonean leone",
        "sympol": "Le",
        "flag": "🇸🇱",
        "decimal_degits": 0,
    },
    "SOS": {
        "name": "Somali Shilling",
        "sympol": "S",
        "flag": "🇸🇴",
        "decimal_degits": 0,
    },
    "SRD": {
        "name": "Surinami guilder",
        "sympol": "$",
        "flag": "🇸🇷",
        "decimal_degits": 2,
    },
    "SSP": {
        "name": "South Sudanese Pound",
        "sympol": "£",
        "flag": "🇸🇸",
        "decimal_degits": 2,
    },
    "STD": {
        "name": "São Tomé and Príncipe dobra",
        "sympol": "Db",
        "flag": "🇸🇹",
        "decimal_degits": 2,
    },
    "SVC": {
        "name": "Salvadoran colón",
        "sympol": "$",
        "flag": "🇸🇻",
        "decimal_degits": 0,
    },
    "SZL": {
        "name": "Swazi lilangeni",
        "sympol": "E",
        "flag": "🇸🇿",
        "decimal_degits": 0,
    },
    "THB": {"name": "Thai Baht", "sympol": "฿", "flag": "🇹🇭", "decimal_degits": 2},
    "TJS": {
        "name": "Tajikistani somoni",
        "sympol": "SM",
        "flag": "🇹🇯",
        "decimal_degits": 0,
    },
    "TMT": {
        "name": "Turkmenistan manat",
        "sympol": "T",
        "flag": "🇹🇲",
        "decimal_degits": 0,
    },
    "TND": {
        "name": "Tunisian Dinar",
        "sympol": "د.ت",
        "flag": "🇹🇳",
        "decimal_degits": 3,
    },
    "TOP": {
        "name": "Tongan Paʻanga",
        "sympol": "T$",
        "flag": "🇹🇴",
        "decimal_degits": 2,
    },
    "TRY": {"name": "Turkish Lira", "sympol": "₺", "flag": "🇹🇷", "decimal_degits": 2},
    "TTD": {
        "name": "Trinidad and Tobago Dollar",
        "sympol": "TT$",
        "flag": "🇹🇹",
        "decimal_degits": 2,
    },
    "TWD": {
        "name": "New Taiwan Dollar",
        "sympol": "NT$",
        "flag": "🇹🇼",
        "decimal_degits": 2,
    },
    "TZS": {
        "name": "Tanzanian Shilling",
        "sympol": "TSh",
        "flag": "🇹🇿",
        "decimal_degits": 0,
    },
    "UAH": {
        "name": "Ukrainian Hryvnia",
        "sympol": "₴",
        "flag": "🇺🇦",
        "decimal_degits": 2,
    },
    "UGX": {
        "name": "Ugandan Shilling",
        "sympol": "USh",
        "flag": "🇺🇬",
        "decimal_degits": 0,
    },
    "UYU": {
        "name": "Uruguayan Peso",
        "sympol": "$U",
        "flag": "🇺🇾",
        "decimal_degits": 2,
    },
    "UZS": {
        "name": "Uzbekistan Som",
        "sympol": "лв",
        "flag": "🇺🇿",
        "decimal_degits": 0,
    },
    "VES": {
        "name": "Venezuelan bolívar soberano",
        "sympol": "",
        "flag": "🇻🇪",
        "decimal_degits": 2,
    },
    "VND": {
        "name": "Vietnamese Dong",
        "sympol": "₫",
        "flag": "🇻🇳",
        "decimal_degits": 0,
    },
    "VUV": {"name": "Vanuatu vatu", "sympol": "VT", "flag": "🇻🇺", "decimal_degits": 0},
    "WST": {"name": "Samoan tala", "sympol": "WS$", "flag": "🇼🇸", "decimal_degits": 0},
    "XAF": {
        "name": "CFA Franc BEAC",
        "sympol": "FCFA",
        "flag": "🇨🇲",
        "decimal_degits": 0,
    },
    "XAG": {
        "name": "Silver (one troy ounce)",
        "sympol": "",
        "flag": "",
        "decimal_degits": 0,
    },
    "XAU": {
        "name": "Gold (one troy ounce)",
        "sympol": "",
        "flag": "",
        "decimal_degits": 0,
    },
    "XCD": {
        "name": "Eastern Carribean dollar",
        "sympol": "$",
        "flag": "🇦🇮",
        "decimal_degits": 0,
    },
    "XDR": {
        "name": "Special drawing rights",
        "sympol": "",
        "flag": "",
        "decimal_degits": 0,
    },
    "XOF": {
        "name": "CFA Franc BCEAO",
        "sympol": "CFA",
        "flag": "🇧🇯",
        "decimal_degits": 0,
    },
    "XPD": {
        "name": "Palladium (one troy ounce)",
        "sympol": "",
        "flag": "",
        "decimal_degits": 0,
    },
    "XPF": {
        "name": "CFP franc (franc Pacifique)",
        "sympol": "₣",
        "flag": "🇵🇫",
        "decimal_degits": 0,
    },
    "XPT": {
        "name": "Platinum (one troy ounce)",
        "sympol": "",
        "flag": "",
        "decimal_degits": 0,
    },
    "YER": {"name": "Yemeni Rial", "sympol": "﷼", "flag": "🇾🇪", "decimal_degits": 0},
    "ZAR": {
        "name": "South African Rand",
        "sympol": "R",
        "flag": "🇿🇦",
        "decimal_degits": 2,
    },
    "ZMW": {"name": "Zambian kwacha", "sympol": "", "flag": "🇿🇲", "decimal_degits": 2},
    "JEP": {"name": "Jersey pound", "sympol": "£", "flag": "🇯🇪", "decimal_degits": 2},
    "GGP": {"name": "Guernsey pound", "sympol": "£", "flag": "🇬🇬", "decimal_degits": 2},
    "IMP": {
        "name": "Isle of Man pound",
        "sympol": "£",
        "flag": "🇮🇲",
        "decimal_degits": 2,
    },
    "GBX": {
        "name": "Penny sterling",
        "sympol": "£p",
        "flag": "🇬🇧",
        "decimal_degits": 2,
    },
    "CNH": {
        "name": "Chinese yuan (offshore)",
        "sympol": "",
        "flag": "🇭🇰",
        "decimal_degits": 2,
    },
    "TMM": {
        "name": "Turkmenistani manat",
        "sympol": "",
        "flag": "🇹🇲",
        "decimal_degits": 2,
    },
    "ZWL": {
        "name": "Zimbabwean dollar",
        "sympol": "",
        "flag": "🇿🇼",
        "decimal_degits": 0,
    },
    "SGD": {
        "name": "Singapore Dollar",
        "sympol": "$",
        "flag": "🇸🇬",
        "decimal_degits": 2,
    },
    "USD": {"name": "US Dollar", "sympol": "$", "flag": "🇺🇸", "decimal_degits": 2},
}

CRYPTO_CURRENCIES = {
    "BTC": {"name": "Bitcoin", "sympol": "฿"},
    "BCH": {"name": "Bitcoin Cash", "sympol": ""},
    "BSV": {"name": "Bitcoin SV", "sympol": ""},
    "ETH": {"name": "Ethereum", "sympol": "Ξ"},
    "ETH2": {"name": "Ethereum 2", "sympol": ""},
    "ETC": {"name": "Ethereum Classic", "sympol": ""},
    "LTC": {"name": "Litecoin", "sympol": "Ł"},
    "ZRX": {"name": "0x", "sympol": ""},
    "USDC": {"name": "USD Coin", "sympol": ""},
    "BAT": {"name": "Basic Attention Token", "sympol": ""},
    "MANA": {"name": "Decentraland", "sympol": ""},
    "KNC": {"name": "Kyber Network", "sympol": ""},
    "LINK": {"name": "ChainLink", "sympol": ""},
    "DNT": {"name": "district0x", "sympol": ""},
    "MKR": {"name": "Maker", "sympol": ""},
    "CVC": {"name": "Civic", "sympol": ""},
    "OMG": {"name": "OmiseGo", "sympol": ""},
    "DAI": {"name": "Dai", "sympol": ""},
    "ZEC": {"name": "ZCash", "sympol": ""},
    "XRP": {"name": "XRP", "sympol": ""},
    "REP": {"name": "Augur", "sympol": ""},
    "XLM": {"name": "Stellar", "sympol": ""},
    "EOS": {"name": "EOS", "sympol": ""},
    "XTZ": {"name": "Tezos", "sympol": ""},
    "ALGO": {"name": "Algorand", "sympol": ""},
    "DASH": {"name": "Dash", "sympol": ""},
    "ATOM": {"name": "Atomic Coin", "sympol": ""},
    "OXT": {"name": "Orchid", "sympol": ""},
    "COMP": {"name": "Compound Coin", "sympol": ""},
    "ENJ": {"name": "Enjin Coin", "sympol": ""},
    "REPV2": {"name": "REPv2", "sympol": ""},
    "BAND": {"name": "Band Protocol", "sympol": ""},
    "NMR": {"name": "Numeraire", "sympol": ""},
    "CGLD": {"name": "Celo", "sympol": ""},
    "UMA": {"name": "UMA", "sympol": ""},
    "LRC": {"name": "Loopring", "sympol": ""},
    "YFI": {"name": "yearn.finance", "sympol": ""},
    "UNI": {"name": "Universe", "sympol": ""},
    "BAL": {"name": "Balancer", "sympol": ""},
    "REN": {"name": "Republic Token", "sympol": ""},
    "WBTC": {"name": "Wrapped Bitcoin", "sympol": ""},
    "NU": {"name": "NuCypher", "sympol": ""},
    "YFII": {"name": "DFI.Money", "sympol": ""},
    "FIL": {"name": "FileCoin", "sympol": ""},
    "AAVE": {"name": "Aave", "sympol": ""},
    "BNT": {"name": "Bancor Network Token", "sympol": ""},
    "GRT": {"name": "The Graph", "sympol": ""},
    "SNX": {"name": "Synthetix", "sympol": ""},
    "STORJ": {"name": "Storj", "sympol": ""},
    "SUSHI": {"name": "SushiSwap", "sympol": ""},
    "MATIC": {"name": "Polygon", "sympol": ""},
    "SKL": {"name": "SKALE", "sympol": ""},
    "ADA": {"name": "Cardano", "sympol": ""},
    "ANKR": {"name": "Ankr Network", "sympol": ""},
    "CRV": {"name": "Cravy", "sympol": ""},
    "ICP": {"name": "Internet Computer", "sympol": ""},
    "NKN": {"name": "NKN", "sympol": ""},
    "OGN": {"name": "Origin Token", "sympol": ""},
    "1INCH": {"name": "1inch", "sympol": ""},
    "USDT": {"name": "Tether", "sympol": ""},
    "FORTH": {"name": "Ampleforth Governance", "sympol": ""},
    "CTSI": {"name": "Cartesi", "sympol": ""},
    "TRB": {"name": "Tellor", "sympol": ""},
    "POLY": {"name": "PolyBit", "sympol": ""},
    "MIR": {"name": "Mirror Protocol", "sympol": ""},
    "RLC": {"name": "iEx.ec", "sympol": ""},
    "DOT": {"name": "Dotcoin", "sympol": ""},
    "SOL": {"name": "Sola", "sympol": ""},
    "DOGE": {"name": "Dogecoin", "sympol": ""},
    "MLN": {"name": "Melon", "sympol": ""},
    "GTC": {"name": "Game", "sympol": ""},
    "AMP": {"name": "Synereo", "sympol": ""},
    "SHIB": {"name": "SHIBA INU", "sympol": ""},
    "CHZ": {"name": "Chiliz", "sympol": ""},
    "KEEP": {"name": "Keep Network", "sympol": ""},
    "LPT": {"name": "Livepeer", "sympol": ""},
    "QNT": {"name": "Quant", "sympol": ""},
    "BOND": {"name": "BarnBridge", "sympol": ""},
    "RLY": {"name": "Rally", "sympol": ""},
    "CLV": {"name": "CleverCoin", "sympol": ""},
    "FARM": {"name": "FARM Coin", "sympol": ""},
    "MASK": {"name": "Mask Network", "sympol": ""},
    "FET": {"name": "Fetch.AI", "sympol": ""},
    "PAX": {"name": "Paxos Standard", "sympol": ""},
    "ACH": {"name": "AchieveCoin", "sympol": ""},
    "ASM": {"name": "Assemble Protocol", "sympol": ""},
    "PLA": {"name": "PlayChip", "sympol": ""},
    "RAI": {"name": "Rai Reflex Index", "sympol": ""},
    "TRIBE": {"name": "TribeToken", "sympol": ""},
    "ORN": {"name": "Orion Protocol", "sympol": ""},
    "IOTX": {"name": "IoTeX Network", "sympol": ""},
    "UST": {"name": "TerraUSD", "sympol": ""},
    "QUICK": {"name": "QuickSwap", "sympol": ""},
    "AXS": {"name": "AXS", "sympol": ""},
    "REQ": {"name": "Request Network", "sympol": ""},
    "WLUNA": {"name": "Wrapped LUNA Token", "sympol": ""},
    "TRU": {"name": "TrueFi", "sympol": ""},
    "RAD": {"name": "Radicle", "sympol": ""},
    "COTI": {"name": "COTI", "sympol": ""},
    "DDX": {"name": "DerivaDAO", "sympol": ""},
    "SUKU": {"name": "SUKU", "sympol": ""},
    "RGT": {"name": "Retail.Global", "sympol": ""},
    "XYO": {"name": "XY Oracle", "sympol": ""},
    "ZEN": {"name": "ZEN", "sympol": ""},
    "AUCTION": {"name": "Bounce Token", "sympol": ""},
    "JASMY": {"name": "JASMY", "sympol": ""},
    "WCFG": {"name": "Wrapped Centrifuge", "sympol": ""},
    "BTRST": {"name": "Braintrust", "sympol": ""},
    "AGLD": {"name": "Adventure Gold", "sympol": ""},
    "AVAX": {"name": "Avalanche", "sympol": ""},
    "FX": {"name": "FCoin", "sympol": ""},
    "TRAC": {"name": "OriginTrail", "sympol": ""},
    "LCX": {"name": "LCX", "sympol": ""},
    "ARPA": {"name": "ArpaCoin", "sympol": ""},
    "BADGER": {"name": "Badger DAO", "sympol": ""},
    "KRL": {"name": "Kryll", "sympol": ""},
    "PERP": {"name": "Perpetual Protocol", "sympol": ""},
    "RARI": {"name": "Rarible", "sympol": ""},
    "DESO": {"name": "Decentralized Social", "sympol": ""},
    "API3": {"name": "API3", "sympol": ""},
    "NCT": {"name": "PolySwarm", "sympol": ""},
    "SHPING": {"name": "Shping Coin", "sympol": ""},
    "CRO": {"name": "Crypto.com Chain Token", "sympol": ""},
    "MDT": {"name": "Midnight", "sympol": ""},
    "VGX": {"name": "Voyager Token", "sympol": ""},
    "ALCX": {"name": "Alchemix", "sympol": ""},
    "COVAL": {"name": "Circuits of Value", "sympol": ""},
    "FOX": {"name": "Shapeshift FOX Token", "sympol": ""},
    "MUSD": {"name": "MUSDcoin", "sympol": ""},
    "GALA": {"name": "Gala", "sympol": ""},
    "POWR": {"name": "Power Ledger", "sympol": ""},
    "GYEN": {"name": "GYEN", "sympol": ""},
    "INV": {"name": "Invictus", "sympol": ""},
    "LQTY": {"name": "Liquity", "sympol": ""},
    "PRO": {"name": "Propy", "sympol": ""},
    "SPELL": {"name": "Spell Token", "sympol": ""},
    "ENS": {"name": "Ethereum Name Service", "sympol": ""},
    "BLZ": {"name": "Bluzelle", "sympol": ""},
    "IDEX": {"name": "IDEX", "sympol": ""},
    "MCO2": {"name": "Moss Carbon Credit", "sympol": ""},
    "POLS": {"name": "Polkastarter", "sympol": ""},
    "SUPER": {"name": "SuperCoin", "sympol": ""},
    "STX": {"name": "Stox", "sympol": ""},
    "GODS": {"name": "Gods Unchained", "sympol": ""},
    "IMX": {"name": "Impact", "sympol": ""},
    "RBN": {"name": "Ribbon Finance", "sympol": ""},
    "BICO": {"name": "BICONOMY (BICO)", "sympol": ""},
    "GFI": {"name": "Goldfinch Protocol", "sympol": ""},
}
