# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/02_dialog_system.ipynb (unless otherwise specified).

__all__ = ['DialogSystem', 'dialog_system']

# Cell
from .settings import *
import logging
from collections import defaultdict

logging.basicConfig(
    #filename='example.log',
    format='%(asctime)s %(levelname)s:%(message)s',
    level=logging.ERROR,
    datefmt='%I:%M:%S'
)

logging.debug(" Debug Log Active")
logging.info("Hello! Welcome to our automated dialog system!")
logging.warning(' Warning Log Active')
logging.error(' Error Log Active ')

# Cell
class DialogSystem:
    def __init__(
        self, context_data_file=None, faq_data_file=None, configs_faq=None
    ):
        run_shell_installs()
        self.data = {'context': defaultdict(str), 'faq': defaultdict(str)}

        load_and_prepare_data(
            context_data_file=context_data_file,
            faq_data_file=faq_data_file,
            configs_faq=configs_faq,
            data=self.data
        )
        self.qa_models = load_qa_models(config_tfidf=self.data['faq']['config'])

    def question_answer(self):
        question, responses = question_response(
            data=self.data,
            qa_models=self.qa_models,
            num_returned_values_per_squad_model=1
        )
        print('\n\n' + responses)

    def new_answer(self):
        ...

    def new_context(self):
        ...

# Cell
def dialog_system(context_data_file=None, faq_data_file=None, configs_faq=None):
    '''
     Main Dialog System
    '''
    run_shell_installs()

    data = {'context': defaultdict(str), 'faq': defaultdict(str)}

    load_and_prepare_data(
        context_data_file=context_data_file,
        faq_data_file=faq_data_file,
        configs_faq=configs_faq,
        data=data
    )

    qa_models = load_qa_models(config_tfidf=data['faq']['config'])

    while True:
        try:
            responses, _ = question_response(data=data, qa_models=qa_models)
        except (KeyboardInterrupt, EOFError, SystemExit):
            logging.debug('Goodbye!')
            return 'Goodbye!'