import s3 = require('@aws-cdk/aws-s3');
import cdk = require('@aws-cdk/cdk');
import { ISource } from './source';
export interface BucketDeploymentProps {
    /**
     * The source from which to deploy the contents of this bucket.
     */
    readonly source: ISource;
    /**
     * The S3 bucket to sync the contents of the zip file to.
     */
    readonly destinationBucket: s3.IBucket;
    /**
     * Key prefix in the destination bucket.
     *
     * @default "/" (unzip to root of the destination bucket)
     */
    readonly destinationKeyPrefix?: string;
    /**
     * If this is set to "false", the destination files will be deleted when the
     * resource is deleted or the destination is updated.
     *
     * NOTICE: if this is set to "false" and destination bucket/prefix is updated,
     * all files in the previous destination will first be deleted and then
     * uploaded to the new destination location. This could have availablity
     * implications on your users.
     *
     * @default true - when resource is deleted/updated, files are retained
     */
    readonly retainOnDelete?: boolean;
}
export declare class BucketDeployment extends cdk.Construct {
    constructor(scope: cdk.Construct, id: string, props: BucketDeploymentProps);
}
