import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface GrantConfig extends cdktf.TerraformMetaArguments {
    /**
     * The database to grant privileges on for this role.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/grant.html#database Grant#database}
     *
     * @stability stable
     */
    readonly database: string;
    /**
     * The PostgreSQL object type to grant the privileges on (one of: database, function, schema, sequence, table, foreign_data_wrapper, foreign_server).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/grant.html#object_type Grant#object_type}
     *
     * @stability stable
     */
    readonly objectType: string;
    /**
     * The specific objects to grant privileges on for this role (empty means all objects of the requested type).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/grant.html#objects Grant#objects}
     *
     * @stability stable
     */
    readonly objects?: string[];
    /**
     * The list of privileges to grant.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/grant.html#privileges Grant#privileges}
     *
     * @stability stable
     */
    readonly privileges: string[];
    /**
     * The name of the role to grant privileges on.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/grant.html#role Grant#role}
     *
     * @stability stable
     */
    readonly role: string;
    /**
     * The database schema to grant privileges on for this role.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/grant.html#schema Grant#schema}
     *
     * @stability stable
     */
    readonly schema?: string;
    /**
     * Permit the grant recipient to grant it to others.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/grant.html#with_grant_option Grant#with_grant_option}
     *
     * @stability stable
     */
    readonly withGrantOption?: boolean | cdktf.IResolvable;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/postgresql/r/grant.html postgresql_grant}.
 *
 * @stability stable
 */
export declare class Grant extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/postgresql/r/grant.html postgresql_grant} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: GrantConfig);
    private _database?;
    /**
     * @stability stable
     */
    get database(): string;
    /**
     * @stability stable
     */
    set database(value: string);
    /**
     * @stability stable
     */
    get databaseInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _objectType?;
    /**
     * @stability stable
     */
    get objectType(): string;
    /**
     * @stability stable
     */
    set objectType(value: string);
    /**
     * @stability stable
     */
    get objectTypeInput(): string | undefined;
    private _objects?;
    /**
     * @stability stable
     */
    get objects(): string[];
    /**
     * @stability stable
     */
    set objects(value: string[]);
    /**
     * @stability stable
     */
    resetObjects(): void;
    /**
     * @stability stable
     */
    get objectsInput(): string[] | undefined;
    private _privileges?;
    /**
     * @stability stable
     */
    get privileges(): string[];
    /**
     * @stability stable
     */
    set privileges(value: string[]);
    /**
     * @stability stable
     */
    get privilegesInput(): string[] | undefined;
    private _role?;
    /**
     * @stability stable
     */
    get role(): string;
    /**
     * @stability stable
     */
    set role(value: string);
    /**
     * @stability stable
     */
    get roleInput(): string | undefined;
    private _schema?;
    /**
     * @stability stable
     */
    get schema(): string;
    /**
     * @stability stable
     */
    set schema(value: string);
    /**
     * @stability stable
     */
    resetSchema(): void;
    /**
     * @stability stable
     */
    get schemaInput(): string | undefined;
    private _withGrantOption?;
    /**
     * @stability stable
     */
    get withGrantOption(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set withGrantOption(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetWithGrantOption(): void;
    /**
     * @stability stable
     */
    get withGrantOptionInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
