from enum import IntEnum


class DataAccessResult(IntEnum):
    SUCCESS = 0
    HARDWARE_FAULT = 1
    TEMPORARY_FAILURE = 2
    READ_WRITE_DENIED = 3
    OBJECT_UNDEFINED = 4
    OBJECT_CLASS_INCONSISTENT = 9
    OBJECT_UNAVAILABLE = 11
    TYPE_UNMATCHED = 12
    SCOPE_OF_ACCESS_VIOLATED = 13
    DATA_BLOCK_UNAVAILABLE = 14
    LONG_GET_ABORTED = 15
    NO_LONG_GET_IN_PROGRESS = 16
    LONG_SET_ABORTED = 17
    NO_LONG_SET_IN_PROGRESS = 18
    DATA_BLOCK_NUMBER_INVALID = 19
    OTHER_REASON = 250


class GetResponse(IntEnum):
    NORMAL = 1
    WITH_DATABLOCK = 2
    WITH_LIST = 3


class SetResponse(IntEnum):
    NORMAL = 1
    DATABLOCK = 2
    LAST_DATABLOCK = 3
    LAST_DATABLOCK_WITH_LIST = 4
    WITH_LIST = 5


class ActionResult(IntEnum):
    SUCCESS = 0
    HARDWARE_FAULT = 1
    TEMPORARY_FAILURE = 2
    READ_WRITE_DENIED = 3
    OBJECT_UNDEFINED = 4
    OBJECT_CLASS_INCONSISTENT = 9
    OBJECT_UNAVAILABLE = 11
    TYPE_UNMATCHED = 12
    SCOPE_OF_ACCESS_VIOLATED = 13
    DATA_BLOCK_UNAVAILABLE = 14
    LONG_ACTION_ABORTED = 15
    NO_LONG_ACTION_IN_PROGRESS = 16
    OTHER_REASON = 250


class ActionResponse(IntEnum):
    NORMAL = 1
    WITH_PBLOCK = 2
    WITH_LIST = 3
    NEXT_PBLOCK = 4
