# multibaas-sdk
MultiBaas's REST APIv0.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.0
- Package version: 1.0.0
- Generator version: 7.14.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.9+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/curvegrid/multibaas-sdk-python.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/curvegrid/multibaas-sdk-python.git`)

Then import the package:
```python
import multibaas_sdk
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import multibaas_sdk
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import multibaas_sdk
from multibaas_sdk.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://your_deployment.multibaas.com/api/v0
# See configuration.py for a list of all supported configuration parameters.
configuration = multibaas_sdk.Configuration(
    host = "https://your_deployment.multibaas.com/api/v0"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: cookie
configuration.api_key['cookie'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['cookie'] = 'Bearer'

# Configure Bearer authorization (JWT): bearer
configuration = multibaas_sdk.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)


# Enter a context with an instance of the API client
with multibaas_sdk.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = multibaas_sdk.AddressesApi(api_client)
    chain = multibaas_sdk.ChainName() # ChainName | The blockchain chain label.
    address_or_alias = 'address_or_alias_example' # str | An address or the alias of an address.

    try:
        # Delete address
        api_response = api_instance.delete_address(chain, address_or_alias)
        print("The response of AddressesApi->delete_address:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AddressesApi->delete_address: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://your_deployment.multibaas.com/api/v0*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AddressesApi* | [**delete_address**](docs/AddressesApi.md#delete_address) | **DELETE** /chains/{chain}/addresses/{address-or-alias} | Delete address
*AddressesApi* | [**get_address**](docs/AddressesApi.md#get_address) | **GET** /chains/{chain}/addresses/{address-or-alias} | Get address
*AddressesApi* | [**list_addresses**](docs/AddressesApi.md#list_addresses) | **GET** /chains/{chain}/addresses | List addresses
*AddressesApi* | [**set_address**](docs/AddressesApi.md#set_address) | **POST** /chains/{chain}/addresses | Create or update address
*AdminApi* | [**accept_invite**](docs/AdminApi.md#accept_invite) | **POST** /invites/{inviteID} | Accept invite
*AdminApi* | [**add_cors_origin**](docs/AdminApi.md#add_cors_origin) | **POST** /cors | Add CORS origin
*AdminApi* | [**add_group_api_key**](docs/AdminApi.md#add_group_api_key) | **PUT** /groups/{groupID}/api_keys/{apiKeyID} | Add API key to group
*AdminApi* | [**add_group_role**](docs/AdminApi.md#add_group_role) | **PUT** /groups/{groupID}/roles/{roleShortName} | Add role to group
*AdminApi* | [**add_group_user**](docs/AdminApi.md#add_group_user) | **PUT** /groups/{groupID}/users/{userID} | Add user to group
*AdminApi* | [**check_invite**](docs/AdminApi.md#check_invite) | **GET** /invites/{inviteID} | Check invite
*AdminApi* | [**create_api_key**](docs/AdminApi.md#create_api_key) | **POST** /api_keys | Create API key
*AdminApi* | [**delete_api_key**](docs/AdminApi.md#delete_api_key) | **DELETE** /api_keys/{apiKeyID} | Delete API key
*AdminApi* | [**delete_invite**](docs/AdminApi.md#delete_invite) | **DELETE** /invites/{email}/delete | Delete invite
*AdminApi* | [**delete_user**](docs/AdminApi.md#delete_user) | **DELETE** /users/{userID} | Delete user
*AdminApi* | [**get_api_key**](docs/AdminApi.md#get_api_key) | **GET** /api_keys/{apiKeyID} | Get API Key
*AdminApi* | [**get_plan**](docs/AdminApi.md#get_plan) | **GET** /plan | Get plan
*AdminApi* | [**invite_user**](docs/AdminApi.md#invite_user) | **POST** /invites | Invite user
*AdminApi* | [**list_api_keys**](docs/AdminApi.md#list_api_keys) | **GET** /api_keys | List API keys
*AdminApi* | [**list_audit_logs**](docs/AdminApi.md#list_audit_logs) | **GET** /systemactivities | List audit logs
*AdminApi* | [**list_cors_origins**](docs/AdminApi.md#list_cors_origins) | **GET** /cors | List CORS origins
*AdminApi* | [**list_groups**](docs/AdminApi.md#list_groups) | **GET** /groups | List groups
*AdminApi* | [**list_invites**](docs/AdminApi.md#list_invites) | **GET** /invites | List invites
*AdminApi* | [**list_user_signers**](docs/AdminApi.md#list_user_signers) | **GET** /users/{userID}/signers | List user signers
*AdminApi* | [**list_users**](docs/AdminApi.md#list_users) | **GET** /users | List users
*AdminApi* | [**remove_cors_origin**](docs/AdminApi.md#remove_cors_origin) | **DELETE** /cors/{originID} | Remove CORS Origin
*AdminApi* | [**remove_group_api_key**](docs/AdminApi.md#remove_group_api_key) | **DELETE** /groups/{groupID}/api_keys/{apiKeyID} | Remove API key from group
*AdminApi* | [**remove_group_role**](docs/AdminApi.md#remove_group_role) | **DELETE** /groups/{groupID}/roles/{roleShortName} | Remove role from group
*AdminApi* | [**remove_group_user**](docs/AdminApi.md#remove_group_user) | **DELETE** /groups/{groupID}/users/{userID} | Remove user from group
*AdminApi* | [**remove_user_signer_cloud_wallet**](docs/AdminApi.md#remove_user_signer_cloud_wallet) | **DELETE** /users/{userID}/cloudwallets/{wallet_address} | Remove user cloud wallet signer
*AdminApi* | [**remove_user_signer_safe_account**](docs/AdminApi.md#remove_user_signer_safe_account) | **DELETE** /users/{userID}/safeaccounts/{wallet_address} | Remove user safe account signer
*AdminApi* | [**remove_user_signer_web3_wallet**](docs/AdminApi.md#remove_user_signer_web3_wallet) | **DELETE** /users/{userID}/web3wallets/{wallet_address} | Remove user web3 wallet signer
*AdminApi* | [**set_user_signer_cloud_wallet**](docs/AdminApi.md#set_user_signer_cloud_wallet) | **PUT** /users/{userID}/cloudwallets/{wallet_address} | Add or update user cloud wallet signer
*AdminApi* | [**set_user_signer_safe_account**](docs/AdminApi.md#set_user_signer_safe_account) | **PUT** /users/{userID}/safeaccounts/{wallet_address} | Add or update user safe account signer
*AdminApi* | [**set_user_signer_web3_wallet**](docs/AdminApi.md#set_user_signer_web3_wallet) | **PUT** /users/{userID}/web3wallets/{wallet_address} | Add or update user web3 wallet signer
*AdminApi* | [**update_api_key**](docs/AdminApi.md#update_api_key) | **PUT** /api_keys/{apiKeyID} | Update API key
*ChainsApi* | [**get_block**](docs/ChainsApi.md#get_block) | **GET** /chains/{chain}/blocks/{block} | Get a block
*ChainsApi* | [**get_chain_status**](docs/ChainsApi.md#get_chain_status) | **GET** /chains/{chain}/status | Get chain status
*ChainsApi* | [**get_transaction**](docs/ChainsApi.md#get_transaction) | **GET** /chains/{chain}/transactions/{hash} | Get transaction
*ChainsApi* | [**get_transaction_receipt**](docs/ChainsApi.md#get_transaction_receipt) | **GET** /chains/{chain}/transactions/receipt/{hash} | Get transaction receipt
*ChainsApi* | [**submit_signed_transaction**](docs/ChainsApi.md#submit_signed_transaction) | **POST** /chains/{chain}/transactions/submit | Submit signed transaction
*ChainsApi* | [**transfer_eth**](docs/ChainsApi.md#transfer_eth) | **POST** /chains/{chain}/transfers | Transfer ETH
*ContractsApi* | [**call_contract_function**](docs/ContractsApi.md#call_contract_function) | **POST** /chains/{chain}/addresses/{address-or-alias}/contracts/{contract}/methods/{method} | Call a contract function
*ContractsApi* | [**create_contract**](docs/ContractsApi.md#create_contract) | **POST** /contracts/{contract} | Create a contract
*ContractsApi* | [**create_contracts**](docs/ContractsApi.md#create_contracts) | **POST** /contracts | Create multiple contracts
*ContractsApi* | [**delete_contract**](docs/ContractsApi.md#delete_contract) | **DELETE** /contracts/{contract} | Delete a contract
*ContractsApi* | [**delete_contract_version**](docs/ContractsApi.md#delete_contract_version) | **DELETE** /contracts/{contract}/{version} | Delete a contract version
*ContractsApi* | [**deploy_contract**](docs/ContractsApi.md#deploy_contract) | **POST** /contracts/{contract}/deploy | Deploy a contract
*ContractsApi* | [**deploy_contract_version**](docs/ContractsApi.md#deploy_contract_version) | **POST** /contracts/{contract}/{version}/deploy | Deploy a contract version
*ContractsApi* | [**get_contract**](docs/ContractsApi.md#get_contract) | **GET** /contracts/{contract} | Get a contract
*ContractsApi* | [**get_contract_version**](docs/ContractsApi.md#get_contract_version) | **GET** /contracts/{contract}/{version} | Get a contract version
*ContractsApi* | [**get_contract_versions**](docs/ContractsApi.md#get_contract_versions) | **GET** /contracts/{contract}/all | Get all contract versions
*ContractsApi* | [**get_event_monitor_status**](docs/ContractsApi.md#get_event_monitor_status) | **GET** /chains/{chain}/addresses/{address-or-alias}/contracts/{contract}/status | Get event monitor status
*ContractsApi* | [**get_event_type_conversions**](docs/ContractsApi.md#get_event_type_conversions) | **GET** /contracts/{contract}/{version}/events/{event} | Get event type conversions
*ContractsApi* | [**get_function_type_conversions**](docs/ContractsApi.md#get_function_type_conversions) | **GET** /contracts/{contract}/{version}/methods/{method} | Get function type conversions
*ContractsApi* | [**link_address_contract**](docs/ContractsApi.md#link_address_contract) | **POST** /chains/{chain}/addresses/{address-or-alias}/contracts | Link address and contract
*ContractsApi* | [**list_contract_versions**](docs/ContractsApi.md#list_contract_versions) | **GET** /contracts/{contract}/versions | List all contract versions
*ContractsApi* | [**list_contracts**](docs/ContractsApi.md#list_contracts) | **GET** /contracts | List contracts
*ContractsApi* | [**set_event_type_conversions**](docs/ContractsApi.md#set_event_type_conversions) | **POST** /contracts/{contract}/{version}/events/{event} | Set event type conversions
*ContractsApi* | [**set_function_type_conversions**](docs/ContractsApi.md#set_function_type_conversions) | **POST** /contracts/{contract}/{version}/methods/{method} | Set function type conversions
*ContractsApi* | [**unlink_address_contract**](docs/ContractsApi.md#unlink_address_contract) | **DELETE** /chains/{chain}/addresses/{address-or-alias}/contracts/{contract} | Unlink address and contract
*EventQueriesApi* | [**count_event_query_records**](docs/EventQueriesApi.md#count_event_query_records) | **GET** /queries/{event_query}/count | Count event query records
*EventQueriesApi* | [**delete_event_query**](docs/EventQueriesApi.md#delete_event_query) | **DELETE** /queries/{event_query} | Delete event query
*EventQueriesApi* | [**execute_arbitrary_event_query**](docs/EventQueriesApi.md#execute_arbitrary_event_query) | **POST** /queries | Execute arbitrary event query
*EventQueriesApi* | [**execute_event_query**](docs/EventQueriesApi.md#execute_event_query) | **GET** /queries/{event_query}/results | Execute event query
*EventQueriesApi* | [**get_event_query**](docs/EventQueriesApi.md#get_event_query) | **GET** /queries/{event_query} | Get event query
*EventQueriesApi* | [**list_event_queries**](docs/EventQueriesApi.md#list_event_queries) | **GET** /queries | List event queries
*EventQueriesApi* | [**set_event_query**](docs/EventQueriesApi.md#set_event_query) | **PUT** /queries/{event_query} | Create or update event query
*EventsApi* | [**get_event_count**](docs/EventsApi.md#get_event_count) | **GET** /events/count | Get event count
*EventsApi* | [**list_events**](docs/EventsApi.md#list_events) | **GET** /events | List events
*HsmApi* | [**add_hsm_config**](docs/HsmApi.md#add_hsm_config) | **POST** /hsm/config | Add HSM config
*HsmApi* | [**add_hsm_key**](docs/HsmApi.md#add_hsm_key) | **POST** /hsm/key | Add HSM key
*HsmApi* | [**create_hsm_key**](docs/HsmApi.md#create_hsm_key) | **POST** /hsm/key/new | Create HSM key
*HsmApi* | [**list_hsm**](docs/HsmApi.md#list_hsm) | **GET** /hsm | List HSM configs and wallets
*HsmApi* | [**list_hsm_wallets**](docs/HsmApi.md#list_hsm_wallets) | **GET** /hsm/wallets | List HSM wallets
*HsmApi* | [**remove_hsm_config**](docs/HsmApi.md#remove_hsm_config) | **DELETE** /hsm/config/{client_id} | Remove HSM config
*HsmApi* | [**remove_hsm_key**](docs/HsmApi.md#remove_hsm_key) | **DELETE** /hsm/key/{wallet_address} | Remove HSM key
*HsmApi* | [**set_local_nonce**](docs/HsmApi.md#set_local_nonce) | **POST** /chains/{chain}/hsm/nonce/{wallet_address} | Set local nonce
*HsmApi* | [**sign_and_submit_transaction**](docs/HsmApi.md#sign_and_submit_transaction) | **POST** /chains/{chain}/hsm/submit | Sign and submit transaction
*HsmApi* | [**sign_data**](docs/HsmApi.md#sign_data) | **POST** /chains/{chain}/hsm/sign | Sign data
*TxmApi* | [**cancel_transaction**](docs/TxmApi.md#cancel_transaction) | **POST** /chains/{chain}/txm/{wallet_address}/nonce/{nonce}/cancel | Cancel transaction
*TxmApi* | [**count_wallet_transactions**](docs/TxmApi.md#count_wallet_transactions) | **GET** /chains/{chain}/txm/{wallet_address}/count | Count all transactions for a wallet
*TxmApi* | [**list_wallet_transactions**](docs/TxmApi.md#list_wallet_transactions) | **GET** /chains/{chain}/txm/{wallet_address} | List transactions for a wallet
*TxmApi* | [**speed_up_transaction**](docs/TxmApi.md#speed_up_transaction) | **POST** /chains/{chain}/txm/{wallet_address}/nonce/{nonce}/speed_up | Speed up transaction
*WebhooksApi* | [**count_webhook_events**](docs/WebhooksApi.md#count_webhook_events) | **GET** /webhooks/{webhookID}/events/count | Count webhook events
*WebhooksApi* | [**count_webhooks**](docs/WebhooksApi.md#count_webhooks) | **GET** /webhooks/count | Count webhooks
*WebhooksApi* | [**create_webhook**](docs/WebhooksApi.md#create_webhook) | **POST** /webhooks | Create webhook
*WebhooksApi* | [**delete_webhook**](docs/WebhooksApi.md#delete_webhook) | **DELETE** /webhooks/{webhookID} | Delete webhook
*WebhooksApi* | [**get_webhook**](docs/WebhooksApi.md#get_webhook) | **GET** /webhooks/{webhookID} | Get webhook
*WebhooksApi* | [**list_webhook_events**](docs/WebhooksApi.md#list_webhook_events) | **GET** /webhooks/{webhookID}/events | List webhook events
*WebhooksApi* | [**list_webhooks**](docs/WebhooksApi.md#list_webhooks) | **GET** /webhooks | List webhooks
*WebhooksApi* | [**update_webhook**](docs/WebhooksApi.md#update_webhook) | **PUT** /webhooks/{webhookID} | Update webhook


## Documentation For Models

 - [APIKey](docs/APIKey.md)
 - [APIKeyWithSecret](docs/APIKeyWithSecret.md)
 - [AcceptInvite200Response](docs/AcceptInvite200Response.md)
 - [AcceptInviteRequest](docs/AcceptInviteRequest.md)
 - [AccessTuple](docs/AccessTuple.md)
 - [AddKey](docs/AddKey.md)
 - [Address](docs/Address.md)
 - [AddressAlias](docs/AddressAlias.md)
 - [AuditLog](docs/AuditLog.md)
 - [AzureAccount](docs/AzureAccount.md)
 - [AzureHardwareWallet](docs/AzureHardwareWallet.md)
 - [AzureWallet](docs/AzureWallet.md)
 - [BaseAPIKey](docs/BaseAPIKey.md)
 - [BaseAzureAccount](docs/BaseAzureAccount.md)
 - [BaseContract](docs/BaseContract.md)
 - [BaseResponse](docs/BaseResponse.md)
 - [BaseUser](docs/BaseUser.md)
 - [BaseWebhookEndpoint](docs/BaseWebhookEndpoint.md)
 - [Block](docs/Block.md)
 - [CORSOrigin](docs/CORSOrigin.md)
 - [CallContractFunction200Response](docs/CallContractFunction200Response.md)
 - [CallContractFunction200ResponseAllOfResult](docs/CallContractFunction200ResponseAllOfResult.md)
 - [ChainName](docs/ChainName.md)
 - [ChainStatus](docs/ChainStatus.md)
 - [CloudWalletTXToSign](docs/CloudWalletTXToSign.md)
 - [CloudWalletTXToSignTx](docs/CloudWalletTXToSignTx.md)
 - [Contract](docs/Contract.md)
 - [ContractABI](docs/ContractABI.md)
 - [ContractABIError](docs/ContractABIError.md)
 - [ContractABIErrorArgument](docs/ContractABIErrorArgument.md)
 - [ContractABIEvent](docs/ContractABIEvent.md)
 - [ContractABIEventArgument](docs/ContractABIEventArgument.md)
 - [ContractABIMethod](docs/ContractABIMethod.md)
 - [ContractABIMethod1](docs/ContractABIMethod1.md)
 - [ContractABIMethodArgument](docs/ContractABIMethodArgument.md)
 - [ContractABIType](docs/ContractABIType.md)
 - [ContractABITypeConversion](docs/ContractABITypeConversion.md)
 - [ContractEventOptions](docs/ContractEventOptions.md)
 - [ContractInformation](docs/ContractInformation.md)
 - [ContractInstance](docs/ContractInstance.md)
 - [ContractLookup](docs/ContractLookup.md)
 - [ContractMetadata](docs/ContractMetadata.md)
 - [ContractMethodInformation](docs/ContractMethodInformation.md)
 - [ContractMethodOptions](docs/ContractMethodOptions.md)
 - [ContractOverview](docs/ContractOverview.md)
 - [ContractParameter](docs/ContractParameter.md)
 - [CountEventQueryRecords200Response](docs/CountEventQueryRecords200Response.md)
 - [CountWalletTransactions200Response](docs/CountWalletTransactions200Response.md)
 - [CountWebhookEvents200Response](docs/CountWebhookEvents200Response.md)
 - [CountWebhooks200Response](docs/CountWebhooks200Response.md)
 - [CreateApiKey200Response](docs/CreateApiKey200Response.md)
 - [CreateApiKeyRequest](docs/CreateApiKeyRequest.md)
 - [CreateHsmKey200Response](docs/CreateHsmKey200Response.md)
 - [CreateKey](docs/CreateKey.md)
 - [CreateWebhook200Response](docs/CreateWebhook200Response.md)
 - [DeployContract200Response](docs/DeployContract200Response.md)
 - [DeployContractTransaction](docs/DeployContractTransaction.md)
 - [EIP712Domain](docs/EIP712Domain.md)
 - [EIP712DomainChainId](docs/EIP712DomainChainId.md)
 - [EIP712TypeEntry](docs/EIP712TypeEntry.md)
 - [EIP712TypedData](docs/EIP712TypedData.md)
 - [EIP712Types](docs/EIP712Types.md)
 - [Error](docs/Error.md)
 - [Event](docs/Event.md)
 - [EventField](docs/EventField.md)
 - [EventInformation](docs/EventInformation.md)
 - [EventMonitorStatus](docs/EventMonitorStatus.md)
 - [EventQuery](docs/EventQuery.md)
 - [EventQueryEvent](docs/EventQueryEvent.md)
 - [EventQueryField](docs/EventQueryField.md)
 - [EventQueryFilter](docs/EventQueryFilter.md)
 - [EventQueryResults](docs/EventQueryResults.md)
 - [EventTypeConversionOptions](docs/EventTypeConversionOptions.md)
 - [ExecuteArbitraryEventQuery200Response](docs/ExecuteArbitraryEventQuery200Response.md)
 - [FieldType](docs/FieldType.md)
 - [GasParams](docs/GasParams.md)
 - [GetApiKey200Response](docs/GetApiKey200Response.md)
 - [GetBlock200Response](docs/GetBlock200Response.md)
 - [GetChainStatus200Response](docs/GetChainStatus200Response.md)
 - [GetContract200Response](docs/GetContract200Response.md)
 - [GetContractVersions200Response](docs/GetContractVersions200Response.md)
 - [GetEventCount200Response](docs/GetEventCount200Response.md)
 - [GetEventMonitorStatus200Response](docs/GetEventMonitorStatus200Response.md)
 - [GetEventQuery200Response](docs/GetEventQuery200Response.md)
 - [GetEventTypeConversions200Response](docs/GetEventTypeConversions200Response.md)
 - [GetFunctionTypeConversions200Response](docs/GetFunctionTypeConversions200Response.md)
 - [GetPlan200Response](docs/GetPlan200Response.md)
 - [GetTransaction200Response](docs/GetTransaction200Response.md)
 - [GetTransactionReceipt200Response](docs/GetTransactionReceipt200Response.md)
 - [Group](docs/Group.md)
 - [HSMData](docs/HSMData.md)
 - [HSMSignRequest](docs/HSMSignRequest.md)
 - [HSMSignRequestPersonalSign](docs/HSMSignRequestPersonalSign.md)
 - [HSMSignRequestPersonalSignChainId](docs/HSMSignRequestPersonalSignChainId.md)
 - [HSMSignRequestTypedData](docs/HSMSignRequestTypedData.md)
 - [HSMSignResponse](docs/HSMSignResponse.md)
 - [Invite](docs/Invite.md)
 - [InviteRequest](docs/InviteRequest.md)
 - [LinkAddressContractRequest](docs/LinkAddressContractRequest.md)
 - [ListAddresses200Response](docs/ListAddresses200Response.md)
 - [ListApiKeys200Response](docs/ListApiKeys200Response.md)
 - [ListAuditLogs200Response](docs/ListAuditLogs200Response.md)
 - [ListContractVersions200Response](docs/ListContractVersions200Response.md)
 - [ListContractVersions200ResponseAllOfResult](docs/ListContractVersions200ResponseAllOfResult.md)
 - [ListContracts200Response](docs/ListContracts200Response.md)
 - [ListCorsOrigins200Response](docs/ListCorsOrigins200Response.md)
 - [ListEventQueries200Response](docs/ListEventQueries200Response.md)
 - [ListEvents200Response](docs/ListEvents200Response.md)
 - [ListGroups200Response](docs/ListGroups200Response.md)
 - [ListHsm200Response](docs/ListHsm200Response.md)
 - [ListHsmWallets200Response](docs/ListHsmWallets200Response.md)
 - [ListInvites200Response](docs/ListInvites200Response.md)
 - [ListUserSigners200Response](docs/ListUserSigners200Response.md)
 - [ListUsers200Response](docs/ListUsers200Response.md)
 - [ListWalletTransactions200Response](docs/ListWalletTransactions200Response.md)
 - [ListWebhookEvents200Response](docs/ListWebhookEvents200Response.md)
 - [ListWebhooks200Response](docs/ListWebhooks200Response.md)
 - [Log](docs/Log.md)
 - [MethodArg](docs/MethodArg.md)
 - [MethodCallPreviewResponse](docs/MethodCallPreviewResponse.md)
 - [MethodCallResponse](docs/MethodCallResponse.md)
 - [MethodTypeConversionOptions](docs/MethodTypeConversionOptions.md)
 - [Plan](docs/Plan.md)
 - [PlanFeature](docs/PlanFeature.md)
 - [PlanLimit](docs/PlanLimit.md)
 - [PostMethodArgs](docs/PostMethodArgs.md)
 - [PostMethodResponse](docs/PostMethodResponse.md)
 - [PreviewArgs](docs/PreviewArgs.md)
 - [Role](docs/Role.md)
 - [SavedEventQuery](docs/SavedEventQuery.md)
 - [SetAddress201Response](docs/SetAddress201Response.md)
 - [SetCodeAuthorization](docs/SetCodeAuthorization.md)
 - [SetNonceRequest](docs/SetNonceRequest.md)
 - [SignData200Response](docs/SignData200Response.md)
 - [SignedTransactionResponse](docs/SignedTransactionResponse.md)
 - [SignedTransactionSubmission](docs/SignedTransactionSubmission.md)
 - [SignerLabel](docs/SignerLabel.md)
 - [SignerWallet](docs/SignerWallet.md)
 - [StandaloneWallet](docs/StandaloneWallet.md)
 - [SubmitSignedTransaction200Response](docs/SubmitSignedTransaction200Response.md)
 - [Transaction](docs/Transaction.md)
 - [TransactionData](docs/TransactionData.md)
 - [TransactionInformation](docs/TransactionInformation.md)
 - [TransactionReceipt](docs/TransactionReceipt.md)
 - [TransactionReceiptData](docs/TransactionReceiptData.md)
 - [TransactionStatus](docs/TransactionStatus.md)
 - [TransactionToSign](docs/TransactionToSign.md)
 - [TransactionToSignResponse](docs/TransactionToSignResponse.md)
 - [TransactionToSignTx](docs/TransactionToSignTx.md)
 - [TransferEth200Response](docs/TransferEth200Response.md)
 - [TypeConversionOptions](docs/TypeConversionOptions.md)
 - [User](docs/User.md)
 - [WalletTransaction](docs/WalletTransaction.md)
 - [WebhookEndpoint](docs/WebhookEndpoint.md)
 - [WebhookEvent](docs/WebhookEvent.md)
 - [WebhookEventsType](docs/WebhookEventsType.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="bearer"></a>
### bearer

- **Type**: Bearer authentication (JWT)

<a id="cookie"></a>
### cookie

- **Type**: API key
- **API key parameter name**: token
- **Location**: 


## Author

contact@curvegrid.com


