# coding: utf-8

"""
    MultiBaas API

    MultiBaas's REST APIv0.

    The version of the OpenAPI document: 0.0
    Contact: contact@curvegrid.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Optional
from typing_extensions import Annotated
from multibaas_sdk.models.chain_name import ChainName
from multibaas_sdk.models.get_event_count200_response import GetEventCount200Response
from multibaas_sdk.models.list_events200_response import ListEvents200Response

from multibaas_sdk.api_client import ApiClient, RequestSerialized
from multibaas_sdk.api_response import ApiResponse
from multibaas_sdk.rest import RESTResponseType


class EventsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def get_event_count(
        self,
        block_hash: Annotated[Optional[Annotated[str, Field(min_length=66, strict=True, max_length=66)]], Field(description="Filter events by a block hash.")] = None,
        block_number: Annotated[Optional[StrictInt], Field(description="Filter events by a block number.")] = None,
        tx_index_in_block: Annotated[Optional[StrictInt], Field(description="Filter events by a transaction's index in the block.")] = None,
        event_index_in_log: Annotated[Optional[StrictInt], Field(description="Filter events by index in the log.")] = None,
        tx_hash: Annotated[Optional[Annotated[str, Field(min_length=66, strict=True, max_length=66)]], Field(description="Filter events by a transaction hash.")] = None,
        from_constructor: Annotated[Optional[StrictBool], Field(description="Filter events by whether they were emitted from the constructor function.")] = None,
        chain: Annotated[Optional[ChainName], Field(description="Filter events by a chain name.")] = None,
        contract_address: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Filter events by a contract address.")] = None,
        contract_label: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Filter events by a contract label.")] = None,
        event_signature: Annotated[Optional[StrictStr], Field(description="Filter events by the signature.")] = None,
        limit: Optional[StrictInt] = None,
        offset: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetEventCount200Response:
        """Get event count

        Gets the number of events stored in the database.

        :param block_hash: Filter events by a block hash.
        :type block_hash: str
        :param block_number: Filter events by a block number.
        :type block_number: int
        :param tx_index_in_block: Filter events by a transaction's index in the block.
        :type tx_index_in_block: int
        :param event_index_in_log: Filter events by index in the log.
        :type event_index_in_log: int
        :param tx_hash: Filter events by a transaction hash.
        :type tx_hash: str
        :param from_constructor: Filter events by whether they were emitted from the constructor function.
        :type from_constructor: bool
        :param chain: Filter events by a chain name.
        :type chain: ChainName
        :param contract_address: Filter events by a contract address.
        :type contract_address: str
        :param contract_label: Filter events by a contract label.
        :type contract_label: str
        :param event_signature: Filter events by the signature.
        :type event_signature: str
        :param limit:
        :type limit: int
        :param offset:
        :type offset: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_event_count_serialize(
            block_hash=block_hash,
            block_number=block_number,
            tx_index_in_block=tx_index_in_block,
            event_index_in_log=event_index_in_log,
            tx_hash=tx_hash,
            from_constructor=from_constructor,
            chain=chain,
            contract_address=contract_address,
            contract_label=contract_label,
            event_signature=event_signature,
            limit=limit,
            offset=offset,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetEventCount200Response",
            '4XX': "Error",
            '5XX': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_event_count_with_http_info(
        self,
        block_hash: Annotated[Optional[Annotated[str, Field(min_length=66, strict=True, max_length=66)]], Field(description="Filter events by a block hash.")] = None,
        block_number: Annotated[Optional[StrictInt], Field(description="Filter events by a block number.")] = None,
        tx_index_in_block: Annotated[Optional[StrictInt], Field(description="Filter events by a transaction's index in the block.")] = None,
        event_index_in_log: Annotated[Optional[StrictInt], Field(description="Filter events by index in the log.")] = None,
        tx_hash: Annotated[Optional[Annotated[str, Field(min_length=66, strict=True, max_length=66)]], Field(description="Filter events by a transaction hash.")] = None,
        from_constructor: Annotated[Optional[StrictBool], Field(description="Filter events by whether they were emitted from the constructor function.")] = None,
        chain: Annotated[Optional[ChainName], Field(description="Filter events by a chain name.")] = None,
        contract_address: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Filter events by a contract address.")] = None,
        contract_label: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Filter events by a contract label.")] = None,
        event_signature: Annotated[Optional[StrictStr], Field(description="Filter events by the signature.")] = None,
        limit: Optional[StrictInt] = None,
        offset: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetEventCount200Response]:
        """Get event count

        Gets the number of events stored in the database.

        :param block_hash: Filter events by a block hash.
        :type block_hash: str
        :param block_number: Filter events by a block number.
        :type block_number: int
        :param tx_index_in_block: Filter events by a transaction's index in the block.
        :type tx_index_in_block: int
        :param event_index_in_log: Filter events by index in the log.
        :type event_index_in_log: int
        :param tx_hash: Filter events by a transaction hash.
        :type tx_hash: str
        :param from_constructor: Filter events by whether they were emitted from the constructor function.
        :type from_constructor: bool
        :param chain: Filter events by a chain name.
        :type chain: ChainName
        :param contract_address: Filter events by a contract address.
        :type contract_address: str
        :param contract_label: Filter events by a contract label.
        :type contract_label: str
        :param event_signature: Filter events by the signature.
        :type event_signature: str
        :param limit:
        :type limit: int
        :param offset:
        :type offset: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_event_count_serialize(
            block_hash=block_hash,
            block_number=block_number,
            tx_index_in_block=tx_index_in_block,
            event_index_in_log=event_index_in_log,
            tx_hash=tx_hash,
            from_constructor=from_constructor,
            chain=chain,
            contract_address=contract_address,
            contract_label=contract_label,
            event_signature=event_signature,
            limit=limit,
            offset=offset,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetEventCount200Response",
            '4XX': "Error",
            '5XX': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_event_count_without_preload_content(
        self,
        block_hash: Annotated[Optional[Annotated[str, Field(min_length=66, strict=True, max_length=66)]], Field(description="Filter events by a block hash.")] = None,
        block_number: Annotated[Optional[StrictInt], Field(description="Filter events by a block number.")] = None,
        tx_index_in_block: Annotated[Optional[StrictInt], Field(description="Filter events by a transaction's index in the block.")] = None,
        event_index_in_log: Annotated[Optional[StrictInt], Field(description="Filter events by index in the log.")] = None,
        tx_hash: Annotated[Optional[Annotated[str, Field(min_length=66, strict=True, max_length=66)]], Field(description="Filter events by a transaction hash.")] = None,
        from_constructor: Annotated[Optional[StrictBool], Field(description="Filter events by whether they were emitted from the constructor function.")] = None,
        chain: Annotated[Optional[ChainName], Field(description="Filter events by a chain name.")] = None,
        contract_address: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Filter events by a contract address.")] = None,
        contract_label: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Filter events by a contract label.")] = None,
        event_signature: Annotated[Optional[StrictStr], Field(description="Filter events by the signature.")] = None,
        limit: Optional[StrictInt] = None,
        offset: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get event count

        Gets the number of events stored in the database.

        :param block_hash: Filter events by a block hash.
        :type block_hash: str
        :param block_number: Filter events by a block number.
        :type block_number: int
        :param tx_index_in_block: Filter events by a transaction's index in the block.
        :type tx_index_in_block: int
        :param event_index_in_log: Filter events by index in the log.
        :type event_index_in_log: int
        :param tx_hash: Filter events by a transaction hash.
        :type tx_hash: str
        :param from_constructor: Filter events by whether they were emitted from the constructor function.
        :type from_constructor: bool
        :param chain: Filter events by a chain name.
        :type chain: ChainName
        :param contract_address: Filter events by a contract address.
        :type contract_address: str
        :param contract_label: Filter events by a contract label.
        :type contract_label: str
        :param event_signature: Filter events by the signature.
        :type event_signature: str
        :param limit:
        :type limit: int
        :param offset:
        :type offset: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_event_count_serialize(
            block_hash=block_hash,
            block_number=block_number,
            tx_index_in_block=tx_index_in_block,
            event_index_in_log=event_index_in_log,
            tx_hash=tx_hash,
            from_constructor=from_constructor,
            chain=chain,
            contract_address=contract_address,
            contract_label=contract_label,
            event_signature=event_signature,
            limit=limit,
            offset=offset,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetEventCount200Response",
            '4XX': "Error",
            '5XX': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_event_count_serialize(
        self,
        block_hash,
        block_number,
        tx_index_in_block,
        event_index_in_log,
        tx_hash,
        from_constructor,
        chain,
        contract_address,
        contract_label,
        event_signature,
        limit,
        offset,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if block_hash is not None:
            
            _query_params.append(('block_hash', block_hash))
            
        if block_number is not None:
            
            _query_params.append(('block_number', block_number))
            
        if tx_index_in_block is not None:
            
            _query_params.append(('tx_index_in_block', tx_index_in_block))
            
        if event_index_in_log is not None:
            
            _query_params.append(('event_index_in_log', event_index_in_log))
            
        if tx_hash is not None:
            
            _query_params.append(('tx_hash', tx_hash))
            
        if from_constructor is not None:
            
            _query_params.append(('from_constructor', from_constructor))
            
        if chain is not None:
            
            _query_params.append(('chain', chain.value))
            
        if contract_address is not None:
            
            _query_params.append(('contract_address', contract_address))
            
        if contract_label is not None:
            
            _query_params.append(('contract_label', contract_label))
            
        if event_signature is not None:
            
            _query_params.append(('event_signature', event_signature))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'cookie', 
            'bearer'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/events/count',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def list_events(
        self,
        block_hash: Annotated[Optional[Annotated[str, Field(min_length=66, strict=True, max_length=66)]], Field(description="Filter events by a block hash.")] = None,
        block_number: Annotated[Optional[StrictInt], Field(description="Filter events by a block number.")] = None,
        tx_index_in_block: Annotated[Optional[StrictInt], Field(description="Filter events by a transaction's index in the block.")] = None,
        event_index_in_log: Annotated[Optional[StrictInt], Field(description="Filter events by index in the log.")] = None,
        tx_hash: Annotated[Optional[Annotated[str, Field(min_length=66, strict=True, max_length=66)]], Field(description="Filter events by a transaction hash.")] = None,
        from_constructor: Annotated[Optional[StrictBool], Field(description="Filter events by whether they were emitted from the constructor function.")] = None,
        chain: Annotated[Optional[ChainName], Field(description="Filter events by a chain name.")] = None,
        contract_address: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Filter events by a contract address.")] = None,
        contract_label: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Filter events by a contract label.")] = None,
        event_signature: Annotated[Optional[StrictStr], Field(description="Filter events by the signature.")] = None,
        limit: Optional[StrictInt] = None,
        offset: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListEvents200Response:
        """List events

        Returns all events stored in the database.

        :param block_hash: Filter events by a block hash.
        :type block_hash: str
        :param block_number: Filter events by a block number.
        :type block_number: int
        :param tx_index_in_block: Filter events by a transaction's index in the block.
        :type tx_index_in_block: int
        :param event_index_in_log: Filter events by index in the log.
        :type event_index_in_log: int
        :param tx_hash: Filter events by a transaction hash.
        :type tx_hash: str
        :param from_constructor: Filter events by whether they were emitted from the constructor function.
        :type from_constructor: bool
        :param chain: Filter events by a chain name.
        :type chain: ChainName
        :param contract_address: Filter events by a contract address.
        :type contract_address: str
        :param contract_label: Filter events by a contract label.
        :type contract_label: str
        :param event_signature: Filter events by the signature.
        :type event_signature: str
        :param limit:
        :type limit: int
        :param offset:
        :type offset: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_events_serialize(
            block_hash=block_hash,
            block_number=block_number,
            tx_index_in_block=tx_index_in_block,
            event_index_in_log=event_index_in_log,
            tx_hash=tx_hash,
            from_constructor=from_constructor,
            chain=chain,
            contract_address=contract_address,
            contract_label=contract_label,
            event_signature=event_signature,
            limit=limit,
            offset=offset,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListEvents200Response",
            '4XX': "Error",
            '5XX': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def list_events_with_http_info(
        self,
        block_hash: Annotated[Optional[Annotated[str, Field(min_length=66, strict=True, max_length=66)]], Field(description="Filter events by a block hash.")] = None,
        block_number: Annotated[Optional[StrictInt], Field(description="Filter events by a block number.")] = None,
        tx_index_in_block: Annotated[Optional[StrictInt], Field(description="Filter events by a transaction's index in the block.")] = None,
        event_index_in_log: Annotated[Optional[StrictInt], Field(description="Filter events by index in the log.")] = None,
        tx_hash: Annotated[Optional[Annotated[str, Field(min_length=66, strict=True, max_length=66)]], Field(description="Filter events by a transaction hash.")] = None,
        from_constructor: Annotated[Optional[StrictBool], Field(description="Filter events by whether they were emitted from the constructor function.")] = None,
        chain: Annotated[Optional[ChainName], Field(description="Filter events by a chain name.")] = None,
        contract_address: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Filter events by a contract address.")] = None,
        contract_label: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Filter events by a contract label.")] = None,
        event_signature: Annotated[Optional[StrictStr], Field(description="Filter events by the signature.")] = None,
        limit: Optional[StrictInt] = None,
        offset: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListEvents200Response]:
        """List events

        Returns all events stored in the database.

        :param block_hash: Filter events by a block hash.
        :type block_hash: str
        :param block_number: Filter events by a block number.
        :type block_number: int
        :param tx_index_in_block: Filter events by a transaction's index in the block.
        :type tx_index_in_block: int
        :param event_index_in_log: Filter events by index in the log.
        :type event_index_in_log: int
        :param tx_hash: Filter events by a transaction hash.
        :type tx_hash: str
        :param from_constructor: Filter events by whether they were emitted from the constructor function.
        :type from_constructor: bool
        :param chain: Filter events by a chain name.
        :type chain: ChainName
        :param contract_address: Filter events by a contract address.
        :type contract_address: str
        :param contract_label: Filter events by a contract label.
        :type contract_label: str
        :param event_signature: Filter events by the signature.
        :type event_signature: str
        :param limit:
        :type limit: int
        :param offset:
        :type offset: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_events_serialize(
            block_hash=block_hash,
            block_number=block_number,
            tx_index_in_block=tx_index_in_block,
            event_index_in_log=event_index_in_log,
            tx_hash=tx_hash,
            from_constructor=from_constructor,
            chain=chain,
            contract_address=contract_address,
            contract_label=contract_label,
            event_signature=event_signature,
            limit=limit,
            offset=offset,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListEvents200Response",
            '4XX': "Error",
            '5XX': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def list_events_without_preload_content(
        self,
        block_hash: Annotated[Optional[Annotated[str, Field(min_length=66, strict=True, max_length=66)]], Field(description="Filter events by a block hash.")] = None,
        block_number: Annotated[Optional[StrictInt], Field(description="Filter events by a block number.")] = None,
        tx_index_in_block: Annotated[Optional[StrictInt], Field(description="Filter events by a transaction's index in the block.")] = None,
        event_index_in_log: Annotated[Optional[StrictInt], Field(description="Filter events by index in the log.")] = None,
        tx_hash: Annotated[Optional[Annotated[str, Field(min_length=66, strict=True, max_length=66)]], Field(description="Filter events by a transaction hash.")] = None,
        from_constructor: Annotated[Optional[StrictBool], Field(description="Filter events by whether they were emitted from the constructor function.")] = None,
        chain: Annotated[Optional[ChainName], Field(description="Filter events by a chain name.")] = None,
        contract_address: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Filter events by a contract address.")] = None,
        contract_label: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Filter events by a contract label.")] = None,
        event_signature: Annotated[Optional[StrictStr], Field(description="Filter events by the signature.")] = None,
        limit: Optional[StrictInt] = None,
        offset: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List events

        Returns all events stored in the database.

        :param block_hash: Filter events by a block hash.
        :type block_hash: str
        :param block_number: Filter events by a block number.
        :type block_number: int
        :param tx_index_in_block: Filter events by a transaction's index in the block.
        :type tx_index_in_block: int
        :param event_index_in_log: Filter events by index in the log.
        :type event_index_in_log: int
        :param tx_hash: Filter events by a transaction hash.
        :type tx_hash: str
        :param from_constructor: Filter events by whether they were emitted from the constructor function.
        :type from_constructor: bool
        :param chain: Filter events by a chain name.
        :type chain: ChainName
        :param contract_address: Filter events by a contract address.
        :type contract_address: str
        :param contract_label: Filter events by a contract label.
        :type contract_label: str
        :param event_signature: Filter events by the signature.
        :type event_signature: str
        :param limit:
        :type limit: int
        :param offset:
        :type offset: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_events_serialize(
            block_hash=block_hash,
            block_number=block_number,
            tx_index_in_block=tx_index_in_block,
            event_index_in_log=event_index_in_log,
            tx_hash=tx_hash,
            from_constructor=from_constructor,
            chain=chain,
            contract_address=contract_address,
            contract_label=contract_label,
            event_signature=event_signature,
            limit=limit,
            offset=offset,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListEvents200Response",
            '4XX': "Error",
            '5XX': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_events_serialize(
        self,
        block_hash,
        block_number,
        tx_index_in_block,
        event_index_in_log,
        tx_hash,
        from_constructor,
        chain,
        contract_address,
        contract_label,
        event_signature,
        limit,
        offset,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if block_hash is not None:
            
            _query_params.append(('block_hash', block_hash))
            
        if block_number is not None:
            
            _query_params.append(('block_number', block_number))
            
        if tx_index_in_block is not None:
            
            _query_params.append(('tx_index_in_block', tx_index_in_block))
            
        if event_index_in_log is not None:
            
            _query_params.append(('event_index_in_log', event_index_in_log))
            
        if tx_hash is not None:
            
            _query_params.append(('tx_hash', tx_hash))
            
        if from_constructor is not None:
            
            _query_params.append(('from_constructor', from_constructor))
            
        if chain is not None:
            
            _query_params.append(('chain', chain.value))
            
        if contract_address is not None:
            
            _query_params.append(('contract_address', contract_address))
            
        if contract_label is not None:
            
            _query_params.append(('contract_label', contract_label))
            
        if event_signature is not None:
            
            _query_params.append(('event_signature', event_signature))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'cookie', 
            'bearer'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/events',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


