# coding: utf-8

"""
    MultiBaas API

    MultiBaas's REST APIv0.

    The version of the OpenAPI document: 0.0
    Contact: contact@curvegrid.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBytes, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from multibaas_sdk.models.contract_lookup import ContractLookup
from multibaas_sdk.models.contract_metadata import ContractMetadata
from typing import Optional, Set
from typing_extensions import Self

class Address(BaseModel):
    """
    An address details.
    """ # noqa: E501
    alias: Annotated[str, Field(strict=True)] = Field(description="An alias to easily identify and reference addresses.")
    address: Annotated[str, Field(strict=True)] = Field(description="An ethereum address.")
    balance: Optional[StrictStr] = None
    chain: StrictStr
    nonce: Optional[StrictInt] = Field(default=None, description="The next transaction nonce for this address (obtained from the blockchain node).")
    local_nonce: Optional[StrictInt] = Field(default=None, description="The next transaction nonce for this address when using the nonce management feature.", alias="localNonce")
    code_at: Optional[Union[StrictBytes, StrictStr]] = Field(default=None, alias="codeAt")
    contracts: List[ContractMetadata]
    contract_lookup: Optional[List[ContractLookup]] = Field(default=None, alias="contractLookup")
    __properties: ClassVar[List[str]] = ["alias", "address", "balance", "chain", "nonce", "localNonce", "codeAt", "contracts", "contractLookup"]

    @field_validator('alias')
    def alias_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[a-z0-9_-]+$", value):
            raise ValueError(r"must validate the regular expression /^[a-z0-9_-]+$/")
        return value

    @field_validator('address')
    def address_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^0[xX][a-fA-F0-9]{40}$", value):
            raise ValueError(r"must validate the regular expression /^0[xX][a-fA-F0-9]{40}$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Address from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in contracts (list)
        _items = []
        if self.contracts:
            for _item_contracts in self.contracts:
                if _item_contracts:
                    _items.append(_item_contracts.to_dict())
            _dict['contracts'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in contract_lookup (list)
        _items = []
        if self.contract_lookup:
            for _item_contract_lookup in self.contract_lookup:
                if _item_contract_lookup:
                    _items.append(_item_contract_lookup.to_dict())
            _dict['contractLookup'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Address from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "alias": obj.get("alias"),
            "address": obj.get("address"),
            "balance": obj.get("balance"),
            "chain": obj.get("chain"),
            "nonce": obj.get("nonce"),
            "localNonce": obj.get("localNonce"),
            "codeAt": obj.get("codeAt"),
            "contracts": [ContractMetadata.from_dict(_item) for _item in obj["contracts"]] if obj.get("contracts") is not None else None,
            "contractLookup": [ContractLookup.from_dict(_item) for _item in obj["contractLookup"]] if obj.get("contractLookup") is not None else None
        })
        return _obj


