# coding: utf-8

"""
    MultiBaas API

    MultiBaas's REST APIv0.

    The version of the OpenAPI document: 0.0
    Contact: contact@curvegrid.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional
from multibaas_sdk.models.contract_abi_error import ContractABIError
from multibaas_sdk.models.contract_abi_event import ContractABIEvent
from multibaas_sdk.models.contract_abi_method import ContractABIMethod
from multibaas_sdk.models.contract_abi_method1 import ContractABIMethod1
from typing import Optional, Set
from typing_extensions import Self

class ContractABI(BaseModel):
    """
    The contract ABI.
    """ # noqa: E501
    constructor: Optional[ContractABIMethod1]
    methods: Dict[str, Optional[ContractABIMethod]]
    events: Dict[str, ContractABIEvent]
    errors: Optional[Dict[str, ContractABIError]] = None
    fallback: Optional[ContractABIMethod]
    receive: Optional[ContractABIMethod]
    __properties: ClassVar[List[str]] = ["constructor", "methods", "events", "errors", "fallback", "receive"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ContractABI from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of constructor
        if self.constructor:
            _dict['constructor'] = self.constructor.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in methods (dict)
        _field_dict = {}
        if self.methods:
            for _key_methods in self.methods:
                if self.methods[_key_methods]:
                    _field_dict[_key_methods] = self.methods[_key_methods].to_dict()
            _dict['methods'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in events (dict)
        _field_dict = {}
        if self.events:
            for _key_events in self.events:
                if self.events[_key_events]:
                    _field_dict[_key_events] = self.events[_key_events].to_dict()
            _dict['events'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in errors (dict)
        _field_dict = {}
        if self.errors:
            for _key_errors in self.errors:
                if self.errors[_key_errors]:
                    _field_dict[_key_errors] = self.errors[_key_errors].to_dict()
            _dict['errors'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of fallback
        if self.fallback:
            _dict['fallback'] = self.fallback.to_dict()
        # override the default output from pydantic by calling `to_dict()` of receive
        if self.receive:
            _dict['receive'] = self.receive.to_dict()
        # set to None if constructor (nullable) is None
        # and model_fields_set contains the field
        if self.constructor is None and "constructor" in self.model_fields_set:
            _dict['constructor'] = None

        # set to None if fallback (nullable) is None
        # and model_fields_set contains the field
        if self.fallback is None and "fallback" in self.model_fields_set:
            _dict['fallback'] = None

        # set to None if receive (nullable) is None
        # and model_fields_set contains the field
        if self.receive is None and "receive" in self.model_fields_set:
            _dict['receive'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ContractABI from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "constructor": ContractABIMethod1.from_dict(obj["constructor"]) if obj.get("constructor") is not None else None,
            "methods": dict(
                (_k, ContractABIMethod.from_dict(_v))
                for _k, _v in obj["methods"].items()
            )
            if obj.get("methods") is not None
            else None,
            "events": dict(
                (_k, ContractABIEvent.from_dict(_v))
                for _k, _v in obj["events"].items()
            )
            if obj.get("events") is not None
            else None,
            "errors": dict(
                (_k, ContractABIError.from_dict(_v))
                for _k, _v in obj["errors"].items()
            )
            if obj.get("errors") is not None
            else None,
            "fallback": ContractABIMethod.from_dict(obj["fallback"]) if obj.get("fallback") is not None else None,
            "receive": ContractABIMethod.from_dict(obj["receive"]) if obj.get("receive") is not None else None
        })
        return _obj


