# coding: utf-8

"""
    MultiBaas API

    MultiBaas's REST APIv0.

    The version of the OpenAPI document: 0.0
    Contact: contact@curvegrid.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class ContractInformation(BaseModel):
    """
    The contract information within the event or transaction.
    """ # noqa: E501
    address: Annotated[str, Field(strict=True)] = Field(description="An ethereum address.")
    address_alias: Annotated[str, Field(strict=True)] = Field(description="An alias to easily identify and reference addresses.", alias="addressAlias")
    name: StrictStr = Field(description="The name of the contract.")
    label: Annotated[str, Field(strict=True)] = Field(description="An alias to easily identify and reference the entity in subsequent requests.")
    __properties: ClassVar[List[str]] = ["address", "addressAlias", "name", "label"]

    @field_validator('address')
    def address_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^0[xX][a-fA-F0-9]{40}$", value):
            raise ValueError(r"must validate the regular expression /^0[xX][a-fA-F0-9]{40}$/")
        return value

    @field_validator('address_alias')
    def address_alias_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[a-z0-9_-]+$", value):
            raise ValueError(r"must validate the regular expression /^[a-z0-9_-]+$/")
        return value

    @field_validator('label')
    def label_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[a-z0-9_-]+$", value):
            raise ValueError(r"must validate the regular expression /^[a-z0-9_-]+$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ContractInformation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ContractInformation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "address": obj.get("address"),
            "addressAlias": obj.get("addressAlias"),
            "name": obj.get("name"),
            "label": obj.get("label")
        })
        return _obj


