# coding: utf-8

"""
    MultiBaas API

    MultiBaas's REST APIv0.

    The version of the OpenAPI document: 0.0
    Contact: contact@curvegrid.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, field_validator
from typing import Any, ClassVar, Dict, List
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class ContractMetadata(BaseModel):
    """
    ContractMetadata
    """ # noqa: E501
    label: Annotated[str, Field(strict=True)] = Field(description="An alias to easily identify and reference the entity in subsequent requests.")
    name: Annotated[str, Field(strict=True)] = Field(description="The name of the contract.")
    version: Annotated[str, Field(strict=True)] = Field(description="The contract version.")
    __properties: ClassVar[List[str]] = ["label", "name", "version"]

    @field_validator('label')
    def label_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[a-z0-9_-]+$", value):
            raise ValueError(r"must validate the regular expression /^[a-z0-9_-]+$/")
        return value

    @field_validator('name')
    def name_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[^\"#$%&\'\'()*+,\/:;<>?[\\\]^\x60{}~]*$", value):
            raise ValueError(r"must validate the regular expression /^[^\"#$%&''()*+,\/:;<>?[\\\]^\x60{}~]*$/")
        return value

    @field_validator('version')
    def version_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[^\"#$%&\'\'()*+,\/:;<>?[\\\]^\x60{}~]*$", value):
            raise ValueError(r"must validate the regular expression /^[^\"#$%&''()*+,\/:;<>?[\\\]^\x60{}~]*$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ContractMetadata from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ContractMetadata from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "label": obj.get("label"),
            "name": obj.get("name"),
            "version": obj.get("version")
        })
        return _obj


