# coding: utf-8

"""
    MultiBaas API

    MultiBaas's REST APIv0.

    The version of the OpenAPI document: 0.0
    Contact: contact@curvegrid.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List
from multibaas_sdk.models.eip712_domain import EIP712Domain
from multibaas_sdk.models.eip712_types import EIP712Types
from typing import Optional, Set
from typing_extensions import Self

class EIP712TypedData(BaseModel):
    """
    EIP-712 structured typed data object.
    """ # noqa: E501
    types: EIP712Types
    primary_type: StrictStr = Field(description="The root type of the message object. Must correspond to a key in the `types` object.", alias="primaryType")
    domain: EIP712Domain
    message: Dict[str, Any] = Field(description="The actual data, conforming to the `primaryType` definition in `types`.")
    __properties: ClassVar[List[str]] = ["types", "primaryType", "domain", "message"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EIP712TypedData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of types
        if self.types:
            _dict['types'] = self.types.to_dict()
        # override the default output from pydantic by calling `to_dict()` of domain
        if self.domain:
            _dict['domain'] = self.domain.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EIP712TypedData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "types": EIP712Types.from_dict(obj["types"]) if obj.get("types") is not None else None,
            "primaryType": obj.get("primaryType"),
            "domain": EIP712Domain.from_dict(obj["domain"]) if obj.get("domain") is not None else None,
            "message": obj.get("message")
        })
        return _obj


