# coding: utf-8

"""
    MultiBaas API

    MultiBaas's REST APIv0.

    The version of the OpenAPI document: 0.0
    Contact: contact@curvegrid.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from multibaas_sdk.models.contract_information import ContractInformation
from multibaas_sdk.models.event_field import EventField
from typing import Optional, Set
from typing_extensions import Self

class EventInformation(BaseModel):
    """
    The event information returned as part of an event.
    """ # noqa: E501
    name: StrictStr = Field(description="The name of the event.")
    signature: StrictStr = Field(description="The event signature.")
    inputs: List[EventField] = Field(description="The list of input arguments for the event.")
    raw_fields: Optional[StrictStr] = Field(default=None, description="The raw output from an event. Omitted when returned as part of a transaction receipt.", alias="rawFields")
    contract: ContractInformation
    index_in_log: StrictInt = Field(description="The event's index in the log.", alias="indexInLog")
    __properties: ClassVar[List[str]] = ["name", "signature", "inputs", "rawFields", "contract", "indexInLog"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EventInformation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in inputs (list)
        _items = []
        if self.inputs:
            for _item_inputs in self.inputs:
                if _item_inputs:
                    _items.append(_item_inputs.to_dict())
            _dict['inputs'] = _items
        # override the default output from pydantic by calling `to_dict()` of contract
        if self.contract:
            _dict['contract'] = self.contract.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EventInformation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "signature": obj.get("signature"),
            "inputs": [EventField.from_dict(_item) for _item in obj["inputs"]] if obj.get("inputs") is not None else None,
            "rawFields": obj.get("rawFields"),
            "contract": ContractInformation.from_dict(obj["contract"]) if obj.get("contract") is not None else None,
            "indexInLog": obj.get("indexInLog")
        })
        return _obj


