# coding: utf-8

"""
    MultiBaas API

    MultiBaas's REST APIv0.

    The version of the OpenAPI document: 0.0
    Contact: contact@curvegrid.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from multibaas_sdk.models.field_type import FieldType
from typing import Optional, Set
from typing_extensions import Self

class EventQueryFilter(BaseModel):
    """
    A event query filter.
    """ # noqa: E501
    rule: Optional[StrictStr] = Field(default=None, description="The rule type, can be omitted if this is the last filter to be applied.")
    field_type: Optional[FieldType] = Field(default=None, alias="fieldType")
    input_index: Optional[StrictInt] = Field(default=None, description="The field's index, can be used in place of `name`.", alias="inputIndex")
    operator: Optional[StrictStr] = Field(default=None, description="The operator on the filter.")
    value: Optional[StrictStr] = Field(default=None, description="The value to be compared with.")
    children: Optional[List[EventQueryFilter]] = Field(default=None, description="Other filters to be applied in succession with the rule specified.")
    __properties: ClassVar[List[str]] = ["rule", "fieldType", "inputIndex", "operator", "value", "children"]

    @field_validator('rule')
    def rule_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['and', 'or']):
            raise ValueError("must be one of enum values ('and', 'or')")
        return value

    @field_validator('operator')
    def operator_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['equal', 'notequal', 'lessthan', 'greaterthan', 'lessthanorequal', 'greaterthanorequal']):
            raise ValueError("must be one of enum values ('equal', 'notequal', 'lessthan', 'greaterthan', 'lessthanorequal', 'greaterthanorequal')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EventQueryFilter from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in children (list)
        _items = []
        if self.children:
            for _item_children in self.children:
                if _item_children:
                    _items.append(_item_children.to_dict())
            _dict['children'] = _items
        # set to None if input_index (nullable) is None
        # and model_fields_set contains the field
        if self.input_index is None and "input_index" in self.model_fields_set:
            _dict['inputIndex'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EventQueryFilter from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "rule": obj.get("rule"),
            "fieldType": obj.get("fieldType"),
            "inputIndex": obj.get("inputIndex"),
            "operator": obj.get("operator"),
            "value": obj.get("value"),
            "children": [EventQueryFilter.from_dict(_item) for _item in obj["children"]] if obj.get("children") is not None else None
        })
        return _obj

# TODO: Rewrite to not use raise_errors
EventQueryFilter.model_rebuild(raise_errors=False)

