# coding: utf-8

"""
    MultiBaas API

    MultiBaas's REST APIv0.

    The version of the OpenAPI document: 0.0
    Contact: contact@curvegrid.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, field_validator
from typing import Any, ClassVar, Dict, List
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class Log(BaseModel):
    """
    A contract log event.
    """ # noqa: E501
    address: Annotated[str, Field(strict=True)] = Field(description="An ethereum address.")
    topics: List[Annotated[str, Field(min_length=66, strict=True, max_length=66)]] = Field(description="A list of topics provided by the contract.")
    data: Annotated[str, Field(strict=True)] = Field(description="A hex string.")
    block_number: Annotated[str, Field(strict=True)] = Field(description="A hex string.", alias="blockNumber")
    transaction_hash: Annotated[str, Field(min_length=66, strict=True, max_length=66)] = Field(description="The keccak256 hash as a hex string of 256 bits.", alias="transactionHash")
    transaction_index: Annotated[str, Field(strict=True)] = Field(description="A hex string.", alias="transactionIndex")
    block_hash: Annotated[str, Field(min_length=66, strict=True, max_length=66)] = Field(description="The keccak256 hash as a hex string of 256 bits.", alias="blockHash")
    log_index: Annotated[str, Field(strict=True)] = Field(description="A hex string.", alias="logIndex")
    removed: StrictBool = Field(description="True if this log was reverted due to a chain reorganization.")
    __properties: ClassVar[List[str]] = ["address", "topics", "data", "blockNumber", "transactionHash", "transactionIndex", "blockHash", "logIndex", "removed"]

    @field_validator('address')
    def address_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^0[xX][a-fA-F0-9]{40}$", value):
            raise ValueError(r"must validate the regular expression /^0[xX][a-fA-F0-9]{40}$/")
        return value

    @field_validator('data')
    def data_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^(0x[0-9a-f]*|0X[0-9A-F]*)$", value):
            raise ValueError(r"must validate the regular expression /^(0x[0-9a-f]*|0X[0-9A-F]*)$/")
        return value

    @field_validator('block_number')
    def block_number_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^(0x[0-9a-f]*|0X[0-9A-F]*)$", value):
            raise ValueError(r"must validate the regular expression /^(0x[0-9a-f]*|0X[0-9A-F]*)$/")
        return value

    @field_validator('transaction_hash')
    def transaction_hash_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^(0x[0-9a-f]{64}|0X[0-9A-F]{64})$", value):
            raise ValueError(r"must validate the regular expression /^(0x[0-9a-f]{64}|0X[0-9A-F]{64})$/")
        return value

    @field_validator('transaction_index')
    def transaction_index_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^(0x[0-9a-f]*|0X[0-9A-F]*)$", value):
            raise ValueError(r"must validate the regular expression /^(0x[0-9a-f]*|0X[0-9A-F]*)$/")
        return value

    @field_validator('block_hash')
    def block_hash_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^(0x[0-9a-f]{64}|0X[0-9A-F]{64})$", value):
            raise ValueError(r"must validate the regular expression /^(0x[0-9a-f]{64}|0X[0-9A-F]{64})$/")
        return value

    @field_validator('log_index')
    def log_index_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^(0x[0-9a-f]*|0X[0-9A-F]*)$", value):
            raise ValueError(r"must validate the regular expression /^(0x[0-9a-f]*|0X[0-9A-F]*)$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Log from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Log from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "address": obj.get("address"),
            "topics": obj.get("topics"),
            "data": obj.get("data"),
            "blockNumber": obj.get("blockNumber"),
            "transactionHash": obj.get("transactionHash"),
            "transactionIndex": obj.get("transactionIndex"),
            "blockHash": obj.get("blockHash"),
            "logIndex": obj.get("logIndex"),
            "removed": obj.get("removed")
        })
        return _obj


