# coding: utf-8

"""
    MultiBaas API

    MultiBaas's REST APIv0.

    The version of the OpenAPI document: 0.0
    Contact: contact@curvegrid.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from multibaas_sdk.models.access_tuple import AccessTuple
from multibaas_sdk.models.set_code_authorization import SetCodeAuthorization
from typing import Optional, Set
from typing_extensions import Self

class Transaction(BaseModel):
    """
    A transaction from the Ethereum Blockchain.
    """ # noqa: E501
    type: Annotated[str, Field(strict=True)] = Field(description="A hex string.")
    chain_id: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="A hex string or null.", alias="chainId")
    nonce: Annotated[str, Field(strict=True)] = Field(description="A hex string.")
    to: Optional[Annotated[str, Field(strict=True)]] = Field(description="An ethereum address.")
    var_from: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="An ethereum address.", alias="from")
    gas: Annotated[str, Field(strict=True)] = Field(description="A hex string.")
    gas_price: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="A hex string or null.", alias="gasPrice")
    max_priority_fee_per_gas: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="A hex string or null.", alias="maxPriorityFeePerGas")
    max_fee_per_gas: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="A hex string or null.", alias="maxFeePerGas")
    max_fee_per_blob_gas: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="A hex string or null.", alias="maxFeePerBlobGas")
    value: Optional[Annotated[str, Field(strict=True)]] = Field(description="A hex string or null.")
    input: Annotated[str, Field(strict=True)] = Field(description="A hex string.")
    access_list: Optional[List[AccessTuple]] = Field(default=None, alias="accessList")
    blob_versioned_hashes: Optional[List[Annotated[str, Field(min_length=66, strict=True, max_length=66)]]] = Field(default=None, alias="blobVersionedHashes")
    authorization_list: Optional[List[SetCodeAuthorization]] = Field(default=None, alias="authorizationList")
    v: Annotated[str, Field(strict=True)] = Field(description="A hex string.")
    r: Annotated[str, Field(strict=True)] = Field(description="A hex string.")
    s: Annotated[str, Field(strict=True)] = Field(description="A hex string.")
    y_parity: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="A hex string or null.", alias="yParity")
    blobs: Optional[List[Annotated[str, Field(strict=True)]]] = None
    commitments: Optional[List[Annotated[str, Field(strict=True)]]] = None
    proofs: Optional[List[Annotated[str, Field(strict=True)]]] = None
    hash: Annotated[str, Field(min_length=66, strict=True, max_length=66)] = Field(description="The keccak256 hash as a hex string of 256 bits.")
    __properties: ClassVar[List[str]] = ["type", "chainId", "nonce", "to", "from", "gas", "gasPrice", "maxPriorityFeePerGas", "maxFeePerGas", "maxFeePerBlobGas", "value", "input", "accessList", "blobVersionedHashes", "authorizationList", "v", "r", "s", "yParity", "blobs", "commitments", "proofs", "hash"]

    @field_validator('type')
    def type_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^(0x[0-9a-f]*|0X[0-9A-F]*)$", value):
            raise ValueError(r"must validate the regular expression /^(0x[0-9a-f]*|0X[0-9A-F]*)$/")
        return value

    @field_validator('chain_id')
    def chain_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^(0x[0-9a-f]*|0X[0-9A-F]*)$", value):
            raise ValueError(r"must validate the regular expression /^(0x[0-9a-f]*|0X[0-9A-F]*)$/")
        return value

    @field_validator('nonce')
    def nonce_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^(0x[0-9a-f]*|0X[0-9A-F]*)$", value):
            raise ValueError(r"must validate the regular expression /^(0x[0-9a-f]*|0X[0-9A-F]*)$/")
        return value

    @field_validator('to')
    def to_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^0[xX][a-fA-F0-9]{40}$", value):
            raise ValueError(r"must validate the regular expression /^0[xX][a-fA-F0-9]{40}$/")
        return value

    @field_validator('var_from')
    def var_from_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^0[xX][a-fA-F0-9]{40}$", value):
            raise ValueError(r"must validate the regular expression /^0[xX][a-fA-F0-9]{40}$/")
        return value

    @field_validator('gas')
    def gas_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^(0x[0-9a-f]*|0X[0-9A-F]*)$", value):
            raise ValueError(r"must validate the regular expression /^(0x[0-9a-f]*|0X[0-9A-F]*)$/")
        return value

    @field_validator('gas_price')
    def gas_price_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^(0x[0-9a-f]*|0X[0-9A-F]*)$", value):
            raise ValueError(r"must validate the regular expression /^(0x[0-9a-f]*|0X[0-9A-F]*)$/")
        return value

    @field_validator('max_priority_fee_per_gas')
    def max_priority_fee_per_gas_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^(0x[0-9a-f]*|0X[0-9A-F]*)$", value):
            raise ValueError(r"must validate the regular expression /^(0x[0-9a-f]*|0X[0-9A-F]*)$/")
        return value

    @field_validator('max_fee_per_gas')
    def max_fee_per_gas_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^(0x[0-9a-f]*|0X[0-9A-F]*)$", value):
            raise ValueError(r"must validate the regular expression /^(0x[0-9a-f]*|0X[0-9A-F]*)$/")
        return value

    @field_validator('max_fee_per_blob_gas')
    def max_fee_per_blob_gas_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^(0x[0-9a-f]*|0X[0-9A-F]*)$", value):
            raise ValueError(r"must validate the regular expression /^(0x[0-9a-f]*|0X[0-9A-F]*)$/")
        return value

    @field_validator('value')
    def value_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^(0x[0-9a-f]*|0X[0-9A-F]*)$", value):
            raise ValueError(r"must validate the regular expression /^(0x[0-9a-f]*|0X[0-9A-F]*)$/")
        return value

    @field_validator('input')
    def input_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^(0x[0-9a-f]*|0X[0-9A-F]*)$", value):
            raise ValueError(r"must validate the regular expression /^(0x[0-9a-f]*|0X[0-9A-F]*)$/")
        return value

    @field_validator('v')
    def v_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^(0x[0-9a-f]*|0X[0-9A-F]*)$", value):
            raise ValueError(r"must validate the regular expression /^(0x[0-9a-f]*|0X[0-9A-F]*)$/")
        return value

    @field_validator('r')
    def r_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^(0x[0-9a-f]*|0X[0-9A-F]*)$", value):
            raise ValueError(r"must validate the regular expression /^(0x[0-9a-f]*|0X[0-9A-F]*)$/")
        return value

    @field_validator('s')
    def s_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^(0x[0-9a-f]*|0X[0-9A-F]*)$", value):
            raise ValueError(r"must validate the regular expression /^(0x[0-9a-f]*|0X[0-9A-F]*)$/")
        return value

    @field_validator('y_parity')
    def y_parity_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^(0x[0-9a-f]*|0X[0-9A-F]*)$", value):
            raise ValueError(r"must validate the regular expression /^(0x[0-9a-f]*|0X[0-9A-F]*)$/")
        return value

    @field_validator('hash')
    def hash_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^(0x[0-9a-f]{64}|0X[0-9A-F]{64})$", value):
            raise ValueError(r"must validate the regular expression /^(0x[0-9a-f]{64}|0X[0-9A-F]{64})$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Transaction from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in access_list (list)
        _items = []
        if self.access_list:
            for _item_access_list in self.access_list:
                if _item_access_list:
                    _items.append(_item_access_list.to_dict())
            _dict['accessList'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in authorization_list (list)
        _items = []
        if self.authorization_list:
            for _item_authorization_list in self.authorization_list:
                if _item_authorization_list:
                    _items.append(_item_authorization_list.to_dict())
            _dict['authorizationList'] = _items
        # set to None if chain_id (nullable) is None
        # and model_fields_set contains the field
        if self.chain_id is None and "chain_id" in self.model_fields_set:
            _dict['chainId'] = None

        # set to None if to (nullable) is None
        # and model_fields_set contains the field
        if self.to is None and "to" in self.model_fields_set:
            _dict['to'] = None

        # set to None if var_from (nullable) is None
        # and model_fields_set contains the field
        if self.var_from is None and "var_from" in self.model_fields_set:
            _dict['from'] = None

        # set to None if gas_price (nullable) is None
        # and model_fields_set contains the field
        if self.gas_price is None and "gas_price" in self.model_fields_set:
            _dict['gasPrice'] = None

        # set to None if max_priority_fee_per_gas (nullable) is None
        # and model_fields_set contains the field
        if self.max_priority_fee_per_gas is None and "max_priority_fee_per_gas" in self.model_fields_set:
            _dict['maxPriorityFeePerGas'] = None

        # set to None if max_fee_per_gas (nullable) is None
        # and model_fields_set contains the field
        if self.max_fee_per_gas is None and "max_fee_per_gas" in self.model_fields_set:
            _dict['maxFeePerGas'] = None

        # set to None if max_fee_per_blob_gas (nullable) is None
        # and model_fields_set contains the field
        if self.max_fee_per_blob_gas is None and "max_fee_per_blob_gas" in self.model_fields_set:
            _dict['maxFeePerBlobGas'] = None

        # set to None if value (nullable) is None
        # and model_fields_set contains the field
        if self.value is None and "value" in self.model_fields_set:
            _dict['value'] = None

        # set to None if access_list (nullable) is None
        # and model_fields_set contains the field
        if self.access_list is None and "access_list" in self.model_fields_set:
            _dict['accessList'] = None

        # set to None if blob_versioned_hashes (nullable) is None
        # and model_fields_set contains the field
        if self.blob_versioned_hashes is None and "blob_versioned_hashes" in self.model_fields_set:
            _dict['blobVersionedHashes'] = None

        # set to None if authorization_list (nullable) is None
        # and model_fields_set contains the field
        if self.authorization_list is None and "authorization_list" in self.model_fields_set:
            _dict['authorizationList'] = None

        # set to None if y_parity (nullable) is None
        # and model_fields_set contains the field
        if self.y_parity is None and "y_parity" in self.model_fields_set:
            _dict['yParity'] = None

        # set to None if blobs (nullable) is None
        # and model_fields_set contains the field
        if self.blobs is None and "blobs" in self.model_fields_set:
            _dict['blobs'] = None

        # set to None if commitments (nullable) is None
        # and model_fields_set contains the field
        if self.commitments is None and "commitments" in self.model_fields_set:
            _dict['commitments'] = None

        # set to None if proofs (nullable) is None
        # and model_fields_set contains the field
        if self.proofs is None and "proofs" in self.model_fields_set:
            _dict['proofs'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Transaction from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type"),
            "chainId": obj.get("chainId"),
            "nonce": obj.get("nonce"),
            "to": obj.get("to"),
            "from": obj.get("from"),
            "gas": obj.get("gas"),
            "gasPrice": obj.get("gasPrice"),
            "maxPriorityFeePerGas": obj.get("maxPriorityFeePerGas"),
            "maxFeePerGas": obj.get("maxFeePerGas"),
            "maxFeePerBlobGas": obj.get("maxFeePerBlobGas"),
            "value": obj.get("value"),
            "input": obj.get("input"),
            "accessList": [AccessTuple.from_dict(_item) for _item in obj["accessList"]] if obj.get("accessList") is not None else None,
            "blobVersionedHashes": obj.get("blobVersionedHashes"),
            "authorizationList": [SetCodeAuthorization.from_dict(_item) for _item in obj["authorizationList"]] if obj.get("authorizationList") is not None else None,
            "v": obj.get("v"),
            "r": obj.get("r"),
            "s": obj.get("s"),
            "yParity": obj.get("yParity"),
            "blobs": obj.get("blobs"),
            "commitments": obj.get("commitments"),
            "proofs": obj.get("proofs"),
            "hash": obj.get("hash")
        })
        return _obj


