# coding: utf-8

"""
    MultiBaas API

    MultiBaas's REST APIv0.

    The version of the OpenAPI document: 0.0
    Contact: contact@curvegrid.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from multibaas_sdk.models.contract_information import ContractInformation
from multibaas_sdk.models.contract_method_information import ContractMethodInformation
from multibaas_sdk.models.transaction import Transaction
from typing import Optional, Set
from typing_extensions import Self

class TransactionData(BaseModel):
    """
    The transaction data returned from a call to get transaction by hash.
    """ # noqa: E501
    data: Transaction
    is_pending: StrictBool = Field(description="Whether the transaction has been included yet.", alias="isPending")
    var_from: Annotated[str, Field(strict=True)] = Field(description="An ethereum address.", alias="from")
    block_hash: Optional[Annotated[str, Field(min_length=66, strict=True, max_length=66)]] = Field(default=None, description="The keccak256 hash as a hex string of 256 bits.", alias="blockHash")
    block_number: Optional[StrictStr] = Field(default=None, description="The transaction block number.", alias="blockNumber")
    contract: Optional[ContractInformation] = None
    method: Optional[ContractMethodInformation] = None
    __properties: ClassVar[List[str]] = ["data", "isPending", "from", "blockHash", "blockNumber", "contract", "method"]

    @field_validator('var_from')
    def var_from_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^0[xX][a-fA-F0-9]{40}$", value):
            raise ValueError(r"must validate the regular expression /^0[xX][a-fA-F0-9]{40}$/")
        return value

    @field_validator('block_hash')
    def block_hash_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^(0x[0-9a-f]{64}|0X[0-9A-F]{64})$", value):
            raise ValueError(r"must validate the regular expression /^(0x[0-9a-f]{64}|0X[0-9A-F]{64})$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TransactionData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of data
        if self.data:
            _dict['data'] = self.data.to_dict()
        # override the default output from pydantic by calling `to_dict()` of contract
        if self.contract:
            _dict['contract'] = self.contract.to_dict()
        # override the default output from pydantic by calling `to_dict()` of method
        if self.method:
            _dict['method'] = self.method.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TransactionData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "data": Transaction.from_dict(obj["data"]) if obj.get("data") is not None else None,
            "isPending": obj.get("isPending"),
            "from": obj.get("from"),
            "blockHash": obj.get("blockHash"),
            "blockNumber": obj.get("blockNumber"),
            "contract": ContractInformation.from_dict(obj["contract"]) if obj.get("contract") is not None else None,
            "method": ContractMethodInformation.from_dict(obj["method"]) if obj.get("method") is not None else None
        })
        return _obj


