# coding: utf-8

"""
    MultiBaas API

    MultiBaas's REST APIv0.

    The version of the OpenAPI document: 0.0
    Contact: contact@curvegrid.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class TransactionToSignTx(BaseModel):
    """
    An Ethereum transaction.
    """ # noqa: E501
    nonce: StrictInt = Field(description="Sender account nonce of the transaction")
    gas_price: Optional[StrictStr] = Field(default=None, description="Gas price of the transaction", alias="gasPrice")
    gas_fee_cap: Optional[StrictStr] = Field(default=None, description="Fee cap per gas of the transaction", alias="gasFeeCap")
    gas_tip_cap: Optional[StrictStr] = Field(default=None, description="GasTipCap per gas of the transaction", alias="gasTipCap")
    gas: StrictInt = Field(description="Gas limit of the transaction")
    var_from: Annotated[str, Field(strict=True)] = Field(description="An ethereum address.", alias="from")
    to: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="An ethereum address.")
    value: StrictStr = Field(description="Amount (in wei) to send with the transaction.")
    data: Annotated[str, Field(strict=True)] = Field(description="A hex string.")
    hash: Optional[Annotated[str, Field(min_length=66, strict=True, max_length=66)]] = Field(default=None, description="The keccak256 hash as a hex string of 256 bits.")
    type: StrictInt = Field(description="Transaction type")
    __properties: ClassVar[List[str]] = ["nonce", "gasPrice", "gasFeeCap", "gasTipCap", "gas", "from", "to", "value", "data", "hash", "type"]

    @field_validator('var_from')
    def var_from_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^0[xX][a-fA-F0-9]{40}$", value):
            raise ValueError(r"must validate the regular expression /^0[xX][a-fA-F0-9]{40}$/")
        return value

    @field_validator('to')
    def to_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^0[xX][a-fA-F0-9]{40}$", value):
            raise ValueError(r"must validate the regular expression /^0[xX][a-fA-F0-9]{40}$/")
        return value

    @field_validator('data')
    def data_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^(0x[0-9a-f]*|0X[0-9A-F]*)$", value):
            raise ValueError(r"must validate the regular expression /^(0x[0-9a-f]*|0X[0-9A-F]*)$/")
        return value

    @field_validator('hash')
    def hash_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^(0x[0-9a-f]{64}|0X[0-9A-F]{64})$", value):
            raise ValueError(r"must validate the regular expression /^(0x[0-9a-f]{64}|0X[0-9A-F]{64})$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TransactionToSignTx from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if to (nullable) is None
        # and model_fields_set contains the field
        if self.to is None and "to" in self.model_fields_set:
            _dict['to'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TransactionToSignTx from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "nonce": obj.get("nonce"),
            "gasPrice": obj.get("gasPrice"),
            "gasFeeCap": obj.get("gasFeeCap"),
            "gasTipCap": obj.get("gasTipCap"),
            "gas": obj.get("gas"),
            "from": obj.get("from"),
            "to": obj.get("to"),
            "value": obj.get("value"),
            "data": obj.get("data"),
            "hash": obj.get("hash"),
            "type": obj.get("type")
        })
        return _obj


