# coding: utf-8

"""
    MultiBaas API

    MultiBaas's REST APIv0.

    The version of the OpenAPI document: 0.0
    Contact: contact@curvegrid.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from multibaas_sdk.models.transaction import Transaction
from multibaas_sdk.models.transaction_status import TransactionStatus
from typing import Optional, Set
from typing_extensions import Self

class WalletTransaction(BaseModel):
    """
    WalletTransaction
    """ # noqa: E501
    tx: Transaction
    status: TransactionStatus
    var_from: Annotated[str, Field(strict=True)] = Field(description="An ethereum address.", alias="from")
    resubmission_attempts: StrictInt = Field(description="The total number of resubmission attempts.", alias="resubmissionAttempts")
    successful_resubmissions: StrictInt = Field(description="The total number of successful resubmission (added into the transaction pool).", alias="successfulResubmissions")
    created_at: datetime = Field(description="The time the transaction was created.", alias="createdAt")
    updated_at: datetime = Field(description="The time the transaction was last updated.", alias="updatedAt")
    failed: Optional[StrictBool] = Field(default=None, description="Whether the transaction failed when it was included in a block.")
    block_number: Optional[StrictInt] = Field(default=None, description="The block number that the transaction was included in.", alias="blockNumber")
    block_hash: Optional[Annotated[str, Field(min_length=66, strict=True, max_length=66)]] = Field(default=None, description="The keccak256 hash as a hex string of 256 bits.", alias="blockHash")
    __properties: ClassVar[List[str]] = ["tx", "status", "from", "resubmissionAttempts", "successfulResubmissions", "createdAt", "updatedAt", "failed", "blockNumber", "blockHash"]

    @field_validator('var_from')
    def var_from_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^0[xX][a-fA-F0-9]{40}$", value):
            raise ValueError(r"must validate the regular expression /^0[xX][a-fA-F0-9]{40}$/")
        return value

    @field_validator('block_hash')
    def block_hash_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^(0x[0-9a-f]{64}|0X[0-9A-F]{64})$", value):
            raise ValueError(r"must validate the regular expression /^(0x[0-9a-f]{64}|0X[0-9A-F]{64})$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WalletTransaction from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of tx
        if self.tx:
            _dict['tx'] = self.tx.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WalletTransaction from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "tx": Transaction.from_dict(obj["tx"]) if obj.get("tx") is not None else None,
            "status": obj.get("status"),
            "from": obj.get("from"),
            "resubmissionAttempts": obj.get("resubmissionAttempts"),
            "successfulResubmissions": obj.get("successfulResubmissions"),
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt"),
            "failed": obj.get("failed"),
            "blockNumber": obj.get("blockNumber"),
            "blockHash": obj.get("blockHash")
        })
        return _obj


