# coding: utf-8

"""
    MultiBaas API

    MultiBaas's REST APIv0.

    The version of the OpenAPI document: 0.0
    Contact: contact@curvegrid.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from setuptools import setup, find_packages  # noqa: H301

# To install the library, run the following
#
# python setup.py install
#
# prerequisite: setuptools
# http://pypi.python.org/pypi/setuptools
NAME = "multibaas-sdk"
VERSION = "1.0.0"
PYTHON_REQUIRES = ">= 3.9"
REQUIRES = [
    "urllib3 >= 2.1.0, < 3.0.0",
    "python-dateutil >= 2.8.2",
    "pydantic >= 2",
    "typing-extensions >= 4.7.1",
]

setup(
    name=NAME,
    version=VERSION,
    description="Python SDK for MultiBaas",
    author="Curvegrid",
    author_email="contact@curvegrid.com",
    url="https://github.com/curvegrid/multibaas-sdk-python",
    keywords = ["multibaas", "blockchain", "ethereum", "curvegrid"],
    install_requires=REQUIRES,
    packages=find_packages(exclude=["test", "tests"]),
    include_package_data=True,
    license="MIT",
    long_description_content_type='text/markdown',
    long_description="""# multibaas-sdk
MultiBaas's REST APIv0.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.0
- Package version: 1.0.0
- Generator version: 7.14.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.9+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/curvegrid/multibaas-sdk-python.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/curvegrid/multibaas-sdk-python.git`)

Then import the package:
```python
import multibaas_sdk
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import multibaas_sdk
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import multibaas_sdk
from multibaas_sdk.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://your_deployment.multibaas.com/api/v0
# See configuration.py for a list of all supported configuration parameters.
configuration = multibaas_sdk.Configuration(
    host = "https://your_deployment.multibaas.com/api/v0"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: cookie
configuration.api_key['cookie'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['cookie'] = 'Bearer'

# Configure Bearer authorization (JWT): bearer
configuration = multibaas_sdk.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)


# Enter a context with an instance of the API client
with multibaas_sdk.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = multibaas_sdk.AddressesApi(api_client)
    chain = multibaas_sdk.ChainName() # ChainName | The blockchain chain label.
    address_or_alias = 'address_or_alias_example' # str | An address or the alias of an address.

    try:
        # Delete address
        api_response = api_instance.delete_address(chain, address_or_alias)
        print("The response of AddressesApi->delete_address:
")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AddressesApi->delete_address: %s
" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://your_deployment.multibaas.com/api/v0*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AddressesApi* | [**delete_address**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/AddressesApi.md#delete_address) | **DELETE** /chains/{chain}/addresses/{address-or-alias} | Delete address
*AddressesApi* | [**get_address**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/AddressesApi.md#get_address) | **GET** /chains/{chain}/addresses/{address-or-alias} | Get address
*AddressesApi* | [**list_addresses**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/AddressesApi.md#list_addresses) | **GET** /chains/{chain}/addresses | List addresses
*AddressesApi* | [**set_address**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/AddressesApi.md#set_address) | **POST** /chains/{chain}/addresses | Create or update address
*AdminApi* | [**accept_invite**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/AdminApi.md#accept_invite) | **POST** /invites/{inviteID} | Accept invite
*AdminApi* | [**add_cors_origin**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/AdminApi.md#add_cors_origin) | **POST** /cors | Add CORS origin
*AdminApi* | [**add_group_api_key**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/AdminApi.md#add_group_api_key) | **PUT** /groups/{groupID}/api_keys/{apiKeyID} | Add API key to group
*AdminApi* | [**add_group_role**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/AdminApi.md#add_group_role) | **PUT** /groups/{groupID}/roles/{roleShortName} | Add role to group
*AdminApi* | [**add_group_user**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/AdminApi.md#add_group_user) | **PUT** /groups/{groupID}/users/{userID} | Add user to group
*AdminApi* | [**check_invite**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/AdminApi.md#check_invite) | **GET** /invites/{inviteID} | Check invite
*AdminApi* | [**create_api_key**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/AdminApi.md#create_api_key) | **POST** /api_keys | Create API key
*AdminApi* | [**delete_api_key**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/AdminApi.md#delete_api_key) | **DELETE** /api_keys/{apiKeyID} | Delete API key
*AdminApi* | [**delete_invite**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/AdminApi.md#delete_invite) | **DELETE** /invites/{email}/delete | Delete invite
*AdminApi* | [**delete_user**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/AdminApi.md#delete_user) | **DELETE** /users/{userID} | Delete user
*AdminApi* | [**get_api_key**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/AdminApi.md#get_api_key) | **GET** /api_keys/{apiKeyID} | Get API Key
*AdminApi* | [**get_plan**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/AdminApi.md#get_plan) | **GET** /plan | Get plan
*AdminApi* | [**invite_user**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/AdminApi.md#invite_user) | **POST** /invites | Invite user
*AdminApi* | [**list_api_keys**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/AdminApi.md#list_api_keys) | **GET** /api_keys | List API keys
*AdminApi* | [**list_audit_logs**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/AdminApi.md#list_audit_logs) | **GET** /systemactivities | List audit logs
*AdminApi* | [**list_cors_origins**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/AdminApi.md#list_cors_origins) | **GET** /cors | List CORS origins
*AdminApi* | [**list_groups**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/AdminApi.md#list_groups) | **GET** /groups | List groups
*AdminApi* | [**list_invites**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/AdminApi.md#list_invites) | **GET** /invites | List invites
*AdminApi* | [**list_user_signers**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/AdminApi.md#list_user_signers) | **GET** /users/{userID}/signers | List user signers
*AdminApi* | [**list_users**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/AdminApi.md#list_users) | **GET** /users | List users
*AdminApi* | [**remove_cors_origin**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/AdminApi.md#remove_cors_origin) | **DELETE** /cors/{originID} | Remove CORS Origin
*AdminApi* | [**remove_group_api_key**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/AdminApi.md#remove_group_api_key) | **DELETE** /groups/{groupID}/api_keys/{apiKeyID} | Remove API key from group
*AdminApi* | [**remove_group_role**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/AdminApi.md#remove_group_role) | **DELETE** /groups/{groupID}/roles/{roleShortName} | Remove role from group
*AdminApi* | [**remove_group_user**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/AdminApi.md#remove_group_user) | **DELETE** /groups/{groupID}/users/{userID} | Remove user from group
*AdminApi* | [**remove_user_signer_cloud_wallet**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/AdminApi.md#remove_user_signer_cloud_wallet) | **DELETE** /users/{userID}/cloudwallets/{wallet_address} | Remove user cloud wallet signer
*AdminApi* | [**remove_user_signer_safe_account**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/AdminApi.md#remove_user_signer_safe_account) | **DELETE** /users/{userID}/safeaccounts/{wallet_address} | Remove user safe account signer
*AdminApi* | [**remove_user_signer_web3_wallet**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/AdminApi.md#remove_user_signer_web3_wallet) | **DELETE** /users/{userID}/web3wallets/{wallet_address} | Remove user web3 wallet signer
*AdminApi* | [**set_user_signer_cloud_wallet**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/AdminApi.md#set_user_signer_cloud_wallet) | **PUT** /users/{userID}/cloudwallets/{wallet_address} | Add or update user cloud wallet signer
*AdminApi* | [**set_user_signer_safe_account**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/AdminApi.md#set_user_signer_safe_account) | **PUT** /users/{userID}/safeaccounts/{wallet_address} | Add or update user safe account signer
*AdminApi* | [**set_user_signer_web3_wallet**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/AdminApi.md#set_user_signer_web3_wallet) | **PUT** /users/{userID}/web3wallets/{wallet_address} | Add or update user web3 wallet signer
*AdminApi* | [**update_api_key**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/AdminApi.md#update_api_key) | **PUT** /api_keys/{apiKeyID} | Update API key
*ChainsApi* | [**get_block**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ChainsApi.md#get_block) | **GET** /chains/{chain}/blocks/{block} | Get a block
*ChainsApi* | [**get_chain_status**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ChainsApi.md#get_chain_status) | **GET** /chains/{chain}/status | Get chain status
*ChainsApi* | [**get_transaction**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ChainsApi.md#get_transaction) | **GET** /chains/{chain}/transactions/{hash} | Get transaction
*ChainsApi* | [**get_transaction_receipt**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ChainsApi.md#get_transaction_receipt) | **GET** /chains/{chain}/transactions/receipt/{hash} | Get transaction receipt
*ChainsApi* | [**submit_signed_transaction**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ChainsApi.md#submit_signed_transaction) | **POST** /chains/{chain}/transactions/submit | Submit signed transaction
*ChainsApi* | [**transfer_eth**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ChainsApi.md#transfer_eth) | **POST** /chains/{chain}/transfers | Transfer ETH
*ContractsApi* | [**call_contract_function**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ContractsApi.md#call_contract_function) | **POST** /chains/{chain}/addresses/{address-or-alias}/contracts/{contract}/methods/{method} | Call a contract function
*ContractsApi* | [**create_contract**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ContractsApi.md#create_contract) | **POST** /contracts/{contract} | Create a contract
*ContractsApi* | [**create_contracts**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ContractsApi.md#create_contracts) | **POST** /contracts | Create multiple contracts
*ContractsApi* | [**delete_contract**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ContractsApi.md#delete_contract) | **DELETE** /contracts/{contract} | Delete a contract
*ContractsApi* | [**delete_contract_version**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ContractsApi.md#delete_contract_version) | **DELETE** /contracts/{contract}/{version} | Delete a contract version
*ContractsApi* | [**deploy_contract**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ContractsApi.md#deploy_contract) | **POST** /contracts/{contract}/deploy | Deploy a contract
*ContractsApi* | [**deploy_contract_version**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ContractsApi.md#deploy_contract_version) | **POST** /contracts/{contract}/{version}/deploy | Deploy a contract version
*ContractsApi* | [**get_contract**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ContractsApi.md#get_contract) | **GET** /contracts/{contract} | Get a contract
*ContractsApi* | [**get_contract_version**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ContractsApi.md#get_contract_version) | **GET** /contracts/{contract}/{version} | Get a contract version
*ContractsApi* | [**get_contract_versions**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ContractsApi.md#get_contract_versions) | **GET** /contracts/{contract}/all | Get all contract versions
*ContractsApi* | [**get_event_monitor_status**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ContractsApi.md#get_event_monitor_status) | **GET** /chains/{chain}/addresses/{address-or-alias}/contracts/{contract}/status | Get event monitor status
*ContractsApi* | [**get_event_type_conversions**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ContractsApi.md#get_event_type_conversions) | **GET** /contracts/{contract}/{version}/events/{event} | Get event type conversions
*ContractsApi* | [**get_function_type_conversions**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ContractsApi.md#get_function_type_conversions) | **GET** /contracts/{contract}/{version}/methods/{method} | Get function type conversions
*ContractsApi* | [**link_address_contract**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ContractsApi.md#link_address_contract) | **POST** /chains/{chain}/addresses/{address-or-alias}/contracts | Link address and contract
*ContractsApi* | [**list_contract_versions**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ContractsApi.md#list_contract_versions) | **GET** /contracts/{contract}/versions | List all contract versions
*ContractsApi* | [**list_contracts**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ContractsApi.md#list_contracts) | **GET** /contracts | List contracts
*ContractsApi* | [**set_event_type_conversions**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ContractsApi.md#set_event_type_conversions) | **POST** /contracts/{contract}/{version}/events/{event} | Set event type conversions
*ContractsApi* | [**set_function_type_conversions**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ContractsApi.md#set_function_type_conversions) | **POST** /contracts/{contract}/{version}/methods/{method} | Set function type conversions
*ContractsApi* | [**unlink_address_contract**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ContractsApi.md#unlink_address_contract) | **DELETE** /chains/{chain}/addresses/{address-or-alias}/contracts/{contract} | Unlink address and contract
*EventQueriesApi* | [**count_event_query_records**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/EventQueriesApi.md#count_event_query_records) | **GET** /queries/{event_query}/count | Count event query records
*EventQueriesApi* | [**delete_event_query**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/EventQueriesApi.md#delete_event_query) | **DELETE** /queries/{event_query} | Delete event query
*EventQueriesApi* | [**execute_arbitrary_event_query**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/EventQueriesApi.md#execute_arbitrary_event_query) | **POST** /queries | Execute arbitrary event query
*EventQueriesApi* | [**execute_event_query**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/EventQueriesApi.md#execute_event_query) | **GET** /queries/{event_query}/results | Execute event query
*EventQueriesApi* | [**get_event_query**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/EventQueriesApi.md#get_event_query) | **GET** /queries/{event_query} | Get event query
*EventQueriesApi* | [**list_event_queries**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/EventQueriesApi.md#list_event_queries) | **GET** /queries | List event queries
*EventQueriesApi* | [**set_event_query**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/EventQueriesApi.md#set_event_query) | **PUT** /queries/{event_query} | Create or update event query
*EventsApi* | [**get_event_count**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/EventsApi.md#get_event_count) | **GET** /events/count | Get event count
*EventsApi* | [**list_events**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/EventsApi.md#list_events) | **GET** /events | List events
*HsmApi* | [**add_hsm_config**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/HsmApi.md#add_hsm_config) | **POST** /hsm/config | Add HSM config
*HsmApi* | [**add_hsm_key**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/HsmApi.md#add_hsm_key) | **POST** /hsm/key | Add HSM key
*HsmApi* | [**create_hsm_key**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/HsmApi.md#create_hsm_key) | **POST** /hsm/key/new | Create HSM key
*HsmApi* | [**list_hsm**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/HsmApi.md#list_hsm) | **GET** /hsm | List HSM configs and wallets
*HsmApi* | [**list_hsm_wallets**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/HsmApi.md#list_hsm_wallets) | **GET** /hsm/wallets | List HSM wallets
*HsmApi* | [**remove_hsm_config**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/HsmApi.md#remove_hsm_config) | **DELETE** /hsm/config/{client_id} | Remove HSM config
*HsmApi* | [**remove_hsm_key**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/HsmApi.md#remove_hsm_key) | **DELETE** /hsm/key/{wallet_address} | Remove HSM key
*HsmApi* | [**set_local_nonce**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/HsmApi.md#set_local_nonce) | **POST** /chains/{chain}/hsm/nonce/{wallet_address} | Set local nonce
*HsmApi* | [**sign_and_submit_transaction**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/HsmApi.md#sign_and_submit_transaction) | **POST** /chains/{chain}/hsm/submit | Sign and submit transaction
*HsmApi* | [**sign_data**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/HsmApi.md#sign_data) | **POST** /chains/{chain}/hsm/sign | Sign data
*TxmApi* | [**cancel_transaction**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/TxmApi.md#cancel_transaction) | **POST** /chains/{chain}/txm/{wallet_address}/nonce/{nonce}/cancel | Cancel transaction
*TxmApi* | [**count_wallet_transactions**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/TxmApi.md#count_wallet_transactions) | **GET** /chains/{chain}/txm/{wallet_address}/count | Count all transactions for a wallet
*TxmApi* | [**list_wallet_transactions**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/TxmApi.md#list_wallet_transactions) | **GET** /chains/{chain}/txm/{wallet_address} | List transactions for a wallet
*TxmApi* | [**speed_up_transaction**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/TxmApi.md#speed_up_transaction) | **POST** /chains/{chain}/txm/{wallet_address}/nonce/{nonce}/speed_up | Speed up transaction
*WebhooksApi* | [**count_webhook_events**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/WebhooksApi.md#count_webhook_events) | **GET** /webhooks/{webhookID}/events/count | Count webhook events
*WebhooksApi* | [**count_webhooks**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/WebhooksApi.md#count_webhooks) | **GET** /webhooks/count | Count webhooks
*WebhooksApi* | [**create_webhook**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/WebhooksApi.md#create_webhook) | **POST** /webhooks | Create webhook
*WebhooksApi* | [**delete_webhook**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/WebhooksApi.md#delete_webhook) | **DELETE** /webhooks/{webhookID} | Delete webhook
*WebhooksApi* | [**get_webhook**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/WebhooksApi.md#get_webhook) | **GET** /webhooks/{webhookID} | Get webhook
*WebhooksApi* | [**list_webhook_events**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/WebhooksApi.md#list_webhook_events) | **GET** /webhooks/{webhookID}/events | List webhook events
*WebhooksApi* | [**list_webhooks**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/WebhooksApi.md#list_webhooks) | **GET** /webhooks | List webhooks
*WebhooksApi* | [**update_webhook**](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/WebhooksApi.md#update_webhook) | **PUT** /webhooks/{webhookID} | Update webhook


## Documentation For Models

 - [APIKey](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/APIKey.md)
 - [APIKeyWithSecret](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/APIKeyWithSecret.md)
 - [AcceptInvite200Response](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/AcceptInvite200Response.md)
 - [AcceptInviteRequest](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/AcceptInviteRequest.md)
 - [AccessTuple](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/AccessTuple.md)
 - [AddKey](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/AddKey.md)
 - [Address](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/Address.md)
 - [AddressAlias](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/AddressAlias.md)
 - [AuditLog](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/AuditLog.md)
 - [AzureAccount](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/AzureAccount.md)
 - [AzureHardwareWallet](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/AzureHardwareWallet.md)
 - [AzureWallet](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/AzureWallet.md)
 - [BaseAPIKey](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/BaseAPIKey.md)
 - [BaseAzureAccount](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/BaseAzureAccount.md)
 - [BaseContract](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/BaseContract.md)
 - [BaseResponse](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/BaseResponse.md)
 - [BaseUser](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/BaseUser.md)
 - [BaseWebhookEndpoint](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/BaseWebhookEndpoint.md)
 - [Block](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/Block.md)
 - [CORSOrigin](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/CORSOrigin.md)
 - [CallContractFunction200Response](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/CallContractFunction200Response.md)
 - [CallContractFunction200ResponseAllOfResult](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/CallContractFunction200ResponseAllOfResult.md)
 - [ChainName](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ChainName.md)
 - [ChainStatus](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ChainStatus.md)
 - [CloudWalletTXToSign](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/CloudWalletTXToSign.md)
 - [CloudWalletTXToSignTx](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/CloudWalletTXToSignTx.md)
 - [Contract](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/Contract.md)
 - [ContractABI](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ContractABI.md)
 - [ContractABIError](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ContractABIError.md)
 - [ContractABIErrorArgument](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ContractABIErrorArgument.md)
 - [ContractABIEvent](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ContractABIEvent.md)
 - [ContractABIEventArgument](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ContractABIEventArgument.md)
 - [ContractABIMethod](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ContractABIMethod.md)
 - [ContractABIMethod1](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ContractABIMethod1.md)
 - [ContractABIMethodArgument](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ContractABIMethodArgument.md)
 - [ContractABIType](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ContractABIType.md)
 - [ContractABITypeConversion](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ContractABITypeConversion.md)
 - [ContractEventOptions](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ContractEventOptions.md)
 - [ContractInformation](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ContractInformation.md)
 - [ContractInstance](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ContractInstance.md)
 - [ContractLookup](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ContractLookup.md)
 - [ContractMetadata](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ContractMetadata.md)
 - [ContractMethodInformation](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ContractMethodInformation.md)
 - [ContractMethodOptions](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ContractMethodOptions.md)
 - [ContractOverview](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ContractOverview.md)
 - [ContractParameter](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ContractParameter.md)
 - [CountEventQueryRecords200Response](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/CountEventQueryRecords200Response.md)
 - [CountWalletTransactions200Response](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/CountWalletTransactions200Response.md)
 - [CountWebhookEvents200Response](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/CountWebhookEvents200Response.md)
 - [CountWebhooks200Response](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/CountWebhooks200Response.md)
 - [CreateApiKey200Response](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/CreateApiKey200Response.md)
 - [CreateApiKeyRequest](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/CreateApiKeyRequest.md)
 - [CreateHsmKey200Response](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/CreateHsmKey200Response.md)
 - [CreateKey](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/CreateKey.md)
 - [CreateWebhook200Response](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/CreateWebhook200Response.md)
 - [DeployContract200Response](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/DeployContract200Response.md)
 - [DeployContractTransaction](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/DeployContractTransaction.md)
 - [EIP712Domain](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/EIP712Domain.md)
 - [EIP712DomainChainId](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/EIP712DomainChainId.md)
 - [EIP712TypeEntry](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/EIP712TypeEntry.md)
 - [EIP712TypedData](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/EIP712TypedData.md)
 - [EIP712Types](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/EIP712Types.md)
 - [Error](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/Error.md)
 - [Event](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/Event.md)
 - [EventField](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/EventField.md)
 - [EventInformation](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/EventInformation.md)
 - [EventMonitorStatus](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/EventMonitorStatus.md)
 - [EventQuery](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/EventQuery.md)
 - [EventQueryEvent](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/EventQueryEvent.md)
 - [EventQueryField](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/EventQueryField.md)
 - [EventQueryFilter](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/EventQueryFilter.md)
 - [EventQueryResults](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/EventQueryResults.md)
 - [EventTypeConversionOptions](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/EventTypeConversionOptions.md)
 - [ExecuteArbitraryEventQuery200Response](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ExecuteArbitraryEventQuery200Response.md)
 - [FieldType](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/FieldType.md)
 - [GasParams](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/GasParams.md)
 - [GetApiKey200Response](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/GetApiKey200Response.md)
 - [GetBlock200Response](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/GetBlock200Response.md)
 - [GetChainStatus200Response](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/GetChainStatus200Response.md)
 - [GetContract200Response](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/GetContract200Response.md)
 - [GetContractVersions200Response](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/GetContractVersions200Response.md)
 - [GetEventCount200Response](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/GetEventCount200Response.md)
 - [GetEventMonitorStatus200Response](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/GetEventMonitorStatus200Response.md)
 - [GetEventQuery200Response](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/GetEventQuery200Response.md)
 - [GetEventTypeConversions200Response](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/GetEventTypeConversions200Response.md)
 - [GetFunctionTypeConversions200Response](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/GetFunctionTypeConversions200Response.md)
 - [GetPlan200Response](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/GetPlan200Response.md)
 - [GetTransaction200Response](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/GetTransaction200Response.md)
 - [GetTransactionReceipt200Response](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/GetTransactionReceipt200Response.md)
 - [Group](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/Group.md)
 - [HSMData](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/HSMData.md)
 - [HSMSignRequest](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/HSMSignRequest.md)
 - [HSMSignRequestPersonalSign](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/HSMSignRequestPersonalSign.md)
 - [HSMSignRequestPersonalSignChainId](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/HSMSignRequestPersonalSignChainId.md)
 - [HSMSignRequestTypedData](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/HSMSignRequestTypedData.md)
 - [HSMSignResponse](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/HSMSignResponse.md)
 - [Invite](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/Invite.md)
 - [InviteRequest](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/InviteRequest.md)
 - [LinkAddressContractRequest](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/LinkAddressContractRequest.md)
 - [ListAddresses200Response](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ListAddresses200Response.md)
 - [ListApiKeys200Response](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ListApiKeys200Response.md)
 - [ListAuditLogs200Response](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ListAuditLogs200Response.md)
 - [ListContractVersions200Response](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ListContractVersions200Response.md)
 - [ListContractVersions200ResponseAllOfResult](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ListContractVersions200ResponseAllOfResult.md)
 - [ListContracts200Response](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ListContracts200Response.md)
 - [ListCorsOrigins200Response](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ListCorsOrigins200Response.md)
 - [ListEventQueries200Response](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ListEventQueries200Response.md)
 - [ListEvents200Response](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ListEvents200Response.md)
 - [ListGroups200Response](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ListGroups200Response.md)
 - [ListHsm200Response](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ListHsm200Response.md)
 - [ListHsmWallets200Response](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ListHsmWallets200Response.md)
 - [ListInvites200Response](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ListInvites200Response.md)
 - [ListUserSigners200Response](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ListUserSigners200Response.md)
 - [ListUsers200Response](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ListUsers200Response.md)
 - [ListWalletTransactions200Response](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ListWalletTransactions200Response.md)
 - [ListWebhookEvents200Response](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ListWebhookEvents200Response.md)
 - [ListWebhooks200Response](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/ListWebhooks200Response.md)
 - [Log](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/Log.md)
 - [MethodArg](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/MethodArg.md)
 - [MethodCallPreviewResponse](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/MethodCallPreviewResponse.md)
 - [MethodCallResponse](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/MethodCallResponse.md)
 - [MethodTypeConversionOptions](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/MethodTypeConversionOptions.md)
 - [Plan](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/Plan.md)
 - [PlanFeature](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/PlanFeature.md)
 - [PlanLimit](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/PlanLimit.md)
 - [PostMethodArgs](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/PostMethodArgs.md)
 - [PostMethodResponse](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/PostMethodResponse.md)
 - [PreviewArgs](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/PreviewArgs.md)
 - [Role](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/Role.md)
 - [SavedEventQuery](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/SavedEventQuery.md)
 - [SetAddress201Response](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/SetAddress201Response.md)
 - [SetCodeAuthorization](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/SetCodeAuthorization.md)
 - [SetNonceRequest](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/SetNonceRequest.md)
 - [SignData200Response](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/SignData200Response.md)
 - [SignedTransactionResponse](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/SignedTransactionResponse.md)
 - [SignedTransactionSubmission](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/SignedTransactionSubmission.md)
 - [SignerLabel](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/SignerLabel.md)
 - [SignerWallet](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/SignerWallet.md)
 - [StandaloneWallet](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/StandaloneWallet.md)
 - [SubmitSignedTransaction200Response](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/SubmitSignedTransaction200Response.md)
 - [Transaction](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/Transaction.md)
 - [TransactionData](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/TransactionData.md)
 - [TransactionInformation](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/TransactionInformation.md)
 - [TransactionReceipt](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/TransactionReceipt.md)
 - [TransactionReceiptData](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/TransactionReceiptData.md)
 - [TransactionStatus](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/TransactionStatus.md)
 - [TransactionToSign](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/TransactionToSign.md)
 - [TransactionToSignResponse](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/TransactionToSignResponse.md)
 - [TransactionToSignTx](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/TransactionToSignTx.md)
 - [TransferEth200Response](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/TransferEth200Response.md)
 - [TypeConversionOptions](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/TypeConversionOptions.md)
 - [User](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/User.md)
 - [WalletTransaction](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/WalletTransaction.md)
 - [WebhookEndpoint](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/WebhookEndpoint.md)
 - [WebhookEvent](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/WebhookEvent.md)
 - [WebhookEventsType](https://github.com/curvegrid/multibaas-sdk-python/blob/v1.0.0/docs/WebhookEventsType.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="bearer"></a>
### bearer

- **Type**: Bearer authentication (JWT)

<a id="cookie"></a>
### cookie

- **Type**: API key
- **API key parameter name**: token
- **Location**: 


## Author

contact@curvegrid.com


""",  # noqa: E501
    package_data={"multibaas_sdk": ["py.typed"]},
)