"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StepFunctionsRestApi = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const sfn = require("@aws-cdk/aws-stepfunctions");
const _1 = require(".");
const stepfunctions_1 = require("./integrations/stepfunctions");
const model_1 = require("./model");
/**
 * Defines an API Gateway REST API with a Synchrounous Express State Machine as a proxy integration.
 */
class StepFunctionsRestApi extends _1.RestApi {
    constructor(scope, id, props) {
        var _b, _c;
        jsiiDeprecationWarnings._aws_cdk_aws_apigateway_StepFunctionsRestApiProps(props);
        if (props.defaultIntegration) {
            throw new Error('Cannot specify "defaultIntegration" since Step Functions integration is automatically defined');
        }
        if (props.stateMachine.node.defaultChild.stateMachineType !== sfn.StateMachineType.EXPRESS) {
            throw new Error('State Machine must be of type "EXPRESS". Please use StateMachineType.EXPRESS as the stateMachineType');
        }
        const stepfunctionsIntegration = stepfunctions_1.StepFunctionsIntegration.startExecution(props.stateMachine, {
            credentialsRole: role(scope, props),
            requestContext: props.requestContext,
            path: (_b = props.path) !== null && _b !== void 0 ? _b : true,
            querystring: (_c = props.querystring) !== null && _c !== void 0 ? _c : true,
            headers: props.headers,
            authorizer: props.authorizer,
        });
        super(scope, id, props);
        this.root.addMethod('ANY', stepfunctionsIntegration, {
            methodResponses: methodResponse(),
        });
    }
}
exports.StepFunctionsRestApi = StepFunctionsRestApi;
_a = JSII_RTTI_SYMBOL_1;
StepFunctionsRestApi[_a] = { fqn: "@aws-cdk/aws-apigateway.StepFunctionsRestApi", version: "1.148.0" };
/**
 * Defines the IAM Role for API Gateway with required permissions
 * to invoke a synchronous execution for the provided state machine
 *
 * @param scope
 * @param props
 * @returns Role - IAM Role
 */
function role(scope, props) {
    const roleName = 'StartSyncExecutionRole';
    const apiRole = new iam.Role(scope, roleName, {
        assumedBy: new iam.ServicePrincipal('apigateway.amazonaws.com'),
    });
    props.stateMachine.grantStartSyncExecution(apiRole);
    return apiRole;
}
/**
 * Defines the method response modelfor each HTTP code response
 * @returns methodResponse
 */
function methodResponse() {
    return [
        {
            statusCode: '200',
            responseModels: {
                'application/json': model_1.Model.EMPTY_MODEL,
            },
        },
        {
            statusCode: '400',
            responseModels: {
                'application/json': model_1.Model.ERROR_MODEL,
            },
        },
        {
            statusCode: '500',
            responseModels: {
                'application/json': model_1.Model.ERROR_MODEL,
            },
        },
    ];
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RlcGZ1bmN0aW9ucy1hcGkuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJzdGVwZnVuY3Rpb25zLWFwaS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFBQSx3Q0FBd0M7QUFDeEMsa0RBQWtEO0FBRWxELHdCQUEwQztBQUUxQyxnRUFBd0U7QUFDeEUsbUNBQWdDO0FBdUZoQzs7R0FFRztBQUNILE1BQWEsb0JBQXFCLFNBQVEsVUFBTztJQUMvQyxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQWdDOzs7UUFDeEUsSUFBSSxLQUFLLENBQUMsa0JBQWtCLEVBQUU7WUFDNUIsTUFBTSxJQUFJLEtBQUssQ0FBQywrRkFBK0YsQ0FBQyxDQUFDO1NBQ2xIO1FBRUQsSUFBSyxLQUFLLENBQUMsWUFBWSxDQUFDLElBQUksQ0FBQyxZQUFvQyxDQUFDLGdCQUFnQixLQUFLLEdBQUcsQ0FBQyxnQkFBZ0IsQ0FBQyxPQUFPLEVBQUU7WUFDbkgsTUFBTSxJQUFJLEtBQUssQ0FBQyxzR0FBc0csQ0FBQyxDQUFDO1NBQ3pIO1FBRUQsTUFBTSx3QkFBd0IsR0FBRyx3Q0FBd0IsQ0FBQyxjQUFjLENBQUMsS0FBSyxDQUFDLFlBQVksRUFBRTtZQUMzRixlQUFlLEVBQUUsSUFBSSxDQUFDLEtBQUssRUFBRSxLQUFLLENBQUM7WUFDbkMsY0FBYyxFQUFFLEtBQUssQ0FBQyxjQUFjO1lBQ3BDLElBQUksUUFBRSxLQUFLLENBQUMsSUFBSSxtQ0FBRyxJQUFJO1lBQ3ZCLFdBQVcsUUFBRSxLQUFLLENBQUMsV0FBVyxtQ0FBRyxJQUFJO1lBQ3JDLE9BQU8sRUFBRSxLQUFLLENBQUMsT0FBTztZQUN0QixVQUFVLEVBQUUsS0FBSyxDQUFDLFVBQVU7U0FDN0IsQ0FBQyxDQUFDO1FBRUgsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFFeEIsSUFBSSxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsS0FBSyxFQUFFLHdCQUF3QixFQUFFO1lBQ25ELGVBQWUsRUFBRSxjQUFjLEVBQUU7U0FDbEMsQ0FBQyxDQUFDO0tBQ0o7O0FBeEJILG9EQXlCQzs7O0FBRUQ7Ozs7Ozs7R0FPRztBQUNILFNBQVMsSUFBSSxDQUFDLEtBQWdCLEVBQUUsS0FBZ0M7SUFDOUQsTUFBTSxRQUFRLEdBQVcsd0JBQXdCLENBQUM7SUFDbEQsTUFBTSxPQUFPLEdBQUcsSUFBSSxHQUFHLENBQUMsSUFBSSxDQUFDLEtBQUssRUFBRSxRQUFRLEVBQUU7UUFDNUMsU0FBUyxFQUFFLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLDBCQUEwQixDQUFDO0tBQ2hFLENBQUMsQ0FBQztJQUVILEtBQUssQ0FBQyxZQUFZLENBQUMsdUJBQXVCLENBQUMsT0FBTyxDQUFDLENBQUM7SUFFcEQsT0FBTyxPQUFPLENBQUM7QUFDakIsQ0FBQztBQUVEOzs7R0FHRztBQUNILFNBQVMsY0FBYztJQUNyQixPQUFPO1FBQ0w7WUFDRSxVQUFVLEVBQUUsS0FBSztZQUNqQixjQUFjLEVBQUU7Z0JBQ2Qsa0JBQWtCLEVBQUUsYUFBSyxDQUFDLFdBQVc7YUFDdEM7U0FDRjtRQUNEO1lBQ0UsVUFBVSxFQUFFLEtBQUs7WUFDakIsY0FBYyxFQUFFO2dCQUNkLGtCQUFrQixFQUFFLGFBQUssQ0FBQyxXQUFXO2FBQ3RDO1NBQ0Y7UUFDRDtZQUNFLFVBQVUsRUFBRSxLQUFLO1lBQ2pCLGNBQWMsRUFBRTtnQkFDZCxrQkFBa0IsRUFBRSxhQUFLLENBQUMsV0FBVzthQUN0QztTQUNGO0tBQ0YsQ0FBQztBQUNKLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBpYW0gZnJvbSAnQGF3cy1jZGsvYXdzLWlhbSc7XG5pbXBvcnQgKiBhcyBzZm4gZnJvbSAnQGF3cy1jZGsvYXdzLXN0ZXBmdW5jdGlvbnMnO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBSZXN0QXBpLCBSZXN0QXBpUHJvcHMgfSBmcm9tICcuJztcbmltcG9ydCB7IFJlcXVlc3RDb250ZXh0IH0gZnJvbSAnLi9pbnRlZ3JhdGlvbnMnO1xuaW1wb3J0IHsgU3RlcEZ1bmN0aW9uc0ludGVncmF0aW9uIH0gZnJvbSAnLi9pbnRlZ3JhdGlvbnMvc3RlcGZ1bmN0aW9ucyc7XG5pbXBvcnQgeyBNb2RlbCB9IGZyb20gJy4vbW9kZWwnO1xuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIFN0ZXBGdW5jdGlvbnNSZXN0QXBpXG4gKlxuICovXG5leHBvcnQgaW50ZXJmYWNlIFN0ZXBGdW5jdGlvbnNSZXN0QXBpUHJvcHMgZXh0ZW5kcyBSZXN0QXBpUHJvcHMge1xuICAvKipcbiAgICogVGhlIGRlZmF1bHQgU3RhdGUgTWFjaGluZSB0aGF0IGhhbmRsZXMgYWxsIHJlcXVlc3RzIGZyb20gdGhpcyBBUEkuXG4gICAqXG4gICAqIFRoaXMgc3RhdGVNYWNoaW5lIHdpbGwgYmUgdXNlZCBhcyBhIHRoZSBkZWZhdWx0IGludGVncmF0aW9uIGZvciBhbGwgbWV0aG9kcyBpblxuICAgKiB0aGlzIEFQSSwgdW5sZXNzIHNwZWNpZmllZCBvdGhlcndpc2UgaW4gYGFkZE1ldGhvZGAuXG4gICAqL1xuICByZWFkb25seSBzdGF0ZU1hY2hpbmU6IHNmbi5JU3RhdGVNYWNoaW5lO1xuXG4gIC8qKlxuICAgKiBXaGljaCBkZXRhaWxzIG9mIHRoZSBpbmNvbWluZyByZXF1ZXN0IG11c3QgYmUgcGFzc2VkIG9udG8gdGhlIHVuZGVybHlpbmcgc3RhdGUgbWFjaGluZSxcbiAgICogc3VjaCBhcywgYWNjb3VudCBpZCwgdXNlciBpZGVudGl0eSwgcmVxdWVzdCBpZCwgZXRjLiBUaGUgZXhlY3V0aW9uIGlucHV0IHdpbGwgaW5jbHVkZSBhIG5ldyBrZXkgYHJlcXVlc3RDb250ZXh0YDpcbiAgICpcbiAgICoge1xuICAgKiAgIFwiYm9keVwiOiB7fSxcbiAgICogICBcInJlcXVlc3RDb250ZXh0XCI6IHtcbiAgICogICAgICAgXCJrZXlcIjogXCJ2YWx1ZVwiXG4gICAqICAgfVxuICAgKiB9XG4gICAqXG4gICAqIEBkZWZhdWx0IC0gYWxsIHBhcmFtZXRlcnMgd2l0aGluIHJlcXVlc3QgY29udGV4dCB3aWxsIGJlIHNldCBhcyBmYWxzZVxuICAgKi9cbiAgcmVhZG9ubHkgcmVxdWVzdENvbnRleHQ/OiBSZXF1ZXN0Q29udGV4dDtcblxuICAvKipcbiAgICogQ2hlY2sgaWYgcXVlcnlzdHJpbmcgaXMgdG8gYmUgaW5jbHVkZWQgaW5zaWRlIHRoZSBleGVjdXRpb24gaW5wdXQuIFRoZSBleGVjdXRpb24gaW5wdXQgd2lsbCBpbmNsdWRlIGEgbmV3IGtleSBgcXVlcnlTdHJpbmdgOlxuICAgKlxuICAgKiB7XG4gICAqICAgXCJib2R5XCI6IHt9LFxuICAgKiAgIFwicXVlcnlzdHJpbmdcIjoge1xuICAgKiAgICAgXCJrZXlcIjogXCJ2YWx1ZVwiXG4gICAqICAgfVxuICAgKiB9XG4gICAqXG4gICAqIEBkZWZhdWx0IHRydWVcbiAgICovXG4gIHJlYWRvbmx5IHF1ZXJ5c3RyaW5nPzogYm9vbGVhbjtcblxuICAvKipcbiAgICogQ2hlY2sgaWYgcGF0aCBpcyB0byBiZSBpbmNsdWRlZCBpbnNpZGUgdGhlIGV4ZWN1dGlvbiBpbnB1dC4gVGhlIGV4ZWN1dGlvbiBpbnB1dCB3aWxsIGluY2x1ZGUgYSBuZXcga2V5IGBwYXRoYDpcbiAgICpcbiAgICoge1xuICAgKiAgIFwiYm9keVwiOiB7fSxcbiAgICogICBcInBhdGhcIjoge1xuICAgKiAgICAgXCJyZXNvdXJjZU5hbWVcIjogXCJyZXNvdXJjZVZhbHVlXCJcbiAgICogICB9XG4gICAqIH1cbiAgICpcbiAgICogQGRlZmF1bHQgdHJ1ZVxuICAgKi9cbiAgcmVhZG9ubHkgcGF0aD86IGJvb2xlYW47XG5cbiAgLyoqXG4gICAqIENoZWNrIGlmIGhlYWRlciBpcyB0byBiZSBpbmNsdWRlZCBpbnNpZGUgdGhlIGV4ZWN1dGlvbiBpbnB1dC4gVGhlIGV4ZWN1dGlvbiBpbnB1dCB3aWxsIGluY2x1ZGUgYSBuZXcga2V5IGBoZWFkZXJzYDpcbiAgICpcbiAgICoge1xuICAgKiAgIFwiYm9keVwiOiB7fSxcbiAgICogICBcImhlYWRlcnNcIjoge1xuICAgKiAgICAgIFwiaGVhZGVyMVwiOiBcInZhbHVlXCIsXG4gICAqICAgICAgXCJoZWFkZXIyXCI6IFwidmFsdWVcIlxuICAgKiAgIH1cbiAgICogfVxuICAgKiBAZGVmYXVsdCBmYWxzZVxuICAgKi9cbiAgcmVhZG9ubHkgaGVhZGVycz86IGJvb2xlYW47XG5cbiAgLyoqXG4gICAqIElmIHRoZSB3aG9sZSBhdXRob3JpemVyIG9iamVjdCwgaW5jbHVkaW5nIGN1c3RvbSBjb250ZXh0IHZhbHVlcyBzaG91bGQgYmUgaW4gdGhlIGV4ZWN1dGlvbiBpbnB1dC4gVGhlIGV4ZWN1dGlvbiBpbnB1dCB3aWxsIGluY2x1ZGUgYSBuZXcga2V5IGBhdXRob3JpemVyYDpcbiAgICpcbiAgICoge1xuICAgKiAgIFwiYm9keVwiOiB7fSxcbiAgICogICBcImF1dGhvcml6ZXJcIjoge1xuICAgKiAgICAgXCJrZXlcIjogXCJ2YWx1ZVwiXG4gICAqICAgfVxuICAgKiB9XG4gICAqXG4gICAqIEBkZWZhdWx0IGZhbHNlXG4gICAqL1xuICByZWFkb25seSBhdXRob3JpemVyPzogYm9vbGVhbjtcbn1cblxuLyoqXG4gKiBEZWZpbmVzIGFuIEFQSSBHYXRld2F5IFJFU1QgQVBJIHdpdGggYSBTeW5jaHJvdW5vdXMgRXhwcmVzcyBTdGF0ZSBNYWNoaW5lIGFzIGEgcHJveHkgaW50ZWdyYXRpb24uXG4gKi9cbmV4cG9ydCBjbGFzcyBTdGVwRnVuY3Rpb25zUmVzdEFwaSBleHRlbmRzIFJlc3RBcGkge1xuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogU3RlcEZ1bmN0aW9uc1Jlc3RBcGlQcm9wcykge1xuICAgIGlmIChwcm9wcy5kZWZhdWx0SW50ZWdyYXRpb24pIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignQ2Fubm90IHNwZWNpZnkgXCJkZWZhdWx0SW50ZWdyYXRpb25cIiBzaW5jZSBTdGVwIEZ1bmN0aW9ucyBpbnRlZ3JhdGlvbiBpcyBhdXRvbWF0aWNhbGx5IGRlZmluZWQnKTtcbiAgICB9XG5cbiAgICBpZiAoKHByb3BzLnN0YXRlTWFjaGluZS5ub2RlLmRlZmF1bHRDaGlsZCBhcyBzZm4uQ2ZuU3RhdGVNYWNoaW5lKS5zdGF0ZU1hY2hpbmVUeXBlICE9PSBzZm4uU3RhdGVNYWNoaW5lVHlwZS5FWFBSRVNTKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoJ1N0YXRlIE1hY2hpbmUgbXVzdCBiZSBvZiB0eXBlIFwiRVhQUkVTU1wiLiBQbGVhc2UgdXNlIFN0YXRlTWFjaGluZVR5cGUuRVhQUkVTUyBhcyB0aGUgc3RhdGVNYWNoaW5lVHlwZScpO1xuICAgIH1cblxuICAgIGNvbnN0IHN0ZXBmdW5jdGlvbnNJbnRlZ3JhdGlvbiA9IFN0ZXBGdW5jdGlvbnNJbnRlZ3JhdGlvbi5zdGFydEV4ZWN1dGlvbihwcm9wcy5zdGF0ZU1hY2hpbmUsIHtcbiAgICAgIGNyZWRlbnRpYWxzUm9sZTogcm9sZShzY29wZSwgcHJvcHMpLFxuICAgICAgcmVxdWVzdENvbnRleHQ6IHByb3BzLnJlcXVlc3RDb250ZXh0LFxuICAgICAgcGF0aDogcHJvcHMucGF0aD8/IHRydWUsXG4gICAgICBxdWVyeXN0cmluZzogcHJvcHMucXVlcnlzdHJpbmc/PyB0cnVlLFxuICAgICAgaGVhZGVyczogcHJvcHMuaGVhZGVycyxcbiAgICAgIGF1dGhvcml6ZXI6IHByb3BzLmF1dGhvcml6ZXIsXG4gICAgfSk7XG5cbiAgICBzdXBlcihzY29wZSwgaWQsIHByb3BzKTtcblxuICAgIHRoaXMucm9vdC5hZGRNZXRob2QoJ0FOWScsIHN0ZXBmdW5jdGlvbnNJbnRlZ3JhdGlvbiwge1xuICAgICAgbWV0aG9kUmVzcG9uc2VzOiBtZXRob2RSZXNwb25zZSgpLFxuICAgIH0pO1xuICB9XG59XG5cbi8qKlxuICogRGVmaW5lcyB0aGUgSUFNIFJvbGUgZm9yIEFQSSBHYXRld2F5IHdpdGggcmVxdWlyZWQgcGVybWlzc2lvbnNcbiAqIHRvIGludm9rZSBhIHN5bmNocm9ub3VzIGV4ZWN1dGlvbiBmb3IgdGhlIHByb3ZpZGVkIHN0YXRlIG1hY2hpbmVcbiAqXG4gKiBAcGFyYW0gc2NvcGVcbiAqIEBwYXJhbSBwcm9wc1xuICogQHJldHVybnMgUm9sZSAtIElBTSBSb2xlXG4gKi9cbmZ1bmN0aW9uIHJvbGUoc2NvcGU6IENvbnN0cnVjdCwgcHJvcHM6IFN0ZXBGdW5jdGlvbnNSZXN0QXBpUHJvcHMpOiBpYW0uUm9sZSB7XG4gIGNvbnN0IHJvbGVOYW1lOiBzdHJpbmcgPSAnU3RhcnRTeW5jRXhlY3V0aW9uUm9sZSc7XG4gIGNvbnN0IGFwaVJvbGUgPSBuZXcgaWFtLlJvbGUoc2NvcGUsIHJvbGVOYW1lLCB7XG4gICAgYXNzdW1lZEJ5OiBuZXcgaWFtLlNlcnZpY2VQcmluY2lwYWwoJ2FwaWdhdGV3YXkuYW1hem9uYXdzLmNvbScpLFxuICB9KTtcblxuICBwcm9wcy5zdGF0ZU1hY2hpbmUuZ3JhbnRTdGFydFN5bmNFeGVjdXRpb24oYXBpUm9sZSk7XG5cbiAgcmV0dXJuIGFwaVJvbGU7XG59XG5cbi8qKlxuICogRGVmaW5lcyB0aGUgbWV0aG9kIHJlc3BvbnNlIG1vZGVsZm9yIGVhY2ggSFRUUCBjb2RlIHJlc3BvbnNlXG4gKiBAcmV0dXJucyBtZXRob2RSZXNwb25zZVxuICovXG5mdW5jdGlvbiBtZXRob2RSZXNwb25zZSgpIHtcbiAgcmV0dXJuIFtcbiAgICB7XG4gICAgICBzdGF0dXNDb2RlOiAnMjAwJyxcbiAgICAgIHJlc3BvbnNlTW9kZWxzOiB7XG4gICAgICAgICdhcHBsaWNhdGlvbi9qc29uJzogTW9kZWwuRU1QVFlfTU9ERUwsXG4gICAgICB9LFxuICAgIH0sXG4gICAge1xuICAgICAgc3RhdHVzQ29kZTogJzQwMCcsXG4gICAgICByZXNwb25zZU1vZGVsczoge1xuICAgICAgICAnYXBwbGljYXRpb24vanNvbic6IE1vZGVsLkVSUk9SX01PREVMLFxuICAgICAgfSxcbiAgICB9LFxuICAgIHtcbiAgICAgIHN0YXR1c0NvZGU6ICc1MDAnLFxuICAgICAgcmVzcG9uc2VNb2RlbHM6IHtcbiAgICAgICAgJ2FwcGxpY2F0aW9uL2pzb24nOiBNb2RlbC5FUlJPUl9NT0RFTCxcbiAgICAgIH0sXG4gICAgfSxcbiAgXTtcbn0iXX0=