# Generated by Django 3.2.13 on 2022-06-01 22:17

from django.db import migrations
from vendor.models import Payment

def post_payment_status_change(apps, schema_editor):
    ReceiptModel = apps.get_model('vendor', 'Receipt')

    for payment in Payment.objects.all():
        receipt = payment.get_receipt()
        
        if receipt:
            r = ReceiptModel.objects.get(pk=receipt.pk)
            payment.status = r.status
            payment.save()
            print(f"Payment Status Updated {payment}")


class Migration(migrations.Migration):

    dependencies = [
        ('vendor', '0035_add_subscription_relation'),
    ]

    operations = [
        migrations.RunPython(post_payment_status_change, reverse_code=migrations.RunPython.noop),
    ]

